/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.serializers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.serializers.encoding.Charset;
import org.apache.cocoon.components.serializers.encoding.CharsetFactory;
import org.apache.cocoon.components.serializers.encoding.Encoder;
import org.apache.cocoon.components.serializers.encoding.XMLEncoder;
import org.apache.cocoon.components.serializers.util.Namespaces;
import org.apache.cocoon.serialization.Serializer;
import org.apache.commons.lang.SystemUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class EncodingSerializer
implements Serializer,
Locator,
Recyclable,
Configurable {
    private static final char[] S_EOL = SystemUtils.LINE_SEPARATOR.toCharArray();
    public static final int ATTRIBUTE_NSURI = 0;
    public static final int ATTRIBUTE_LOCAL = 1;
    public static final int ATTRIBUTE_QNAME = 2;
    public static final int ATTRIBUTE_VALUE = 3;
    public static final int ATTRIBUTE_LENGTH = 4;
    private Encoder encoder = null;
    private Locator locator = null;
    private OutputStreamWriter out = null;
    private boolean prolog = true;
    private boolean processing = false;
    private int level = 0;
    private char[] indentBuffer = null;
    protected Charset charset = null;
    protected Namespaces namespaces = new Namespaces();
    protected int indentPerLevel = 0;
    private boolean setContentLength;

    protected EncodingSerializer(Encoder encoder) {
        this.encoder = encoder;
        this.recycle();
    }

    public boolean shouldSetContentLength() {
        return this.setContentLength;
    }

    public void recycle() {
        if (this.processing) {
            throw new IllegalStateException();
        }
        this.namespaces = new Namespaces();
        this.locator = null;
        this.out = null;
        this.prolog = true;
        if (this.encoder instanceof XMLEncoder) {
            ((XMLEncoder)this.encoder).reset();
        }
    }

    public void setOutputStream(OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("Null output");
        }
        this.out = new OutputStreamWriter(out, this.charset.getName());
    }

    public void configure(Configuration conf) throws ConfigurationException {
        String encoding = conf.getChild("encoding").getValue(null);
        try {
            this.charset = CharsetFactory.newInstance().getCharset(encoding);
        }
        catch (UnsupportedEncodingException exception) {
            throw new ConfigurationException("Encoding not supported: " + encoding, (Throwable)exception);
        }
        this.indentPerLevel = conf.getChild("indent").getValueAsInteger(0);
        if (this.indentPerLevel > 0) {
            this.assureIndentBuffer(this.indentPerLevel * 6);
        }
        this.setContentLength = conf.getChild("setContentLength").getValueAsBoolean(false);
    }

    private char[] assureIndentBuffer(int size) {
        if (this.indentBuffer == null || this.indentBuffer.length < size) {
            this.indentBuffer = new char[size];
            Arrays.fill(this.indentBuffer, ' ');
        }
        return this.indentBuffer;
    }

    protected void encode(String data) throws SAXException {
        char[] array = data.toCharArray();
        this.encode(array, 0, array.length);
    }

    protected void encode(char[] data) throws SAXException {
        this.encode(data, 0, data.length);
    }

    protected void encode(char[] data, int start, int length) throws SAXException {
        int end = start + length;
        if (data == null) {
            throw new NullPointerException("Null data");
        }
        if (start < 0 || start > data.length || length < 0 || end > data.length || end < 0) {
            throw new IndexOutOfBoundsException("Invalid data");
        }
        if (length == 0) {
            return;
        }
        for (int x = start; x < end; ++x) {
            char c = data[x];
            if (this.charset.allows(c) && this.encoder.allows(c)) continue;
            if (start != x) {
                this.write(data, start, x - start);
            }
            this.write(this.encoder.encode(c));
            start = x + 1;
        }
        if (start != end) {
            this.write(data, start, end - start);
        }
    }

    public final void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public String getPublicId() {
        return this.locator == null ? null : this.locator.getPublicId();
    }

    @Override
    public String getSystemId() {
        return this.locator == null ? null : this.locator.getSystemId();
    }

    @Override
    public int getLineNumber() {
        return this.locator == null ? -1 : this.locator.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.locator == null ? -1 : this.locator.getColumnNumber();
    }

    protected String getLocation() {
        if (this.locator == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(" (");
        if (this.getSystemId() != null) {
            buf.append(this.getSystemId());
            buf.append(' ');
        }
        buf.append("line " + this.getLineNumber());
        buf.append(" col " + this.getColumnNumber());
        buf.append(')');
        return buf.toString();
    }

    protected void flush() throws SAXException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new SAXException("I/O error flushing: " + e.getMessage(), e);
        }
    }

    protected void write(char[] data) throws SAXException {
        try {
            this.out.write(data, 0, data.length);
        }
        catch (IOException e) {
            throw new SAXException("I/O error writing: " + e.getMessage(), e);
        }
    }

    protected void write(char[] data, int start, int length) throws SAXException {
        try {
            this.out.write(data, start, length);
        }
        catch (IOException e) {
            throw new SAXException("I/O error writing: " + e.getMessage(), e);
        }
    }

    protected void write(int c) throws SAXException {
        try {
            this.out.write(c);
        }
        catch (IOException e) {
            throw new SAXException("I/O error writing: " + e.getMessage(), e);
        }
    }

    protected void write(String data) throws SAXException {
        try {
            this.out.write(data);
        }
        catch (IOException e) {
            throw new SAXException("I/O error writing: " + e.getMessage(), e);
        }
    }

    protected void write(String data, int start, int length) throws SAXException {
        try {
            this.out.write(data, start, length);
        }
        catch (IOException e) {
            throw new SAXException("I/O error writing: " + e.getMessage(), e);
        }
    }

    protected void writeln() throws SAXException {
        try {
            this.out.write(S_EOL);
        }
        catch (IOException e) {
            throw new SAXException("I/O error writing: " + e.getMessage(), e);
        }
    }

    protected void writeln(String data) throws SAXException {
        try {
            this.out.write(data);
            this.out.write(S_EOL);
        }
        catch (IOException e) {
            throw new SAXException("I/O error writing: " + e.getMessage(), e);
        }
    }

    protected void writeIndent(int indent) throws SAXException {
        this.charactersImpl("\n".toCharArray(), 0, 1);
        if (indent > 0) {
            this.charactersImpl(this.assureIndentBuffer(indent), 0, indent);
        }
    }

    public void startDocument() throws SAXException {
        this.processing = true;
        this.level = 0;
    }

    public void endDocument() throws SAXException {
        this.processing = false;
        this.flush();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.push(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.pop(prefix);
    }

    public void startElement(String nsuri, String local, String qual, Attributes attributes) throws SAXException {
        if (this.indentPerLevel > 0) {
            this.writeIndent(this.indentPerLevel * this.level);
            ++this.level;
        }
        String name = this.namespaces.qualify(nsuri, local, qual);
        if (this.prolog) {
            this.body(nsuri, local, name);
            this.prolog = false;
        }
        String[][] ns = this.namespaces.commit();
        String[][] at = new String[attributes.getLength()][4];
        for (int x = 0; x < at.length; ++x) {
            at[x][0] = attributes.getURI(x);
            at[x][1] = attributes.getLocalName(x);
            at[x][2] = this.namespaces.qualify(attributes.getURI(x), attributes.getLocalName(x), attributes.getQName(x));
            at[x][3] = attributes.getValue(x);
        }
        this.startElementImpl(nsuri, local, name, ns, at);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.indentPerLevel > 0) {
            this.writeIndent(this.indentPerLevel * this.level + 1);
        }
        this.charactersImpl(ch, start, length);
    }

    public void endElement(String nsuri, String local, String qual) throws SAXException {
        if (this.indentPerLevel > 0) {
            --this.level;
            this.writeIndent(this.indentPerLevel * this.level);
        }
        String name = this.namespaces.qualify(nsuri, local, qual);
        this.endElementImpl(nsuri, local, name);
    }

    public abstract void body(String var1, String var2, String var3) throws SAXException;

    public abstract void startElementImpl(String var1, String var2, String var3, String[][] var4, String[][] var5) throws SAXException;

    public abstract void charactersImpl(char[] var1, int var2, int var3) throws SAXException;

    public abstract void endElementImpl(String var1, String var2, String var3) throws SAXException;
}

