/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.plugins.repositoryapp.RepositoryProvider;
import org.ametys.workspaces.repository.jcr.RepositoryDao;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;

public class BinaryPropertyReader
extends ServiceableReader {
    protected RepositoryProvider _repositoryProvider;
    private Node _node;
    private Property _property;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._repositoryProvider = (RepositoryProvider)((Object)serviceManager.lookup(RepositoryProvider.ROLE));
    }

    public void setup(SourceResolver res, Map objModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(res, objModel, src, par);
        Session session = null;
        String workspaceName = null;
        try {
            workspaceName = this.parameters.getParameter("workspace");
            session = this._repositoryProvider.getSession(workspaceName);
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to retrieve repository", (Throwable)e);
        }
        try {
            String path = par.getParameter("path", "");
            String relPath = RepositoryDao.removeLeadingSlash(path);
            this._node = session.getRootNode().getNode(relPath);
            String name = par.getParameter("property", null);
            this._property = this._node.getProperty(name);
        }
        catch (RepositoryException e) {
            throw new ProcessingException((Exception)((Object)e));
        }
    }

    public String getMimeType() {
        try {
            if (this._node.hasProperty("jcr:mimeType")) {
                return this._node.getProperty("jcr:mimeType").getString();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return "application/unknown";
    }

    private String _getName() throws RepositoryException {
        if ("nt:resource".equals(this._node.getPrimaryNodeType().getName())) {
            return this._node.getParent().getName();
        }
        return this._property.getName();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String path = null;
        try {
            String name = this._getName();
            name = name.replaceAll("\\\\", "\\\\\\\\");
            name = name.replaceAll("\\\"", "\\\\\\\"");
            path = this._property.getPath();
            Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
            response.setHeader("Content-Length", Long.toString(this._property.getLength()));
            response.setHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
            try (InputStream is = this._property.getBinary().getStream();){
                IOUtils.copy((InputStream)is, (OutputStream)this.out);
            }
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to download binary property of path " + path, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.out);
        }
    }
}

