/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.jcr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.ametys.core.util.DateUtils;
import org.ametys.runtime.config.Config;
import org.ametys.workspaces.repository.jcr.AbstractRepositoryGenerator;
import org.ametys.workspaces.repository.jcr.NodeGroupHelper;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RepositoryNodeGenerator
extends AbstractRepositoryGenerator {
    private static final Comparator<Node> __ALPHA_NODE_COMPARATOR = new NodeNameComparator();
    private static final Comparator<Node> __REVERSE_ALPHA_NODE_COMPARATOR = new NodeNameComparator(false);

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String workspaceName = this.parameters.getParameter("workspace", "default");
        String defaultOrder = Config.getInstance() != null ? (String)Config.getInstance().getValue("repository.default.sort") : "document";
        String order = this.parameters.getParameter("order", defaultOrder);
        if (StringUtils.isBlank((String)order)) {
            order = defaultOrder;
        }
        this._getRepository(request, workspaceName);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Trying to generate content for a node");
        }
        this.contentHandler.startDocument();
        if (workspaceName != null) {
            AttributesImpl repositoryAttributes = new AttributesImpl();
            repositoryAttributes.addCDATAAttribute("workspace", workspaceName);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"repository", (Attributes)repositoryAttributes);
        } else {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"repository");
        }
        try {
            this._saxNode(this._session, order);
        }
        catch (RepositoryException e) {
            throw new ProcessingException("Unable to retrieve node for path: '" + this.source + "'", (Throwable)e);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"repository");
        this.contentHandler.endDocument();
    }

    private void _saxNode(Session session, String order) throws SAXException, RepositoryException {
        Node node = null;
        Node rootNode = session.getRootNode();
        String path = this.parameters.getParameter("path", "");
        long start = this.parameters.getParameterAsLong("start", -1L);
        long end = this.parameters.getParameterAsLong("end", -1L);
        node = StringUtils.isEmpty((String)path) ? rootNode : rootNode.getNode(path);
        AttributesImpl nodeAttributes = new AttributesImpl();
        if (rootNode != node) {
            nodeAttributes.addCDATAAttribute("parentPath", node.getParent().getPath());
        } else {
            nodeAttributes.addCDATAAttribute("parentPath", "");
        }
        if (start > -1L && end > -1L) {
            nodeAttributes.addCDATAAttribute("start", Long.toString(start));
            nodeAttributes.addCDATAAttribute("end", Long.toString(end));
        }
        boolean hasOrderableChildNodes = node.getPrimaryNodeType().hasOrderableChildNodes();
        nodeAttributes.addCDATAAttribute("name", node.getName());
        nodeAttributes.addCDATAAttribute("path", node.getPath());
        nodeAttributes.addCDATAAttribute("pathWithGroups", NodeGroupHelper.getPathWithGroups(node));
        nodeAttributes.addCDATAAttribute("index", String.valueOf(node.getIndex()));
        nodeAttributes.addCDATAAttribute("hasOrderableChildNodes", Boolean.toString(hasOrderableChildNodes));
        nodeAttributes.addCDATAAttribute("isNew", Boolean.toString(node.isNew()));
        nodeAttributes.addCDATAAttribute("isModified", Boolean.toString(node.isModified()));
        nodeAttributes.addCDATAAttribute("noChild", Boolean.toString(!node.hasNodes()));
        nodeAttributes.addCDATAAttribute("type", "node");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"node", (Attributes)nodeAttributes);
        this._saxProperties(node);
        this._saxChildren(node, start, end, order);
        this._saxReferers(node);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"node");
    }

    private void _saxProperties(Node node) throws SAXException, RepositoryException {
        TreeMap<String, Property> jcrProperties = new TreeMap<String, Property>();
        TreeMap<String, Property> otherProperties = new TreeMap<String, Property>();
        PropertyIterator itProperty = node.getProperties();
        while (itProperty.hasNext()) {
            Property property = itProperty.nextProperty();
            String propertyName = property.getName();
            if (propertyName.startsWith("jcr:")) {
                jcrProperties.put(propertyName, property);
                continue;
            }
            otherProperties.put(propertyName, property);
        }
        for (Property property : jcrProperties.values()) {
            this._saxProperty(property, node);
        }
        for (Property property : otherProperties.values()) {
            this._saxProperty(property, node);
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isLocked", (String)String.valueOf(node.isLocked()));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isCheckedOut", (String)String.valueOf(node.isCheckedOut()));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isNew", (String)Boolean.toString(node.isNew()));
    }

    private void _saxProperty(Property property, Node parentNode) throws SAXException, RepositoryException {
        boolean isMultiple = property.getDefinition().isMultiple();
        AttributesImpl propertyAttributes = new AttributesImpl();
        boolean editable = !property.getDefinition().isProtected() && !parentNode.isLocked();
        propertyAttributes.addCDATAAttribute("name", property.getName());
        propertyAttributes.addCDATAAttribute("multiple", String.valueOf(isMultiple));
        propertyAttributes.addCDATAAttribute("type", PropertyType.nameFromValue((int)property.getType()));
        propertyAttributes.addCDATAAttribute("editable", String.valueOf(editable));
        propertyAttributes.addCDATAAttribute("new", Boolean.toString(property.isNew()));
        propertyAttributes.addCDATAAttribute("modified", Boolean.toString(property.isModified()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"property", (Attributes)propertyAttributes);
        if (isMultiple) {
            Value[] values = property.getValues();
            for (int i = 0; i < values.length; ++i) {
                this._saxValue(values[i]);
            }
        } else {
            this._saxValue(property.getValue());
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"property");
    }

    private void _saxChildren(Node node, long start, long end, String order) throws SAXException, RepositoryException {
        long startIndex;
        NodeIterator itNode = node.getNodes();
        long endIndex = end >= 0L ? end : itNode.getSize() - 1L;
        long childCount = endIndex - (startIndex = Math.max(0L, start)) + 1L;
        if (childCount > 100L) {
            this._saxGroups(node, startIndex, childCount);
        } else if ("alpha".equals(order) || "reverseAlpha".equals(order)) {
            Collection<Node> children = this._extractNodes(itNode, startIndex, endIndex, "alpha".equals(order));
            for (Node child : children) {
                this._saxSubnode(child);
            }
        } else {
            itNode.skip(startIndex);
            for (long i = startIndex; i <= endIndex && itNode.hasNext(); ++i) {
                this._saxSubnode(itNode.nextNode());
            }
        }
    }

    private Collection<Node> _extractNodes(NodeIterator itNodes, long start, long end, boolean ascending) {
        ArrayList<Node> nodes = new ArrayList<Node>((int)itNodes.getSize());
        while (itNodes.hasNext()) {
            nodes.add(itNodes.nextNode());
        }
        Collections.sort(nodes, ascending ? __ALPHA_NODE_COMPARATOR : __REVERSE_ALPHA_NODE_COMPARATOR);
        return nodes.subList((int)start, (int)end + 1);
    }

    private void _saxGroups(Node node, long startIndex, long childCount) throws RepositoryException, SAXException {
        long level = (long)Math.ceil(Math.log(childCount) / Math.log(100.0)) - 1L;
        long childrenPerGroup = (long)Math.pow(100.0, level);
        long groupCount = (long)Math.ceil((double)childCount / (double)childrenPerGroup);
        for (long i = 0L; i < groupCount; ++i) {
            long groupStartIndex = startIndex + i * childrenPerGroup;
            long groupEndIndex = startIndex + Math.min((i + 1L) * childrenPerGroup - 1L, childCount - 1L);
            String name = String.format("%d...%d", groupStartIndex + 1L, groupEndIndex + 1L);
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("level", Long.toString(level));
            atts.addCDATAAttribute("index", Long.toString(i));
            atts.addCDATAAttribute("start", Long.toString(groupStartIndex));
            atts.addCDATAAttribute("end", Long.toString(groupEndIndex));
            atts.addCDATAAttribute("path", node.getPath());
            atts.addCDATAAttribute("name", name);
            atts.addCDATAAttribute("type", "group");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"group", (Attributes)atts);
        }
    }

    private void _saxSubnode(Node node) throws RepositoryException, SAXException {
        AttributesImpl subNodeAttributes = new AttributesImpl();
        int index = node.getIndex();
        String name = node.getName();
        if (index != 1) {
            name = name + "[" + index + "]";
        }
        subNodeAttributes.addCDATAAttribute("parentPath", node.getParent().getPath());
        subNodeAttributes.addCDATAAttribute("name", name);
        subNodeAttributes.addCDATAAttribute("index", String.valueOf(index));
        subNodeAttributes.addCDATAAttribute("hasOrderableChildNodes", Boolean.toString(node.getPrimaryNodeType().hasOrderableChildNodes()));
        subNodeAttributes.addCDATAAttribute("isNew", Boolean.toString(node.isNew()));
        subNodeAttributes.addCDATAAttribute("isModified", Boolean.toString(node.isModified()));
        subNodeAttributes.addCDATAAttribute("type", "node");
        if (!node.hasNodes()) {
            subNodeAttributes.addCDATAAttribute("noChild", "true");
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"node", (Attributes)subNodeAttributes);
    }

    private void _saxReferers(Node node) throws SAXException, RepositoryException {
        PropertyIterator itReference = node.getReferences();
        while (itReference.hasNext()) {
            Property property = itReference.nextProperty();
            AttributesImpl referenceAttributes = new AttributesImpl();
            Node parent = property.getParent();
            referenceAttributes.addCDATAAttribute("path", parent.getPath());
            referenceAttributes.addCDATAAttribute("pathWithGroups", NodeGroupHelper.getPathWithGroups(parent));
            referenceAttributes.addCDATAAttribute("name", property.getName());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"referer", (Attributes)referenceAttributes);
        }
    }

    private void _saxValue(Value value) throws RepositoryException, SAXException {
        Attributes attrs = XMLUtils.EMPTY_ATTRIBUTES;
        String textValue = null;
        switch (value.getType()) {
            case 2: {
                textValue = "";
                break;
            }
            case 5: {
                textValue = DateUtils.dateToString((Date)value.getDate().getTime());
                break;
            }
            default: {
                textValue = value.getString();
            }
        }
        if (textValue != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)textValue);
        }
    }

    protected static class NodeNameComparator
    implements Comparator<Node> {
        protected boolean _ascending;

        public NodeNameComparator() {
            this(true);
        }

        public NodeNameComparator(boolean ascending) {
            this._ascending = ascending;
        }

        @Override
        public int compare(Node o1, Node o2) {
            try {
                if (this._ascending) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o2.getName().compareTo(o1.getName());
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Impossible to get a node name.", e);
            }
        }
    }
}

