/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.jcr;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.ametys.plugins.repositoryapp.RepositoryProvider;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WorkspacesGenerator
extends ServiceableGenerator {
    protected RepositoryProvider _repositoryProvider;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._repositoryProvider = (RepositoryProvider)((Object)serviceManager.lookup(RepositoryProvider.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            Session session = this._repositoryProvider.getSession("default");
            Workspace workspace = session.getWorkspace();
            this.contentHandler.startDocument();
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"workspaces");
            for (String workspaceName : workspace.getAccessibleWorkspaceNames()) {
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("name", workspaceName);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"workspace", (Attributes)attrs);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"workspaces");
            this.contentHandler.endDocument();
        }
        catch (RepositoryException e) {
            throw new ProcessingException("Unable to get accessible workspaces", (Throwable)e);
        }
    }
}

