/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance;

import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.ametys.core.util.SystemStatus;
import org.ametys.plugins.repositoryapp.RepositoryProvider;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.ametys.workspaces.repository.maintenance.AbstractMaintenanceTask;
import org.ametys.workspaces.repository.maintenance.ConsistencyCheckTask;
import org.ametys.workspaces.repository.maintenance.DataStoreGarbageCollectorTask;
import org.ametys.workspaces.repository.maintenance.ReindexingTask;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Context;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;

public class MaintenanceTaskManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = MaintenanceTaskManager.class.getName();
    public static final String REPOSITORY_UNAVAILABLE = "REPOSITORY_UNAVAILABLE";
    public static final String MAINTENANCE_TASK_RUNNING = "MAINTENANCE_TASK_RUNNING";
    public static final String MAINTENANCE_TASK_ENDED = "MAINTENANCE_TASK_ENDED";
    protected static AbstractMaintenanceTask _runningTask;
    protected static MaintenanceTaskType _lastRunningTaskType;
    protected MaintenanceTaskType _runningTaskType;
    protected SystemStatus _systemStatus;
    private RepositoryProvider _repositoryProvider;
    private final ExecutorService _executor = Executors.newFixedThreadPool(1);
    private FutureTask<Void> _future;
    private boolean _repositoryShutdown;
    private Context _context;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager manager) throws ServiceException {
        if (manager.hasService(RepositoryProvider.ROLE)) {
            this._repositoryProvider = (RepositoryProvider)((Object)manager.lookup(RepositoryProvider.ROLE));
        }
        this._systemStatus = (SystemStatus)manager.lookup(SystemStatus.ROLE);
    }

    public boolean launch(MaintenanceTaskType type) {
        boolean launched = false;
        if (!this.isTaskRunning()) {
            try {
                this.run(type);
                launched = true;
            }
            catch (ConfigurationException e) {
                this.getLogger().error("Unable to get the configuration of the repository.", (Throwable)e);
            }
            catch (RepositoryException e) {
                this.getLogger().error("Unable to launch the task.", (Throwable)e);
            }
        }
        return launched;
    }

    private void run(final MaintenanceTaskType type) throws ConfigurationException, RepositoryException {
        this._runningTaskType = type;
        this._systemStatus.addStatus(REPOSITORY_UNAVAILABLE);
        this._systemStatus.addStatus(MAINTENANCE_TASK_RUNNING);
        this._systemStatus.removeStatus(MAINTENANCE_TASK_ENDED);
        final Logger logger = this.getLogger();
        if (this.isJndi()) {
            throw new UnsupportedOperationException("A maintenance task can not be run on a JNDI repository instance");
        }
        this.shutdownRepository();
        final RepositoryConfig repositoryConfig = this._getRepositoryConfig();
        this._future = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws ServletException {
                try {
                    _runningTask = MaintenanceTaskManager.this._createTask(type);
                    _runningTask.execute(repositoryConfig);
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    MaintenanceTaskManager.this._systemStatus.removeStatus(MaintenanceTaskManager.MAINTENANCE_TASK_RUNNING);
                    MaintenanceTaskManager.this._systemStatus.addStatus(MaintenanceTaskManager.MAINTENANCE_TASK_ENDED);
                    MaintenanceTaskManager.this._runningTaskType = null;
                }
                return null;
            }
        });
        this._executor.execute(this._future);
    }

    public boolean isJndi() {
        return this._repositoryProvider.isJndi();
    }

    protected void shutdownRepository() throws RepositoryException {
        if (this._repositoryProvider.isJndi()) {
            throw new RepositoryException("JNDI Repository instance are currently not allowed.");
        }
        this._repositoryProvider.disconnect();
        this._repositoryShutdown = true;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Repository instance has been shutdown in order to run an automated maintenance task.");
        }
    }

    private RepositoryConfig _getRepositoryConfig() throws ConfigurationException {
        String config = this._context.getRealPath("/WEB-INF/param/repository.xml");
        File homeFile = new File(AmetysHomeHelper.getAmetysHomeData(), "repository");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating JCR Repository config at: " + homeFile.getAbsolutePath());
        }
        return RepositoryConfig.create((String)config, (String)homeFile.getAbsolutePath());
    }

    protected AbstractMaintenanceTask _createTask(MaintenanceTaskType type) throws RepositoryException {
        switch (type) {
            case DATA_STORE_GARBAGE_COLLECTOR: {
                return new DataStoreGarbageCollectorTask();
            }
            case REINDEXING: {
                return new ReindexingTask();
            }
            case CONSISTENCY_CHECK: {
                return new ConsistencyCheckTask();
            }
        }
        throw new IllegalArgumentException("This type of maintenance task is not allowed : " + (Object)((Object)type));
    }

    public boolean isTaskRunning() {
        return this._runningTaskType != null;
    }

    public Map<String, Object> getProgressInfo() {
        if (_runningTask != null) {
            return _runningTask.getProgressInfo();
        }
        return null;
    }

    public String getRunningTaskType() {
        if (this._runningTaskType != null) {
            return this._runningTaskType.name();
        }
        return null;
    }

    public String getLastRunningTaskType() {
        if (_lastRunningTaskType != null) {
            return _lastRunningTaskType.name();
        }
        return null;
    }

    public boolean isRepositoryStarted() {
        return !this._repositoryShutdown;
    }

    public static enum MaintenanceTaskType {
        DATA_STORE_GARBAGE_COLLECTOR,
        REINDEXING,
        CONSISTENCY_CHECK;

    }
}

