/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.serializers.encoding;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.cocoon.components.serializers.encoding.Charset;
import org.apache.cocoon.components.serializers.encoding.UnknownCharset;

public final class CharsetFactory {
    private static final String CHARSET_LOOKUP_CLASS = "org/apache/cocoon/components/serializers/encoding/cs_US_ASCII.class";
    private static CharsetFactory instance = new CharsetFactory();
    private Charset defaultCharset = null;
    private Charset unknownCharset = null;
    private HashMap charsets = new HashMap();

    private CharsetFactory() {
        this.unknownCharset = new UnknownCharset();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(CHARSET_LOOKUP_CLASS);
        if (url == null) {
            throw new CharsetFactoryException("Unable to load charsets because their classes are not present", null);
        }
        if ("jar".equals(url.getProtocol())) {
            this.loadCharsetsFromJar(url);
        } else if ("file".equals(url.getProtocol())) {
            this.loadCharsetsFromFile(url);
        } else {
            throw new CharsetFactoryException("Unable to load charsets from protocol \"" + url.getProtocol() + "\"", null);
        }
        ByteArrayOutputStream otmp = new ByteArrayOutputStream();
        OutputStreamWriter wtmp = new OutputStreamWriter(otmp);
        String etmp = wtmp.getEncoding();
        try {
            this.defaultCharset = this.getCharset(etmp);
        }
        catch (UnsupportedEncodingException exception) {
            throw new CharsetFactoryException("The default encoding of this JVM \"" + etmp + "\" is not supported", exception);
        }
    }

    private void loadCharset(Charset charset) {
        this.charsets.put(charset.getName().toLowerCase(), charset);
        String[] aliases = charset.getAliases();
        for (int x = 0; x < aliases.length; ++x) {
            this.charsets.put(aliases[x].toLowerCase(), charset);
        }
    }

    private void loadCharset(String clazz) {
        try {
            Class<?> c = Class.forName(clazz);
            Object o = c.newInstance();
            if (o instanceof Charset) {
                this.loadCharset((Charset)o);
            }
        }
        catch (Exception exception) {
            throw new CharsetFactoryException("Unable to instantiate class \"" + clazz + "\"", exception);
        }
    }

    private void loadCharsetsFromJar(URL url) {
        try {
            String file = url.getFile();
            String mtch = file.substring(file.indexOf(33));
            file = file.substring(5, file.indexOf(33));
            mtch = mtch.substring(2, mtch.lastIndexOf(47) + 1) + "cs_";
            file = URLDecoder.decode(file, "UTF-8");
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zip.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                String name = entry.getName();
                if (!name.startsWith(mtch) || !name.endsWith(".class")) continue;
                name = name.substring(mtch.length());
                name = ".cs_" + name.substring(0, name.length() - 6);
                name = this.getClass().getPackage().getName() + name;
                this.loadCharset(name);
            }
        }
        catch (IOException exception) {
            throw new CharsetFactoryException("Unable to access JAR \"" + url.toString() + "\"", exception);
        }
    }

    private void loadCharsetsFromFile(URL url) {
        File file = new File(url.getFile()).getParentFile();
        String[] children = file.list();
        for (int x = 0; x < children.length; ++x) {
            String child = children[x];
            if (!child.startsWith("cs_") || !child.endsWith(".class")) continue;
            child = '.' + child.substring(0, child.length() - 6);
            child = this.getClass().getPackage().getName() + child;
            this.loadCharset(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharsetFactory newInstance() {
        if (instance != null) {
            return instance;
        }
        Class<CharsetFactory> clazz = CharsetFactory.class;
        synchronized (CharsetFactory.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            instance = new CharsetFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Charset getCharset() {
        return this.unknownCharset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public Charset getCharset(String name) throws UnsupportedEncodingException {
        if (name == null) {
            return this.getDefaultCharset();
        }
        Charset charset = (Charset)this.charsets.get(name.toLowerCase());
        if (charset != null) {
            return charset;
        }
        throw new UnsupportedEncodingException("Unsupported charset \"" + name + "\"");
    }

    private static class CharsetFactoryException
    extends RuntimeException {
        private Exception exception = null;

        private CharsetFactoryException(String message, Exception exception) {
            super(message == null ? exception.getMessage() : message);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public void printStackTrace(PrintWriter out) {
            super.printStackTrace(out);
            if (this.exception != null) {
                out.print("Root cause: ");
                this.exception.printStackTrace(out);
            }
        }

        @Override
        public void printStackTrace(PrintStream out) {
            super.printStackTrace(out);
            if (this.exception != null) {
                out.print("Root cause: ");
                this.exception.printStackTrace(out);
            }
        }
    }
}

