/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.serializers.encoding;

import org.apache.cocoon.components.serializers.encoding.CompiledEncoder;

public class XMLEncoder
extends CompiledEncoder {
    private static final char[] ENCODE_HEX = "0123456789ABCDEF".toCharArray();
    private static final char[] ENCODE_QUOT = "&quot;".toCharArray();
    private static final char[] ENCODE_AMP = "&amp;".toCharArray();
    private static final char[] ENCODE_APOS = "&apos;".toCharArray();
    private static final char[] ENCODE_LT = "&lt;".toCharArray();
    private static final char[] ENCODE_GT = "&gt;".toCharArray();
    private Character highSurrogate = null;

    public XMLEncoder() {
        super("X-W3C-XML");
    }

    protected XMLEncoder(String name) {
        super(name);
    }

    public void reset() {
        this.highSurrogate = null;
    }

    @Override
    protected boolean compile(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        return c != '\"' && c != '&' && c != '\'' && c != '<' && c != '>' && c >= ' ' && (c <= '\ud7ff' || c >= '\ue000') && c <= '\ufffd';
    }

    @Override
    public char[] encode(char c) {
        if (this.highSurrogate != null) {
            if (!Character.isLowSurrogate(c)) {
                throw new IllegalArgumentException("Expected low surrogate char");
            }
            int codePoint = Character.toCodePoint(this.highSurrogate.charValue(), c);
            this.highSurrogate = null;
            return this.encode(codePoint);
        }
        if (Character.isHighSurrogate(c)) {
            this.highSurrogate = Character.valueOf(c);
            return new char[0];
        }
        return this.encode((int)c);
    }

    private char[] encode(int c) {
        switch (c) {
            case 34: {
                return ENCODE_QUOT;
            }
            case 38: {
                return ENCODE_AMP;
            }
            case 39: {
                return ENCODE_APOS;
            }
            case 60: {
                return ENCODE_LT;
            }
            case 62: {
                return ENCODE_GT;
            }
        }
        if (c > 65535) {
            char[] ret = new char[]{'&', '#', 'x', ENCODE_HEX[c >> 16 & 0xF], ENCODE_HEX[c >> 12 & 0xF], ENCODE_HEX[c >> 8 & 0xF], ENCODE_HEX[c >> 4 & 0xF], ENCODE_HEX[c & 0xF], ';'};
            return ret;
        }
        if (c > 4095) {
            char[] ret = new char[]{'&', '#', 'x', ENCODE_HEX[c >> 12 & 0xF], ENCODE_HEX[c >> 8 & 0xF], ENCODE_HEX[c >> 4 & 0xF], ENCODE_HEX[c & 0xF], ';'};
            return ret;
        }
        if (c > 255) {
            char[] ret = new char[]{'&', '#', 'x', ENCODE_HEX[c >> 8 & 0xF], ENCODE_HEX[c >> 4 & 0xF], ENCODE_HEX[c & 0xF], ';'};
            return ret;
        }
        char[] ret = new char[]{'&', '#', 'x', ENCODE_HEX[c >> 4 & 0xF], ENCODE_HEX[c & 0xF], ';'};
        return ret;
    }
}

