/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.serializers.util;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DocType {
    private static final char[] S_DOCTYPE_1 = "<!DOCTYPE ".toCharArray();
    private static final char[] S_DOCTYPE_2 = " PUBLIC \"".toCharArray();
    private static final char[] S_DOCTYPE_3 = "\" \"".toCharArray();
    private static final char[] S_DOCTYPE_4 = " SYSTEM \"".toCharArray();
    private static final char[] S_DOCTYPE_5 = "\">".toCharArray();
    private static final char[] S_DOCTYPE_6 = ">".toCharArray();
    protected String root_name = null;
    protected String public_id = null;
    protected String system_id = null;

    public DocType(String root_name) {
        this(root_name, null, null);
    }

    public DocType(String root_name, String system_id) {
        this(root_name, null, system_id);
    }

    public DocType(String root_name, String public_id, String system_id) {
        if (root_name == null) {
            throw new NullPointerException("Invalid root document name");
        }
        if (public_id != null && system_id == null) {
            throw new NullPointerException("Required System ID is NULL");
        }
        this.root_name = root_name;
        this.public_id = public_id;
        this.system_id = system_id;
    }

    public String getName() {
        return this.root_name;
    }

    public String getPublicId() {
        return this.public_id;
    }

    public String getSystemId() {
        return this.system_id;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(S_DOCTYPE_1);
        buf.append(this.root_name);
        if (this.public_id != null) {
            buf.append(S_DOCTYPE_2);
            buf.append(this.public_id);
            if (this.system_id != null) {
                buf.append(S_DOCTYPE_3);
                buf.append(this.system_id);
            }
            buf.append(S_DOCTYPE_5);
        } else if (this.system_id != null) {
            buf.append(S_DOCTYPE_4);
            buf.append(this.system_id);
            buf.append(S_DOCTYPE_5);
        } else {
            buf.append(S_DOCTYPE_6);
        }
        return buf.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DocType)) {
            return false;
        }
        DocType rhs = (DocType)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append((Object)this.public_id, (Object)rhs.public_id).append((Object)this.system_id, (Object)rhs.system_id).append((Object)this.root_name, (Object)rhs.root_name).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.public_id).append((Object)this.system_id).append((Object)this.root_name).toHashCode();
    }
}

