/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Map;
import org.apache.avalon.excalibur.component.ComponentProxyGenerator;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.Modifiable;
import org.apache.cocoon.Processor;
import org.apache.cocoon.RequestListener;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.ComponentContext;
import org.apache.cocoon.components.PropertyAwareSAXConfigurationHandler;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.impl.DelayedRefreshSourceWrapper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.Deprecation;
import org.apache.cocoon.util.Settings;
import org.apache.cocoon.util.SettingsHelper;
import org.apache.cocoon.util.SimpleSourceResolver;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationImpl;
import org.apache.cocoon.util.location.LocationUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.excalibur.instrument.InstrumentManageable;
import org.apache.excalibur.instrument.InstrumentManager;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.URLSource;
import org.apache.excalibur.xml.impl.XercesParser;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class Cocoon
extends AbstractLogEnabled
implements ThreadSafe,
Component,
Initializable,
Disposable,
Modifiable,
Processor,
Contextualizable,
Composable,
InstrumentManageable {
    private static final LocationUtils.LocationFinder LOCATION_FINDER = new LocationUtils.LocationFinder(){

        @Override
        public Location getLocation(Object obj, String description) {
            if (obj instanceof Configuration) {
                Configuration config = (Configuration)obj;
                String locString = config.getLocation();
                LocationImpl result = LocationUtils.parse(locString);
                if (LocationUtils.isKnown(result)) {
                    StringBuffer desc = new StringBuffer().append('<');
                    try {
                        if (config.getNamespace().startsWith("http://apache.org/cocoon/sitemap/")) {
                            desc.append("map:");
                        }
                    }
                    catch (ConfigurationException e) {
                        // empty catch block
                    }
                    desc.append(config.getName()).append('>');
                    return new LocationImpl(desc.toString(), result);
                }
                return result;
            }
            if (obj instanceof Exception) {
                String msg = ((Exception)obj).getMessage();
                if (msg == null) {
                    return null;
                }
                int pos = msg.lastIndexOf(" at ");
                if (pos != -1) {
                    return LocationUtils.parse(msg.substring(pos + 4));
                }
                return null;
            }
            return null;
        }
    };
    static Cocoon instance;
    private Logger rootLogger;
    private org.apache.avalon.framework.context.Context context;
    private Source configurationFile;
    private Configuration configuration;
    private LoggerManager loggerManager;
    private InstrumentManager instrumentManager;
    private String classpath;
    private File workDir;
    private ExcaliburComponentManager componentManager;
    private ComponentManager parentComponentManager;
    private boolean disposed;
    private volatile int activeRequestCount;
    private Processor threadSafeProcessor;
    protected SourceResolver sourceResolver;
    protected RequestListener requestListener;

    public Cocoon() throws ConfigurationException {
        this.setSystemProperties();
        instance = this;
    }

    public void enableLogging(Logger logger) {
        this.rootLogger = logger;
        super.enableLogging(logger.getChildLogger("cocoon"));
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.parentComponentManager = manager;
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        if (this.context == null) {
            this.context = new ComponentContext(context);
            SettingsHelper.createSettings((DefaultContext)this.context, this.getLogger());
            ((DefaultContext)this.context).makeReadOnly();
            this.classpath = (String)context.get((Object)"classpath");
            this.workDir = (File)context.get((Object)"work-directory");
            try {
                URLSource urlSource = new URLSource();
                urlSource.init((URL)context.get((Object)"config-url"), null);
                this.configurationFile = new DelayedRefreshSourceWrapper((Source)urlSource, 1000L);
            }
            catch (IOException e) {
                throw new ContextException("Could not open configuration file.", (Throwable)e);
            }
            catch (Exception e) {
                throw new ContextException("contextualize(..) Exception", (Throwable)e);
            }
        }
    }

    public void setLoggerManager(LoggerManager loggerManager) {
        this.loggerManager = loggerManager;
        Deprecation.setLogger(this.loggerManager.getLoggerForCategory("deprecation"));
    }

    public void setInstrumentManager(InstrumentManager manager) {
        this.instrumentManager = manager;
    }

    public void initialize() throws Exception {
        this.componentManager = this.parentComponentManager != null ? new CocoonComponentManager(this.parentComponentManager, (ClassLoader)this.context.get((Object)"class-loader")) : new CocoonComponentManager((ClassLoader)this.context.get((Object)"class-loader"));
        ContainerUtil.enableLogging((Object)this.componentManager, (Logger)this.rootLogger.getChildLogger("manager"));
        ContainerUtil.contextualize((Object)this.componentManager, (org.apache.avalon.framework.context.Context)this.context);
        this.componentManager.setInstrumentManager(this.instrumentManager);
        this.getLogger().debug("New Cocoon object.");
        this.dumpSystemProperties();
        String parser = Cocoon.getSystemProperty("org.apache.cocoon.components.parser.Parser", "org.apache.excalibur.xml.impl.JaxpParser");
        if (!"org.apache.excalibur.xml.impl.JaxpParser".equals(parser)) {
            this.getLogger().warn("Deprecated property org.apache.cocoon.components.parser.Parser is used. Please use org.apache.excalibur.xml.sax.SAXParser instead.");
            if ("org.apache.cocoon.components.parser.XercesParser".equals(parser)) {
                parser = XercesParser.class.getName();
            } else {
                this.getLogger().warn("Unknown value for deprecated property: org.apache.cocoon.components.parser.Parser, value: " + parser + ". If you experience problems during startup, check the parser configuration section of the documentation.");
            }
        } else {
            parser = Cocoon.getSystemProperty("org.apache.excalibur.xml.sax.SAXParser", "org.apache.excalibur.xml.impl.JaxpParser");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Parser: " + parser);
            this.getLogger().debug("Classpath: " + this.classpath);
            this.getLogger().debug("Work directory: " + this.workDir.getCanonicalPath());
        }
        ExcaliburComponentManager startupManager = new ExcaliburComponentManager((ClassLoader)this.context.get((Object)"class-loader"));
        ContainerUtil.enableLogging((Object)startupManager, (Logger)this.rootLogger.getChildLogger("startup"));
        ContainerUtil.contextualize((Object)startupManager, (org.apache.avalon.framework.context.Context)this.context);
        startupManager.setLoggerManager(this.loggerManager);
        try {
            startupManager.addComponent(SAXParser.ROLE, ClassUtils.loadClass(parser), (Configuration)new DefaultConfiguration("", "empty"));
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not load parser " + parser, (Throwable)e);
        }
        ContainerUtil.initialize((Object)startupManager);
        this.configure(startupManager);
        ContainerUtil.dispose((Object)startupManager);
        startupManager = null;
        ComponentProxyGenerator proxyGenerator = new ComponentProxyGenerator();
        Component loggerManagerProxy = proxyGenerator.getProxy(LoggerManager.class.getName(), (Object)this.loggerManager);
        this.componentManager.addComponentInstance(LoggerManager.ROLE, loggerManagerProxy);
        ContainerUtil.initialize((Object)this.componentManager);
        Processor processor = (Processor)this.componentManager.lookup(Processor.ROLE);
        if (processor instanceof ThreadSafe) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Processor of class " + processor.getClass().getName() + " is ThreadSafe");
            }
            this.threadSafeProcessor = processor;
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Processor of class " + processor.getClass().getName() + " is NOT ThreadSafe -- will be looked up at each request");
            }
            this.componentManager.release((Component)processor);
        }
        this.sourceResolver = (SourceResolver)this.componentManager.lookup(SourceResolver.ROLE);
        if (this.componentManager.hasComponent(RequestListener.ROLE)) {
            this.requestListener = (RequestListener)this.componentManager.lookup(RequestListener.ROLE);
        }
    }

    private void dumpSystemProperties() {
        if (this.getLogger().isDebugEnabled()) {
            try {
                Enumeration<?> e = System.getProperties().propertyNames();
                this.getLogger().debug("===== System Properties Start =====");
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    this.getLogger().debug(key + "=" + System.getProperty(key));
                }
                this.getLogger().debug("===== System Properties End =====");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public void configure(ExcaliburComponentManager startupManager) throws ConfigurationException, ContextException {
        InputSource is;
        SAXParser p = null;
        Settings settings = SettingsHelper.getSettings(this.context);
        Configuration roles = null;
        try {
            p = (SAXParser)startupManager.lookup(SAXParser.ROLE);
            PropertyAwareSAXConfigurationHandler b = new PropertyAwareSAXConfigurationHandler(settings, this.getLogger());
            URL url = ClassUtils.getResource("org/apache/cocoon/cocoon.roles");
            is = new InputSource(url.openStream());
            is.setSystemId(url.toString());
            p.parse(is, (ContentHandler)((Object)b));
            roles = b.getConfiguration();
        }
        catch (Exception e) {
            throw new ConfigurationException("Error trying to load configurations", (Throwable)e);
        }
        finally {
            if (p != null) {
                startupManager.release((Component)p);
            }
        }
        DefaultRoleManager drm = new DefaultRoleManager();
        ContainerUtil.enableLogging((Object)drm, (Logger)this.rootLogger.getChildLogger("roles"));
        ContainerUtil.configure((Object)drm, (Configuration)roles);
        roles = null;
        try {
            this.configurationFile.refresh();
            p = (SAXParser)startupManager.lookup(SAXParser.ROLE);
            PropertyAwareSAXConfigurationHandler b = new PropertyAwareSAXConfigurationHandler(settings, this.getLogger());
            is = SourceUtil.getInputSource(this.configurationFile);
            p.parse(is, (ContentHandler)((Object)b));
            this.configuration = b.getConfiguration();
        }
        catch (Exception e) {
            throw new ConfigurationException("Error trying to load configurations", (Throwable)e);
        }
        finally {
            if (p != null) {
                startupManager.release((Component)p);
            }
        }
        Configuration conf = this.configuration;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Root configuration: " + conf.getName());
        }
        if (!"cocoon".equals(conf.getName())) {
            throw new ConfigurationException("Invalid configuration file\n" + conf.toString());
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configuration version: " + conf.getAttribute("version"));
        }
        if (!"2.1".equals(conf.getAttribute("version"))) {
            throw new ConfigurationException("Invalid configuration schema version. Must be '2.1'.");
        }
        String userRoles = conf.getAttribute("user-roles", "");
        if (!"".equals(userRoles)) {
            try {
                p = (SAXParser)startupManager.lookup(SAXParser.ROLE);
                PropertyAwareSAXConfigurationHandler b = new PropertyAwareSAXConfigurationHandler(settings, this.getLogger());
                Context context = (Context)this.context.get((Object)"environment-context");
                URL url = context.getResource(userRoles);
                if (url == null) {
                    throw new ConfigurationException("User-roles configuration '" + userRoles + "' cannot be found.");
                }
                InputSource is2 = new InputSource(new BufferedInputStream(url.openStream()));
                is2.setSystemId(url.toString());
                p.parse(is2, (ContentHandler)((Object)b));
                roles = b.getConfiguration();
            }
            catch (Exception e) {
                throw new ConfigurationException("Error trying to load user-roles configuration", (Throwable)e);
            }
            finally {
                startupManager.release((Component)p);
            }
            DefaultRoleManager urm = new DefaultRoleManager((RoleManager)drm);
            ContainerUtil.enableLogging((Object)urm, (Logger)this.rootLogger.getChildLogger("roles").getChildLogger("user"));
            ContainerUtil.configure((Object)urm, (Configuration)roles);
            roles = null;
            drm = urm;
        }
        this.componentManager.setRoleManager((RoleManager)drm);
        this.componentManager.setLoggerManager(this.loggerManager);
        this.getLogger().debug("Setting up components...");
        ContainerUtil.configure((Object)this.componentManager, (Configuration)conf);
    }

    @Override
    public boolean modifiedSince(long date) {
        return date < this.configurationFile.getLastModified();
    }

    public static String getSystemProperty(String property, String value) {
        try {
            return System.getProperty(property, value);
        }
        catch (SecurityException e) {
            System.err.println("Caught a SecurityException reading the system property '" + property + "';" + " Cocoon will default to '" + value + "' value.");
            return value;
        }
    }

    protected void setSystemProperties() {
        try {
            if (Cocoon.getSystemProperty("org.xml.sax.driver", null) == null) {
                System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
            }
        }
        catch (SecurityException e) {
            System.out.println("Caught a SecurityException writing the system property: " + e);
        }
        try {
            if (Cocoon.getSystemProperty("javax.xml.parsers.DocumentBuilderFactory", "").startsWith("weblogic")) {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
                System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
            }
        }
        catch (SecurityException e) {
            System.out.println("Caught a SecurityException writing the system property: " + e);
        }
    }

    public void dispose() {
        if (this.componentManager != null) {
            if (this.requestListener != null) {
                this.componentManager.release((Component)this.requestListener);
            }
            this.componentManager.release((Component)this.threadSafeProcessor);
            this.threadSafeProcessor = null;
            this.componentManager.release((Component)this.sourceResolver);
            this.sourceResolver = null;
            ContainerUtil.dispose((Object)this.componentManager);
            this.componentManager = null;
        }
        this.context = null;
        if (instance == this) {
            instance = null;
        }
        this.disposed = true;
    }

    protected void debug(Environment environment, boolean internal) {
        String lineSeparator = SystemUtils.LINE_SEPARATOR;
        Map objectModel = environment.getObjectModel();
        Request request = ObjectModelHelper.getRequest(objectModel);
        Session session = request.getSession(false);
        StringBuffer msg = new StringBuffer(2048);
        msg.append("DEBUGGING INFORMATION:").append(lineSeparator);
        if (internal) {
            msg.append("INTERNAL ");
        }
        msg.append("REQUEST: ").append(request.getRequestURI()).append(lineSeparator).append(lineSeparator);
        msg.append("CONTEXT PATH: ").append(request.getContextPath()).append(lineSeparator);
        msg.append("SERVLET PATH: ").append(request.getServletPath()).append(lineSeparator);
        msg.append("PATH INFO: ").append(request.getPathInfo()).append(lineSeparator).append(lineSeparator);
        msg.append("REMOTE HOST: ").append(request.getRemoteHost()).append(lineSeparator);
        msg.append("REMOTE ADDRESS: ").append(request.getRemoteAddr()).append(lineSeparator);
        msg.append("REMOTE USER: ").append(request.getRemoteUser()).append(lineSeparator);
        msg.append("REQUEST SESSION ID: ").append(request.getRequestedSessionId()).append(lineSeparator);
        msg.append("REQUEST PREFERRED LOCALE: ").append(request.getLocale().toString()).append(lineSeparator);
        msg.append("SERVER HOST: ").append(request.getServerName()).append(lineSeparator);
        msg.append("SERVER PORT: ").append(request.getServerPort()).append(lineSeparator).append(lineSeparator);
        msg.append("METHOD: ").append(request.getMethod()).append(lineSeparator);
        msg.append("CONTENT LENGTH: ").append(request.getContentLength()).append(lineSeparator);
        msg.append("PROTOCOL: ").append(request.getProtocol()).append(lineSeparator);
        msg.append("SCHEME: ").append(request.getScheme()).append(lineSeparator);
        msg.append("AUTH TYPE: ").append(request.getAuthType()).append(lineSeparator).append(lineSeparator);
        msg.append("CURRENT ACTIVE REQUESTS: ").append(this.activeRequestCount).append(lineSeparator);
        Enumeration e = request.getParameterNames();
        msg.append("REQUEST PARAMETERS:").append(lineSeparator).append(lineSeparator);
        while (e.hasMoreElements()) {
            String p = (String)e.nextElement();
            msg.append("PARAM: '").append(p).append("' ").append("VALUES: '");
            String[] params = request.getParameterValues(p);
            for (int i = 0; i < params.length; ++i) {
                msg.append("[" + params[i] + "]");
                if (i == params.length - 1) continue;
                msg.append(", ");
            }
            msg.append("'").append(lineSeparator);
        }
        Enumeration e2 = request.getHeaderNames();
        msg.append("HEADER PARAMETERS:").append(lineSeparator).append(lineSeparator);
        while (e2.hasMoreElements()) {
            String p = (String)e2.nextElement();
            msg.append("PARAM: '").append(p).append("' ").append("VALUES: '");
            Enumeration e3 = request.getHeaders(p);
            while (e3.hasMoreElements()) {
                msg.append("[" + e3.nextElement() + "]");
                if (!e3.hasMoreElements()) continue;
                msg.append(", ");
            }
            msg.append("'").append(lineSeparator);
        }
        msg.append(lineSeparator).append("SESSION ATTRIBUTES:").append(lineSeparator).append(lineSeparator);
        if (session != null) {
            StringBuffer buffer = new StringBuffer("");
            for (int count = -1; count <= 0; ++count) {
                try {
                    e = session.getAttributeNames();
                    while (e.hasMoreElements()) {
                        String p = (String)e.nextElement();
                        buffer.append("PARAM: '").append(p).append("' ").append("VALUE: '").append(session.getAttribute(p)).append("'").append(lineSeparator);
                    }
                    break;
                }
                catch (ConcurrentModificationException ex) {
                    buffer = new StringBuffer("");
                    continue;
                }
            }
            msg.append(buffer.toString());
        }
        this.getLogger().debug(msg.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Environment environment) throws Exception {
        if (this.disposed) {
            throw new IllegalStateException("You cannot process a Disposed Cocoon engine.");
        }
        Object key = CocoonComponentManager.startProcessing(environment);
        int environmentDepth = CocoonComponentManager.markEnvironment();
        CocoonComponentManager.enterEnvironment(environment, (ComponentManager)this.componentManager, this);
        try {
            boolean result;
            if (this.getLogger().isDebugEnabled()) {
                ++this.activeRequestCount;
                this.debug(environment, false);
            }
            if (this.requestListener != null) {
                try {
                    this.requestListener.onRequestStart(environment);
                }
                catch (Exception e) {
                    this.getLogger().error("Error encountered monitoring request start: " + e.getMessage());
                }
            }
            if (this.threadSafeProcessor != null) {
                result = this.threadSafeProcessor.process(environment);
                if (this.requestListener != null) {
                    try {
                        this.requestListener.onRequestEnd(environment);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Error encountered monitoring request start: " + e.getMessage());
                    }
                }
            } else {
                Processor processor = (Processor)this.componentManager.lookup(Processor.ROLE);
                try {
                    result = processor.process(environment);
                    if (this.requestListener != null) {
                        try {
                            this.requestListener.onRequestEnd(environment);
                        }
                        catch (Exception e) {
                            this.getLogger().error("Error encountered monitoring request start: " + e.getMessage());
                        }
                    }
                }
                finally {
                    this.componentManager.release((Component)processor);
                }
            }
            environment.commitResponse();
            boolean processor = result;
            return processor;
        }
        catch (Exception any) {
            if (this.requestListener != null) {
                try {
                    this.requestListener.onRequestException(environment, any);
                }
                catch (Exception e) {
                    this.getLogger().error("Error encountered monitoring request start: " + e.getMessage());
                }
            }
            environment.tryResetResponse();
            throw any;
        }
        finally {
            CocoonComponentManager.leaveEnvironment();
            CocoonComponentManager.endProcessing(environment, key);
            if (this.getLogger().isDebugEnabled()) {
                --this.activeRequestCount;
            }
            CocoonComponentManager.checkEnvironment(environmentDepth, this.getLogger());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingPipeline buildPipeline(Environment environment) throws Exception {
        if (this.disposed) {
            throw new IllegalStateException("You cannot process a Disposed Cocoon engine.");
        }
        try {
            ProcessingPipeline processingPipeline;
            if (this.getLogger().isDebugEnabled()) {
                ++this.activeRequestCount;
                this.debug(environment, true);
            }
            if (this.threadSafeProcessor != null) {
                ProcessingPipeline processingPipeline2 = this.threadSafeProcessor.buildPipeline(environment);
                return processingPipeline2;
            }
            Processor processor = (Processor)this.componentManager.lookup(Processor.ROLE);
            try {
                processingPipeline = processor.buildPipeline(environment);
            }
            catch (Throwable throwable) {
                this.componentManager.release((Component)processor);
                throw throwable;
            }
            this.componentManager.release((Component)processor);
            return processingPipeline;
        }
        finally {
            if (this.getLogger().isDebugEnabled()) {
                --this.activeRequestCount;
            }
        }
    }

    @Override
    public Map getComponentConfigurations() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Processor getRootProcessor() {
        return this;
    }

    public int getActiveRequestCount() {
        return this.activeRequestCount;
    }

    public ExcaliburComponentManager getComponentManager() {
        return this.componentManager;
    }

    protected SourceResolver createSourceResolver(Logger logger) throws ContextException {
        SimpleSourceResolver resolver = new SimpleSourceResolver();
        resolver.enableLogging(logger);
        try {
            resolver.contextualize(this.context);
        }
        catch (ContextException ce) {
            throw new ContextException("Cannot setup source resolver.", (Throwable)ce);
        }
        return resolver;
    }

    static {
        LocationUtils.addFinder(LOCATION_FINDER);
    }
}

