/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.bean.helpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.bean.Target;

public class Crawler {
    private Map allTranslatedLinks;
    private Map stillNotVisited;
    private Set visitedAlready = new HashSet();

    public Crawler() {
        this.stillNotVisited = new HashMap();
        this.allTranslatedLinks = new HashMap();
    }

    public boolean addTarget(Target target) {
        String targetString = target.toString();
        if (!this.visitedAlready.contains(targetString) && !this.stillNotVisited.containsKey(targetString)) {
            this.stillNotVisited.put(targetString, target);
            return true;
        }
        return false;
    }

    public int getRemainingCount() {
        return this.stillNotVisited.size();
    }

    public int getProcessedCount() {
        return this.visitedAlready.size();
    }

    public int getTranslatedCount() {
        return this.allTranslatedLinks.size();
    }

    public void addTranslatedLink(Target target) throws ProcessingException {
        this.allTranslatedLinks.put(target.getSourceURI(), target);
    }

    public boolean hasTranslatedLink(Target link) {
        return this.allTranslatedLinks.get(link.getSourceURI()) != null;
    }

    public Target getTranslatedLink(Target link) {
        return (Target)this.allTranslatedLinks.get(link.getSourceURI());
    }

    public CrawlingIterator iterator() {
        return new CrawlingIterator(this.visitedAlready, this.stillNotVisited);
    }

    public static class CrawlingIterator
    implements Iterator {
        private Map stillNotVisited;
        private Set visitedAlready;

        public CrawlingIterator(Set visitedAlready, Map stillNotVisited) {
            this.visitedAlready = visitedAlready;
            this.stillNotVisited = stillNotVisited;
        }

        @Override
        public boolean hasNext() {
            return !this.stillNotVisited.isEmpty();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            Object nextKey = this.stillNotVisited.keySet().toArray()[0];
            Object nextElement = this.stillNotVisited.remove(nextKey);
            this.visitedAlready.add(nextKey);
            return nextElement;
        }
    }
}

