/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.GlobalRequestLifecycleComponent;
import org.apache.cocoon.environment.Environment;

final class EnvironmentDescription {
    Environment environment;
    Map objectModel;
    Map requestLifecycleComponents;
    List autoreleaseComponents = new ArrayList(4);

    EnvironmentDescription(Environment env) {
        this.environment = env;
        this.objectModel = env.getObjectModel();
    }

    Map getGlobalRequestLifcecycleComponents() {
        HashMap m = (HashMap)this.environment.getAttribute(GlobalRequestLifecycleComponent.class.getName());
        if (m == null) {
            m = new HashMap();
            this.environment.setAttribute(GlobalRequestLifecycleComponent.class.getName(), m);
        }
        return m;
    }

    synchronized void release() {
        Component component;
        if (this.requestLifecycleComponents != null) {
            for (Object[] o : this.requestLifecycleComponents.values()) {
                component = (Component)o[0];
                ((CocoonComponentManager)((Object)o[1])).releaseRLComponent(component);
            }
            this.requestLifecycleComponents.clear();
        }
        for (int i = 0; i < this.autoreleaseComponents.size(); ++i) {
            Object[] o;
            o = (Object[])this.autoreleaseComponents.get(i);
            component = (Component)o[0];
            if (o[1] instanceof ComponentManager) {
                ((ComponentManager)o[1]).release(component);
                continue;
            }
            ((ComponentSelector)o[1]).release(component);
            if (o[2] == null) continue;
            ((ComponentManager)o[2]).release((Component)o[1]);
        }
        this.autoreleaseComponents.clear();
        this.environment = null;
        this.objectModel = null;
    }

    void addRequestLifecycleComponent(String role, Component co, ComponentManager manager) {
        if (this.requestLifecycleComponents == null) {
            this.requestLifecycleComponents = new HashMap();
        }
        this.requestLifecycleComponents.put(role, new Object[]{co, manager});
    }

    void addGlobalRequestLifecycleComponent(String role, Component co, ComponentManager manager) {
        this.getGlobalRequestLifcecycleComponents().put(role, new Object[]{co, manager});
    }

    boolean containsRequestLifecycleComponent(String role) {
        if (this.requestLifecycleComponents == null) {
            return false;
        }
        return this.requestLifecycleComponents.containsKey(role);
    }

    boolean containsGlobalRequestLifecycleComponent(String role) {
        return this.getGlobalRequestLifcecycleComponents().containsKey(role);
    }

    Component getRequestLifecycleComponent(String role) {
        if (this.requestLifecycleComponents == null) {
            return null;
        }
        Object[] o = (Object[])this.requestLifecycleComponents.get(role);
        if (null != o) {
            return (Component)o[0];
        }
        return null;
    }

    Component getGlobalRequestLifecycleComponent(String role) {
        Object[] o = (Object[])this.getGlobalRequestLifcecycleComponents().get(role);
        if (null != o) {
            return (Component)o[0];
        }
        return null;
    }

    synchronized void addToAutoRelease(ComponentSelector selector, Component component, ComponentManager manager) {
        this.autoreleaseComponents.add(new Object[]{component, selector, manager});
    }

    synchronized void addToAutoRelease(ComponentManager manager, Component component) {
        this.autoreleaseComponents.add(new Object[]{component, manager});
    }

    synchronized void removeFromAutoRelease(Component component) throws ProcessingException {
        int i = 0;
        boolean found = false;
        while (i < this.autoreleaseComponents.size() && !found) {
            Object[] o = (Object[])this.autoreleaseComponents.get(i);
            if (o[0] == component) {
                found = true;
                if (o[1] instanceof ComponentManager) {
                    ((ComponentManager)o[1]).release(component);
                } else {
                    ((ComponentSelector)o[1]).release(component);
                    if (o[2] != null) {
                        ((ComponentManager)o[2]).release((Component)o[1]);
                    }
                }
                this.autoreleaseComponents.remove(i);
                continue;
            }
            ++i;
        }
        if (!found) {
            throw new ProcessingException("Unable to remove component from automatic release: component not found.");
        }
    }
}

