/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components;

import org.apache.avalon.excalibur.component.ExcaliburComponentSelector;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.cocoon.components.ComponentLocator;
import org.apache.cocoon.components.ParentAware;

public class ExtendedComponentSelector
extends ExcaliburComponentSelector
implements ParentAware {
    protected RoleManager roles;
    protected ExtendedComponentSelector parentSelector;
    protected ComponentLocator parentLocator;
    protected ClassLoader classLoader;
    protected String roleName;
    protected String defaultHint;
    private String location;

    public ExtendedComponentSelector() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public ExtendedComponentSelector(ClassLoader loader) {
        super(loader);
        this.classLoader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
    }

    protected String getComponentInstanceName() {
        return null;
    }

    protected String getClassAttributeName() {
        return "class";
    }

    protected String getDefaultHintAttributeName() {
        return "default";
    }

    public void setRoleManager(RoleManager roles) {
        super.setRoleManager(roles);
        this.roles = roles;
    }

    protected String getRoleName(Configuration config) {
        String roleName = config.getAttribute("role", null);
        if (roleName == null && this.roles != null) {
            roleName = this.roles.getRoleForName(config.getName());
        }
        return roleName;
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.location = config.getLocation();
        this.roleName = this.getRoleName(config);
        DefaultConfiguration temp = new DefaultConfiguration(config.getName(), this.location);
        if (config.getAttribute("role", null) != null) {
            temp.setAttribute("role", this.roleName);
        }
        super.configure((Configuration)temp);
        this.defaultHint = config.getAttribute(this.getDefaultHintAttributeName(), null);
        String compInstanceName = this.getComponentInstanceName();
        Configuration[] instances = config.getChildren();
        for (int i = 0; i < instances.length; ++i) {
            Configuration instance = instances[i];
            String hint = instance.getAttribute("name").trim();
            String classAttr = instance.getAttribute(this.getClassAttributeName(), null);
            String className = compInstanceName == null ? (classAttr == null ? this.roles.getDefaultClassNameForHint(this.roleName, instance.getName()) : classAttr.trim()) : (compInstanceName.equals(instance.getName()) ? (classAttr == null ? null : classAttr.trim()) : this.roles.getDefaultClassNameForHint(this.roleName, instance.getName()));
            if (className == null) {
                String message = "Unable to determine class name for component named '" + hint + "' at " + instance.getLocation();
                this.getLogger().error(message);
                throw new ConfigurationException(message);
            }
            try {
                Class<?> clazz = this.classLoader.loadClass(className);
                this.addComponent(hint, clazz, instance);
                continue;
            }
            catch (Exception e) {
                String message = "Could not load class " + className + " for component named '" + hint + "' at " + instance.getLocation();
                this.getLogger().error(message, (Throwable)e);
                throw new ConfigurationException(message, (Throwable)e);
            }
        }
    }

    public String getDefaultHint() {
        if (this.defaultHint == null && this.parentSelector != null) {
            return this.parentSelector.getDefaultHint();
        }
        return this.defaultHint;
    }

    public Component select(Object hint) throws ComponentException {
        if (hint == null) {
            hint = this.defaultHint;
        }
        if (this.parentSelector == null) {
            return super.select(hint);
        }
        try {
            Component component = super.select(hint);
            return component;
        }
        catch (ComponentException original) {
            try {
                Component component = this.parentSelector.select(hint);
                return component;
            }
            catch (ComponentException nested) {
                if (nested.getCause() != null) {
                    throw nested;
                }
                throw original;
            }
        }
    }

    public void release(Component component) {
        if (this.parentSelector != null && this.parentSelector.canRelease(component)) {
            this.parentSelector.release(component);
        } else {
            super.release(component);
        }
    }

    public boolean hasComponent(Object hint) {
        boolean exists = super.hasComponent(hint);
        if (!exists && this.parentSelector != null) {
            exists = this.parentSelector.hasComponent(hint);
        }
        return exists;
    }

    protected boolean hasDeclaredComponent(Object hint) {
        return super.hasComponent(hint);
    }

    @Override
    public void setParentLocator(ComponentLocator locator) throws ComponentException {
        if (this.parentSelector != null) {
            throw new ComponentException(null, "Parent selector is already set");
        }
        this.parentLocator = locator;
        this.parentSelector = (ExtendedComponentSelector)locator.lookup();
    }

    public void dispose() {
        super.dispose();
        if (this.parentLocator != null) {
            this.parentLocator.release(this.parentSelector);
            this.parentLocator = null;
            this.parentSelector = null;
        }
    }

    protected boolean canRelease(Component component) {
        if (this.parentSelector != null && this.parentSelector.canRelease(component)) {
            return true;
        }
        return super.canRelease(component);
    }
}

