/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.jxpath.ClassFunctions;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.PackageFunctions;

public class JXPathHelperConfiguration {
    private FunctionLibrary library;
    private boolean lenient;
    private Map namespaces;

    public JXPathHelperConfiguration() {
        this.lenient = true;
    }

    public JXPathHelperConfiguration(Configuration config) throws ConfigurationException {
        this.lenient = config.getChild("lenient").getValueAsBoolean(true);
        this.library = new FunctionLibrary();
        this.setup(config);
        this.library.addFunctions((Functions)new PackageFunctions("", null));
    }

    public JXPathHelperConfiguration(JXPathHelperConfiguration global, Configuration config) throws ConfigurationException {
        this.lenient = global.lenient;
        this.library = new FunctionLibrary();
        this.library.addFunctions((Functions)global.getLibrary());
        if (global.getNamespaces() != null) {
            this.namespaces = new HashMap(global.getNamespaces());
        }
        this.setup(config);
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public FunctionLibrary getLibrary() {
        return this.library;
    }

    public Map getNamespaces() {
        return this.namespaces;
    }

    private void setup(Configuration config) throws ConfigurationException {
        this.getFunctions(config);
        this.getPackages(config);
        this.getNamespaces(config);
    }

    private void getFunctions(Configuration conf) {
        Configuration[] children = conf.getChildren("function");
        int i = children.length;
        while (i-- > 0) {
            String clazzName = children[i].getAttribute("name", null);
            String prefix = children[i].getAttribute("prefix", null);
            if (clazzName == null || prefix == null) continue;
            try {
                Class<?> clazz = Class.forName(clazzName);
                this.library.addFunctions((Functions)new ClassFunctions(clazz, prefix));
            }
            catch (ClassNotFoundException cnf) {}
        }
    }

    private void getPackages(Configuration conf) {
        Configuration[] children = conf.getChildren("package");
        int i = children.length;
        while (i-- > 0) {
            String packageName = children[i].getAttribute("name", null);
            String prefix = children[i].getAttribute("prefix", null);
            if (packageName == null || prefix == null) continue;
            this.library.addFunctions((Functions)new PackageFunctions(packageName, prefix));
        }
    }

    private void getNamespaces(Configuration conf) throws ConfigurationException {
        Configuration[] children = conf.getChildren("namespace");
        int i = children.length;
        if (i > 0) {
            this.namespaces = new HashMap(i + 2);
        }
        while (i-- > 0) {
            String uri = children[i].getAttribute("uri");
            String prefix = children[i].getAttribute("prefix");
            if (uri == null || prefix == null) continue;
            this.namespaces.put(prefix, uri);
        }
    }
}

