/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.notification;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.component.Component;
import org.apache.cocoon.components.notification.Notifying;
import org.apache.cocoon.components.notification.NotifyingBuilder;
import org.apache.cocoon.components.notification.SimpleNotifyingBean;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.xml.sax.SAXParseException;

public class DefaultNotifyingBuilder
implements NotifyingBuilder,
Component {
    @Override
    public Notifying build(Object sender, Object o) {
        if (o instanceof Notifying) {
            return (Notifying)o;
        }
        if (o instanceof Throwable) {
            Throwable t = (Throwable)o;
            SimpleNotifyingBean n = new SimpleNotifyingBean(sender);
            n.setType("error");
            n.setTitle("An Error Occurred");
            if (t != null) {
                TransformerException transformerException;
                SourceLocator sourceLocator;
                Throwable rootCause = DefaultNotifyingBuilder.getRootCause(t);
                n.setSource(t.getClass().getName());
                if (rootCause.getMessage() != null) {
                    n.setMessage(rootCause.getMessage());
                } else {
                    n.setMessage(t.getMessage());
                }
                n.setDescription(t.toString());
                n.addExtraDescription("cause", rootCause.toString());
                if (rootCause instanceof SAXParseException) {
                    SAXParseException saxParseException = (SAXParseException)rootCause;
                    n.addExtraDescription("location", String.valueOf(saxParseException.getSystemId()));
                    n.addExtraDescription("line", String.valueOf(saxParseException.getLineNumber()));
                    n.addExtraDescription("column", String.valueOf(saxParseException.getColumnNumber()));
                } else if (rootCause instanceof TransformerException && null != (sourceLocator = (transformerException = (TransformerException)rootCause).getLocator())) {
                    n.addExtraDescription("location", String.valueOf(sourceLocator.getSystemId()));
                    n.addExtraDescription("line", String.valueOf(sourceLocator.getLineNumber()));
                    n.addExtraDescription("column", String.valueOf(sourceLocator.getColumnNumber()));
                }
                StringWriter sw = new StringWriter();
                rootCause.printStackTrace(new PrintWriter(sw));
                n.addExtraDescription("stacktrace", sw.toString());
                sw = new StringWriter();
                DefaultNotifyingBuilder.appendTraceChain(sw, t);
                n.addExtraDescription("full exception chain stacktrace", sw.toString());
            }
            return n;
        }
        SimpleNotifyingBean n = new SimpleNotifyingBean(sender);
        n.setType("unknown");
        n.setTitle("Object Notification");
        n.setMessage(String.valueOf(o));
        n.setDescription("No details available.");
        return n;
    }

    @Override
    public Notifying build(Object sender, Object o, String type, String title, String source, String message, String description, Map extra) {
        SimpleNotifyingBean n = (SimpleNotifyingBean)this.build(sender, o);
        if (type != null) {
            n.setType(type);
        }
        if (title != null) {
            n.setTitle(title);
        }
        if (source != null) {
            n.setSource(source);
        }
        if (message != null) {
            n.setMessage(message);
        }
        if (description != null) {
            n.setDescription(description);
        }
        if (extra != null) {
            n.addExtraDescriptions(extra);
        }
        return n;
    }

    private static void appendTraceChain(Writer out, Throwable t) {
        PrintWriter pw = new PrintWriter(out);
        if (SystemUtils.isJavaVersionAtLeast((int)140)) {
            t.printStackTrace(pw);
        } else {
            Throwable cause = t;
            while (cause != null) {
                if (cause != t) {
                    pw.println();
                }
                cause.printStackTrace(pw);
                cause = ExceptionUtils.getCause((Throwable)cause);
            }
        }
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
        return rootCause != null ? rootCause : t;
    }
}

