/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.CachingOutputStream;
import org.apache.cocoon.caching.IdentifierCacheKey;
import org.apache.cocoon.components.pipeline.impl.BaseCachingProcessingPipeline;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.components.sax.XMLTeePipe;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.ExpiresValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;

public class ExpiresCachingProcessingPipeline
extends BaseCachingProcessingPipeline {
    public static final String CACHE_KEY_KEY = ExpiresCachingProcessingPipeline.class.getName() + "/CacheKey";
    public static final String CACHE_EXPIRES_KEY = ExpiresCachingProcessingPipeline.class.getName() + "/Expires";
    protected SourceValidity cacheValidity;
    protected IdentifierCacheKey cacheKey;
    protected long cacheExpires;
    protected long defaultCacheExpires = 3600L;
    protected CachedResponse cachedResponse;

    @Override
    public void parameterize(Parameters params) throws ParameterException {
        super.parameterize(params);
        this.defaultCacheExpires = params.getParameterAsLong("cache-expires", this.defaultCacheExpires);
    }

    @Override
    protected boolean processXMLPipeline(Environment environment) throws ProcessingException {
        try {
            if (this.cachedResponse != null) {
                byte[] content = this.cachedResponse.getResponse();
                if (this.serializer == this.lastConsumer) {
                    if (this.cachedResponse.getContentType() != null) {
                        environment.setContentType(this.cachedResponse.getContentType());
                    } else {
                        this.setMimeTypeForSerializer(environment);
                    }
                    OutputStream outputStream = environment.getOutputStream(0);
                    if (content.length > 0) {
                        environment.setContentLength(content.length);
                        outputStream.write(content);
                    }
                } else {
                    this.setMimeTypeForSerializer(environment);
                    this.xmlDeserializer.setConsumer(this.lastConsumer);
                    this.xmlDeserializer.deserialize(content);
                }
            } else {
                byte[] cachedData;
                if (this.cacheExpires == 0L) {
                    return super.processXMLPipeline(environment);
                }
                this.setMimeTypeForSerializer(environment);
                if (this.serializer == this.lastConsumer) {
                    if (this.serializer.shouldSetContentLength()) {
                        OutputStream os = environment.getOutputStream(this.outputBufferSize);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        this.serializer.setOutputStream(baos);
                        this.generator.generate();
                        cachedData = baos.toByteArray();
                        environment.setContentLength(cachedData.length);
                        os.write(cachedData);
                    } else {
                        CachingOutputStream os = new CachingOutputStream(environment.getOutputStream(this.outputBufferSize));
                        this.serializer.setOutputStream(os);
                        this.generator.generate();
                        cachedData = os.getContent();
                    }
                } else {
                    this.generator.generate();
                    cachedData = (byte[])this.xmlSerializer.getSAXFragment();
                }
                if (this.cacheValidity != null) {
                    this.cachedResponse = new CachedResponse(this.cacheValidity, cachedData);
                    this.cachedResponse.setContentType(environment.getContentType());
                    this.cache.store(this.cacheKey, this.cachedResponse);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return true;
    }

    @Override
    protected void connectPipeline(Environment environment) throws ProcessingException {
        if (this.lastConsumer != this.serializer) {
            if (this.cachedResponse == null) {
                if (this.cacheExpires != 0L) {
                    try {
                        XMLConsumer old = this.lastConsumer;
                        this.xmlSerializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
                        this.lastConsumer = new XMLTeePipe(this.lastConsumer, this.xmlSerializer);
                        super.connectPipeline(environment);
                        this.lastConsumer = old;
                    }
                    catch (ComponentException e) {
                        throw new ProcessingException("Could not connect pipeline.", e);
                    }
                } else {
                    super.connectPipeline(environment);
                }
            } else {
                try {
                    this.xmlDeserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                }
                catch (ComponentException e) {
                    throw new ProcessingException("Could not connect pipeline.", e);
                }
            }
        } else if (this.cachedResponse == null) {
            super.connectPipeline(environment);
        }
    }

    @Override
    protected void preparePipeline(Environment environment) throws ProcessingException {
        if (this.cachedResponse == null) {
            super.preparePipeline(environment);
        }
    }

    @Override
    protected void setupPipeline(Environment environment) throws ProcessingException {
        String expiresValue;
        Map objectModel = environment.getObjectModel();
        String key = (String)objectModel.get(CACHE_KEY_KEY);
        if (key == null) {
            key = this.parameters.getParameter("cache-key", null);
            if (key == null) {
                key = environment.getURIPrefix() + environment.getURI();
            }
        } else {
            objectModel.remove(CACHE_KEY_KEY);
        }
        if ((expiresValue = (String)objectModel.get(CACHE_EXPIRES_KEY)) == null) {
            this.cacheExpires = this.parameters.getParameterAsLong("cache-expires", this.defaultCacheExpires);
        } else {
            this.cacheExpires = Long.valueOf(expiresValue);
            objectModel.remove(CACHE_EXPIRES_KEY);
        }
        this.cacheKey = new IdentifierCacheKey(key, this.serializer == this.lastConsumer);
        if (this.cacheExpires > 0L) {
            this.cacheValidity = new ExpiresValidity(this.cacheExpires * 1000L);
        } else if (this.cacheExpires < 0L) {
            this.cacheValidity = NOPValidity.SHARED_INSTANCE;
        }
        boolean purge = this.parameters.getParameterAsBoolean("purge-cache", false);
        this.cachedResponse = this.cache.get(this.cacheKey);
        if (this.cachedResponse != null) {
            SourceValidity sv = this.cachedResponse.getValidityObjects()[0];
            if (purge || this.cacheExpires != -1L && sv.isValid() != 1) {
                this.cache.remove(this.cacheKey);
                this.cachedResponse = null;
            }
        }
        if (this.cacheExpires > 0L && (this.reader != null || this.lastConsumer == this.serializer)) {
            Response res = ObjectModelHelper.getResponse(environment.getObjectModel());
            res.setDateHeader("Expires", System.currentTimeMillis() + this.cacheExpires * 1000L);
            res.setHeader("Cache-Control", "max-age=" + this.cacheExpires + ", public");
        }
        if (this.cachedResponse == null) {
            super.setupPipeline(environment);
        }
    }

    @Override
    public SourceValidity getValidityForEventPipeline() {
        return this.cacheValidity;
    }

    @Override
    public String getKeyForEventPipeline() {
        if (this.cacheKey != null && this.cacheValidity != null) {
            return this.cacheKey.toString();
        }
        return null;
    }

    @Override
    public void recycle() {
        this.cacheKey = null;
        this.cacheExpires = 0L;
        this.cachedResponse = null;
        super.recycle();
    }

    @Override
    protected boolean processReader(Environment environment) throws ProcessingException {
        try {
            if (this.cachedResponse != null) {
                if (this.cachedResponse.getContentType() != null) {
                    environment.setContentType(this.cachedResponse.getContentType());
                } else {
                    this.setMimeTypeForReader(environment);
                }
                byte[] content = this.cachedResponse.getResponse();
                environment.setContentLength(content.length);
                OutputStream os = environment.getOutputStream(0);
                os.write(content);
            } else {
                byte[] cachedData;
                if (this.cacheExpires == 0L) {
                    return super.processReader(environment);
                }
                this.setMimeTypeForReader(environment);
                if (this.reader.shouldSetContentLength()) {
                    OutputStream os = environment.getOutputStream(this.outputBufferSize);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.reader.setOutputStream(baos);
                    this.reader.generate();
                    cachedData = baos.toByteArray();
                    environment.setContentLength(cachedData.length);
                    os.write(cachedData);
                } else {
                    CachingOutputStream os = new CachingOutputStream(environment.getOutputStream(this.outputBufferSize));
                    this.reader.setOutputStream(os);
                    this.reader.generate();
                    cachedData = os.getContent();
                }
                if (this.cacheValidity != null) {
                    this.cachedResponse = new CachedResponse(this.cacheValidity, cachedData);
                    this.cachedResponse.setContentType(environment.getContentType());
                    this.cache.store(this.cacheKey, this.cachedResponse);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return true;
    }
}

