/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.modules.output.OutputModule;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.util.jxpath.DOMFactory;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.impl.AbstractSource;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XModuleSource
extends AbstractSource
implements ModifiableSource,
XMLizable,
DOMBuilder.Listener {
    private static final String SCHEME = "xmodule";
    private String attributeType;
    private String attributeName;
    private String xPath;
    protected ServiceManager manager;
    private Map objectModel;
    private Logger logger;
    private String configuredSerializerName = "xml";

    public XModuleSource(Map objectModel, String uri, ServiceManager manager, Logger logger) throws MalformedURLException {
        this.objectModel = objectModel;
        this.manager = manager;
        this.logger = logger;
        this.setSystemId(uri);
        int start = 0;
        int end = uri.indexOf(58);
        if (end == -1) {
            throw new MalformedURLException("Malformed uri for xmodule source (cannot find scheme) : " + uri);
        }
        String scheme = uri.substring(start, end);
        if (!SCHEME.equals(scheme)) {
            throw new MalformedURLException("Malformed uri for a xmodule source : " + uri);
        }
        this.setScheme(scheme);
        start = end + 1;
        end = uri.indexOf(58, start);
        if (end == -1) {
            throw new MalformedURLException("Malformed uri for xmodule source (cannot find attribute type) : " + uri);
        }
        this.attributeType = uri.substring(start, end);
        start = end + 1;
        if ((end = uri.indexOf(35, start)) == -1) {
            end = uri.length();
        }
        if (end == start) {
            throw new MalformedURLException("Malformed uri for xmodule source (cannot find attribute name) : " + uri);
        }
        this.attributeName = uri.substring(start, end);
        start = end + 1;
        this.xPath = start < uri.length() ? uri.substring(start) : "";
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        DOMStreamer domStreamer;
        JXPathContext context;
        Object obj = this.getInputAttribute(this.attributeType, this.attributeName);
        if (obj == null) {
            throw new SAXException(" The attribute: " + this.attributeName + " is empty");
        }
        if (this.xPath.length() != 0 && !this.xPath.equals("/") && (obj = (context = JXPathContext.newContext((Object)obj)).getPointer(this.xPath).getNode()) == null) {
            throw new SAXException("the xpath: " + this.xPath + " applied on the attribute: " + this.attributeName + " returns null");
        }
        if (obj instanceof Document) {
            domStreamer = new DOMStreamer(handler);
            domStreamer.stream((Document)obj);
        } else if (obj instanceof Node) {
            domStreamer = new DOMStreamer(handler);
            handler.startDocument();
            domStreamer.stream((Node)obj);
            handler.endDocument();
        } else if (obj instanceof XMLizable) {
            ((XMLizable)obj).toSAX(handler);
        } else {
            throw new SAXException("The object type: " + obj.getClass() + " could not be serialized to XML: " + obj);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream() throws IOException, SourceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting InputStream for " + this.getURI());
        }
        ByteArrayInputStream inputStream = null;
        ServiceSelector selector = null;
        Serializer serializer = null;
        try {
            selector = (ServiceSelector)this.manager.lookup(Serializer.ROLE + "Selector");
            serializer = (Serializer)selector.select((Object)this.configuredSerializerName);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2048);
            serializer.setOutputStream(outputStream);
            this.toSAX((ContentHandler)((Object)serializer));
            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            if (selector == null) return inputStream;
        }
        catch (SAXException e) {
            try {
                throw new SourceException("Serializing SAX to a ByteArray failed!", (Throwable)e);
                catch (ServiceException e2) {
                    throw new SourceException("Retrieving serializer failed.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (selector == null) throw throwable;
                selector.release(serializer);
                this.manager.release(selector);
                throw throwable;
            }
        }
        selector.release((Object)serializer);
        this.manager.release((Object)selector);
        return inputStream;
    }

    public boolean exists() {
        boolean exists = false;
        try {
            exists = this.getInputAttribute(this.attributeType, this.attributeName) != null;
        }
        catch (SAXException e) {
            exists = false;
        }
        return exists;
    }

    public OutputStream getOutputStream() throws IOException {
        return new DOMOutputStream();
    }

    public void delete() throws SourceException {
        if (this.xPath.length() != 0 && !this.xPath.equals("/")) {
            Object value;
            try {
                value = this.getInputAttribute(this.attributeType, this.attributeName);
            }
            catch (SAXException e) {
                throw new SourceException("delete: ", (Throwable)e);
            }
            if (value == null) {
                throw new SourceException(" The attribute: " + this.attributeName + " is empty");
            }
            JXPathContext context = JXPathContext.newContext((Object)value);
            context.removeAll(this.xPath);
        } else {
            try {
                this.setOutputAttribute(this.attributeType, this.attributeName, null);
            }
            catch (SAXException e) {
                throw new SourceException("delete: ", (Throwable)e);
            }
        }
    }

    public void deleteTest() throws SourceException {
        this.delete();
    }

    public boolean canCancel(OutputStream stream) {
        return false;
    }

    public void cancel(OutputStream stream) throws IOException {
    }

    public ContentHandler getContentHandler() {
        return new DOMBuilder(this);
    }

    @Override
    public void notify(Document insertDoc) throws SAXException {
        if (this.xPath.length() != 0 && !this.xPath.equals("/")) {
            Object value = this.getInputAttribute(this.attributeType, this.attributeName);
            if (value == null) {
                throw new SAXException(" The attribute: " + this.attributeName + " is empty");
            }
            JXPathContext context = JXPathContext.newContext((Object)value);
            if (value instanceof Document) {
                Document doc = (Document)value;
                Node importedNode = doc.importNode(insertDoc.getDocumentElement(), true);
                context.setLenient(true);
                context.setFactory((AbstractFactory)new DOMFactory());
                context.createPathAndSetValue(this.xPath, (Object)importedNode);
            } else {
                context.setValue(this.xPath, (Object)insertDoc);
            }
        } else {
            this.setOutputAttribute(this.attributeType, this.attributeName, insertDoc);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getInputAttribute(String inputModuleName, String attributeName) throws SAXException {
        Object obj;
        ServiceSelector selector = null;
        InputModule inputModule = null;
        try {
            selector = (ServiceSelector)this.manager.lookup(InputModule.ROLE + "Selector");
            inputModule = (InputModule)selector.select((Object)inputModuleName);
            obj = inputModule.getAttribute(attributeName, null, this.objectModel);
            if (selector == null) return obj;
        }
        catch (ServiceException e) {
            try {
                throw new SAXException("Could not find an InputModule of the type " + inputModuleName, (Exception)((Object)e));
                catch (ConfigurationException e2) {
                    throw new SAXException("Could not find an attribute: " + attributeName + " from the InputModule " + inputModuleName, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                if (selector == null) throw throwable;
                selector.release(inputModule);
                this.manager.release(selector);
                throw throwable;
            }
        }
        selector.release((Object)inputModule);
        this.manager.release((Object)selector);
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setOutputAttribute(String outputModuleName, String attributeName, Object value) throws SAXException {
        ServiceSelector selector = null;
        OutputModule outputModule = null;
        try {
            selector = (ServiceSelector)this.manager.lookup(OutputModule.ROLE + "Selector");
            outputModule = (OutputModule)selector.select((Object)outputModuleName);
            outputModule.setAttribute(null, this.objectModel, attributeName, value);
            outputModule.commit(null, this.objectModel);
            if (selector == null) return;
        }
        catch (ServiceException e) {
            try {
                throw new SAXException("Could not find an OutputModule of the type " + outputModuleName, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                if (selector == null) throw throwable;
                selector.release(outputModule);
                this.manager.release(selector);
                throw throwable;
            }
        }
        selector.release((Object)outputModule);
        this.manager.release((Object)selector);
        return;
    }

    private class DOMOutputStream
    extends ByteArrayOutputStream {
        private DOMOutputStream() {
        }

        @Override
        public void close() throws IOException {
            SAXParser parser = null;
            try {
                parser = (SAXParser)XModuleSource.this.manager.lookup(SAXParser.ROLE);
                parser.parse(new InputSource(new ByteArrayInputStream(super.toByteArray())), XModuleSource.this.getContentHandler());
            }
            catch (Exception e) {
                throw new IOException("Exception during processing of " + XModuleSource.this.getURI() + e.getMessage());
            }
            finally {
                if (parser != null) {
                    XModuleSource.this.manager.release((Object)parser);
                }
            }
            super.close();
        }
    }
}

