/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.ChainedConfiguration;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.TreeProcessor;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ForwardRedirector;
import org.apache.cocoon.environment.PermanentRedirector;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.cocoon.environment.wrapper.MutableEnvironmentFacade;

public class ConcreteTreeProcessor
extends AbstractLogEnabled
implements Processor,
Disposable {
    private TreeProcessor wrappingProcessor;
    ComponentManager sitemapComponentManager;
    private List disposableNodes;
    private ProcessingNode rootNode;
    private Map sitemapComponentConfigurations;
    private Configuration componentConfigurations;
    private int requestCount;

    public ConcreteTreeProcessor(TreeProcessor wrappingProcessor) {
        this.wrappingProcessor = wrappingProcessor;
    }

    public void setProcessorData(ComponentManager manager, ProcessingNode rootNode, List disposableNodes) {
        if (this.sitemapComponentManager != null) {
            throw new IllegalStateException("setProcessorData() can only be called once");
        }
        this.sitemapComponentManager = manager;
        this.rootNode = rootNode;
        this.disposableNodes = disposableNodes;
    }

    public void setComponentConfigurations(Configuration componentConfigurations) {
        this.componentConfigurations = componentConfigurations;
        this.sitemapComponentConfigurations = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getComponentConfigurations() {
        if (null == this.sitemapComponentConfigurations) {
            ConcreteTreeProcessor concreteTreeProcessor = this;
            synchronized (concreteTreeProcessor) {
                if (this.sitemapComponentConfigurations == null) {
                    Configuration[] childs;
                    Configuration[] configurationArray = childs = this.componentConfigurations == null ? null : this.componentConfigurations.getChildren();
                    if (null != childs) {
                        this.sitemapComponentConfigurations = null == this.wrappingProcessor.parent ? new HashMap(12) : new HashMap(this.wrappingProcessor.parent.getComponentConfigurations());
                        for (int m = 0; m < childs.length; ++m) {
                            String r = this.wrappingProcessor.roleManager.getRoleForName(childs[m].getName());
                            this.sitemapComponentConfigurations.put(r, new ChainedConfiguration(childs[m], (ChainedConfiguration)this.sitemapComponentConfigurations.get(r)));
                        }
                    } else {
                        this.sitemapComponentConfigurations = null == this.wrappingProcessor.parent ? Collections.EMPTY_MAP : this.wrappingProcessor.parent.getComponentConfigurations();
                    }
                }
            }
        }
        return this.sitemapComponentConfigurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markForDisposal() {
        ConcreteTreeProcessor concreteTreeProcessor = this;
        synchronized (concreteTreeProcessor) {
            --this.requestCount;
        }
        if (this.requestCount < 0) {
            this.dispose();
        }
    }

    public TreeProcessor getWrappingProcessor() {
        return this.wrappingProcessor;
    }

    @Override
    public Processor getRootProcessor() {
        return this.wrappingProcessor.getRootProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Environment environment) throws Exception {
        InvokeContext context = new InvokeContext();
        context.enableLogging(this.getLogger());
        try {
            boolean bl = this.process(environment, context);
            return bl;
        }
        finally {
            context.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingPipeline buildPipeline(Environment environment) throws Exception {
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        try {
            if (this.process(environment, context)) {
                ProcessingPipeline processingPipeline = context.getProcessingPipeline();
                return processingPipeline;
            }
            ProcessingPipeline processingPipeline = null;
            return processingPipeline;
        }
        finally {
            context.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(Environment environment, InvokeContext context) throws Exception {
        ConcreteTreeProcessor concreteTreeProcessor = this;
        synchronized (concreteTreeProcessor) {
            ++this.requestCount;
        }
        try {
            boolean bl;
            CocoonComponentManager.enterEnvironment(environment, this.sitemapComponentManager, this);
            Map objectModel = environment.getObjectModel();
            Object oldResolver = objectModel.get("source-resolver");
            Redirector oldRedirector = context.getRedirector();
            TreeProcessorRedirector redirector = new TreeProcessorRedirector(environment, context);
            this.setupLogger(redirector);
            context.setRedirector(redirector);
            objectModel.put("source-resolver", environment);
            boolean success = false;
            try {
                bl = success = this.rootNode.invoke(environment, context);
            }
            catch (Throwable throwable) {
                CocoonComponentManager.leaveEnvironment(success);
                context.setRedirector(oldRedirector);
                objectModel.put("source-resolver", oldResolver);
                throw throwable;
            }
            CocoonComponentManager.leaveEnvironment(success);
            context.setRedirector(oldRedirector);
            objectModel.put("source-resolver", oldResolver);
            return bl;
        }
        finally {
            ConcreteTreeProcessor concreteTreeProcessor2 = this;
            synchronized (concreteTreeProcessor2) {
                --this.requestCount;
            }
            if (this.requestCount < 0) {
                this.dispose();
            }
        }
    }

    private boolean handleCocoonRedirect(String uri, Environment environment, InvokeContext context) throws Exception {
        Environment forwardEnv;
        MutableEnvironmentFacade facade;
        MutableEnvironmentFacade mutableEnvironmentFacade = facade = environment instanceof MutableEnvironmentFacade ? (MutableEnvironmentFacade)environment : null;
        if (facade != null) {
            environment = facade.getDelegate();
        }
        boolean isRedirect = environment.getObjectModel().remove("cocoon:forward") == null;
        Environment newEnv = new ForwardEnvironmentWrapper(environment, this.sitemapComponentManager, uri, this.getLogger());
        if (isRedirect) {
            newEnv.setInternalRedirect(true);
        }
        if (facade != null) {
            facade.setDelegate((EnvironmentWrapper)newEnv);
            newEnv = facade;
        }
        ConcreteTreeProcessor processor = this;
        if (uri.startsWith("cocoon://")) {
            processor = ((TreeProcessor)this.getRootProcessor()).concreteProcessor;
            newEnv.changeContext("", ((TreeProcessor)this.getRootProcessor()).source.getURI());
        }
        boolean result = processor.process(newEnv, context);
        if (facade != null) {
            newEnv = facade.getDelegate();
        }
        if (((EnvironmentWrapper)(forwardEnv = newEnv)).hasRedirected()) {
            if (((EnvironmentWrapper)forwardEnv).isPermanentRedirection() && environment instanceof PermanentRedirector) {
                ((PermanentRedirector)((Object)environment)).permanentRedirect(false, ((EnvironmentWrapper)forwardEnv).getRedirectURL());
            } else {
                environment.redirect(false, ((EnvironmentWrapper)forwardEnv).getRedirectURL());
            }
        }
        return result;
    }

    public void dispose() {
        if (this.disposableNodes != null) {
            for (int i = this.disposableNodes.size() - 1; i > -1; --i) {
                ((Disposable)this.disposableNodes.get(i)).dispose();
            }
            this.disposableNodes = null;
        }
        this.rootNode = null;
    }

    public String toString() {
        return "ConcreteTreeProcessor - " + this.wrappingProcessor.source.getURI();
    }

    private static final class ForwardEnvironmentWrapper
    extends EnvironmentWrapper {
        public ForwardEnvironmentWrapper(Environment env, ComponentManager manager, String uri, Logger logger) throws MalformedURLException {
            super(env, manager, uri, logger, false);
        }

        @Override
        public void setStatus(int statusCode) {
            this.environment.setStatus(statusCode);
        }

        @Override
        public void setContentLength(int length) {
            this.environment.setContentLength(length);
        }

        @Override
        public void setContentType(String contentType) {
            this.environment.setContentType(contentType);
        }

        @Override
        public String getContentType() {
            return this.environment.getContentType();
        }

        @Override
        public boolean isResponseModified(long lastModified) {
            return this.environment.isResponseModified(lastModified);
        }

        @Override
        public void setResponseIsNotModified() {
            this.environment.setResponseIsNotModified();
        }
    }

    private class TreeProcessorRedirector
    extends ForwardRedirector {
        private InvokeContext context;

        public TreeProcessorRedirector(Environment env, InvokeContext context) {
            super(env);
            this.context = context;
        }

        @Override
        protected void cocoonRedirect(String uri) throws IOException, ProcessingException {
            try {
                ConcreteTreeProcessor.this.handleCocoonRedirect(uri, this.env, this.context);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (ProcessingException pe) {
                throw pe;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new ProcessingException(ex);
            }
        }
    }
}

