/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.cocoon.acting.Action;
import org.apache.cocoon.components.ComponentLocator;
import org.apache.cocoon.components.ExtendedComponentSelector;
import org.apache.cocoon.components.pipeline.OutputComponentSelector;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.reading.Reader;
import org.apache.cocoon.selection.Selector;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.sitemap.ContentAggregator;
import org.apache.cocoon.sitemap.LinkGatherer;
import org.apache.cocoon.sitemap.LinkTranslator;
import org.apache.cocoon.sitemap.NotifyingGenerator;
import org.apache.cocoon.sitemap.SitemapComponentSelector;
import org.apache.cocoon.transformation.Transformer;

public class ComponentsSelector
extends ExtendedComponentSelector
implements OutputComponentSelector,
SitemapComponentSelector {
    public static final int UNKNOWN = -1;
    public static final int GENERATOR = 0;
    public static final int TRANSFORMER = 1;
    public static final int SERIALIZER = 2;
    public static final int READER = 3;
    public static final int MATCHER = 4;
    public static final int SELECTOR = 5;
    public static final int ACTION = 6;
    public static final int PIPELINE = 7;
    public static final String[] SELECTOR_ROLES = new String[]{Generator.ROLE + "Selector", Transformer.ROLE + "Selector", Serializer.ROLE + "Selector", Reader.ROLE + "Selector", Matcher.ROLE + "Selector", Selector.ROLE + "Selector", Action.ROLE + "Selector", ProcessingPipeline.ROLE + "Selector"};
    public static final String[] COMPONENT_NAMES = new String[]{"generator", "transformer", "serializer", "reader", "matcher", "selector", "action", "pipe"};
    private int roleId;
    private Map hintMimeTypes;
    private Map hintLabels;
    private Map pipelineHints;
    private Set knownHints = new HashSet();
    private SitemapComponentSelector parentSitemapSelector;

    @Override
    public void setParentLocator(ComponentLocator locator) throws ComponentException {
        super.setParentLocator(locator);
        if (this.parentSelector instanceof SitemapComponentSelector) {
            this.parentSitemapSelector = (SitemapComponentSelector)((Object)this.parentSelector);
        }
    }

    @Override
    protected String getComponentInstanceName() {
        return this.roleId == -1 ? null : COMPONENT_NAMES[this.roleId];
    }

    @Override
    protected String getClassAttributeName() {
        return this.roleId == -1 ? "class" : "src";
    }

    @Override
    public void configure(Configuration config) throws ConfigurationException {
        String role = this.getRoleName(config);
        this.roleId = -1;
        for (int i = 0; i < SELECTOR_ROLES.length; ++i) {
            if (!SELECTOR_ROLES[i].equals(role)) continue;
            this.roleId = i;
            break;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Setting up sitemap component selector for " + role + " (role id = " + this.roleId + ")");
        }
        if (this.roleId == 2 || this.roleId == 3) {
            this.hintMimeTypes = new HashMap();
        }
        this.hintLabels = new HashMap();
        this.pipelineHints = new HashMap();
        super.configure(config);
    }

    public void addComponent(Object hint, Class clazz, Configuration config) throws ComponentException {
        String label;
        String mimeType;
        super.addComponent(hint, clazz, config);
        this.knownHints.add(hint);
        if ((this.roleId == 2 || this.roleId == 3) && (mimeType = config.getAttribute("mime-type", null)) != null) {
            this.hintMimeTypes.put(hint, mimeType);
        }
        if ((label = config.getAttribute("label", null)) != null) {
            StringTokenizer st = new StringTokenizer(label, " ,", false);
            String[] labels = new String[st.countTokens()];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = st.nextToken();
            }
            this.hintLabels.put(hint, labels);
        }
        String pipelineHint = config.getAttribute("hint", null);
        this.pipelineHints.put(hint, pipelineHint);
    }

    public void initialize() {
        try {
            DefaultConfiguration config = null;
            switch (this.roleId) {
                case 0: {
                    config = new DefaultConfiguration(COMPONENT_NAMES[0], "autogenerated");
                    config.setAttribute("name", "<notifier>");
                    this.ensureExists("<notifier>", NotifyingGenerator.class, (Configuration)config);
                    config = new DefaultConfiguration(COMPONENT_NAMES[0], "autogenerated");
                    config.setAttribute("name", "<aggregator>");
                    this.ensureExists("<aggregator>", ContentAggregator.class, (Configuration)config);
                    break;
                }
                case 1: {
                    config = new DefaultConfiguration(COMPONENT_NAMES[1], "autogenerated");
                    config.setAttribute("name", "<translator>");
                    this.ensureExists("<translator>", LinkTranslator.class, (Configuration)config);
                    config = new DefaultConfiguration(COMPONENT_NAMES[1], "autogenerated");
                    config.setAttribute("name", "<gatherer>");
                    this.ensureExists("<gatherer>", LinkGatherer.class, (Configuration)config);
                }
            }
            super.initialize();
            this.knownHints = null;
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Cannot setup default components", (Throwable)e);
        }
    }

    private void ensureExists(Object hint, Class clazz, Configuration config) throws ComponentException {
        if (!this.knownHints.contains(hint)) {
            this.addComponent(hint, clazz, config);
        }
    }

    @Override
    public String getMimeTypeForHint(Object hint) {
        if (this.hintMimeTypes == null) {
            return null;
        }
        if (this.hasDeclaredComponent(hint)) {
            return (String)this.hintMimeTypes.get(hint);
        }
        if (this.parentSitemapSelector != null) {
            return this.parentSitemapSelector.getMimeTypeForHint(hint);
        }
        return null;
    }

    @Override
    public boolean hasLabel(Object hint, String label) {
        String[] labels = this.getLabels(hint);
        if (labels != null) {
            for (int i = 0; i < labels.length; ++i) {
                if (!labels[i].equals(label)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getLabels(Object hint) {
        if (this.hasDeclaredComponent(hint)) {
            return (String[])this.hintLabels.get(hint);
        }
        if (this.parentSitemapSelector != null) {
            return this.parentSitemapSelector.getLabels(hint);
        }
        return null;
    }

    @Override
    public String getPipelineHint(Object hint) {
        if (this.hasDeclaredComponent(hint)) {
            return (String)this.pipelineHints.get(hint);
        }
        if (this.parentSitemapSelector != null) {
            return this.parentSitemapSelector.getPipelineHint(hint);
        }
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.parentSitemapSelector = null;
    }
}

