/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.util.BufferedOutputStream;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.Deprecation;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.SAXException;

public abstract class AbstractEnvironment
extends AbstractLogEnabled
implements Environment {
    protected String uris;
    protected StringBuffer prefix = new StringBuffer();
    protected String view;
    protected String action;
    protected String context;
    private String tempInitContext;
    protected String rootContext;
    protected HashMap objectModel;
    protected SourceResolver sourceResolver;
    protected ComponentManager manager;
    private Map attributes = new HashMap();
    protected BufferedOutputStream secureOutputStream;
    protected OutputStream outputStream;
    protected static Method avalonToCocoonSourceWrapper;
    protected boolean initializedComponents = false;

    public AbstractEnvironment(String uri, String view, File file) throws MalformedURLException {
        this(uri, view, file, null);
    }

    public AbstractEnvironment(String uri, String view, File file, String action) throws MalformedURLException {
        this(uri, view, file.toURL().toExternalForm(), action);
    }

    public AbstractEnvironment(String uri, String view, String context, String action) throws MalformedURLException {
        this.uris = uri;
        this.view = view;
        this.tempInitContext = context;
        this.action = action;
        this.objectModel = new HashMap();
    }

    protected void setView(String view) {
        if (this.view != null) {
            throw new IllegalStateException("View was already set on this environment");
        }
        this.view = view;
    }

    protected void setAction(String action) {
        if (this.action != null) {
            throw new IllegalStateException("Action was already set on this environment");
        }
        this.action = action;
    }

    protected static String extractView(Request request) {
        return request.getParameter("cocoon-view");
    }

    protected static String extractAction(Request req) {
        String action = req.getParameter("cocoon-action");
        if (action != null) {
            return action;
        }
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("cocoon-action-")) continue;
            if (name.endsWith(".x") || name.endsWith(".y")) {
                return name.substring("cocoon-action-".length(), name.length() - 2);
            }
            return name.substring("cocoon-action-".length());
        }
        return null;
    }

    @Override
    public String getURI() {
        return this.uris;
    }

    @Override
    public String getRootContext() {
        if (!this.initializedComponents) {
            this.initComponents();
        }
        return this.rootContext;
    }

    @Override
    public String getContext() {
        if (!this.initializedComponents) {
            this.initComponents();
        }
        return this.context;
    }

    @Override
    public String getURIPrefix() {
        return this.prefix.toString();
    }

    protected void setURIPrefix(String prefix) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Set the URI Prefix (OLD=" + this.getURIPrefix() + ", NEW=" + prefix + ")");
        }
        this.prefix = new StringBuffer(prefix);
    }

    protected void setContext(String context) {
        this.context = context;
    }

    @Override
    public void setContext(String prefix, String uri, String context) {
        this.setContext(context);
        this.setURIPrefix(prefix == null ? "" : prefix);
        this.uris = uri;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Reset context to " + this.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeContext(String newPrefix, String newContext) throws IOException {
        block14: {
            block15: {
                int l;
                if (!this.initializedComponents) {
                    this.initComponents();
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Changing Cocoon context");
                    this.getLogger().debug("  from context(" + this.context + ") and prefix(" + this.prefix + ")");
                    this.getLogger().debug("  to context(" + newContext + ") and prefix(" + newPrefix + ")");
                    this.getLogger().debug("  at URI " + this.uris);
                }
                if ((l = newPrefix.length()) >= 1) {
                    if (!this.uris.startsWith(newPrefix)) {
                        String message = "The current URI (" + this.uris + ") doesn't start with given prefix (" + newPrefix + ")";
                        this.getLogger().error(message);
                        throw new RuntimeException(message);
                    }
                    this.prefix.append(newPrefix);
                    this.uris = this.uris.substring(l);
                    if (this.uris.startsWith("/")) {
                        this.uris = this.uris.substring(1);
                        this.prefix.append('/');
                    }
                }
                if (!this.context.startsWith("zip:")) break block15;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Base context is zip: " + this.context);
                }
                org.apache.excalibur.source.Source source = null;
                try {
                    source = this.sourceResolver.resolveURI(this.context + newContext);
                    this.context = source.getURI();
                }
                catch (Throwable throwable) {
                    this.sourceResolver.release(source);
                    throw throwable;
                }
                this.sourceResolver.release(source);
                break block14;
            }
            if (newContext.length() > 0) {
                String sContext = newContext.charAt(0) == '/' ? "file:" + newContext : (newContext.indexOf(58) > 1 ? newContext : this.context + '/' + newContext);
                int i = sContext.lastIndexOf(47);
                if (i != -1 && i + 1 < sContext.length()) {
                    sContext = sContext.substring(0, i + 1);
                }
                org.apache.excalibur.source.Source source = null;
                try {
                    source = this.sourceResolver.resolveURI(sContext);
                    this.context = source.getURI();
                }
                finally {
                    this.sourceResolver.release(source);
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("New context is " + this.context);
        }
    }

    public void globalRedirect(boolean sessionmode, String newURL) throws IOException {
        this.redirect(sessionmode, newURL);
    }

    @Override
    public String getView() {
        return this.view;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public void setStatus(int statusCode) {
    }

    @Override
    public Map getObjectModel() {
        return this.objectModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source resolve(String systemId) throws ProcessingException, SAXException, IOException {
        Class clazz;
        Deprecation.logger.warn("The method SourceResolver.resolve(String) is deprecated. Use resolveURI(String) instead.");
        if (!this.initializedComponents) {
            this.initComponents();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolving '" + systemId + "' in context '" + this.context + "'");
        }
        if (systemId == null) {
            throw new SAXException("Invalid System ID");
        }
        try {
            clazz = ClassUtils.loadClass("org.apache.cocoon.components.source.impl.AvalonToCocoonSourceInvocationHandler");
        }
        catch (Exception e) {
            throw new ProcessingException("The deprecated resolve() method of the environment was called.Please either update your code to use the new resolveURI() method or install the deprecation support.", e);
        }
        if (null == avalonToCocoonSourceWrapper) {
            Class<?> e = this.getClass();
            synchronized (e) {
                try {
                    avalonToCocoonSourceWrapper = clazz.getDeclaredMethod("createProxy", ClassUtils.loadClass("org.apache.excalibur.source.Source"), ClassUtils.loadClass("org.apache.excalibur.source.SourceResolver"), ClassUtils.loadClass(Environment.class.getName()), ClassUtils.loadClass(ComponentManager.class.getName()));
                }
                catch (Exception e2) {
                    throw new ProcessingException("The deprecated resolve() method of the environment was called.Please either update your code to use the new resolveURI() method or install the deprecation support.", e2);
                }
            }
        }
        try {
            org.apache.excalibur.source.Source source = this.resolveURI(systemId);
            Source wrappedSource = (Source)avalonToCocoonSourceWrapper.invoke((Object)clazz, source, this.sourceResolver, this, this.manager);
            return wrappedSource;
        }
        catch (SourceException se) {
            throw SourceUtil.handle(se);
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to create source wrapper.", e);
        }
    }

    @Override
    public boolean isResponseModified(long lastModified) {
        return true;
    }

    @Override
    public void setResponseIsNotModified() {
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    protected boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        Deprecation.logger.warn("The method Environment.getOutputStream() is deprecated. Use getOutputStream(-1) instead.");
        return this.getOutputStream(-1);
    }

    @Override
    public OutputStream getOutputStream(int bufferSize) throws IOException {
        if (bufferSize == 0) {
            if (this.secureOutputStream != null) {
                this.secureOutputStream = null;
            }
            return this.outputStream;
        }
        if (this.secureOutputStream == null) {
            this.secureOutputStream = new BufferedOutputStream(this.outputStream, bufferSize);
        }
        return this.secureOutputStream;
    }

    @Override
    public boolean tryResetResponse() throws IOException {
        if (this.secureOutputStream != null && this.secureOutputStream.isResettable()) {
            this.secureOutputStream.reset();
            return true;
        }
        return false;
    }

    @Override
    public void commitResponse() throws IOException {
        if (this.secureOutputStream != null) {
            if (this.secureOutputStream.isResettable()) {
                this.setContentLength(this.secureOutputStream.getCount());
            }
            this.secureOutputStream.flush();
        } else if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public org.apache.excalibur.source.Source resolveURI(String location) throws MalformedURLException, IOException, SourceException {
        return this.resolveURI(location, null, null);
    }

    public org.apache.excalibur.source.Source resolveURI(String location, String baseURI, Map parameters) throws MalformedURLException, IOException, SourceException {
        if (!this.initializedComponents) {
            this.initComponents();
        }
        return this.sourceResolver.resolveURI(location, baseURI, parameters);
    }

    public void release(org.apache.excalibur.source.Source source) {
        if (null != source) {
            this.sourceResolver.release(source);
        }
    }

    protected void initComponents() {
        block7: {
            this.initializedComponents = true;
            try {
                this.manager = CocoonComponentManager.getSitemapComponentManager();
                this.sourceResolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                if (this.tempInitContext == null) break block7;
                org.apache.excalibur.source.Source source = null;
                try {
                    source = this.sourceResolver.resolveURI(this.tempInitContext);
                    this.context = source.getURI();
                    if (this.rootContext == null) {
                        this.rootContext = this.context;
                    }
                }
                finally {
                    this.sourceResolver.release(source);
                }
                this.tempInitContext = null;
            }
            catch (ComponentException ce) {
                throw new CascadingRuntimeException("Unable to lookup component.", (Throwable)ce);
            }
            catch (IOException ie) {
                throw new CascadingRuntimeException("Unable to resolve URI: " + this.tempInitContext, (Throwable)ie);
            }
        }
    }

    @Override
    public void startingProcessing() {
    }

    @Override
    public void finishingProcessing() {
        if (null != this.manager) {
            this.manager.release((Component)this.sourceResolver);
            this.manager = null;
            this.sourceResolver = null;
        }
        this.initializedComponents = false;
    }

    @Override
    public boolean isInternalRedirect() {
        return false;
    }
}

