/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.commandline;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.cocoon.Constants;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.commandline.CommandLineSession;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.SystemUtils;

public class CommandLineRequest
implements Request {
    private Environment env;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private Map attributes;
    private Map parameters;
    private Map headers;
    private String characterEncoding;

    public CommandLineRequest(Environment env, String contextPath, String servletPath, String pathInfo) {
        this(env, contextPath, servletPath, pathInfo, null, null, null);
    }

    public CommandLineRequest(Environment env, String contextPath, String servletPath, String pathInfo, Map attributes) {
        this(env, contextPath, servletPath, pathInfo, attributes, null, null);
    }

    public CommandLineRequest(Environment env, String contextPath, String servletPath, String pathInfo, Map attributes, Map parameters) {
        this(env, contextPath, servletPath, pathInfo, attributes, parameters, null);
    }

    public CommandLineRequest(Environment env, String contextPath, String servletPath, String pathInfo, Map attributes, Map parameters, Map headers) {
        this.env = env;
        this.contextPath = contextPath;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.attributes = attributes == null ? new HashMap() : attributes;
        this.parameters = parameters;
        this.headers = headers;
    }

    @Override
    public Object get(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        Vector<String> vect = new Vector<String>(values.length);
        for (int i = 0; i < values.length; ++i) {
            vect.add(values[i]);
        }
        return vect;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getRequestURI() {
        StringBuffer buffer = new StringBuffer();
        if (this.servletPath != null) {
            buffer.append(this.servletPath);
        }
        if (this.contextPath != null) {
            buffer.append(this.contextPath);
        }
        if (this.pathInfo != null) {
            buffer.append(this.pathInfo);
        }
        return buffer.toString();
    }

    @Override
    public String getSitemapURI() {
        return this.env.getURI();
    }

    @Override
    public String getSitemapURIPrefix() {
        return this.env.getURIPrefix();
    }

    @Override
    public String getQueryString() {
        return null;
    }

    @Override
    public String getPathTranslated() {
        return null;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Enumeration getAttributeNames() {
        return IteratorUtils.asEnumeration(this.attributes.keySet().iterator());
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public String getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        Object value = this.parameters.get(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return null;
        }
        String[] values = (String[])value;
        if (values.length == 0) {
            return null;
        }
        return values[0];
    }

    @Override
    public Enumeration getParameterNames() {
        return this.parameters != null ? IteratorUtils.asEnumeration(this.parameters.keySet().iterator()) : null;
    }

    @Override
    public String[] getParameterValues(String name) {
        Object value = this.parameters.get(name);
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        return (String[])value;
    }

    @Override
    public String getHeader(String name) {
        return this.headers != null ? (String)this.headers.get(name.toLowerCase()) : null;
    }

    public int getIntHeader(String name) {
        String header = this.headers != null ? (String)this.headers.get(name.toLowerCase()) : null;
        return header != null ? Integer.parseInt(header) : -1;
    }

    @Override
    public long getDateHeader(String name) {
        return 0L;
    }

    @Override
    public Enumeration getHeaders(String name) {
        return new EmptyEnumeration();
    }

    @Override
    public Enumeration getHeaderNames() {
        if (this.headers != null) {
            return IteratorUtils.asEnumeration(this.headers.keySet().iterator());
        }
        return new EmptyEnumeration();
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public int getContentLength() {
        return -1;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public String getProtocol() {
        return "cli";
    }

    @Override
    public String getScheme() {
        return "cli";
    }

    @Override
    public String getServerName() {
        return Constants.COMPLETE_NAME;
    }

    @Override
    public int getServerPort() {
        return -1;
    }

    @Override
    public String getRemoteAddr() {
        return "127.0.0.1";
    }

    @Override
    public String getRemoteHost() {
        return "localhost";
    }

    @Override
    public String getMethod() {
        return "get";
    }

    @Override
    public String getRemoteUser() {
        return SystemUtils.USER_NAME;
    }

    @Override
    public Cookie[] getCookies() {
        return null;
    }

    @Override
    public Map getCookieMap() {
        return Collections.unmodifiableMap(new HashMap());
    }

    @Override
    public Session getSession() {
        return this.getSession(true);
    }

    @Override
    public Session getSession(boolean create) {
        return CommandLineSession.getSession(create);
    }

    @Override
    public Session getCocoonSession(boolean create) {
        return this.getSession(create);
    }

    @Override
    public Session getCocoonSession() {
        return this.getSession(true);
    }

    @Override
    public String getRequestedSessionId() {
        return CommandLineSession.getSession(false) != null ? CommandLineSession.getSession(false).getId() : null;
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return CommandLineSession.getSession(false) != null;
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    @Override
    public Locale getLocale() {
        return Locale.getDefault();
    }

    @Override
    public Enumeration getLocales() {
        throw new RuntimeException(this.getClass().getName() + ".getLocales() method not yet implemented!");
    }

    @Override
    public String getAuthType() {
        return null;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean isUserInRole(String role) {
        return false;
    }

    @Override
    public Principal getUserPrincipal() {
        return null;
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    @Override
    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.characterEncoding = env;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    private static class EmptyEnumeration
    implements Enumeration {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

