/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.environment.AbstractEnvironment;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.PermanentRedirector;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.wrapper.MutableEnvironmentFacade;
import org.apache.cocoon.environment.wrapper.RequestWrapper;
import org.apache.cocoon.environment.wrapper.ResponseWrapper;
import org.apache.cocoon.util.BufferedOutputStream;

public class EnvironmentWrapper
extends AbstractEnvironment
implements Redirector,
PermanentRedirector {
    protected Environment environment;
    protected Map objectModel;
    protected String redirectURL;
    protected Request request;
    protected OutputStream outputStream;
    protected String contentType;
    protected boolean internalRedirect = false;
    protected boolean hasRedirected;
    protected boolean permanentRedirection;

    public EnvironmentWrapper(Environment env, String requestURI, String queryString, Logger logger) throws MalformedURLException {
        this(env, requestURI, queryString, logger, false);
    }

    public EnvironmentWrapper(Environment env, String requestURI, String queryString, Logger logger, boolean rawMode) throws MalformedURLException {
        this(env, requestURI, queryString, logger, null, rawMode);
    }

    public EnvironmentWrapper(Environment env, String requestURI, String queryString, Logger logger, ComponentManager manager, boolean rawMode) throws MalformedURLException {
        this(env, requestURI, queryString, logger, null, rawMode, env.getView(), true);
    }

    public EnvironmentWrapper(Environment env, String requestURI, String queryString, Logger logger, ComponentManager manager, boolean rawMode, String view) throws MalformedURLException {
        this(env, requestURI, queryString, logger, manager, rawMode, view, true);
    }

    public EnvironmentWrapper(Environment env, String requestURI, String queryString, Logger logger, ComponentManager manager, boolean rawMode, String view, boolean wrapResponse) throws MalformedURLException {
        super(env.getURI(), view, env.getContext(), env.getAction());
        this.init(env, requestURI, queryString, logger, manager, rawMode, view, wrapResponse);
    }

    private void init(Environment env, String requestURI, String queryString, Logger logger, ComponentManager manager, boolean rawMode, String view, boolean wrapResponse) throws MalformedURLException {
        this.rootContext = env.getRootContext();
        this.enableLogging(logger);
        this.environment = env;
        this.view = view;
        this.prefix = new StringBuffer(env.getURIPrefix());
        Map oldObjectModel = env.getObjectModel();
        if (oldObjectModel instanceof HashMap) {
            this.objectModel = (Map)((HashMap)oldObjectModel).clone();
        } else {
            this.objectModel = new HashMap(oldObjectModel.size() * 2);
            for (Map.Entry entry : oldObjectModel.entrySet()) {
                this.objectModel.put(entry.getKey(), entry.getValue());
            }
        }
        this.request = new RequestWrapper(ObjectModelHelper.getRequest(oldObjectModel), requestURI, queryString, this, rawMode);
        this.objectModel.put("request", this.request);
        if (wrapResponse) {
            ResponseWrapper response = new ResponseWrapper(ObjectModelHelper.getResponse(oldObjectModel));
            this.objectModel.put("response", response);
        }
    }

    public EnvironmentWrapper(Environment env, ComponentManager manager, String uri, Logger logger, boolean wrapResponse) throws MalformedURLException {
        super(env.getURI(), env.getView(), env.getContext(), env.getAction());
        String tmp;
        int index;
        String prefix;
        boolean rawMode = false;
        int position = uri.indexOf(58) + 1;
        if (position != 0) {
            if (uri.startsWith("raw:", position)) {
                position += 4;
                rawMode = true;
            }
        } else {
            throw new MalformedURLException("No protocol found for sitemap source in " + uri);
        }
        if (uri.startsWith("//", position)) {
            position += 2;
            prefix = "";
        } else if (uri.startsWith("/", position)) {
            ++position;
            prefix = null;
        } else {
            throw new MalformedURLException("Malformed cocoon URI: " + uri);
        }
        String queryString = null;
        int queryStringPos = uri.indexOf(63, position);
        if (queryStringPos != -1) {
            queryString = uri.substring(queryStringPos + 1);
            uri = uri.substring(position, queryStringPos);
        } else if (position > 0) {
            uri = uri.substring(position);
        }
        String view = null;
        view = queryString != null ? ((index = queryString.indexOf("cocoon-view")) != -1 && (index == 0 || queryString.charAt(index - 1) == '&') && queryString.length() > index + "cocoon-view".length() && queryString.charAt(index + "cocoon-view".length()) == '=' ? ((index = (tmp = queryString.substring(index + "cocoon-view".length() + 1)).indexOf(38)) != -1 ? tmp.substring(0, index) : tmp) : env.getView()) : env.getView();
        String requestURI = prefix == null ? env.getURIPrefix() + uri : uri;
        this.init(env, requestURI, queryString, logger, manager, rawMode, view, wrapResponse);
        this.setURI(prefix, uri);
    }

    @Override
    public void redirect(boolean sessionmode, String newURL) throws IOException {
        this.redirectURL = newURL;
        this.hasRedirected = true;
        if (sessionmode) {
            this.request.getSession(true);
        }
    }

    @Override
    public void permanentRedirect(boolean sessionmode, String newURL) throws IOException {
        this.redirect(sessionmode, newURL);
        this.permanentRedirection = true;
    }

    @Override
    public boolean hasRedirected() {
        return this.hasRedirected;
    }

    public boolean isPermanentRedirection() {
        return this.permanentRedirection;
    }

    @Override
    public void sendStatus(int sc) {
        this.setStatus(sc);
        this.hasRedirected = true;
    }

    @Override
    public void globalRedirect(boolean sessionmode, String newURL) throws IOException {
        if (this.environment instanceof EnvironmentWrapper) {
            ((EnvironmentWrapper)this.environment).globalRedirect(sessionmode, newURL);
        } else if (this.environment instanceof MutableEnvironmentFacade) {
            ((MutableEnvironmentFacade)this.environment).getDelegate().globalRedirect(sessionmode, newURL);
        } else {
            this.environment.redirect(sessionmode, newURL);
        }
    }

    @Override
    public OutputStream getOutputStream(int bufferSize) throws IOException {
        return this.outputStream == null ? this.environment.getOutputStream(bufferSize) : this.outputStream;
    }

    public void setOutputStream(OutputStream stream) {
        this.outputStream = stream;
    }

    @Override
    public boolean tryResetResponse() throws IOException {
        OutputStream outputStream = this.getOutputStream(-1);
        if (outputStream instanceof BufferedOutputStream && ((BufferedOutputStream)outputStream).isResettable()) {
            ((BufferedOutputStream)outputStream).reset();
            return true;
        }
        return super.tryResetResponse();
    }

    @Override
    public void commitResponse() throws IOException {
        OutputStream outputStream = this.getOutputStream(-1);
        if (outputStream != null) {
            outputStream.flush();
        } else {
            super.commitResponse();
        }
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void reset() {
        this.redirectURL = null;
    }

    @Override
    public void setStatus(int statusCode) {
    }

    @Override
    public void setContentLength(int length) {
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Map getObjectModel() {
        return this.objectModel;
    }

    public void setURI(String prefix, String uris) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Setting uri (prefix=" + prefix + ", uris=" + uris + ")");
        }
        if (!this.initializedComponents) {
            this.initComponents();
        }
        if (prefix != null) {
            this.setContext(this.getRootContext());
            this.setURIPrefix(prefix);
        }
        this.uris = uris;
    }

    @Override
    public Object getAttribute(String name) {
        Object value = super.getAttribute(name);
        if (value == null && !this.hasAttribute(name)) {
            value = this.environment.getAttribute(name);
        }
        return value;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    public void setInternalRedirect(boolean flag) {
        this.internalRedirect = flag;
        if (flag) {
            ((RequestWrapper)this.request).setRequestURI(this.prefix.toString(), this.uris);
        }
    }

    @Override
    public boolean isInternalRedirect() {
        return this.internalRedirect;
    }
}

