/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.wrapper;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.wrapper.RequestParameters;

public final class RequestWrapper
implements Request {
    private final Request req;
    private String queryString;
    private final RequestParameters parameters;
    private final Environment environment;
    private final boolean rawMode;
    private String requestURI;

    public RequestWrapper(Request request, String requestURI, String queryString, Environment env) {
        this(request, requestURI, queryString, env, false);
    }

    public RequestWrapper(Request request, String requestURI, String queryString, Environment env, boolean rawMode) {
        this.environment = env;
        this.req = request;
        this.queryString = queryString;
        this.parameters = new RequestParameters(queryString);
        this.rawMode = rawMode;
        if (this.req.getQueryString() != null && !this.rawMode) {
            this.queryString = this.queryString == null ? this.req.getQueryString() : this.queryString + '&' + this.req.getQueryString();
        }
        this.requestURI = this.req.getRequestURI();
    }

    @Override
    public Object get(String name) {
        return this.req.get(name);
    }

    @Override
    public Object getAttribute(String name) {
        return this.req.getAttribute(name);
    }

    @Override
    public Enumeration getAttributeNames() {
        return this.req.getAttributeNames();
    }

    @Override
    public String getCharacterEncoding() {
        return this.req.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        this.req.setCharacterEncoding(enc);
    }

    @Override
    public int getContentLength() {
        return this.req.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.req.getContentType();
    }

    @Override
    public String getParameter(String name) {
        String value = this.parameters.getParameter(name);
        if (value == null && !this.rawMode) {
            return this.req.getParameter(name);
        }
        return value;
    }

    @Override
    public Enumeration getParameterNames() {
        if (!this.rawMode) {
            HashSet parameterNames = new HashSet();
            Enumeration names = this.parameters.getParameterNames();
            while (names.hasMoreElements()) {
                parameterNames.add(names.nextElement());
            }
            names = this.req.getParameterNames();
            while (names.hasMoreElements()) {
                parameterNames.add(names.nextElement());
            }
            return new EnumerationFromIterator(parameterNames.iterator());
        }
        return this.parameters.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name) {
        if (!this.rawMode) {
            String[] values = this.parameters.getParameterValues(name);
            String[] inherited = this.req.getParameterValues(name);
            if (inherited == null) {
                return values;
            }
            if (values == null) {
                return inherited;
            }
            String[] allValues = new String[values.length + inherited.length];
            System.arraycopy(values, 0, allValues, 0, values.length);
            System.arraycopy(inherited, 0, allValues, values.length, inherited.length);
            return allValues;
        }
        return this.parameters.getParameterValues(name);
    }

    @Override
    public String getProtocol() {
        return this.req.getProtocol();
    }

    @Override
    public String getScheme() {
        return this.req.getScheme();
    }

    @Override
    public String getServerName() {
        return this.req.getServerName();
    }

    @Override
    public int getServerPort() {
        return this.req.getServerPort();
    }

    @Override
    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        return this.req.getRemoteHost();
    }

    @Override
    public void setAttribute(String name, Object o) {
        this.req.setAttribute(name, o);
    }

    @Override
    public void removeAttribute(String name) {
        this.req.removeAttribute(name);
    }

    @Override
    public Locale getLocale() {
        return this.req.getLocale();
    }

    @Override
    public Enumeration getLocales() {
        return this.req.getLocales();
    }

    @Override
    public boolean isSecure() {
        return this.req.isSecure();
    }

    @Override
    public Cookie[] getCookies() {
        return this.req.getCookies();
    }

    @Override
    public Map getCookieMap() {
        return this.req.getCookieMap();
    }

    @Override
    public long getDateHeader(String name) {
        return this.req.getDateHeader(name);
    }

    @Override
    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    @Override
    public Enumeration getHeaders(String name) {
        return this.req.getHeaders(name);
    }

    @Override
    public Enumeration getHeaderNames() {
        return this.req.getHeaderNames();
    }

    @Override
    public String getMethod() {
        return this.req.getMethod();
    }

    @Override
    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    @Override
    public String getPathTranslated() {
        return this.req.getPathTranslated();
    }

    @Override
    public String getContextPath() {
        return this.req.getContextPath();
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getRemoteUser() {
        return this.req.getRemoteUser();
    }

    @Override
    public String getRequestedSessionId() {
        return this.req.getRequestedSessionId();
    }

    @Override
    public String getRequestURI() {
        return this.requestURI;
    }

    @Override
    public String getSitemapURI() {
        return this.environment.getURI();
    }

    @Override
    public String getSitemapURIPrefix() {
        return this.environment.getURIPrefix();
    }

    @Override
    public String getServletPath() {
        return this.req.getServletPath();
    }

    @Override
    public Session getSession(boolean create) {
        return this.req.getSession(create);
    }

    @Override
    public Session getSession() {
        return this.req.getSession();
    }

    @Override
    public Session getCocoonSession(boolean create) {
        return this.getSession(create);
    }

    @Override
    public Session getCocoonSession() {
        return this.getSession(true);
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return this.req.isRequestedSessionIdValid();
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return this.req.isRequestedSessionIdFromCookie();
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return this.req.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.req.isRequestedSessionIdFromURL();
    }

    @Override
    public Principal getUserPrincipal() {
        return this.req.getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.req.isUserInRole(role);
    }

    @Override
    public String getAuthType() {
        return this.req.getAuthType();
    }

    public void setRequestURI(String prefix, String uri) {
        StringBuffer buffer = new StringBuffer(this.getContextPath());
        buffer.append('/');
        buffer.append(prefix);
        buffer.append(uri);
        this.requestURI = buffer.toString();
    }

    static final class EnumerationFromIterator
    implements Enumeration {
        private Iterator iter;

        EnumerationFromIterator(Iterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        public Object nextElement() {
            return this.iter.next();
        }
    }
}

