/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SessionAttributeGenerator
extends AbstractGenerator {
    public static final String ATTR_NAME = "attr-name";
    public static final String ELEMENT_NAME = "root-element";
    private Object attrObject;
    private String elementName;

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.elementName = par.getParameter(ELEMENT_NAME, null);
        String attrName = par.getParameter(ATTR_NAME, src);
        if (attrName == null) {
            String msg = "SessionAttributeGenerator needs an attribute name !";
            this.getLogger().error(msg);
            throw new ProcessingException(msg);
        }
        Request request = ObjectModelHelper.getRequest(objectModel);
        Session session = request.getSession(false);
        if (session != null) {
            this.attrObject = session.getAttribute(attrName);
        }
        if (this.attrObject == null) {
            if (this.elementName == null) {
                String msg = "Session attribute '" + attrName + "' doesn't exist";
                this.getLogger().error(msg);
                throw new ProcessingException(msg);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Session attribute '" + attrName + "' doesn't exist : will generate a single '" + this.elementName + "' element.");
            }
        } else if (this.elementName == null && !(this.attrObject instanceof XMLizable) && !(this.attrObject instanceof Node)) {
            String msg = "Session attribute '" + attrName + "' needs an enclosing element : class is " + this.attrObject.getClass().getName();
            this.getLogger().warn(msg);
            throw new ProcessingException(msg);
        }
    }

    @Override
    public void generate() throws IOException, SAXException, ProcessingException {
        this.xmlConsumer.startDocument();
        if (this.elementName != null) {
            this.xmlConsumer.startElement("", this.elementName, this.elementName, XMLUtils.EMPTY_ATTRIBUTES);
            XMLUtils.valueOf((ContentHandler)((Object)new IncludeXMLConsumer(this.xmlConsumer)), this.attrObject);
            this.xmlConsumer.endElement("", this.elementName, this.elementName);
        } else {
            XMLUtils.valueOf((ContentHandler)((Object)new IncludeXMLConsumer(this.xmlConsumer)), this.attrObject);
        }
        this.xmlConsumer.endDocument();
    }
}

