/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.DirectoryGenerator;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XPathDirectoryGenerator
extends DirectoryGenerator {
    protected static final String XPATH_NODE_NAME = "xpath";
    protected static final String QUERY_ATTR_NAME = "query";
    protected static final Map mappingFiles = new HashMap();
    protected DOMParser parser = null;
    protected Document doc = null;
    protected PrefixResolver prefixResolver = null;
    protected RE xmlRE = null;
    protected String xpath = null;
    protected XPathProcessor processor = null;

    @Override
    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.processor);
            this.manager.release((Object)this.parser);
            this.processor = null;
            this.parser = null;
        }
        super.dispose();
    }

    @Override
    public void recycle() {
        this.xpath = null;
        this.doc = null;
        super.recycle();
    }

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.processor = (XPathProcessor)manager.lookup(XPathProcessor.ROLE);
        this.parser = (DOMParser)manager.lookup(DOMParser.ROLE);
    }

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        String mappings;
        super.setup(resolver, objectModel, src, par);
        this.xpath = par.getParameter(XPATH_NODE_NAME, null);
        this.cacheKeyParList.add(this.xpath);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Applying XPath: " + this.xpath + " to directory " + this.source);
        }
        if (null != (mappings = par.getParameter("nsmapping", null))) {
            boolean mapping_reload = par.getParameterAsBoolean("nsmapping-reload", false);
            Source mappingSource = resolver.resolveURI(mappings);
            String mappingKey = mappingSource.getURI();
            MappingInfo mappingInfo = (MappingInfo)mappingFiles.get(mappingKey);
            if (null == mappingInfo || !mappingInfo.reload || mappingInfo.mappingSource.getLastModified() < mappingSource.getLastModified()) {
                this.prefixResolver = new MappingInfo(this.getLogger().getChildLogger("prefix-resolver"), mappingSource, mapping_reload);
                mappingFiles.put(mappingKey, this.prefixResolver);
            } else {
                this.prefixResolver = mappingInfo;
            }
        }
        String xmlFilesPattern = null;
        try {
            xmlFilesPattern = par.getParameter("xmlFiles", "\\.xml$");
            this.cacheKeyParList.add(xmlFilesPattern);
            this.xmlRE = new RE(xmlFilesPattern);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("pattern for XML files: " + xmlFilesPattern);
            }
        }
        catch (RESyntaxException rese) {
            throw new ProcessingException("Syntax error in regexp pattern '" + xmlFilesPattern + "'", rese);
        }
    }

    protected boolean isXML(File path) {
        return this.xmlRE.match(path.getName());
    }

    /*
     * Exception decompiling
     */
    protected void performXPathQuery(File xmlFile) throws SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void startNode(String nodeName, File path) throws SAXException {
        super.startNode(nodeName, path);
        if (this.xpath != null && path.isFile() && this.isXML(path)) {
            this.performXPathQuery(path);
        }
    }

    private static class MappingInfo
    implements PrefixResolver {
        public final Source mappingSource;
        public final boolean reload;
        private final Logger logger;
        private final Map prefixMap;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MappingInfo(Logger logger, Source mappingSource, boolean reload) throws SourceNotFoundException, IOException {
            this.logger = logger;
            this.mappingSource = mappingSource;
            this.reload = reload;
            this.prefixMap = new HashMap();
            InputStreamReader input = null;
            BufferedReader br = null;
            try {
                input = new InputStreamReader(mappingSource.getInputStream());
                br = new BufferedReader(input);
                String line = br.readLine();
                while (line != null) {
                    int i = line.indexOf(61);
                    if (i > 0) {
                        String prefix = line.substring(0, i);
                        String namespace = line.substring(i + 1);
                        this.prefixMap.put(prefix, namespace);
                        logger.debug("added mapping: '" + prefix + "'='" + namespace + "'");
                    }
                    line = br.readLine();
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
                if (input != null) {
                    input.close();
                }
            }
        }

        public String prefixToNamespace(String prefix) {
            String namespace = (String)this.prefixMap.get(prefix);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("have to resolve prefix='" + prefix + ", found namespace='" + namespace + "'");
            }
            return namespace;
        }
    }
}

