/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.i18n;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.i18n.Bundle;
import org.apache.cocoon.i18n.BundleFactory;
import org.apache.cocoon.i18n.XMLResourceBundle;
import org.apache.cocoon.util.NetUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.store.Store;

public class XMLResourceBundleFactory
extends AbstractLogEnabled
implements BundleFactory,
Serviceable,
Configurable,
Disposable,
ThreadSafe {
    protected String directory;
    protected long interval;
    protected ServiceManager manager;
    protected SourceResolver resolver;
    protected Store cache;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.directory = configuration.getChild("catalogue-location").getValue("");
        String cacheRole = configuration.getChild("store-role").getValue(Store.TRANSIENT_STORE);
        try {
            this.cache = (Store)this.manager.lookup(cacheRole);
        }
        catch (ServiceException e) {
            throw new ConfigurationException("Unable to lookup store '" + cacheRole + "'");
        }
        this.interval = configuration.getChild("reload-interval").getValueAsLong(60000L);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Bundle directory '" + this.directory + "'");
            this.getLogger().debug("Store role '" + cacheRole + "'");
        }
    }

    public void dispose() {
        this.manager.release((Object)this.resolver);
        this.manager.release((Object)this.cache);
        this.resolver = null;
        this.cache = null;
        this.manager = null;
    }

    protected String getDirectory() {
        return this.directory;
    }

    @Override
    public Bundle select(String name, String locale) throws ComponentException {
        return this.select(this.getDirectory(), name, locale);
    }

    @Override
    public Bundle select(String name, Locale locale) throws ComponentException {
        return this.select(this.getDirectory(), name, locale);
    }

    @Override
    public Bundle select(String directory, String name, String localeName) throws ComponentException {
        return this.select(directory, name, new Locale(localeName, localeName));
    }

    @Override
    public Bundle select(String directory, String name, Locale locale) throws ComponentException {
        return this.select(new String[]{directory}, name, locale);
    }

    @Override
    public Bundle select(String[] directories, String name, Locale locale) throws ComponentException {
        XMLResourceBundle bundle = this._select(directories, 0, name, locale);
        if (bundle == null) {
            throw new ComponentException(name, "Unable to locate resource: " + name);
        }
        return bundle;
    }

    @Override
    public void release(Bundle bundle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLResourceBundle _select(String[] directories, int index, String name, Locale locale) throws ComponentException {
        String cacheKey;
        XMLResourceBundle bundle;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Selecting from: " + name + ", locale: " + locale + ", directory: " + directories[index]);
        }
        if ((bundle = this.selectCached(cacheKey = "XRB" + this.getCacheKey(directories, index, name, locale))) == null) {
            XMLResourceBundleFactory xMLResourceBundleFactory = this;
            synchronized (xMLResourceBundleFactory) {
                bundle = this.selectCached(cacheKey);
                if (bundle == null) {
                    boolean localeAvailable = locale != null && !locale.getLanguage().equals("");
                    XMLResourceBundle parent = null;
                    if (localeAvailable && ++index == directories.length) {
                        parent = this._select(directories, 0, name, this.getParentLocale(locale));
                    } else if (index < directories.length) {
                        parent = this._select(directories, index, name, locale);
                    }
                    String sourceURI = this.getSourceURI(directories[index - 1], name, locale);
                    bundle = this.create(sourceURI, locale, parent);
                    this.updateCache(cacheKey, bundle);
                }
            }
        }
        return bundle;
    }

    protected XMLResourceBundle create(String sourceURI, Locale locale, XMLResourceBundle parent) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating bundle <" + sourceURI + ">");
        }
        XMLResourceBundle bundle = new XMLResourceBundle(sourceURI, locale, parent);
        bundle.enableLogging(this.getLogger());
        bundle.reload(this.manager, this.resolver, this.interval);
        return bundle;
    }

    protected Locale getParentLocale(Locale locale) {
        Locale newloc = locale.getVariant().length() == 0 ? (locale.getCountry().length() == 0 ? new Locale("", "", "") : new Locale(locale.getLanguage(), "", "")) : new Locale(locale.getLanguage(), locale.getCountry(), "");
        return newloc;
    }

    protected String getCacheKey(String[] directories, int index, String name, Locale locale) throws ComponentException {
        StringBuffer cacheKey = new StringBuffer();
        if (index < directories.length) {
            cacheKey.append(":");
            cacheKey.append(this.getSourceURI(directories[index], name, locale));
            cacheKey.append(this.getCacheKey(directories, ++index, name, locale));
        } else if (locale != null && !locale.getLanguage().equals("")) {
            cacheKey.append(this.getCacheKey(directories, 0, name, this.getParentLocale(locale)));
        }
        return cacheKey.toString();
    }

    protected String getSourceURI(String base, String name, Locale locale) throws ComponentException {
        String uri;
        if (base == null) {
            base = "";
        }
        Source src = null;
        HashMap parameters = Collections.EMPTY_MAP;
        StringBuffer sb = new StringBuffer();
        try {
            src = this.resolver.resolveURI(base);
            parameters = new HashMap(7);
            uri = NetUtils.deparameterize(src.getURI(), parameters);
            sb.append(uri);
            if (!uri.endsWith("/")) {
                sb.append('/');
            }
        }
        catch (IOException e) {
            throw new ComponentException("Cannot resolve catalogue base URI <" + base + ">", name, (Throwable)e);
        }
        finally {
            this.resolver.release(src);
        }
        sb.append(name);
        if (locale != null) {
            if (!locale.getLanguage().equals("")) {
                sb.append("_");
                sb.append(locale.getLanguage());
            }
            if (!locale.getCountry().equals("")) {
                sb.append("_");
                sb.append(locale.getCountry());
            }
            if (!locale.getVariant().equals("")) {
                sb.append("_");
                sb.append(locale.getVariant());
            }
        }
        sb.append(".xml");
        uri = NetUtils.parameterize(sb.toString(), parameters);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolved name: " + name + ", locale: " + locale + " --> " + uri);
        }
        return uri;
    }

    protected XMLResourceBundle selectCached(String cacheKey) {
        XMLResourceBundle bundle = (XMLResourceBundle)this.cache.get((Object)cacheKey);
        if (bundle != null && this.interval != -1L) {
            XMLResourceBundle b = bundle;
            while (b != null) {
                b.reload(this.manager, this.resolver, this.interval);
                b = (XMLResourceBundle)b.parent;
            }
        }
        return bundle;
    }

    protected void updateCache(String cacheKey, XMLResourceBundle bundle) {
        try {
            this.cache.store((Object)cacheKey, (Object)bundle);
        }
        catch (IOException e) {
            this.getLogger().error("Bundle <" + bundle.getSourceURI() + ">: unable to store.", (Throwable)e);
        }
    }
}

