/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.selection.Selector;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;

public class ResourceExistsSelector
extends AbstractLogEnabled
implements ThreadSafe,
Serviceable,
Disposable,
Selector {
    private ServiceManager manager;
    private SourceResolver resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void dispose() {
        this.manager.release((Object)this.resolver);
        this.resolver = null;
        this.manager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean select(String expression, Map objectModel, Parameters parameters) {
        String resourceURI = parameters.getParameter("prefix", "") + expression;
        Source source = null;
        try {
            source = this.resolver.resolveURI(resourceURI);
            boolean bl = source.exists();
            return bl;
        }
        catch (SourceNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.getLogger().warn("Exception resolving resource " + resourceURI, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (source != null) {
                this.resolver.release(source);
            }
        }
    }
}

