/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ContentAggregator
extends ContentHandlerWrapper
implements Generator,
CacheableProcessingComponent,
Serviceable {
    protected Element rootElement;
    protected ArrayList parts = new ArrayList();
    private int rootElementIndex;
    protected Element currentElement;
    protected SourceResolver resolver;
    protected ServiceManager manager;

    @Override
    public void generate() throws IOException, SAXException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Generating aggregated content");
        }
        this.contentHandler.startDocument();
        this.startElem(this.rootElement);
        for (int i = 0; i < this.parts.size(); ++i) {
            Part part = (Part)this.parts.get(i);
            int n = this.rootElementIndex = part.stripRootElement ? -1 : 0;
            if (part.element != null) {
                this.currentElement = part.element;
                this.startElem(part.element);
            } else {
                this.currentElement = this.rootElement;
            }
            SourceUtil.parse(this.manager, part.source, (ContentHandler)((Object)this));
            if (part.element == null) continue;
            this.endElem(part.element);
        }
        this.endElem(this.rootElement);
        this.contentHandler.endDocument();
        this.getLogger().debug("Finished aggregating content");
    }

    @Override
    public Serializable getKey() {
        try {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("CA(").append(this.rootElement.prefix).append(':').append(this.rootElement.name).append('<').append(this.rootElement.namespace).append(">)");
            for (int i = 0; i < this.parts.size(); ++i) {
                Part part = (Part)this.parts.get(i);
                Source source = part.source;
                if (part.element == null) {
                    buffer.append("P=").append(part.stripRootElement).append(':').append(source.getURI()).append(';');
                    continue;
                }
                buffer.append("P=").append(part.element.prefix).append(':').append(part.element.name).append('<').append(part.element.namespace).append(">:").append(part.stripRootElement).append(':').append(source.getURI()).append(';');
            }
            return buffer.toString();
        }
        catch (Exception e) {
            this.getLogger().error("Could not generateKey", (Throwable)e);
            return null;
        }
    }

    @Override
    public SourceValidity getValidity() {
        try {
            AggregatedValidity v = new AggregatedValidity();
            for (int i = 0; i < this.parts.size(); ++i) {
                Source current = ((Part)this.parts.get((int)i)).source;
                SourceValidity sv = current.getValidity();
                if (sv == null) {
                    return null;
                }
                v.add(sv);
            }
            return v;
        }
        catch (Exception e) {
            this.getLogger().error("Could not getValidity", (Throwable)e);
            return null;
        }
    }

    public void setRootElement(String element, String namespace, String prefix) {
        this.rootElement = new Element(element, namespace, prefix);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Root element='" + element + "' ns='" + namespace + "' prefix='" + prefix + "'");
        }
    }

    public void addPart(String uri, String element, String namespace, String stripRootElement, String prefix) {
        Element elem = null;
        if (!element.equals("")) {
            elem = namespace.length() == 0 ? new Element(element, this.rootElement.namespace, this.rootElement.prefix) : new Element(element, namespace, prefix);
        }
        this.parts.add(new Part(uri, elem, stripRootElement));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Part uri='" + uri + "' element='" + element + "' ns='" + namespace + "' stripRootElement='" + stripRootElement + "' prefix='" + prefix + "'");
        }
    }

    @Override
    public void setConsumer(XMLConsumer consumer) {
        this.setContentHandler((ContentHandler)((Object)consumer));
        this.setLexicalHandler((LexicalHandler)((Object)consumer));
    }

    @Override
    public void recycle() {
        super.recycle();
        this.rootElement = null;
        for (int i = 0; i < this.parts.size(); ++i) {
            Part current = (Part)this.parts.get(i);
            if (current.source == null) continue;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Releasing " + current.source);
            }
            this.resolver.release(current.source);
        }
        this.parts.clear();
        this.currentElement = null;
        this.resolver = null;
    }

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        this.resolver = resolver;
        try {
            for (int i = 0; i < this.parts.size(); ++i) {
                Part current = (Part)this.parts.get(i);
                current.source = resolver.resolveURI(current.uri);
            }
        }
        catch (SourceException se) {
            throw SourceUtil.handle("Unable to resolve source.", se);
        }
    }

    private void startElem(Element element) throws SAXException {
        String qname;
        String string = qname = element.prefix.length() == 0 ? element.name : element.prefix + ':' + element.name;
        if (!element.namespace.equals("")) {
            this.contentHandler.startPrefixMapping(element.prefix, element.namespace);
        }
        this.contentHandler.startElement(element.namespace, element.name, qname, XMLUtils.EMPTY_ATTRIBUTES);
    }

    private void endElem(Element element) throws SAXException {
        String qname = element.prefix.length() == 0 ? element.name : element.prefix + ':' + element.name;
        this.contentHandler.endElement(element.namespace, element.name, qname);
        if (!element.namespace.equals("")) {
            this.contentHandler.endPrefixMapping(element.prefix);
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String raw, Attributes atts) throws SAXException {
        ++this.rootElementIndex;
        if (this.rootElementIndex == 0) {
            this.getLogger().debug("Skipping root element start event.");
            return;
        }
        if (namespaceURI == null || namespaceURI.length() == 0) {
            String qname = this.currentElement.prefix.length() == 0 ? localName : this.currentElement.prefix + ':' + localName;
            this.contentHandler.startElement(this.currentElement.namespace, localName, qname, atts);
        } else {
            this.contentHandler.startElement(namespaceURI, localName, raw, atts);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String raw) throws SAXException {
        --this.rootElementIndex;
        if (this.rootElementIndex == -1) {
            this.getLogger().debug("Skipping root element end event.");
            return;
        }
        if (namespaceURI == null || namespaceURI.length() == 0) {
            String qname = this.currentElement.prefix.length() == 0 ? localName : this.currentElement.prefix + ':' + localName;
            this.contentHandler.endElement(this.currentElement.namespace, localName, qname);
        } else {
            this.contentHandler.endElement(namespaceURI, localName, raw);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    protected static final class Element {
        public String namespace;
        public String prefix;
        public String name;

        public Element(String name, String namespace, String prefix) {
            this.namespace = namespace;
            this.prefix = prefix;
            this.name = name;
        }
    }

    protected static final class Part {
        public String uri;
        public Element element;
        public Source source;
        boolean stripRootElement;

        public Part(String uri, Element element, String stripRoot) {
            this.uri = uri;
            this.element = element;
            this.stripRootElement = BooleanUtils.toBoolean((String)stripRoot);
        }
    }
}

