/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.util.ClassUtils;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class TeeTransformer
extends AbstractSAXTransformer {
    private TransformerHandler serializer;
    private SAXTransformerFactory transformerFactory;
    private SourceResolver resolver;
    private OutputStream os;

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        Source source = null;
        try {
            this.resolver = resolver;
            source = this.resolver.resolveURI(src);
            String systemId = source.getURI();
            if (!(source instanceof ModifiableSource)) {
                throw new ProcessingException("Source '" + systemId + "' is not writeable.");
            }
            this.serializer = this.transformerFactory.newTransformerHandler();
            this.os = ((ModifiableSource)source).getOutputStream();
            this.serializer.setResult(new StreamResult(this.os));
        }
        catch (SourceException e) {
            throw SourceUtil.handle(e);
        }
        catch (TransformerConfigurationException e) {
            throw new ProcessingException(e);
        }
        catch (TransformerFactoryConfigurationError error) {
            throw new ProcessingException(error.getException());
        }
        finally {
            if (source != null) {
                this.resolver.release(source);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        String tFactoryClass = configuration.getChild("transformer-factory").getValue(null);
        if (tFactoryClass != null) {
            try {
                this.transformerFactory = (SAXTransformerFactory)ClassUtils.newInstance(tFactoryClass);
                if (!this.getLogger().isDebugEnabled()) return;
                this.getLogger().debug("Using transformer factory " + tFactoryClass);
                return;
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot load transformer factory " + tFactoryClass, (Throwable)e);
            }
        } else {
            this.transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
        this.serializer.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
        this.serializer.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
        this.serializer.endDocument();
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException e) {
                throw new CascadingRuntimeException("Error closing output stream.", (Throwable)e);
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
        this.serializer.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
        this.serializer.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.contentHandler.startElement(uri, loc, raw, a);
        this.serializer.startElement(uri, loc, raw, a);
    }

    @Override
    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.contentHandler.endElement(uri, loc, raw);
        this.serializer.endElement(uri, loc, raw);
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        this.contentHandler.characters(ch, start, len);
        this.serializer.characters(ch, start, len);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, len);
        this.serializer.ignorableWhitespace(ch, start, len);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
        this.serializer.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
        this.serializer.skippedEntity(name);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.lexicalHandler.startDTD(name, publicId, systemId);
        this.serializer.startDTD(name, publicId, systemId);
    }

    @Override
    public void endDTD() throws SAXException {
        this.lexicalHandler.endDTD();
        this.serializer.endDTD();
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.lexicalHandler.startEntity(name);
        this.serializer.startEntity(name);
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.lexicalHandler.endEntity(name);
        this.serializer.endEntity(name);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.lexicalHandler.startCDATA();
        this.serializer.startCDATA();
    }

    @Override
    public void endCDATA() throws SAXException {
        this.lexicalHandler.endCDATA();
        this.serializer.endCDATA();
    }

    @Override
    public void comment(char[] ch, int start, int len) throws SAXException {
        this.lexicalHandler.comment(ch, start, len);
        this.serializer.comment(ch, start, len);
    }

    @Override
    public void recycle() {
        super.recycle();
        this.serializer = null;
    }
}

