/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class MIMEUtils {
    private static final String MIME_MAPPING_FILE = "org/apache/cocoon/util/mime.types";
    private static final Map extMap = new HashMap();
    private static final Map mimeMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMIMEType(File file) throws FileNotFoundException, IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[3];
            int count = in.read(buf, 0, 3);
            if (count < 3) {
                String string = null;
                return string;
            }
            if (buf[0] == 71 && buf[1] == 73 && buf[2] == 70) {
                String string = "image/gif";
                return string;
            }
            if (buf[0] == -1 && buf[1] == -40) {
                String string = "image/jpeg";
                return string;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        String name = file.getName();
        int index = name.lastIndexOf(".");
        String fileExt = ".";
        if (index == -1) return MIMEUtils.getMIMEType(fileExt);
        fileExt = name.substring(index);
        return MIMEUtils.getMIMEType(fileExt);
    }

    public static String getMIMEType(String ext) {
        return (String)mimeMap.get(ext);
    }

    public static String getDefaultExtension(String type) {
        return (String)extMap.get(type);
    }

    public static void loadMimeTypes(Reader in, Map extMap, Map mimeMap) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(in);
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() == 0) continue;
            StringTokenizer tok = new StringTokenizer(line, " \t");
            String mimeType = tok.nextToken();
            if (!tok.hasMoreTokens()) continue;
            String defaultExt = tok.nextToken();
            if (!extMap.containsKey(mimeType)) {
                extMap.put(mimeType, "." + defaultExt);
            }
            if (!mimeMap.containsKey("." + defaultExt)) {
                mimeMap.put("." + defaultExt, mimeType);
            }
            while (tok.hasMoreTokens()) {
                String ext = tok.nextToken();
                if (mimeMap.containsKey("." + ext)) continue;
                mimeMap.put("." + ext, mimeType);
            }
        }
    }

    static {
        try {
            InputStream is = MIMEUtils.class.getClassLoader().getResourceAsStream(MIME_MAPPING_FILE);
            if (null == is) {
                throw new RuntimeException("Cocoon cannot load MIME type mappings from org/apache/cocoon/util/mime.types");
            }
            MIMEUtils.loadMimeTypes(new InputStreamReader(is), extMap, mimeMap);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cocoon cannot load MIME type mappings from org/apache/cocoon/util/mime.types");
        }
    }
}

