/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.NodeNameExtractor;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

class CollectFunctionNames
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final transient AbstractCompiler compiler;
    private final FunctionNamesMap functionNames = new FunctionNamesMap();
    private static final char DELIMITER = '.';
    private final NodeNameExtractor extractor = new NodeNameExtractor('.');

    CollectFunctionNames(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    public FunctionNames getFunctionNames() {
        return this.functionNames;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FUNCTION: {
                Node functionNameNode = n.getFirstChild();
                String functionName = functionNameNode.getString();
                if (functionName.isEmpty()) {
                    if (parent.isAssign()) {
                        Node lhs = parent.getFirstChild();
                        functionName = this.extractor.getName(lhs);
                    } else if (parent.isName()) {
                        functionName = this.extractor.getName(parent);
                    }
                }
                Node enclosingFunction = t.getEnclosingFunction();
                this.functionNames.put(n, enclosingFunction, functionName);
                break;
            }
            case ASSIGN: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                if (!rhs.isObjectLit()) break;
                this.collectObjectLiteralMethodsNames(rhs, this.extractor.getName(lhs));
                break;
            }
            case CLASS: {
                this.collectClassMethodsNames(n, this.extractor.getName(n));
                break;
            }
        }
    }

    private void collectObjectLiteralMethodsNames(Node objectLiteral, String context) {
        for (Node keyNode = objectLiteral.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
            Node valueNode = keyNode.getFirstChild();
            if (!keyNode.isStringKey() && !keyNode.isMemberFunctionDef()) continue;
            String name = this.combineNames(context, this.extractor.getName(keyNode));
            Token type = valueNode.getToken();
            if (type == Token.FUNCTION) {
                Node functionNameNode = valueNode.getFirstChild();
                String functionName = functionNameNode.getString();
                if (!functionName.isEmpty()) continue;
                this.functionNames.setFunctionName(name, valueNode);
                continue;
            }
            if (type != Token.OBJECTLIT) continue;
            this.collectObjectLiteralMethodsNames(valueNode, name);
        }
    }

    private void collectClassMethodsNames(Node classNode, String className) {
        Node classMembersNode = classNode.getLastChild();
        for (Node methodNode : classMembersNode.children()) {
            if (!methodNode.isMemberFunctionDef()) continue;
            Node functionNode = methodNode.getFirstChild();
            String name = this.combineNames(className, this.extractor.getName(methodNode));
            this.functionNames.setFunctionName(name, functionNode);
        }
    }

    private String combineNames(String lhs, String rhs) {
        return lhs + '.' + rhs;
    }

    private static class FunctionRecord
    implements Serializable {
        public final int id;
        public final Node parent;
        public String name;

        FunctionRecord(int id, Node parent, String name) {
            this.id = id;
            this.parent = parent;
            this.name = name;
        }
    }

    private static class FunctionNamesMap
    implements FunctionNames {
        private int nextId = 0;
        private final Map<Node, FunctionRecord> functionMap = new LinkedHashMap<Node, FunctionRecord>();

        private FunctionNamesMap() {
        }

        @Override
        public Iterable<Node> getFunctionNodeList() {
            return this.functionMap.keySet();
        }

        @Override
        public int getFunctionId(Node f) {
            FunctionRecord record = this.functionMap.get(f);
            if (record != null) {
                return record.id;
            }
            return -1;
        }

        @Override
        public String getFunctionName(Node f) {
            Node parent;
            FunctionRecord record = this.functionMap.get(f);
            if (record == null) {
                return null;
            }
            String str = record.name;
            if (str.isEmpty()) {
                str = "<anonymous>";
            }
            if ((parent = record.parent) != null) {
                str = this.getFunctionName(parent) + "::" + str;
            }
            str = str.replace("::this.", ".");
            str = str.replace("..", ".");
            str = str.replaceFirst("^(<anonymous>::)*", "");
            return str;
        }

        private void put(Node n, Node enclosingFunction, String functionName) {
            this.functionMap.put(n, new FunctionRecord(this.nextId++, enclosingFunction, functionName));
        }

        private void setFunctionName(String name, Node fnNode) {
            FunctionRecord record = this.functionMap.get(fnNode);
            assert (record != null);
            assert (record.name.isEmpty());
            record.name = name;
        }
    }
}

