/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

class ConvertToDottedProperties
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;

    ConvertToDottedProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETTER_DEF: 
            case SETTER_DEF: 
            case STRING_KEY: {
                if (!NodeUtil.isValidPropertyName(FeatureSet.ES3, n.getString()) || !n.getBooleanProp((byte)36)) break;
                n.putBooleanProp((byte)36, false);
                this.compiler.reportChangeToEnclosingScope(n);
                break;
            }
            case GETELEM: {
                Node left = n.getFirstChild();
                Node right = left.getNext();
                if (!right.isString() || !NodeUtil.isValidPropertyName(FeatureSet.ES3, right.getString())) break;
                n.removeChild(left);
                n.removeChild(right);
                Node newGetProp = IR.getprop(left, right);
                parent.replaceChild(n, newGetProp);
                this.compiler.reportChangeToEnclosingScope(newGetProp);
                break;
            }
        }
    }
}

