/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;

public final class Es6ForOfConverter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.FOR_OF);
    private final boolean addTypes;
    private final TypeIRegistry registry;
    private final TypeI unknownType;
    private final TypeI stringType;
    private final TypeI booleanType;
    private static final String ITER_BASE = "$jscomp$iter$";
    private static final String ITER_RESULT = "$jscomp$key$";

    public Es6ForOfConverter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.addTypes = AbstractCompiler.MostRecentTypechecker.NTI.equals((Object)compiler.getMostRecentTypechecker());
        this.registry = compiler.getTypeIRegistry();
        this.unknownType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.UNKNOWN_TYPE);
        this.stringType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.STRING_TYPE);
        this.booleanType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.BOOLEAN_TYPE);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FOR_OF: {
                this.visitForOf(t, n, parent);
                break;
            }
        }
    }

    private void visitForOf(NodeTraversal t, Node node, Node parent) {
        Node declarationOrAssign;
        String variableName;
        Token declType;
        ObjectTypeI iterableType;
        Node variable = node.removeFirstChild();
        Node iterable = node.removeFirstChild();
        Node body = node.removeFirstChild();
        TypeI typeParam = this.unknownType;
        if (this.addTypes && (iterableType = iterable.getTypeI().autobox().toMaybeObjectType()) != null) {
            TypeIRegistry registry = this.compiler.getTypeIRegistry();
            TypeI iterableBaseType = registry.getNativeType(JSTypeNative.ITERABLE_TYPE);
            typeParam = iterableType.getInstantiatedTypeArgument(iterableBaseType);
        }
        TypeI iteratorType = this.createGenericType(JSTypeNative.ITERATOR_TYPE, typeParam);
        TypeI iIterableResultType = this.createGenericType(JSTypeNative.I_ITERABLE_RESULT_TYPE, typeParam);
        TypeI iteratorNextType = this.addTypes ? iteratorType.toMaybeObjectType().getPropertyType("next") : null;
        JSDocInfo varJSDocInfo = variable.getJSDocInfo();
        Node iterName = Es6ToEs3Util.withType(IR.name(ITER_BASE + (String)this.compiler.getUniqueNameIdSupplier().get()), iteratorType);
        iterName.makeNonIndexable();
        Node getNext = Es6ToEs3Util.withType(IR.call(Es6ToEs3Util.withType(IR.getprop(iterName.cloneTree(), this.withStringType(IR.string("next"))), iteratorNextType), new Node[0]), iIterableResultType);
        if (variable.isName()) {
            declType = Token.NAME;
            variableName = variable.getQualifiedName();
        } else {
            Preconditions.checkState((boolean)NodeUtil.isNameDeclaration(variable), (String)"Expected var, let, or const. Got %s", (Object)variable);
            declType = variable.getToken();
            variableName = variable.getFirstChild().getQualifiedName();
        }
        Node iterResult = Es6ToEs3Util.withType(IR.name(ITER_RESULT + variableName), iIterableResultType);
        iterResult.makeNonIndexable();
        Node call = Es6ToEs3Util.makeIterator(this.compiler, iterable);
        if (this.addTypes) {
            TypeI jscompType = ((Var)t.getScope().getVar("$jscomp")).getNode().getTypeI();
            TypeI makeIteratorType = jscompType.toMaybeObjectType().getPropertyType("makeIterator");
            call.getFirstChild().setTypeI(makeIteratorType);
            call.getFirstFirstChild().setTypeI(jscompType);
        }
        Node init = IR.var(iterName.cloneTree(), Es6ToEs3Util.withType(call, iteratorType));
        Node initIterResult = iterResult.cloneTree();
        initIterResult.addChildToFront(getNext.cloneTree());
        init.addChildToBack(initIterResult);
        Node cond = this.withBooleanType(IR.not(this.withBooleanType(IR.getprop(iterResult.cloneTree(), this.withStringType(IR.string("done"))))));
        Node incr = Es6ToEs3Util.withType(IR.assign(iterResult.cloneTree(), getNext.cloneTree()), iIterableResultType);
        if (declType == Token.NAME) {
            declarationOrAssign = Es6ToEs3Util.withType(IR.assign(Es6ToEs3Util.withType(IR.name(variableName).useSourceInfoFrom(variable), typeParam), Es6ToEs3Util.withType(IR.getprop(iterResult.cloneTree(), this.withStringType(IR.string("value"))), typeParam)), typeParam);
            declarationOrAssign.setJSDocInfo(varJSDocInfo);
            declarationOrAssign = IR.exprResult(declarationOrAssign);
        } else {
            declarationOrAssign = new Node(declType, Es6ToEs3Util.withType(IR.name(variableName).useSourceInfoFrom(variable.getFirstChild()), typeParam));
            declarationOrAssign.getFirstChild().addChildToBack(Es6ToEs3Util.withType(IR.getprop(iterResult.cloneTree(), this.withStringType(IR.string("value"))), typeParam));
            declarationOrAssign.setJSDocInfo(varJSDocInfo);
        }
        Node newBody = IR.block(declarationOrAssign, body).useSourceInfoFrom(body);
        Node newFor = IR.forNode(init, cond, incr, newBody);
        newFor.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, newFor);
        this.compiler.reportChangeToEnclosingScope(newFor);
    }

    private TypeI createGenericType(JSTypeNative typeName, TypeI typeArg) {
        return Es6ToEs3Util.createGenericType(this.addTypes, this.registry, typeName, typeArg);
    }

    private Node withStringType(Node n) {
        return Es6ToEs3Util.withType(n, this.stringType);
    }

    private Node withBooleanType(Node n) {
        return Es6ToEs3Util.withType(n, this.booleanType);
    }
}

