/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.Locale;

public final class Es6ToEs3Util {
    static final DiagnosticType CANNOT_CONVERT = DiagnosticType.error("JSC_CANNOT_CONVERT", "This code cannot be converted from ES6. {0}");
    static final DiagnosticType CANNOT_CONVERT_YET = DiagnosticType.error("JSC_CANNOT_CONVERT_YET", "ES6 transpilation of ''{0}'' is not yet implemented.");

    static void cannotConvert(AbstractCompiler compiler, Node n, String message) {
        compiler.report(JSError.make(n, CANNOT_CONVERT, message));
    }

    static void cannotConvertYet(AbstractCompiler compiler, Node n, String feature) {
        compiler.report(JSError.make(n, CANNOT_CONVERT_YET, feature));
    }

    static Node makeIterator(AbstractCompiler compiler, Node iterable) {
        return Es6ToEs3Util.callEs6RuntimeFunction(compiler, iterable, "makeIterator");
    }

    static Node arrayFromIterator(AbstractCompiler compiler, Node iterator) {
        return Es6ToEs3Util.callEs6RuntimeFunction(compiler, iterator, "arrayFromIterator");
    }

    static Node arrayFromIterable(AbstractCompiler compiler, Node iterable) {
        return Es6ToEs3Util.callEs6RuntimeFunction(compiler, iterable, "arrayFromIterable");
    }

    static void preloadEs6RuntimeFunction(AbstractCompiler compiler, String function) {
        compiler.ensureLibraryInjected("es6/util/" + function.toLowerCase(Locale.US), false);
    }

    static void preloadEs6Symbol(AbstractCompiler compiler) {
        compiler.ensureLibraryInjected("es6/symbol", false);
    }

    static Node callEs6RuntimeFunction(AbstractCompiler compiler, Node iterable, String function) {
        Es6ToEs3Util.preloadEs6RuntimeFunction(compiler, function);
        return IR.call(NodeUtil.newQName(compiler, "$jscomp." + function), iterable);
    }

    static Node withType(Node n, TypeI t) {
        if (t != null) {
            n.setTypeI(t);
        }
        return n;
    }

    static TypeI createType(boolean shouldCreate, TypeIRegistry registry, JSTypeNative typeName) {
        if (!shouldCreate) {
            return null;
        }
        return registry.getNativeType(typeName);
    }

    static TypeI createGenericType(boolean shouldCreate, TypeIRegistry registry, JSTypeNative typeName, TypeI typeArg) {
        if (!shouldCreate) {
            return null;
        }
        ObjectTypeI genericType = (ObjectTypeI)registry.getNativeType(typeName);
        ObjectTypeI uninstantiated = genericType.getRawType();
        return registry.instantiateGenericType(uninstantiated, (ImmutableList<? extends TypeI>)ImmutableList.of((Object)typeArg));
    }
}

