/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;
import javax.annotation.Nullable;

final class InvalidatingTypes {
    private final ImmutableSet<TypeI> types;
    private final boolean allowEnums;
    private final boolean allowScalars;

    private InvalidatingTypes(Builder builder) {
        this.types = builder.types.build();
        this.allowEnums = builder.allowEnums;
        this.allowScalars = builder.allowScalars;
    }

    boolean isInvalidating(TypeI type) {
        if (type == null || type.isUnknownType() || type.isBottom()) {
            return true;
        }
        if (type.isUnionType() && (type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (TypeI typeI : type.getUnionMembers()) {
                if (!this.isInvalidating(typeI)) continue;
                return true;
            }
            return false;
        }
        ObjectTypeI objType = type.toMaybeObjectType();
        if (objType == null) {
            return !this.allowScalars;
        }
        return this.types.contains((Object)objType) || objType.isAmbiguousObject() || !this.allowEnums && objType.isEnumObject() || !this.allowScalars && objType.isBoxableScalar();
    }

    static final class Builder {
        private final ImmutableSet.Builder<TypeI> types = ImmutableSet.builder();
        private final TypeIRegistry registry;
        private boolean allowEnums = false;
        private boolean allowScalars = false;
        @Nullable
        private Multimap<TypeI, Supplier<JSError>> invalidationMap;

        Builder(TypeIRegistry registry) {
            this.registry = registry;
        }

        InvalidatingTypes build() {
            return new InvalidatingTypes(this);
        }

        Builder recordInvalidations(@Nullable Multimap<TypeI, Supplier<JSError>> invalidationMap) {
            this.invalidationMap = invalidationMap;
            return this;
        }

        Builder allowEnumsAndScalars() {
            this.allowScalars = true;
            this.allowEnums = true;
            return this;
        }

        Builder disallowGlobalThis() {
            this.types.add((Object)this.registry.getNativeType(JSTypeNative.GLOBAL_THIS));
            return this;
        }

        Builder addAllTypeMismatches(Iterable<TypeMismatch> mismatches) {
            for (TypeMismatch mis : mismatches) {
                this.addType(mis.typeA, mis);
                this.addType(mis.typeB, mis);
            }
            return this;
        }

        Builder addTypesInvalidForPropertyRenaming() {
            this.types.addAll((Iterable)ImmutableList.of((Object)this.registry.getNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE), (Object)this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), (Object)this.registry.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE), (Object)this.registry.getNativeType(JSTypeNative.OBJECT_TYPE), (Object)this.registry.getNativeType(JSTypeNative.OBJECT_PROTOTYPE), (Object)this.registry.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE), (Object)this.registry.getNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE)));
            return this;
        }

        private Builder addType(TypeI type, TypeMismatch mismatch) {
            if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
                for (TypeI typeI : type.getUnionMembers()) {
                    this.addType(typeI, mismatch);
                }
            } else if (type.isEnumElement()) {
                this.addType(type.getEnumeratedTypeOfEnumElement(), mismatch);
            } else {
                Preconditions.checkState((!type.isUnionType() ? 1 : 0) != 0);
                this.types.add((Object)type);
                this.recordInvalidation(type, mismatch);
                ObjectTypeI objType = type.toMaybeObjectType();
                if (objType != null) {
                    ObjectTypeI objectTypeI = objType.getPrototypeObject();
                    if (objectTypeI != null) {
                        this.types.add((Object)objectTypeI);
                        this.recordInvalidation(objectTypeI, mismatch);
                    }
                    if (objType.isConstructor()) {
                        this.types.add((Object)objType.toMaybeFunctionType().getInstanceType());
                    } else if (objType.isInstanceType()) {
                        this.types.add((Object)objType.getConstructor());
                    }
                }
            }
            return this;
        }

        private void recordInvalidation(TypeI t, TypeMismatch mis) {
            if (!t.isObjectType()) {
                return;
            }
            if (this.invalidationMap != null) {
                this.invalidationMap.put((Object)t, mis.error);
            }
        }
    }
}

