/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Es6TemplateLiterals;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayList;
import java.util.List;

public final class LateEs6ToEs3Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.COMPUTED_PROPERTIES, FeatureSet.Feature.EXTENDED_OBJECT_LITERALS, FeatureSet.Feature.FOR_OF, FeatureSet.Feature.MEMBER_DECLARATIONS, FeatureSet.Feature.TEMPLATE_LITERALS);
    private final boolean addTypes;
    private final TypeIRegistry registry;
    private final TypeI unknownType;
    private static final String FRESH_COMP_PROP_VAR = "$jscomp$compprop";

    public LateEs6ToEs3Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.addTypes = AbstractCompiler.MostRecentTypechecker.NTI.equals((Object)compiler.getMostRecentTypechecker());
        this.registry = compiler.getTypeIRegistry();
        this.unknownType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.UNKNOWN_TYPE);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (this.compiler.getOptions().getLanguageOut() != CompilerOptions.LanguageMode.ECMASCRIPT3) break;
                Es6ToEs3Util.cannotConvert(this.compiler, n, "ES5 getters/setters (consider using --language_out=ES5)");
                return false;
            }
            case FUNCTION: {
                if (!n.isAsyncFunction()) break;
                throw new IllegalStateException("async functions should have already been converted");
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case OBJECTLIT: {
                this.visitObject(n);
                break;
            }
            case MEMBER_FUNCTION_DEF: {
                if (!parent.isObjectLit()) break;
                this.visitMemberFunctionDefInObjectLit(n, parent);
                break;
            }
            case TAGGED_TEMPLATELIT: {
                Es6TemplateLiterals.visitTaggedTemplateLiteral(t, n, this.addTypes);
                break;
            }
            case TEMPLATELIT: {
                if (parent.isTaggedTemplateLit()) break;
                Es6TemplateLiterals.visitTemplateLiteral(t, n, this.addTypes);
                break;
            }
        }
    }

    private void visitMemberFunctionDefInObjectLit(Node n, Node parent) {
        String name = n.getString();
        Node nameNode = n.getFirstFirstChild();
        Node stringKey = Es6ToEs3Util.withType(IR.stringKey(name, n.getFirstChild().detach()), n.getTypeI());
        stringKey.setJSDocInfo(n.getJSDocInfo());
        parent.replaceChild(n, stringKey);
        stringKey.useSourceInfoFrom(nameNode);
        this.compiler.reportChangeToEnclosingScope(stringKey);
    }

    private void visitObject(Node obj) {
        for (Node child : obj.children()) {
            if (!child.isComputedProp()) continue;
            this.visitObjectWithComputedProperty(obj);
            return;
        }
    }

    private void visitObjectWithComputedProperty(Node obj) {
        Preconditions.checkArgument((boolean)obj.isObjectLit());
        List<Node> props = new ArrayList();
        Node currElement = obj.getFirstChild();
        TypeI objectType = obj.getTypeI();
        while (currElement != null) {
            if (currElement.getBooleanProp((byte)73) || currElement.getBooleanProp((byte)74)) {
                Es6ToEs3Util.cannotConvertYet(this.compiler, currElement, "computed getter/setter in an object literal");
                return;
            }
            if (currElement.isGetterDef() || currElement.isSetterDef()) {
                currElement = currElement.getNext();
                continue;
            }
            Node nextNode = currElement.getNext();
            obj.removeChild(currElement);
            props.add(currElement);
            currElement = nextNode;
        }
        String objName = FRESH_COMP_PROP_VAR + (String)this.compiler.getUniqueNameIdSupplier().get();
        props = Lists.reverse(props);
        Node result = Es6ToEs3Util.withType(IR.name(objName), objectType);
        for (Node propdef : props) {
            if (propdef.isComputedProp()) {
                Node propertyExpression = propdef.removeFirstChild();
                Node value = propdef.removeFirstChild();
                TypeI valueType = value.getTypeI();
                result = Es6ToEs3Util.withType(IR.comma(Es6ToEs3Util.withType(IR.assign(this.withUnknownType(IR.getelem(Es6ToEs3Util.withType(IR.name(objName), objectType), propertyExpression)), value), valueType), result), objectType);
                continue;
            }
            Node val = propdef.removeFirstChild();
            TypeI valueType = val.getTypeI();
            propdef.setToken(Token.STRING);
            propdef.setTypeI(null);
            Token token = propdef.isQuotedString() ? Token.GETELEM : Token.GETPROP;
            Node access = Es6ToEs3Util.withType(new Node(token, Es6ToEs3Util.withType(IR.name(objName), objectType), propdef), valueType);
            result = Es6ToEs3Util.withType(IR.comma(Es6ToEs3Util.withType(IR.assign(access, val), valueType), result), objectType);
        }
        Node statement = obj;
        while (!NodeUtil.isStatement(statement)) {
            statement = statement.getParent();
        }
        result.useSourceInfoIfMissingFromForTree(obj);
        obj.replaceWith(result);
        TypeI simpleObjectType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.EMPTY_OBJECT_LITERAL_TYPE);
        Node var = IR.var(Es6ToEs3Util.withType(IR.name(objName), objectType), Es6ToEs3Util.withType(obj, simpleObjectType));
        var.useSourceInfoIfMissingFromForTree(statement);
        statement.getParent().addChildBefore(var, statement);
        this.compiler.reportChangeToEnclosingScope(var);
    }

    private Node withUnknownType(Node n) {
        return Es6ToEs3Util.withType(n, this.unknownType);
    }
}

