/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalTypeInfo;
import com.google.javascript.jscomp.GlobalTypeInfoCollector;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NTIScope;
import com.google.javascript.jscomp.NTIWorkset;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.TypeTransformation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.MismatchInfo;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.ToStringContext;
import com.google.javascript.jscomp.newtypes.TypeEnv;
import com.google.javascript.jscomp.newtypes.UniqueNameGenerator;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class NewTypeInference
implements CompilerPass {
    static final DiagnosticType MISTYPED_ASSIGN_RHS = DiagnosticType.warning("JSC_NTI_MISTYPED_ASSIGN_RHS", "The right side in the assignment is not a subtype of the left side.\n{0}");
    static final DiagnosticType INVALID_OPERAND_TYPE = DiagnosticType.warning("JSC_NTI_INVALID_OPERAND_TYPE", "Invalid type(s) for operator {0}.\n{1}");
    static final DiagnosticType RETURN_NONDECLARED_TYPE = DiagnosticType.warning("JSC_NTI_RETURN_NONDECLARED_TYPE", "Returned type does not match declared return type.\n{0}");
    static final DiagnosticType INVALID_INFERRED_RETURN_TYPE = DiagnosticType.warning("JSC_NTI_INVALID_INFERRED_RETURN_TYPE", "Function called in context that expects incompatible type.\n{0}");
    static final DiagnosticType INVALID_DECLARED_RETURN_TYPE_OF_GENERATOR_FUNCTION = DiagnosticType.warning("JSC_NTI_INVALID_DECLARED_RETURN_TYPE_OF_GENERATOR_FUNCTION", "A generator function must return a (supertype of) Generator.\n{0}.");
    static final DiagnosticType INVALID_ARGUMENT_TYPE = DiagnosticType.warning("JSC_NTI_INVALID_ARGUMENT_TYPE", "Invalid type for parameter {0} of function {1}.\n{2}");
    static final DiagnosticType TEMPLATE_ARGUMENT_MISMATCH = DiagnosticType.warning("JSC_NTI_TEMPLATE_ARGUMENT_MISMATCH", "Invalid type for the first parameter of tag function {0}.\n{1}");
    static final DiagnosticType TEMPLATE_ARGUMENT_MISSING = DiagnosticType.warning("JSC_NTI_TEMPLATE_ARGUMENT_MISSING", "A tag function must take at least one argument.\n");
    static final DiagnosticType CROSS_SCOPE_GOTCHA = DiagnosticType.warning("JSC_NTI_CROSS_SCOPE_GOTCHA", "Variable {0} typed inconsistently across scopes.\nIn outer scope : {1}\nIn inner scope : {2}\n");
    static final DiagnosticType POSSIBLY_INEXISTENT_PROPERTY = DiagnosticType.warning("JSC_NTI_POSSIBLY_INEXISTENT_PROPERTY", "Property {0} may not be present on {1}.");
    static final DiagnosticType PROPERTY_ACCESS_ON_NONOBJECT = DiagnosticType.warning("JSC_NTI_PROPERTY_ACCESS_ON_NONOBJECT", "Cannot access property {0} of non-object type {1}.");
    static final DiagnosticType NOT_UNIQUE_INSTANTIATION = DiagnosticType.warning("JSC_NTI_NOT_UNIQUE_INSTANTIATION", "When instantiating a polymorphic function, you can only specify one type for each type variable.\n Found {0} types for type variable {1}: {2},\n when instantiating type: {3}");
    static final DiagnosticType INVALID_INDEX_TYPE = DiagnosticType.warning("JSC_NTI_INVALID_INDEX_TYPE", "Invalid type for index.\n{0}");
    static final DiagnosticType BOTTOM_INDEX_TYPE = DiagnosticType.warning("JSC_NTI_BOTTOM_INDEX_TYPE", "This IObject {0} cannot be accessed with a valid type.\n Usually the result of a bad union type.\n");
    static final DiagnosticType INVALID_OBJLIT_PROPERTY_TYPE = DiagnosticType.warning("JSC_NTI_INVALID_OBJLIT_PROPERTY_TYPE", "Invalid type for object-literal property.\n{0}");
    static final DiagnosticType FORIN_EXPECTS_OBJECT = DiagnosticType.warning("JSC_NTI_FORIN_EXPECTS_OBJECT", "For/in expects an object, found type {0}.");
    static final DiagnosticType FORIN_EXPECTS_STRING_KEY = DiagnosticType.warning("JSC_NTI_FORIN_EXPECTS_STRING_KEY", "For/in creates string keys, but variable has declared type {1}.");
    static final DiagnosticType FOROF_EXPECTS_ITERABLE = DiagnosticType.warning("JSC_NTI_FOROF_EXPECTS_ITERABLE", "For/of expects an iterable, found type {0}.");
    static final DiagnosticType MISTYPED_FOROF_ELEMENT_TYPE = DiagnosticType.warning("JSC_NTI_MISTYPED_FOROF_ELEMENT_TYPE", "Invalid type for for/of element.\n{0}");
    static final DiagnosticType CONST_REASSIGNED = DiagnosticType.warning("JSC_NTI_CONST_REASSIGNED", "Cannot change the value of a constant.");
    static final DiagnosticType CONST_PROPERTY_REASSIGNED = DiagnosticType.warning("JSC_NTI_CONST_PROPERTY_REASSIGNED", "Cannot change the value of a constant property.");
    static final DiagnosticType CONST_PROPERTY_DELETED = DiagnosticType.warning("JSC_NTI_CONSTANT_PROPERTY_DELETED", "Constant property {0} cannot be deleted");
    static final DiagnosticType NOT_A_CONSTRUCTOR = DiagnosticType.warning("JSC_NTI_NOT_A_CONSTRUCTOR", "Expected a constructor but found type {0}.");
    static final DiagnosticType CANNOT_INSTANTIATE_ABSTRACT_CLASS = DiagnosticType.warning("JSC_NTI_CANNOT_INSTANTIATE_ABSTRACT_CLASS", "Cannot instantiate abstract class {0}.");
    static final DiagnosticType UNDEFINED_SUPER_CLASS = DiagnosticType.warning("JSC_UNDEFINED_SUPER_CLASS", "Undefined super class for {0}.");
    static final DiagnosticType ASSERT_FALSE = DiagnosticType.warning("JSC_NTI_ASSERT_FALSE", "Assertion is always false. Please use a throw or fail() instead.");
    static final DiagnosticType UNKNOWN_ASSERTION_TYPE = DiagnosticType.warning("JSC_NTI_UNKNOWN_ASSERTION_TYPE", "Assert with unknown asserted type.");
    static final DiagnosticType INVALID_THIS_TYPE_IN_BIND = DiagnosticType.warning("JSC_NTI_INVALID_THIS_TYPE_IN_BIND", "Invalid type for the first argument to bind.\n{0}");
    static final DiagnosticType CANNOT_BIND_CTOR = DiagnosticType.warning("JSC_NTI_CANNOT_BIND_CTOR", "We do not support using .bind on constructor functions.");
    static final DiagnosticType GOOG_BIND_EXPECTS_FUNCTION = DiagnosticType.warning("JSC_NTI_GOOG_BIND_EXPECTS_FUNCTION", "The first argument to goog.bind/goog.partial must be a function, found: {0}");
    static final DiagnosticType BOTTOM_PROP = DiagnosticType.warning("JSC_NTI_BOTTOM_PROP", "Property {0} of {1} cannot have a valid type.Maybe the result of a union of incompatible types?");
    static final DiagnosticType INVALID_CAST = DiagnosticType.warning("JSC_NTI_INVALID_CAST", "invalid cast - the types do not have a common subtype\nfrom: {0}\nto  : {1}");
    static final DiagnosticType GLOBAL_THIS = DiagnosticType.warning("JSC_NTI_USED_GLOBAL_THIS", "Dangerous use of the global THIS object");
    static final DiagnosticType MISSING_RETURN_STATEMENT = DiagnosticType.warning("JSC_NTI_MISSING_RETURN_STATEMENT", "Missing return statement. Function expected to return {0}.");
    static final DiagnosticType CONSTRUCTOR_NOT_CALLABLE = DiagnosticType.warning("JSC_NTI_CONSTRUCTOR_NOT_CALLABLE", "Constructor {0} should be called with the \"new\" keyword");
    static final DiagnosticType ILLEGAL_OBJLIT_KEY = DiagnosticType.warning("JSC_NTI_ILLEGAL_OBJLIT_KEY", "Illegal key, the object literal is a {0}");
    static final DiagnosticType ILLEGAL_PROPERTY_CREATION = DiagnosticType.warning("JSC_NTI_ILLEGAL_PROPERTY_CREATION", "Cannot add property {0} to a struct instance after it is constructed.");
    static final DiagnosticType IN_USED_WITH_STRUCT = DiagnosticType.warning("JSC_NTI_IN_USED_WITH_STRUCT", "Cannot use the IN operator with structs");
    static final DiagnosticType ADDING_PROPERTY_TO_NON_OBJECT = DiagnosticType.warning("JSC_NTI_ADDING_PROPERTY_TO_NON_OBJECT", "Cannot create property {0} on non-object type {1}.");
    public static final DiagnosticType INEXISTENT_PROPERTY = DiagnosticType.warning("JSC_NTI_INEXISTENT_PROPERTY", "Property {0} never defined on {1}");
    static final DiagnosticType NOT_CALLABLE = DiagnosticType.warning("JSC_NTI_NOT_FUNCTION_TYPE", "Cannot call non-function type {0}");
    static final DiagnosticType WRONG_ARGUMENT_COUNT = DiagnosticType.warning("JSC_NTI_WRONG_ARGUMENT_COUNT", "Function {0}: called with {1} argument(s). Function requires at least {2} argument(s){3}.");
    static final DiagnosticType ILLEGAL_PROPERTY_ACCESS = DiagnosticType.warning("JSC_NTI_ILLEGAL_PROPERTY_ACCESS", "Cannot do {0} access on a {1}");
    static final DiagnosticType UNKNOWN_TYPEOF_VALUE = DiagnosticType.warning("JSC_NTI_UNKNOWN_TYPEOF_VALUE", "unknown type: {0}");
    static final DiagnosticType UNKNOWN_NAMESPACE_PROPERTY = DiagnosticType.warning("JSC_NTI_UNKNOWN_NAMESPACE_PROPERTY", "Cannot determine the type of namespace property {0}. Maybe a prefix of the property name has been redefined?");
    static final DiagnosticType INCOMPATIBLE_STRICT_COMPARISON = DiagnosticType.warning("JSC_INCOMPATIBLE_STRICT_COMPARISON", "Cannot perform strict equality / inequality comparisons on incompatible types:\nleft : {0}\nright: {1}");
    static final DiagnosticType ABSTRACT_SUPER_METHOD_NOT_CALLABLE = DiagnosticType.warning("JSC_NTI_ABSTRACT_SUPER_METHOD_NOT_CALLABLE", "Abstract super method {0} cannot be called");
    static final DiagnosticType REFLECT_CONSTRUCTOR_EXPECTED = DiagnosticType.warning("JSC_NTI_REFLECT_CONSTRUCTOR_EXPECTED", "Constructor expected as first argument");
    static final DiagnosticType NULLABLE_DEREFERENCE = DiagnosticType.disabled("JSC_NTI_NULLABLE_DEREFERENCE", "Attempt to use nullable type {0}.");
    static final DiagnosticType UNKNOWN_EXPR_TYPE = DiagnosticType.disabled("JSC_NTI_UNKNOWN_EXPR_TYPE", "This {0} expression has the unknown type.");
    static final DiagnosticType YIELD_NONDECLARED_TYPE = DiagnosticType.warning("JSC_NTI_YIELD_NONDECLARED_TYPE", "Yielded type does not match declared return type.\n{0}");
    static final DiagnosticType YIELD_ALL_EXPECTS_ITERABLE = DiagnosticType.warning("JSC_NTI_YIELD_ALL_EXPECTS_ITERABLE", "Expression yield* expects an iterable, found type {0}.");
    static final DiagnosticType CANNOT_USE_UNRESOLVED_TYPE = DiagnosticType.warning("JSC_CANNOT_USE_UNRESOLVED_TYPE", "Cannot use unresolved type {0}. Please include the type definition in your application.");
    static final DiagnosticGroup COMPATIBLE_DIAGNOSTICS = new DiagnosticGroup(ABSTRACT_SUPER_METHOD_NOT_CALLABLE, CANNOT_BIND_CTOR, CANNOT_INSTANTIATE_ABSTRACT_CLASS, CONST_PROPERTY_DELETED, CONST_PROPERTY_REASSIGNED, CONST_REASSIGNED, REFLECT_CONSTRUCTOR_EXPECTED, CONSTRUCTOR_NOT_CALLABLE, FORIN_EXPECTS_STRING_KEY, FOROF_EXPECTS_ITERABLE, MISTYPED_FOROF_ELEMENT_TYPE, GLOBAL_THIS, GOOG_BIND_EXPECTS_FUNCTION, ILLEGAL_OBJLIT_KEY, ILLEGAL_PROPERTY_ACCESS, ILLEGAL_PROPERTY_CREATION, IN_USED_WITH_STRUCT, INEXISTENT_PROPERTY, INVALID_ARGUMENT_TYPE, TEMPLATE_ARGUMENT_MISMATCH, TEMPLATE_ARGUMENT_MISSING, INVALID_CAST, INVALID_INDEX_TYPE, INVALID_OBJLIT_PROPERTY_TYPE, MISSING_RETURN_STATEMENT, MISTYPED_ASSIGN_RHS, NOT_A_CONSTRUCTOR, NOT_CALLABLE, POSSIBLY_INEXISTENT_PROPERTY, RETURN_NONDECLARED_TYPE, UNKNOWN_ASSERTION_TYPE, UNKNOWN_TYPEOF_VALUE, WRONG_ARGUMENT_COUNT, YIELD_ALL_EXPECTS_ITERABLE, INVALID_DECLARED_RETURN_TYPE_OF_GENERATOR_FUNCTION);
    static final DiagnosticGroup NEW_DIAGNOSTICS = new DiagnosticGroup(ADDING_PROPERTY_TO_NON_OBJECT, ASSERT_FALSE, BOTTOM_INDEX_TYPE, BOTTOM_PROP, CANNOT_USE_UNRESOLVED_TYPE, CROSS_SCOPE_GOTCHA, FORIN_EXPECTS_OBJECT, INCOMPATIBLE_STRICT_COMPARISON, INVALID_INFERRED_RETURN_TYPE, INVALID_OPERAND_TYPE, INVALID_THIS_TYPE_IN_BIND, NOT_UNIQUE_INSTANTIATION, PROPERTY_ACCESS_ON_NONOBJECT, UNKNOWN_NAMESPACE_PROPERTY, YIELD_NONDECLARED_TYPE);
    private final WarningReporter warnings;
    private List<TypeMismatch> mismatches;
    private List<TypeMismatch> implicitInterfaceUses;
    private final AbstractCompiler compiler;
    private final CodingConvention convention;
    private TypeTransformation ttlObj;
    private final Map<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>, TypeEnv> envs;
    private final Map<NTIScope, JSType> summaries;
    private final Map<Node, DeferredCheck> deferredChecks;
    private ControlFlowGraph<Node> cfg;
    private NTIScope currentScope;
    private TypeEnv typeEnvFromDeclaredTypes = null;
    private List<TypeEnv> exitEnvs = null;
    private GlobalTypeInfo symbolTable;
    private JSTypes commonTypes;
    private static final String RETVAL_ID = "%return";
    private static final String YIELDVAL_ID = "%yield";
    private static final String THIS_ID = "this";
    private final String ABSTRACT_METHOD_NAME;
    private final Map<String, CodingConvention.AssertionFunctionSpec> assertionFunctionsMap;
    private final boolean reportUnknownTypes;
    private final boolean reportNullDeref;
    private final boolean joinTypesWhenInstantiatingGenerics;
    private final boolean allowPropertyOnSubtypes;
    private final boolean areTypeVariablesUnknown;
    private static final boolean showDebuggingPrints = false;
    static boolean measureMem = false;
    private static long peakMem = 0L;
    private JSType BOOLEAN;
    private JSType BOTTOM;
    private JSType FALSE_TYPE;
    private JSType FALSY;
    private JSType NULL;
    private JSType NULL_OR_UNDEFINED;
    private JSType NUMBER;
    private JSType NUMBER_OR_STRING;
    private JSType STRING;
    private JSType TOP_OBJECT;
    private JSType TRUE_TYPE;
    private JSType TRUTHY;
    private JSType UNDEFINED;
    private JSType UNKNOWN;

    NewTypeInference(AbstractCompiler compiler) {
        boolean inCompatibilityMode;
        this.warnings = new WarningReporter(compiler);
        this.compiler = compiler;
        this.convention = compiler.getCodingConvention();
        this.envs = new LinkedHashMap<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>, TypeEnv>();
        this.summaries = new LinkedHashMap<NTIScope, JSType>();
        this.deferredChecks = new LinkedHashMap<Node, DeferredCheck>();
        this.ABSTRACT_METHOD_NAME = this.convention.getAbstractMethodName();
        this.reportUnknownTypes = compiler.getOptions().enables(DiagnosticGroups.REPORT_UNKNOWN_TYPES);
        this.reportNullDeref = compiler.getOptions().enables(DiagnosticGroups.NEW_CHECK_TYPES_ALL_CHECKS);
        this.assertionFunctionsMap = new LinkedHashMap<String, CodingConvention.AssertionFunctionSpec>();
        for (CodingConvention.AssertionFunctionSpec assertionFunction : this.convention.getAssertionFunctions()) {
            this.assertionFunctionsMap.put(assertionFunction.getFunctionName(), assertionFunction);
        }
        this.joinTypesWhenInstantiatingGenerics = inCompatibilityMode = compiler.getOptions().disables(DiagnosticGroups.NEW_CHECK_TYPES_EXTRA_CHECKS);
        this.allowPropertyOnSubtypes = inCompatibilityMode;
        this.areTypeVariablesUnknown = inCompatibilityMode;
    }

    @VisibleForTesting
    public NTIScope processForTesting(Node externs, Node root) {
        this.process(externs, root);
        return this.symbolTable.getGlobalScope();
    }

    @Override
    public void process(Node externs, Node root) {
        try {
            this.symbolTable = (GlobalTypeInfo)this.compiler.getGlobalTypeInfo();
            this.commonTypes = this.symbolTable.getCommonTypes();
            this.ttlObj = new TypeTransformation(this.compiler, this.symbolTable.getGlobalScope());
            this.mismatches = this.symbolTable.getMismatches();
            this.implicitInterfaceUses = this.symbolTable.getImplicitInterfaceUses();
            this.BOOLEAN = this.commonTypes.BOOLEAN;
            this.BOTTOM = this.commonTypes.BOTTOM;
            this.FALSE_TYPE = this.commonTypes.FALSE_TYPE;
            this.FALSY = this.commonTypes.FALSY;
            this.NULL = this.commonTypes.NULL;
            this.NULL_OR_UNDEFINED = this.commonTypes.NULL_OR_UNDEFINED;
            this.NUMBER = this.commonTypes.NUMBER;
            this.NUMBER_OR_STRING = this.commonTypes.NUMBER_OR_STRING;
            this.STRING = this.commonTypes.STRING;
            this.TOP_OBJECT = this.commonTypes.getTopObject();
            this.TRUE_TYPE = this.commonTypes.TRUE_TYPE;
            this.TRUTHY = this.commonTypes.TRUTHY;
            this.UNDEFINED = this.commonTypes.UNDEFINED;
            this.UNKNOWN = this.commonTypes.UNKNOWN;
            for (NTIScope scope : this.symbolTable.getScopes()) {
                this.analyzeFunction(scope);
                this.envs.clear();
            }
            for (DeferredCheck check : this.deferredChecks.values()) {
                check.runCheck(this.summaries, this.warnings);
            }
            if (measureMem) {
                System.out.println("Peak mem: " + peakMem + "MB");
            }
        }
        catch (Exception unexpectedException) {
            String message = unexpectedException.getMessage();
            if (this.currentScope != null) {
                message = message + "\nIn scope: " + this.currentScope;
            }
            this.compiler.throwInternalError(message, unexpectedException);
        }
    }

    static void updatePeakMem() {
        Runtime rt = Runtime.getRuntime();
        long currentUsedMem = (rt.totalMemory() - rt.freeMemory()) / 0x100000L;
        if (currentUsedMem > peakMem) {
            peakMem = currentUsedMem;
        }
    }

    private static void println(Object ... objs) {
    }

    private void registerMismatchAndWarn(JSError error, JSType found, JSType required) {
        TypeMismatch.registerMismatch(this.mismatches, this.implicitInterfaceUses, found, required, error);
        this.warnings.add(error);
    }

    private void registerImplicitUses(Node src, JSType from, JSType to) {
        TypeMismatch.recordImplicitInterfaceUses(this.implicitInterfaceUses, src, from, to);
        if (!src.isCast()) {
            TypeMismatch.recordImplicitUseOfNativeObject(this.mismatches, src, from, to);
        }
    }

    private TypeEnv getInEnv(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn) {
        List<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>> inEdges = dn.getInEdges();
        if (inEdges.isEmpty()) {
            return this.getEntryTypeEnv();
        }
        if (inEdges.size() == 1) {
            return this.envs.get(inEdges.get(0));
        }
        LinkedHashSet<TypeEnv> envSet = new LinkedHashSet<TypeEnv>();
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> de : inEdges) {
            TypeEnv env = this.envs.get(de);
            if (env == null) continue;
            envSet.add(env);
        }
        if (envSet.isEmpty()) {
            return null;
        }
        return TypeEnv.join(envSet);
    }

    private TypeEnv getOutEnv(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn) {
        List<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>> outEdges = dn.getOutEdges();
        if (outEdges.isEmpty()) {
            Preconditions.checkArgument((boolean)((Node)dn.getValue()).isThrow());
            return this.typeEnvFromDeclaredTypes;
        }
        if (outEdges.size() == 1) {
            return this.envs.get(outEdges.get(0));
        }
        LinkedHashSet<TypeEnv> envSet = new LinkedHashSet<TypeEnv>();
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> de : outEdges) {
            TypeEnv env = this.envs.get(de);
            if (env == null) continue;
            envSet.add(env);
        }
        Preconditions.checkState((!envSet.isEmpty() ? 1 : 0) != 0);
        return TypeEnv.join(envSet);
    }

    private TypeEnv setOutEnv(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn, TypeEnv e) {
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> de : dn.getOutEdges()) {
            this.envs.put(de, e);
        }
        return e;
    }

    private void initEdgeEnvsFwd(TypeEnv entryEnv) {
        this.envs.clear();
        LinkedHashSet<String> nonLocals = new LinkedHashSet<String>();
        if (this.currentScope.hasThis()) {
            nonLocals.add(THIS_ID);
        }
        if (this.currentScope.isFunction()) {
            if (this.currentScope.getName() != null) {
                nonLocals.add(this.currentScope.getName());
            }
            nonLocals.addAll(this.currentScope.getOuterVars());
            nonLocals.addAll(this.currentScope.getFormals());
            entryEnv = NewTypeInference.envPutType(entryEnv, RETVAL_ID, this.UNDEFINED);
        } else {
            nonLocals.addAll((Collection<String>)this.currentScope.getExterns());
        }
        for (String name : nonLocals) {
            JSType declType = this.currentScope.getDeclaredTypeOf(name);
            JSType initType = declType;
            if (initType == null) {
                initType = NewTypeInference.envGetType(entryEnv, name);
            } else if (this.areTypeVariablesUnknown) {
                initType = initType.substituteGenericsWithUnknown();
            }
            NewTypeInference.println("Adding non-local ", name, " with decltype: ", declType, " and inittype: ", initType);
            entryEnv = NewTypeInference.envPutType(entryEnv, name, initType);
        }
        for (String local : this.currentScope.getLocals()) {
            if (this.currentScope.isFunctionNamespace(local)) continue;
            entryEnv = NewTypeInference.envPutType(entryEnv, local, this.UNDEFINED);
        }
        for (String fnName : this.currentScope.getLocalFunDefs()) {
            entryEnv = NewTypeInference.envPutType(entryEnv, fnName, this.getSummaryOfLocalFunDef(fnName));
        }
        NewTypeInference.println("Keeping env: ", entryEnv);
        this.setOutEnv(this.cfg.getEntry(), entryEnv);
    }

    private TypeEnv getTypeEnvFromDeclaredTypes() {
        TypeEnv env = new TypeEnv();
        Set<String> varNames = this.currentScope.getOuterVars();
        ImmutableSet<String> locals = this.currentScope.getLocals();
        varNames.addAll((Collection<String>)locals);
        varNames.addAll((Collection<String>)this.currentScope.getExterns());
        if (this.currentScope.hasThis()) {
            varNames.add(THIS_ID);
        }
        if (this.currentScope.isFunction()) {
            Node fn = this.currentScope.getRoot();
            if (!this.currentScope.hasThis() && NodeUtil.containsType(fn.getLastChild(), Token.SUPER, NodeUtil.MATCH_NOT_FUNCTION)) {
                Node funNameNode = NodeUtil.getBestLValue(fn);
                Node qnameRoot = NodeUtil.getRootOfQualifiedName(funNameNode);
                Preconditions.checkState((boolean)qnameRoot.isName());
                varNames.add(qnameRoot.getString());
            }
            if (this.currentScope.getName() != null) {
                varNames.add(this.currentScope.getName());
            }
            varNames.addAll(this.currentScope.getFormals());
            DeclaredFunctionType dft = this.currentScope.getDeclaredTypeForOwnBody();
            JSType argumentsType = dft.getOptionalArity() == 0 && dft.hasRestFormals() ? dft.getRestFormalsType() : this.UNKNOWN;
            env = NewTypeInference.envPutType(env, "arguments", this.commonTypes.getArgumentsArrayType(argumentsType));
        }
        for (String varName : varNames) {
            if (this.currentScope.isLocalFunDef(varName)) continue;
            JSType declType = this.currentScope.getDeclaredTypeOf(varName);
            if (declType == null) {
                declType = this.UNKNOWN;
            } else if (this.areTypeVariablesUnknown) {
                declType = declType.substituteGenericsWithUnknown();
            }
            env = NewTypeInference.envPutType(env, varName, declType);
        }
        for (String fnName : this.currentScope.getLocalFunDefs()) {
            env = NewTypeInference.envPutType(env, fnName, this.getSummaryOfLocalFunDef(fnName));
        }
        return env;
    }

    private JSType getSummaryOfLocalFunDef(String name) {
        NTIScope fnScope = this.currentScope.getScope(name);
        JSType fnType = this.summaries.get(fnScope);
        if (fnType != null) {
            return fnType;
        }
        fnType = this.currentScope.getDeclaredTypeOf(name);
        if (fnType.getFunType() == null) {
            Preconditions.checkState((boolean)fnType.isUnknown());
            return this.commonTypes.qmarkFunction();
        }
        return this.changeTypeIfFunctionNamespace(fnScope, fnType);
    }

    private void analyzeFunction(NTIScope scope) {
        NewTypeInference.println("=== Analyzing function: ", scope.getReadableName(), " ===");
        this.currentScope = scope;
        this.exitEnvs = new ArrayList<TypeEnv>();
        Node scopeRoot = scope.getRoot();
        if (NodeUtil.isUnannotatedCallback(scopeRoot)) {
            this.computeFnDeclaredTypeForCallback(scope);
        }
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, false);
        cfa.process(null, scopeRoot);
        this.cfg = cfa.getCfg();
        NewTypeInference.println(this.cfg);
        NTIWorkset workset = NTIWorkset.create(this.cfg);
        this.typeEnvFromDeclaredTypes = this.getTypeEnvFromDeclaredTypes();
        if (scope.isFunction() && scope.hasUndeclaredFormalsOrOuters()) {
            for (DiGraph.DiGraphEdge e : this.cfg.getEdges()) {
                this.envs.put(e, this.typeEnvFromDeclaredTypes);
            }
            this.analyzeFunctionBwd(workset);
            TypeEnv entryEnv = this.getEntryTypeEnv();
            for (String varName : scope.getOuterVars()) {
                JSType inferred = scope.getInferredTypeOf(varName);
                if (inferred == null) continue;
                entryEnv = NewTypeInference.envPutType(entryEnv, varName, inferred);
            }
            this.initEdgeEnvsFwd(entryEnv);
            if (measureMem) {
                NewTypeInference.updatePeakMem();
            }
        } else {
            TypeEnv entryEnv = this.typeEnvFromDeclaredTypes;
            this.initEdgeEnvsFwd(entryEnv);
        }
        this.typeEnvFromDeclaredTypes = null;
        this.analyzeFunctionFwd(workset);
        if (scope.isFunction()) {
            this.createSummary(scope);
        }
        if (measureMem) {
            NewTypeInference.updatePeakMem();
        }
    }

    private void analyzeFunctionBwd(NTIWorkset workset) {
        for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn : workset.backward()) {
            TypeEnv inEnv;
            Node n = (Node)dn.getValue();
            TypeEnv outEnv = (TypeEnv)Preconditions.checkNotNull((Object)this.getOutEnv(dn));
            NewTypeInference.println("\tBWD Statment: ", n);
            NewTypeInference.println("\t\toutEnv: ", outEnv);
            switch (n.getToken()) {
                case EXPR_RESULT: {
                    inEnv = this.analyzeExprBwd((Node)n.getFirstChild(), (TypeEnv)outEnv, (JSType)this.UNKNOWN).env;
                    break;
                }
                case RETURN: {
                    Node retExp = n.getFirstChild();
                    if (retExp == null) {
                        inEnv = outEnv;
                        break;
                    }
                    JSType declRetType = this.currentScope.getDeclaredTypeForOwnBody().getReturnType();
                    declRetType = (JSType)MoreObjects.firstNonNull((Object)declRetType, (Object)this.UNKNOWN);
                    inEnv = this.analyzeExprBwd((Node)retExp, (TypeEnv)outEnv, (JSType)declRetType).env;
                    break;
                }
                case VAR: {
                    if (NodeUtil.isTypedefDecl(n)) {
                        inEnv = outEnv;
                        break;
                    }
                    inEnv = outEnv;
                    for (Node nameNode = n.getFirstChild(); nameNode != null; nameNode = nameNode.getNext()) {
                        JSType requiredType;
                        String varName = nameNode.getString();
                        Node rhs = nameNode.getFirstChild();
                        JSType declType = this.currentScope.getDeclaredTypeOf(varName);
                        inEnv = NewTypeInference.envPutType(inEnv, varName, this.UNKNOWN);
                        if (rhs == null || this.currentScope.isLocalFunDef(varName)) continue;
                        JSType inferredType = NewTypeInference.envGetType(outEnv, varName);
                        if (declType == null) {
                            requiredType = inferredType;
                        } else {
                            requiredType = JSType.meet(declType, inferredType);
                            requiredType = NewTypeInference.firstNonBottom(requiredType, this.UNKNOWN);
                        }
                        inEnv = this.analyzeExprBwd((Node)rhs, (TypeEnv)inEnv, (JSType)requiredType).env;
                    }
                    break;
                }
                case BLOCK: 
                case ROOT: 
                case BREAK: 
                case CATCH: 
                case CONTINUE: 
                case DEFAULT_CASE: 
                case DEBUGGER: 
                case EMPTY: 
                case SCRIPT: 
                case TRY: 
                case WITH: {
                    inEnv = outEnv;
                    break;
                }
                case DO: 
                case FOR: 
                case FOR_IN: 
                case FOR_OF: 
                case IF: 
                case WHILE: {
                    Node expr = n.isForIn() || n.isForOf() ? n.getFirstChild() : NodeUtil.getConditionExpression(n);
                    inEnv = this.analyzeExprBwd((Node)expr, (TypeEnv)outEnv).env;
                    break;
                }
                case THROW: 
                case CASE: 
                case SWITCH: {
                    inEnv = this.analyzeExprBwd((Node)n.getFirstChild(), (TypeEnv)outEnv).env;
                    break;
                }
                default: {
                    if (NodeUtil.isStatement(n)) {
                        throw new RuntimeException("Unhandled statement type: " + (Object)((Object)n.getToken()));
                    }
                    inEnv = this.analyzeExprBwd((Node)n, (TypeEnv)outEnv).env;
                }
            }
            NewTypeInference.println("\t\tinEnv: ", inEnv);
            for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> de : dn.getInEdges()) {
                this.envs.put(de, inEnv);
            }
        }
    }

    private void analyzeFunctionFwd(NTIWorkset workset) {
        for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn : workset.forward()) {
            Node n = (Node)dn.getValue();
            Node parent = n.getParent();
            Preconditions.checkState((n != null ? 1 : 0) != 0, (Object)"Implicit return should not be in workset.");
            TypeEnv inEnv = this.getInEnv(dn);
            TypeEnv outEnv = null;
            if (parent.isScript() || parent.isNormalBlock() && parent.getParent().isFunction()) {
                inEnv = inEnv.clearChangeLog();
            }
            NewTypeInference.println("\tFWD Statment: ", n);
            NewTypeInference.println("\t\tinEnv: ", inEnv);
            boolean conditional = false;
            switch (n.getToken()) {
                case BLOCK: 
                case ROOT: 
                case BREAK: 
                case CONTINUE: 
                case DEFAULT_CASE: 
                case DEBUGGER: 
                case EMPTY: 
                case SCRIPT: 
                case TRY: 
                case WITH: 
                case FUNCTION: {
                    outEnv = inEnv;
                    break;
                }
                case CATCH: {
                    Node catchVar = n.getFirstChild();
                    String catchVarname = catchVar.getString();
                    outEnv = NewTypeInference.envPutType(inEnv, catchVarname, this.UNKNOWN);
                    this.maybeSetTypeI(catchVar, this.UNKNOWN);
                    break;
                }
                case EXPR_RESULT: {
                    NewTypeInference.println(new Object[]{"\tsemi ", n.getFirstChild().getToken()});
                    if (n.getBooleanProp((byte)76)) {
                        n.removeProp((byte)76);
                        outEnv = inEnv;
                        break;
                    }
                    outEnv = this.analyzeExprFwd((Node)n.getFirstChild(), (TypeEnv)inEnv, (JSType)this.UNKNOWN).env;
                    break;
                }
                case RETURN: {
                    outEnv = this.analyzeReturnFwd(n, inEnv);
                    break;
                }
                case DO: 
                case FOR: 
                case IF: 
                case WHILE: {
                    conditional = true;
                    this.analyzeConditionalStmFwd(dn, NodeUtil.getConditionExpression(n), inEnv);
                    break;
                }
                case FOR_IN: {
                    outEnv = this.analyzeForInFwd(n, inEnv);
                    break;
                }
                case FOR_OF: {
                    outEnv = this.analyzeForOfFwd(n, inEnv);
                    break;
                }
                case CASE: {
                    conditional = true;
                    this.analyzeConditionalStmFwd(dn, n, inEnv);
                    break;
                }
                case VAR: {
                    outEnv = inEnv;
                    if (NodeUtil.isTypedefDecl(n)) {
                        this.maybeSetTypeI(n.getFirstChild(), this.UNDEFINED);
                        break;
                    }
                    for (Node nameNode : n.children()) {
                        outEnv = this.analyzeVarDeclFwd(nameNode, outEnv);
                    }
                    break;
                }
                case SWITCH: {
                    outEnv = this.analyzeExprFwd((Node)n.getFirstChild(), (TypeEnv)inEnv).env;
                    break;
                }
                case THROW: {
                    outEnv = this.analyzeExprFwd((Node)n.getFirstChild(), (TypeEnv)inEnv).env;
                    this.exitEnvs.add(outEnv);
                    break;
                }
                default: {
                    if (NodeUtil.isStatement(n)) {
                        throw new RuntimeException("Unhandled statement type: " + (Object)((Object)n.getToken()));
                    }
                    outEnv = this.analyzeExprFwd((Node)n, (TypeEnv)inEnv, (JSType)this.UNKNOWN).env;
                }
            }
            if (conditional) continue;
            NewTypeInference.println("\t\toutEnv: ", outEnv);
            this.setOutEnv(dn, outEnv);
        }
    }

    private void analyzeConditionalStmFwd(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> stm, Node cond, TypeEnv inEnv) {
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> outEdge : stm.getOutEdges()) {
            JSType specializedType;
            switch ((ControlFlowGraph.Branch)((Object)outEdge.getValue())) {
                case ON_TRUE: {
                    specializedType = this.TRUTHY;
                    break;
                }
                case ON_FALSE: {
                    specializedType = this.FALSY;
                    break;
                }
                case ON_EX: {
                    specializedType = this.UNKNOWN;
                    break;
                }
                default: {
                    throw new RuntimeException("Condition with an unexpected edge type: " + outEdge.getValue());
                }
            }
            this.envs.put(outEdge, this.analyzeExprFwd((Node)cond, (TypeEnv)inEnv, (JSType)this.UNKNOWN, (JSType)specializedType).env);
        }
    }

    private TypeEnv analyzeReturnFwd(Node n, TypeEnv inEnv) {
        TypeEnv outEnv;
        JSType actualRetType;
        if (this.currentScope.getRoot().isGeneratorFunction()) {
            JSType declRetType = this.getDeclaredReturnTypeOfCurrentScope(this.commonTypes.getGeneratorInstance(this.UNKNOWN));
            if (n.hasChildren()) {
                EnvTypePair retPair = this.analyzeExprFwd(n.getFirstChild(), inEnv, this.UNKNOWN);
                return NewTypeInference.envPutType(retPair.env, RETVAL_ID, declRetType);
            }
            return NewTypeInference.envPutType(inEnv, RETVAL_ID, declRetType);
        }
        JSType declRetType = this.getDeclaredReturnTypeOfCurrentScope(this.UNKNOWN);
        Node retExp = n.getFirstChild();
        if (retExp == null) {
            actualRetType = this.UNDEFINED;
            outEnv = NewTypeInference.envPutType(inEnv, RETVAL_ID, actualRetType);
        } else {
            EnvTypePair retPair = this.analyzeExprFwd(retExp, inEnv, declRetType);
            actualRetType = retPair.type;
            outEnv = NewTypeInference.envPutType(retPair.env, RETVAL_ID, actualRetType);
        }
        if (!actualRetType.isSubtypeOf(declRetType)) {
            this.registerMismatchAndWarn(JSError.make(n, RETURN_NONDECLARED_TYPE, NewTypeInference.errorMsgWithTypeDiff(declRetType, actualRetType)), actualRetType, declRetType);
        }
        return outEnv;
    }

    private TypeEnv analyzeForInFwd(Node n, TypeEnv inEnv) {
        TypeEnv outEnv;
        Node obj = n.getSecondChild();
        EnvTypePair pair = this.analyzeExprFwd(obj, inEnv, this.pickReqObjType(n));
        pair = this.mayWarnAboutNullableReferenceAndTighten(n, pair.type, null, inEnv);
        JSType objType = pair.type;
        if (!objType.isSubtypeOf(this.TOP_OBJECT)) {
            this.warnings.add(JSError.make(obj, FORIN_EXPECTS_OBJECT, objType.toString()));
        } else if (objType.isStruct()) {
            this.warnings.add(JSError.make(obj, IN_USED_WITH_STRUCT, new String[0]));
        }
        Node lhs = n.getFirstChild();
        LValueResultFwd lval = this.analyzeLValueFwd(lhs, inEnv, this.STRING);
        if (lval.declType != null && !this.commonTypes.isStringScalarOrObj(lval.declType)) {
            this.warnings.add(JSError.make(lhs, FORIN_EXPECTS_STRING_KEY, lval.declType.toString()));
            outEnv = lval.env;
        } else {
            outEnv = this.updateLvalueTypeInEnv(lval.env, lhs, lval.ptr, this.STRING);
        }
        return outEnv;
    }

    private TypeEnv analyzeForOfFwd(Node n, TypeEnv inEnv) {
        TypeEnv outEnv;
        JSType lhsExpectedType;
        JSType iterable;
        Node rhs = n.getSecondChild();
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, inEnv, this.pickReqObjType(n));
        rhsPair = this.mayWarnAboutNullableReferenceAndTighten(n, rhsPair.type, null, inEnv);
        JSType rhsObjType = rhsPair.type;
        JSType boxedType = rhsObjType.autobox();
        if (boxedType.isSubtypeOf(iterable = this.commonTypes.getIterableInstance(this.UNKNOWN))) {
            lhsExpectedType = boxedType.getInstantiatedTypeArgument(iterable);
        } else {
            this.warnings.add(JSError.make(rhs, FOROF_EXPECTS_ITERABLE, rhsObjType.toString()));
            lhsExpectedType = this.UNKNOWN;
        }
        Node lhsNode = n.getFirstChild();
        LValueResultFwd lhsLval = this.analyzeLValueFwd(lhsNode, inEnv, lhsExpectedType);
        if (lhsLval.declType == null || lhsExpectedType.isSubtypeOf(lhsLval.declType)) {
            outEnv = this.updateLvalueTypeInEnv(lhsLval.env, lhsNode, lhsLval.ptr, lhsExpectedType);
        } else {
            this.registerMismatchAndWarn(JSError.make(n, MISTYPED_FOROF_ELEMENT_TYPE, NewTypeInference.errorMsgWithTypeDiff(lhsLval.declType, lhsExpectedType)), lhsExpectedType, lhsLval.declType);
            outEnv = this.updateLvalueTypeInEnv(lhsLval.env, lhsNode, lhsLval.ptr, lhsLval.declType);
        }
        return outEnv;
    }

    private void createSummary(NTIScope fn) {
        String formalName2;
        Object formalType;
        int i;
        Node fnRoot = fn.getRoot();
        Preconditions.checkArgument((!fnRoot.isFromExterns() ? 1 : 0) != 0);
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        TypeEnv entryEnv = this.getEntryTypeEnv();
        TypeEnv exitEnv = this.getExitTypeEnv();
        DeclaredFunctionType declType = fn.getDeclaredFunctionType();
        int reqArity = declType.getRequiredArity();
        int optArity = declType.getOptionalArity();
        if (declType.isGeneric()) {
            builder.addTypeParameters(declType.getTypeParameters());
        }
        List<String> formals = fn.getFormals();
        for (i = reqArity - 1; i >= 0 && (formalType = declType.getFormalType(i)) == null && (((JSType)(formalType = this.getTypeAfterFwd(formalName2 = formals.get(i), entryEnv, exitEnv))).isUnknown() || this.UNDEFINED.isSubtypeOf((TypeI)formalType)); --i) {
            --reqArity;
        }
        i = 0;
        for (String formalName2 : formals) {
            JSType formalType2 = declType.getFormalType(i);
            if (formalType2 == null) {
                formalType2 = this.getTypeAfterFwd(formalName2, entryEnv, exitEnv);
            }
            if (i < reqArity) {
                builder.addReqFormal(formalType2);
            } else if (i < optArity) {
                builder.addOptFormal(formalType2);
            }
            ++i;
        }
        if (declType.hasRestFormals()) {
            builder.addRestFormals(declType.getFormalType(i));
        }
        for (String outer : fn.getOuterVars()) {
            NewTypeInference.println("Free var ", outer, " going in summary");
            builder.addOuterVarPrecondition(outer, NewTypeInference.envGetType(entryEnv, outer));
        }
        builder.addNominalType(declType.getNominalType());
        builder.addReceiverType(declType.getReceiverType());
        builder.addAbstract(declType.isAbstract());
        this.addRetTypeAndWarn(fn, exitEnv, declType, builder);
        JSType summary = this.commonTypes.fromFunctionType(builder.buildFunction());
        NewTypeInference.println("Function summary for ", fn.getReadableName());
        NewTypeInference.println("\t", summary);
        summary = this.changeTypeIfFunctionNamespace(fn, summary);
        this.summaries.put(fn, summary);
        this.maybeSetTypeI(fnRoot, summary);
        Node fnNameNode = NodeUtil.getNameNode(fnRoot);
        if (fnNameNode != null) {
            this.maybeSetTypeI(fnNameNode, summary);
        }
    }

    private void addRetTypeAndWarn(NTIScope fn, TypeEnv exitEnv, DeclaredFunctionType declType, FunctionTypeBuilder builder) {
        Node fnRoot = fn.getRoot();
        JSType declRetType = declType.getReturnType();
        JSType actualRetType = (JSType)Preconditions.checkNotNull((Object)NewTypeInference.envGetType(exitEnv, RETVAL_ID));
        if (declRetType != null) {
            if (fnRoot.isGeneratorFunction()) {
                JSType generator = this.commonTypes.getGeneratorInstance(this.UNKNOWN);
                if (!generator.isSubtypeOf(declRetType)) {
                    this.registerMismatchAndWarn(JSError.make(fnRoot, INVALID_DECLARED_RETURN_TYPE_OF_GENERATOR_FUNCTION, NewTypeInference.errorMsgWithTypeDiff(generator, declRetType)), declRetType, generator);
                    builder.addRetType(this.UNKNOWN);
                } else {
                    builder.addRetType(declRetType);
                }
            } else {
                builder.addRetType(declRetType);
                if (!NewTypeInference.isAllowedToNotReturn(fn) && !this.UNDEFINED.isSubtypeOf(declRetType) && NewTypeInference.hasPathWithNoReturn(this.cfg)) {
                    this.warnings.add(JSError.make(fnRoot, MISSING_RETURN_STATEMENT, declRetType.toString()));
                }
            }
        } else if (fnRoot.isGeneratorFunction()) {
            JSType yieldType = NewTypeInference.envGetType(exitEnv, YIELDVAL_ID);
            builder.addRetType(this.commonTypes.getGeneratorInstance((JSType)MoreObjects.firstNonNull((Object)yieldType, (Object)this.UNKNOWN)));
        } else if (declType.getNominalType() == null) {
            builder.addRetType(NewTypeInference.firstNonBottom(actualRetType, this.UNKNOWN));
        } else {
            builder.addRetType(this.UNDEFINED);
        }
    }

    private JSType changeTypeIfFunctionNamespace(NTIScope fnScope, JSType fnType) {
        QualifiedName qname;
        JSType rootNs;
        NTIScope enclosingScope = fnScope.getParent();
        Node fnNameNode = NodeUtil.getNameNode(fnScope.getRoot());
        JSType namespaceType = null;
        if (fnNameNode == null) {
            return fnType;
        }
        if (fnNameNode.isName()) {
            String fnName = fnNameNode.getString();
            if (enclosingScope.isFunctionNamespace(fnName)) {
                namespaceType = enclosingScope.getDeclaredTypeOf(fnName);
            }
        } else if (fnNameNode.isQualifiedName() && (rootNs = enclosingScope.getDeclaredTypeOf((qname = QualifiedName.fromNode(fnNameNode)).getLeftmostName())) != null && rootNs.isSubtypeOf(this.TOP_OBJECT)) {
            namespaceType = rootNs.getProp(qname.getAllButLeftmost());
        }
        if (namespaceType != null && namespaceType.isNamespace()) {
            return namespaceType.withFunction(fnType.getFunTypeIfSingletonObj(), this.commonTypes.getFunctionType());
        }
        return fnType;
    }

    private JSType getTypeAfterFwd(String varName, TypeEnv entryEnv, TypeEnv exitEnv) {
        JSType typeAfterFwd;
        JSType typeAfterBwd = NewTypeInference.envGetType(entryEnv, varName);
        if (!(typeAfterBwd.hasNonScalar() && typeAfterBwd.getFunType() == null || (typeAfterFwd = NewTypeInference.envGetType(exitEnv, varName)) == null)) {
            return typeAfterFwd;
        }
        return typeAfterBwd;
    }

    private static boolean isAllowedToNotReturn(NTIScope methodScope) {
        QualifiedName ntQname;
        JSType rootNamespace;
        Node fn = methodScope.getRoot();
        if (fn.isFromExterns()) {
            return true;
        }
        DeclaredFunctionType declFn = methodScope.getDeclaredFunctionType();
        if (declFn != null && declFn.isAbstract() && declFn.getReceiverType() != null) {
            return true;
        }
        if (!NodeUtil.isPrototypeMethod(fn)) {
            return false;
        }
        Node ntQnameNode = NodeUtil.getPrototypeClassName(fn.getParent().getFirstChild());
        JSType maybeInterface = ntQnameNode.isName() ? methodScope.getDeclaredTypeOf(ntQnameNode.getString()) : ((rootNamespace = methodScope.getDeclaredTypeOf((ntQname = QualifiedName.fromNode(ntQnameNode)).getLeftmostName())) == null ? null : rootNamespace.getProp(ntQname.getAllButLeftmost()));
        return maybeInterface != null && maybeInterface.isInterfaceDefinition();
    }

    private static boolean hasPathWithNoReturn(ControlFlowGraph<Node> cfg) {
        for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn : cfg.getDirectedPredNodes(cfg.getImplicitReturn())) {
            Node cond;
            Node stm = (Node)dn.getValue();
            if (!(NodeUtil.isLoopStructure(stm) ? (cond = NodeUtil.getConditionExpression(stm)) == null || !NodeUtil.isImpureTrue(cond) : (stm.isBreak() ? !cfg.getDirectedPredNodes(dn).isEmpty() : !stm.isReturn()))) continue;
            return true;
        }
        return false;
    }

    private JSType getDeclaredReturnTypeOfCurrentScope(JSType defaultType) {
        JSType declRetType = this.currentScope.getDeclaredTypeForOwnBody().getReturnType();
        if (declRetType == null) {
            declRetType = defaultType;
        } else if (this.areTypeVariablesUnknown) {
            declRetType = declRetType.substituteGenericsWithUnknown();
        }
        return declRetType;
    }

    private TypeEnv analyzeVarDeclFwd(Node nameNode, TypeEnv inEnv) {
        String varName = nameNode.getString();
        JSType declType = this.currentScope.getDeclaredTypeOf(varName);
        if (this.currentScope.isLocalFunDef(varName)) {
            return inEnv;
        }
        Node rhs = nameNode.getFirstChild();
        if (NodeUtil.isNamespaceDecl(nameNode) || GlobalTypeInfoCollector.isCtorDefinedByCall(nameNode) && !this.isFunctionBind(rhs.getFirstChild(), inEnv, true) || nameNode.getParent().getBooleanProp((byte)76)) {
            Preconditions.checkNotNull((Object)declType, (String)"Can't skip var declaration with undeclared type at: %s", (Object)nameNode);
            if (!rhs.isQualifiedName()) {
                this.analyzeExprFwdIgnoreResult(rhs, inEnv);
            }
            this.maybeSetTypeI(nameNode, declType);
            this.maybeSetTypeI(rhs, declType);
            return NewTypeInference.envPutType(inEnv, varName, declType);
        }
        TypeEnv outEnv = inEnv;
        JSType rhsType = null;
        if (rhs != null) {
            EnvTypePair pair = this.analyzeExprFwd(rhs, inEnv, (JSType)MoreObjects.firstNonNull((Object)declType, (Object)this.UNKNOWN));
            outEnv = pair.env;
            rhsType = pair.type;
            if (declType != null) {
                if (rhsType.isSubtypeOf(declType)) {
                    this.registerImplicitUses(rhs, rhsType, declType);
                } else {
                    this.registerMismatchAndWarn(JSError.make(rhs, MISTYPED_ASSIGN_RHS, NewTypeInference.errorMsgWithTypeDiff(declType, rhsType)), rhsType, declType);
                }
            }
        }
        JSType varType = this.getInitialTypeOfVar(nameNode, declType, rhsType);
        this.maybeSetTypeI(nameNode, varType);
        return NewTypeInference.envPutType(outEnv, varName, varType);
    }

    private JSType getInitialTypeOfVar(Node nameNode, JSType declType, JSType rhsType) {
        String varName = nameNode.getString();
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(nameNode);
        Node rhs = nameNode.getFirstChild();
        if (jsdoc != null && jsdoc.hasConstAnnotation()) {
            return jsdoc.hasType() ? declType : (rhsType != null ? rhsType : this.UNKNOWN);
        }
        if (this.currentScope.isEscapedVar(varName)) {
            if (declType != null) {
                return declType;
            }
            if (rhs == null || rhsType.isNullOrUndef()) {
                return this.UNKNOWN;
            }
            if (rhsType.isBoolean()) {
                return this.BOOLEAN;
            }
            return rhsType;
        }
        if (rhs == null) {
            return this.UNDEFINED;
        }
        if (declType != null) {
            return declType;
        }
        return rhsType;
    }

    private void analyzeExprFwdIgnoreResult(Node expr, TypeEnv inEnv) {
        this.analyzeExprFwd(expr, inEnv);
    }

    private EnvTypePair analyzeExprFwd(Node expr, TypeEnv inEnv) {
        return this.analyzeExprFwd(expr, inEnv, this.UNKNOWN, this.UNKNOWN);
    }

    private EnvTypePair analyzeExprFwd(Node expr, TypeEnv inEnv, JSType requiredType) {
        return this.analyzeExprFwd(expr, inEnv, requiredType, requiredType);
    }

    private EnvTypePair analyzeExprFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        Preconditions.checkArgument((requiredType != null && !requiredType.isBottom() ? 1 : 0) != 0);
        EnvTypePair resultPair = null;
        switch (expr.getToken()) {
            case EMPTY: {
                resultPair = new EnvTypePair(inEnv, this.UNKNOWN);
                break;
            }
            case FUNCTION: {
                String fnName = this.symbolTable.getFunInternalName(expr);
                JSType fnType = NewTypeInference.envGetType(inEnv, fnName);
                Preconditions.checkState((fnType != null ? 1 : 0) != 0, (String)"Could not find type for %s", (Object)fnName);
                TypeEnv outEnv = this.collectTypesForEscapedVarsFwd(expr, inEnv);
                resultPair = new EnvTypePair(outEnv, fnType);
                break;
            }
            case FALSE: 
            case NULL: 
            case NUMBER: 
            case STRING: 
            case TRUE: {
                resultPair = new EnvTypePair(inEnv, this.scalarValueToType(expr.getToken()));
                break;
            }
            case OBJECTLIT: {
                resultPair = this.analyzeObjLitFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case THIS: {
                resultPair = this.analyzeThisFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case SUPER: {
                resultPair = this.analyzeSuperFwd(expr, inEnv);
                break;
            }
            case NAME: {
                resultPair = this.analyzeNameFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case AND: 
            case OR: {
                resultPair = this.analyzeLogicalOpFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case INC: 
            case DEC: {
                resultPair = this.analyzeIncDecFwd(expr, inEnv, requiredType);
                break;
            }
            case BITNOT: 
            case NEG: {
                resultPair = this.analyzeUnaryNumFwd(expr, inEnv);
                break;
            }
            case POS: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                resultPair.type = this.NUMBER;
                break;
            }
            case TYPEOF: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                resultPair.type = this.STRING;
                break;
            }
            case INSTANCEOF: {
                resultPair = this.analyzeInstanceofFwd(expr, inEnv, specializedType);
                break;
            }
            case ADD: {
                resultPair = this.analyzeAddFwd(expr, inEnv, requiredType);
                break;
            }
            case BITOR: 
            case BITAND: 
            case BITXOR: 
            case DIV: 
            case EXPONENT: 
            case LSH: 
            case MOD: 
            case MUL: 
            case RSH: 
            case SUB: 
            case URSH: {
                resultPair = this.analyzeBinaryNumericOpFwd(expr, inEnv);
                break;
            }
            case ASSIGN: {
                resultPair = this.analyzeAssignFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case ASSIGN_ADD: {
                resultPair = this.analyzeAssignAddFwd(expr, inEnv, requiredType);
                break;
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_EXPONENT: {
                resultPair = this.analyzeAssignNumericOpFwd(expr, inEnv);
                break;
            }
            case SHEQ: 
            case SHNE: {
                resultPair = this.analyzeStrictComparisonFwd(expr.getToken(), expr.getFirstChild(), expr.getLastChild(), inEnv, specializedType);
                break;
            }
            case EQ: 
            case NE: {
                resultPair = this.analyzeNonStrictComparisonFwd(expr, inEnv, specializedType);
                break;
            }
            case LT: 
            case GT: 
            case LE: 
            case GE: {
                resultPair = this.analyzeLtGtFwd(expr, inEnv);
                break;
            }
            case GETPROP: {
                Preconditions.checkState((!NodeUtil.isAssignmentOp(expr.getParent()) || !NodeUtil.isLValue(expr) ? 1 : 0) != 0);
                if (expr.getBooleanProp((byte)76)) {
                    if (expr.isQualifiedName() && !NodeUtil.isTypedefDecl(expr)) {
                        this.markAndGetTypeOfPreanalyzedNode(expr, inEnv, true);
                    }
                    expr.removeProp((byte)76);
                    resultPair = new EnvTypePair(inEnv, requiredType);
                    break;
                }
                resultPair = this.analyzePropAccessFwd(expr.getFirstChild(), expr.getLastChild().getString(), inEnv, requiredType, specializedType);
                break;
            }
            case HOOK: {
                resultPair = this.analyzeHookFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case CALL: 
            case NEW: 
            case TAGGED_TEMPLATELIT: {
                resultPair = this.analyzeInvocationFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case COMMA: {
                resultPair = this.analyzeExprFwd(expr.getLastChild(), this.analyzeExprFwd((Node)expr.getFirstChild(), (TypeEnv)inEnv).env, requiredType, specializedType);
                break;
            }
            case NOT: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv, this.UNKNOWN, specializedType.negate());
                resultPair.type = resultPair.type.negate().toBoolean();
                break;
            }
            case GETELEM: {
                resultPair = this.analyzeGetElemFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case VOID: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                resultPair.type = this.UNDEFINED;
                break;
            }
            case IN: {
                resultPair = this.analyzeInFwd(expr, inEnv, specializedType);
                break;
            }
            case DELPROP: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                resultPair.type = this.BOOLEAN;
                break;
            }
            case REGEXP: {
                resultPair = new EnvTypePair(inEnv, this.commonTypes.getRegexpType());
                break;
            }
            case ARRAYLIT: {
                resultPair = this.analyzeArrayLitFwd(expr, inEnv);
                break;
            }
            case CAST: {
                resultPair = this.analyzeCastFwd(expr, inEnv);
                break;
            }
            case CASE: {
                resultPair = this.analyzeStrictComparisonFwd(Token.SHEQ, expr.getParent().getFirstChild(), expr.getFirstChild(), inEnv, specializedType);
                break;
            }
            case TEMPLATELIT: {
                resultPair = this.analyzeTemplateLitFwd(expr, inEnv);
                break;
            }
            case TEMPLATELIT_SUB: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv, requiredType);
                break;
            }
            case STRING_KEY: {
                if (expr.hasChildren()) {
                    resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv, requiredType, specializedType);
                    break;
                }
                resultPair = this.analyzeNameFwd(expr, inEnv, requiredType, specializedType);
                break;
            }
            case MEMBER_FUNCTION_DEF: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv, requiredType, specializedType);
                break;
            }
            case COMPUTED_PROP: {
                resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv, requiredType, specializedType);
                resultPair = this.analyzeExprFwd(expr.getSecondChild(), resultPair.env, requiredType, specializedType);
                break;
            }
            case YIELD: {
                resultPair = this.analyzeYieldFwd(expr, inEnv);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled expression type: " + (Object)((Object)expr.getToken()));
            }
        }
        JSType resultType = resultPair.type;
        this.mayWarnAboutUnknownType(expr, resultType);
        if (resultType.isUnresolved()) {
            resultPair.type = this.UNKNOWN;
        }
        this.maybeSetTypeI(expr, resultType);
        if (this.currentScope.isFunction()) {
            NewTypeInference.println("AnalyzeExprFWD: ", expr, " ::reqtype: ", requiredType, " ::spectype: ", specializedType, " ::resulttype: ", resultType);
        }
        return resultPair;
    }

    private void mayWarnAboutUnknownType(Node expr, JSType t) {
        boolean isKnownGetElem;
        boolean bl = isKnownGetElem = expr.isGetElem() && expr.getLastChild().isString();
        if (t.isUnknown() && this.reportUnknownTypes && !expr.getParent().isExprResult() && (!expr.isGetElem() || isKnownGetElem)) {
            this.warnings.add(JSError.make(expr, UNKNOWN_EXPR_TYPE, expr.getToken().toString()));
        }
    }

    private EnvTypePair analyzeNameFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        JSType preciseType;
        String varName = expr.getString();
        if (varName.equals("undefined")) {
            return new EnvTypePair(inEnv, this.UNDEFINED);
        }
        JSType inferredType = NewTypeInference.envGetType(inEnv, varName);
        if (inferredType == null) {
            NewTypeInference.println("Found global variable ", varName);
            return new EnvTypePair(inEnv, this.UNKNOWN);
        }
        NewTypeInference.println(varName, "'s inferredType: ", inferredType, " requiredType:  ", requiredType, " specializedType:  ", specializedType);
        if (!inferredType.isSubtypeOf(requiredType)) {
            JSType declType = this.currentScope.getDeclaredTypeOf(varName);
            if (this.tightenNameTypeAndDontWarn(varName, expr, declType, inferredType, requiredType)) {
                inferredType = inferredType.specialize(requiredType);
            } else {
                return new EnvTypePair(inEnv, inferredType);
            }
        }
        if ((preciseType = inferredType.specialize(specializedType)).isBottom()) {
            preciseType = this.pickFallbackTypeAfterBottom(varName, inferredType, specializedType);
        }
        NewTypeInference.println(varName, "'s preciseType: ", preciseType);
        if ((this.currentScope.isUndeclaredFormal(varName) || this.currentScope.isUndeclaredOuterVar(varName)) && preciseType.hasNonScalar()) {
            preciseType = preciseType.withLoose();
        }
        return EnvTypePair.addBinding(inEnv, varName, preciseType);
    }

    private JSType pickFallbackTypeAfterBottom(String name, JSType inferredType, JSType specializedType) {
        JSType declType = this.currentScope.getDeclaredTypeOf(name);
        if (declType == null) {
            return inferredType;
        }
        JSType preciseType = declType.specialize(specializedType);
        return preciseType.isBottom() ? declType : preciseType;
    }

    private EnvTypePair analyzeLogicalOpFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        Token logicalOp = expr.getToken();
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        if (specializedType.isTrueOrTruthy() && logicalOp == Token.AND || specializedType.isFalseOrFalsy() && logicalOp == Token.OR) {
            EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, this.UNKNOWN, specializedType);
            EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, this.UNKNOWN, specializedType);
            return rhsPair;
        }
        if (specializedType.isFalseOrFalsy() && logicalOp == Token.AND || specializedType.isTrueOrTruthy() && logicalOp == Token.OR) {
            EnvTypePair shortCircuitPair = this.analyzeExprFwd(lhs, inEnv, this.UNKNOWN, specializedType);
            EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, this.UNKNOWN, specializedType.negate());
            EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, this.UNKNOWN, specializedType);
            JSType lhsUnspecializedType = JSType.join(shortCircuitPair.type, lhsPair.type);
            return this.combineLhsAndRhsForLogicalOps(logicalOp, lhsUnspecializedType, shortCircuitPair, rhsPair);
        }
        JSType stopAfterLhsType = logicalOp == Token.AND ? this.FALSY : this.TRUTHY;
        EnvTypePair shortCircuitPair = this.analyzeExprFwd(lhs, inEnv, this.UNKNOWN, stopAfterLhsType);
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, this.UNKNOWN, stopAfterLhsType.negate());
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, requiredType, specializedType);
        JSType lhsType = JSType.join(shortCircuitPair.type, lhsPair.type);
        return this.combineLhsAndRhsForLogicalOps(logicalOp, lhsType, shortCircuitPair, rhsPair);
    }

    private EnvTypePair combineLhsAndRhsForLogicalOps(Token logicalOp, JSType lhsUnspecializedType, EnvTypePair lhsPair, EnvTypePair rhsPair) {
        if (logicalOp == Token.OR) {
            if (lhsUnspecializedType.isAnyTruthyType()) {
                return lhsPair;
            }
            if (lhsUnspecializedType.isAnyFalsyType()) {
                return rhsPair;
            }
            lhsPair.type = lhsPair.type.specialize(this.TRUTHY);
            return EnvTypePair.join(lhsPair, rhsPair);
        }
        Preconditions.checkState((logicalOp == Token.AND ? 1 : 0) != 0);
        if (lhsUnspecializedType.isAnyFalsyType()) {
            return lhsPair;
        }
        if (lhsUnspecializedType.isAnyTruthyType()) {
            return rhsPair;
        }
        lhsPair.type = lhsPair.type.specialize(this.FALSY);
        return EnvTypePair.join(lhsPair, rhsPair);
    }

    private EnvTypePair analyzeIncDecFwd(Node expr, TypeEnv inEnv, JSType requiredType) {
        this.mayWarnAboutConst(expr);
        Node ch = expr.getFirstChild();
        if (ch.isGetProp() || ch.isGetElem() && ch.getLastChild().isString()) {
            Node recv = ch.getFirstChild();
            String pname = ch.getLastChild().getString();
            EnvTypePair pair = this.analyzeExprFwd(recv, inEnv);
            JSType recvType = pair.type;
            if (this.mayWarnAboutConstProp(ch, recvType, new QualifiedName(pname))) {
                this.maybeSetTypeI(ch, recvType.getProp(new QualifiedName(pname)));
                pair.type = requiredType;
                return pair;
            }
        }
        return this.analyzeUnaryNumFwd(expr, inEnv);
    }

    private EnvTypePair analyzeUnaryNumFwd(Node expr, TypeEnv inEnv) {
        Node child = expr.getFirstChild();
        EnvTypePair pair = this.analyzeExprFwd(child, inEnv, this.NUMBER);
        if (!this.commonTypes.isNumberScalarOrObj(pair.type)) {
            this.warnInvalidOperand(child, expr.getToken(), this.NUMBER, pair.type);
        }
        pair.type = this.NUMBER;
        return pair;
    }

    private EnvTypePair analyzeInstanceofFwd(Node expr, TypeEnv inEnv, JSType specializedType) {
        boolean mayBeConstructorFunction;
        Node obj = expr.getFirstChild();
        Node ctor = expr.getLastChild();
        EnvTypePair objPair = this.analyzeExprFwd(obj, inEnv);
        JSType objType = objPair.type;
        if (!(objType.isTop() || objType.isUnknown() || objType.isTrueOrTruthy() || objType.hasNonScalar() || objType.hasTypeVariable())) {
            this.warnInvalidOperand(obj, Token.INSTANCEOF, "an object or a union type that includes an object", objPair.type);
        }
        EnvTypePair ctorPair = this.analyzeExprFwd(ctor, objPair.env, this.commonTypes.topFunction());
        JSType ctorType = ctorPair.type;
        FunctionType ctorFunType = ctorType.getFunType();
        boolean bl = mayBeConstructorFunction = ctorFunType != null && (ctorFunType.isLoose() || ctorFunType.isQmarkFunction() || ctorFunType.isSomeConstructorOrInterface());
        if (!ctorType.isUnknown() && !mayBeConstructorFunction) {
            this.warnInvalidOperand(ctor, Token.INSTANCEOF, "a constructor function", ctorType);
        }
        if (ctorFunType == null || !ctorFunType.isUniqueConstructor() || !specializedType.isTrueOrTruthy() && !specializedType.isFalseOrFalsy()) {
            ctorPair.type = this.BOOLEAN;
            return ctorPair;
        }
        JSType instanceType = ctorFunType.getInstanceTypeOfCtor();
        JSType instanceSpecType = specializedType.isTrueOrTruthy() ? objType.specialize(instanceType) : (objType.isTop() ? objType : objType.removeType(instanceType));
        if (!instanceSpecType.isBottom()) {
            objPair = this.analyzeExprFwd(obj, inEnv, this.UNKNOWN, instanceSpecType);
            ctorPair = this.analyzeExprFwd(ctor, objPair.env, this.commonTypes.topFunction());
        }
        ctorPair.type = this.BOOLEAN;
        return ctorPair;
    }

    private EnvTypePair analyzeAddFwd(Node expr, TypeEnv inEnv, JSType requiredType) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType operandType = requiredType.isNumber() ? this.NUMBER : this.UNKNOWN;
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, operandType);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, operandType);
        JSType lhsType = lhsPair.type;
        JSType rhsType = rhsPair.type;
        if (lhsType.isString() || rhsType.isString()) {
            rhsPair.type = this.STRING;
            return rhsPair;
        }
        if (!this.commonTypes.isNumStrScalarOrObj(lhsType)) {
            this.warnInvalidOperand(lhs, expr.getToken(), this.NUMBER_OR_STRING, lhsType);
        }
        if (!this.commonTypes.isNumStrScalarOrObj(rhsType)) {
            this.warnInvalidOperand(rhs, expr.getToken(), this.NUMBER_OR_STRING, rhsType);
        }
        return new EnvTypePair(rhsPair.env, JSType.plus(lhsType, rhsType));
    }

    private EnvTypePair analyzeBinaryNumericOpFwd(Node expr, TypeEnv inEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, this.NUMBER);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, this.NUMBER);
        if (!this.commonTypes.isNumberScalarOrObj(lhsPair.type)) {
            this.warnInvalidOperand(lhs, expr.getToken(), this.NUMBER, lhsPair.type);
        }
        if (!this.commonTypes.isNumberScalarOrObj(rhsPair.type)) {
            this.warnInvalidOperand(rhs, expr.getToken(), this.NUMBER, rhsPair.type);
        }
        rhsPair.type = this.NUMBER;
        return rhsPair;
    }

    private EnvTypePair analyzeAssignFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        if (expr.getBooleanProp((byte)76)) {
            expr.removeProp((byte)76);
            Node rhs = expr.getLastChild();
            if (!rhs.isQualifiedName()) {
                this.analyzeExprFwdIgnoreResult(rhs, inEnv);
            }
            if (!NodeUtil.isAliasedConstDefinition(expr.getFirstChild())) {
                this.markAndGetTypeOfPreanalyzedNode(expr.getFirstChild(), inEnv, true);
                this.markAndGetTypeOfPreanalyzedNode(rhs, inEnv, true);
            }
            return new EnvTypePair(inEnv, requiredType);
        }
        this.mayWarnAboutConst(expr);
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        if (lhs.getBooleanProp((byte)76)) {
            lhs.removeProp((byte)76);
            JSType declType = this.markAndGetTypeOfPreanalyzedNode(lhs, inEnv, true);
            if (rhs.matchesQualifiedName(this.ABSTRACT_METHOD_NAME) || GlobalTypeInfoCollector.isCtorDefinedByCall(lhs) && !this.isFunctionBind(rhs.getFirstChild(), inEnv, true)) {
                return new EnvTypePair(inEnv, requiredType);
            }
            EnvTypePair rhsPair = this.analyzeExprFwd(rhs, inEnv, declType);
            if (rhsPair.type.isSubtypeOf(declType)) {
                this.registerImplicitUses(expr, rhsPair.type, declType);
            } else if (!NodeUtil.isPrototypeAssignment(lhs)) {
                this.registerMismatchAndWarn(JSError.make(expr, MISTYPED_ASSIGN_RHS, NewTypeInference.errorMsgWithTypeDiff(declType, rhsPair.type)), rhsPair.type, declType);
            }
            return rhsPair;
        }
        LValueResultFwd lvalue = this.analyzeLValueFwd(lhs, inEnv, requiredType);
        JSType declType = lvalue.declType;
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lvalue.env, requiredType, specializedType);
        if (declType == null) {
            if (!this.isGlobalVariable(lhs, inEnv)) {
                rhsPair.env = this.updateLvalueTypeInEnv(rhsPair.env, lhs, lvalue.ptr, rhsPair.type);
            }
        } else if (rhsPair.type.isSubtypeOf(declType)) {
            this.registerImplicitUses(expr, rhsPair.type, declType);
            rhsPair.env = this.updateLvalueTypeInEnv(rhsPair.env, lhs, lvalue.ptr, rhsPair.type);
        } else {
            this.registerMismatchAndWarn(JSError.make(expr, MISTYPED_ASSIGN_RHS, NewTypeInference.errorMsgWithTypeDiff(declType, rhsPair.type)), rhsPair.type, declType);
        }
        return rhsPair;
    }

    private EnvTypePair analyzeAssignAddFwd(Node expr, TypeEnv inEnv, JSType requiredType) {
        this.mayWarnAboutConst(expr);
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType lhsReqType = NewTypeInference.specializeKeep2ndWhenBottom(requiredType, this.NUMBER_OR_STRING);
        LValueResultFwd lvalue = this.analyzeLValueFwd(lhs, inEnv, lhsReqType);
        JSType lhsType = lvalue.type;
        if (!lhsType.isSubtypeOf(this.NUMBER_OR_STRING)) {
            this.warnInvalidOperand(lhs, Token.ASSIGN_ADD, this.NUMBER_OR_STRING, lhsType);
        }
        JSType rhsReqType = lhsType.isNumber() ? this.NUMBER : this.NUMBER_OR_STRING;
        EnvTypePair pair = this.analyzeExprFwd(rhs, lvalue.env, rhsReqType);
        if (!pair.type.isSubtypeOf(rhsReqType)) {
            this.warnInvalidOperand(rhs, Token.ASSIGN_ADD, rhsReqType, pair.type);
        }
        return pair;
    }

    private EnvTypePair analyzeAssignNumericOpFwd(Node expr, TypeEnv inEnv) {
        this.mayWarnAboutConst(expr);
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        LValueResultFwd lvalue = this.analyzeLValueFwd(lhs, inEnv, this.NUMBER);
        JSType lhsType = lvalue.type;
        boolean lhsWarned = false;
        if (!this.commonTypes.isNumberScalarOrObj(lhsType)) {
            this.warnInvalidOperand(lhs, expr.getToken(), this.NUMBER, lhsType);
            lhsWarned = true;
        }
        EnvTypePair pair = this.analyzeExprFwd(rhs, lvalue.env, this.NUMBER);
        if (!this.commonTypes.isNumberScalarOrObj(pair.type)) {
            this.warnInvalidOperand(rhs, expr.getToken(), this.NUMBER, pair.type);
        }
        if (!lhsWarned) {
            pair.env = this.updateLvalueTypeInEnv(pair.env, lhs, lvalue.ptr, this.NUMBER);
        }
        pair.type = this.NUMBER;
        return pair;
    }

    private EnvTypePair analyzeLtGtFwd(Node expr, TypeEnv inEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
        if (lhsPair.type.isScalar() && !rhsPair.type.isScalar()) {
            rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, lhsPair.type);
        } else if (rhsPair.type.isScalar()) {
            lhsPair = this.analyzeExprFwd(lhs, inEnv, rhsPair.type);
            rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, rhsPair.type);
        }
        JSType lhsType = lhsPair.type;
        JSType rhsType = rhsPair.type;
        if (!(lhsType.isSubtypeOf(rhsType) || rhsType.isSubtypeOf(lhsType) || lhsType.isBoolean() && rhsType.isBoolean())) {
            this.warnInvalidOperand(expr, expr.getToken(), "matching types", lhsType + ", " + rhsType);
        }
        rhsPair.type = this.BOOLEAN;
        return rhsPair;
    }

    private EnvTypePair analyzeHookFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        Node cond = expr.getFirstChild();
        Node thenBranch = cond.getNext();
        Node elseBranch = thenBranch.getNext();
        TypeEnv trueEnv = this.analyzeExprFwd((Node)cond, (TypeEnv)inEnv, (JSType)this.UNKNOWN, (JSType)this.TRUTHY).env;
        TypeEnv falseEnv = this.analyzeExprFwd((Node)cond, (TypeEnv)inEnv, (JSType)this.UNKNOWN, (JSType)this.FALSY).env;
        EnvTypePair thenPair = this.analyzeExprFwd(thenBranch, trueEnv, requiredType, specializedType);
        EnvTypePair elsePair = this.analyzeExprFwd(elseBranch, falseEnv, requiredType, specializedType);
        return EnvTypePair.join(thenPair, elsePair);
    }

    private EnvTypePair analyzeObjLitCastFwd(CodingConvention.ObjectLiteralCast cast, Node call, TypeEnv inEnv) {
        if (cast.objectNode == null) {
            this.warnings.add(JSError.make(call, ClosureCodingConvention.OBJECTLIT_EXPECTED, new String[0]));
            return new EnvTypePair(inEnv, this.TOP_OBJECT);
        }
        EnvTypePair pair = this.analyzeExprFwd(cast.objectNode, inEnv);
        if (!pair.type.isPrototypeObject()) {
            this.warnings.add(JSError.make(call, REFLECT_CONSTRUCTOR_EXPECTED, new String[0]));
        }
        return new EnvTypePair(pair.env, this.TOP_OBJECT);
    }

    private ImmutableMap<String, TypeI> getTypemapWithOriginalNames(ImmutableMap<String, JSType> typeMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : typeMap.entrySet()) {
            String originalName = UniqueNameGenerator.getOriginalName((String)entry.getKey());
            builder.put((Object)originalName, entry.getValue());
        }
        return builder.build();
    }

    private FunctionType instantiateCalleeMaybeWithTTL(FunctionType calleeType, ImmutableMap<String, JSType> typeMap) {
        ImmutableMap<String, Node> typeTransformations = calleeType.getTypeTransformations();
        if (typeTransformations.isEmpty()) {
            return calleeType.instantiateGenerics((Map<String, JSType>)typeMap);
        }
        ImmutableMap<String, TypeI> mapWithOriginalNames = this.getTypemapWithOriginalNames(typeMap);
        LinkedHashMap<String, JSType> newTypeMap = new LinkedHashMap<String, JSType>();
        newTypeMap.putAll((Map<String, JSType>)typeMap);
        for (Map.Entry entry : typeTransformations.entrySet()) {
            String ttlVar = (String)entry.getKey();
            Node transform = (Node)entry.getValue();
            JSType t = (JSType)this.ttlObj.eval(transform, mapWithOriginalNames);
            newTypeMap.put(ttlVar, t);
        }
        return calleeType.instantiateGenerics((Map<String, JSType>)ImmutableMap.copyOf(newTypeMap));
    }

    private EnvTypePair analyzeInvocationFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        JSType retType;
        String calleeName;
        FunctionType funType;
        if (this.isPropertyTestCall(expr)) {
            return this.analyzePropertyTestCallFwd(expr, inEnv, specializedType);
        }
        if (expr.isCall() && this.convention.getObjectLiteralCast(expr) != null) {
            return this.analyzeObjLitCastFwd(this.convention.getObjectLiteralCast(expr), expr, inEnv);
        }
        Node callee = expr.getFirstChild();
        if (this.isFunctionBind(callee, inEnv, true)) {
            return this.analyzeFunctionBindFwd(expr, inEnv);
        }
        CodingConvention.AssertionFunctionSpec assertionFunctionSpec = this.assertionFunctionsMap.get(callee.getQualifiedName());
        if (assertionFunctionSpec != null) {
            return this.analyzeAssertionCall(expr, inEnv, assertionFunctionSpec);
        }
        EnvTypePair calleePair = this.analyzeExprFwd(callee, inEnv, this.commonTypes.topFunction());
        TypeEnv envAfterCallee = calleePair.env;
        calleePair = this.mayWarnAboutNullableReferenceAndTighten(callee, calleePair.type, null, envAfterCallee);
        JSType calleeType = calleePair.type;
        if (calleeType.isBottom() || !calleeType.isSubtypeOf(this.commonTypes.topFunction())) {
            this.warnings.add(JSError.make(expr, NOT_CALLABLE, calleeType.toString()));
        }
        if ((funType = calleeType.getFunTypeIfSingletonObj()) == null || funType.isTopFunction() || funType.isQmarkFunction()) {
            return this.analyzeInvocationArgsFwdWhenError(expr, envAfterCallee);
        }
        if (funType.isLoose()) {
            return this.analyzeLooseCallNodeFwd(expr, envAfterCallee, requiredType);
        }
        if (!this.isConstructorCall(expr) && funType.isSomeConstructorOrInterface() && (funType.getReturnType().isUnknown() || funType.getReturnType().isUndefined())) {
            this.warnings.add(JSError.make(expr, CONSTRUCTOR_NOT_CALLABLE, funType.toString()));
            return this.analyzeInvocationArgsFwdWhenError(expr, envAfterCallee);
        }
        if (expr.isNew()) {
            if (!funType.isSomeConstructorOrInterface() || funType.isInterfaceDefinition()) {
                String qnameRoot;
                if (callee.isQualifiedName() && !this.currentScope.isFormalParamInAnyAncestorScope(qnameRoot = QualifiedName.fromNode(callee).getLeftmostName())) {
                    this.warnings.add(JSError.make(expr, NOT_A_CONSTRUCTOR, funType.toString()));
                }
                return this.analyzeInvocationArgsFwdWhenError(expr, envAfterCallee);
            }
            if (funType.isConstructorOfAbstractClass()) {
                this.warnings.add(JSError.make(expr, CANNOT_INSTANTIATE_ABSTRACT_CLASS, funType.toString()));
                return this.analyzeInvocationArgsFwdWhenError(expr, envAfterCallee);
            }
        } else if (expr.isTaggedTemplateLit()) {
            funType = this.checkTaggedFunctionFirstParam(expr.getLastChild(), expr.getFirstChild(), funType);
        }
        if (!this.isInvocationArgCountCorrectAndWarn(funType, expr, callee)) {
            return this.analyzeInvocationArgsFwdWhenError(expr, envAfterCallee);
        }
        FunctionType originalFunType = funType;
        if (funType.isGeneric()) {
            Node receiver = callee.isGetProp() ? callee.getFirstChild() : null;
            Node firstArg = expr.getSecondChild();
            ImmutableMap<String, JSType> typeMap = this.calcTypeInstantiationFwd(expr, receiver, firstArg, funType, envAfterCallee);
            funType = this.instantiateCalleeMaybeWithTTL(funType, typeMap);
            callee.setTypeI(this.commonTypes.fromFunctionType(funType));
            NewTypeInference.println("Instantiated function type: ", funType);
        }
        ArrayList<JSType> argTypes = new ArrayList<JSType>();
        Node invocationNode = expr.isTaggedTemplateLit() ? expr.getLastChild() : expr;
        Iterable<Node> argIterable = NodeUtil.getInvocationArgsAsIterable(expr);
        TypeEnv tmpEnv = this.analyzeInvocationArgumentsFwd(invocationNode, argIterable, funType, argTypes, envAfterCallee);
        if (callee.isName() && this.currentScope.isKnownFunction(calleeName = callee.getString()) && !this.currentScope.isExternalFunction(calleeName)) {
            if (this.currentScope.isLocalFunDef(calleeName)) {
                tmpEnv = this.collectTypesForEscapedVarsFwd(callee, tmpEnv);
            } else if (!originalFunType.isGeneric()) {
                DeferredCheck dc;
                JSType expectedRetType = requiredType;
                NewTypeInference.println("Updating deferred check with ret: ", expectedRetType, " and args: ", argTypes);
                if (funType.isSomeConstructorOrInterface()) {
                    dc = new DeferredCheck(expr, null, this.currentScope, this.currentScope.getScope(calleeName));
                    this.deferredChecks.put(expr, dc);
                } else {
                    dc = this.deferredChecks.get(expr);
                    if (dc != null) {
                        dc.updateReturn(expectedRetType);
                    } else {
                        Preconditions.checkState((!this.currentScope.hasUndeclaredFormalsOrOuters() ? 1 : 0) != 0, (String)"No deferred check created in backward direction for %s", (Object)expr);
                    }
                }
                if (dc != null) {
                    dc.updateArgTypes(argTypes);
                }
            }
        }
        JSType jSType = retType = expr.isNew() ? funType.getThisType() : funType.getReturnType();
        if (retType.isSubtypeOf(requiredType)) {
            retType = retType.specialize(specializedType);
        }
        return new EnvTypePair(tmpEnv, retType);
    }

    private FunctionType checkTaggedFunctionFirstParam(Node taggedLit, Node funcName, FunctionType funType) {
        JSType firstArgType = funType.getFormalType(0);
        JSType templateArray = this.commonTypes.getITemplateArrayType();
        if (firstArgType == null) {
            this.warnings.add(JSError.make(taggedLit, TEMPLATE_ARGUMENT_MISSING, new String[0]));
            return this.commonTypes.qmarkFunction().getFunTypeIfSingletonObj();
        }
        if (!templateArray.isSubtypeOf(firstArgType)) {
            JSError error = JSError.make(taggedLit, TEMPLATE_ARGUMENT_MISMATCH, NewTypeInference.getReadableCalleeName(funcName), NewTypeInference.errorMsgWithTypeDiff(templateArray, firstArgType));
            this.registerMismatchAndWarn(error, firstArgType, templateArray);
        }
        return funType;
    }

    private boolean isInvocationArgCountCorrectAndWarn(FunctionType funType, Node expr, Node funcName) {
        int numArgs = NodeUtil.getInvocationArgsCount(expr);
        int maxArity = funType.getMaxArity();
        int minArity = funType.getMinArity();
        if (numArgs < minArity || numArgs > maxArity) {
            this.warnings.add(JSError.make(expr, WRONG_ARGUMENT_COUNT, NewTypeInference.getReadableCalleeName(funcName), Integer.toString(numArgs), Integer.toString(minArity), " and at most " + maxArity));
            return false;
        }
        return true;
    }

    private boolean isConstructorCall(Node expr) {
        return expr.isNew() || expr.isCall() && this.currentScope.isConstructor() && expr.getFirstChild().isSuper();
    }

    private EnvTypePair analyzeFunctionBindFwd(Node call, TypeEnv inEnv) {
        Preconditions.checkArgument((boolean)call.isCall());
        CodingConvention.Bind bindComponents = this.convention.describeFunctionBind(call, true, false);
        Node boundFunNode = bindComponents.target;
        EnvTypePair pair = this.analyzeExprFwd(boundFunNode, inEnv);
        TypeEnv env = pair.env;
        FunctionType boundFunType = pair.type.getFunTypeIfSingletonObj();
        if (!pair.type.isSubtypeOf(this.commonTypes.topFunction())) {
            this.warnings.add(JSError.make(boundFunNode, GOOG_BIND_EXPECTS_FUNCTION, pair.type.toString()));
        }
        if (boundFunType == null || boundFunType.isTopFunction() || boundFunType.isQmarkFunction() || boundFunType.isLoose()) {
            return this.analyzeInvocationArgsFwdWhenError(call, env);
        }
        if (boundFunType.isSomeConstructorOrInterface()) {
            this.warnings.add(JSError.make(call, CANNOT_BIND_CTOR, new String[0]));
            return new EnvTypePair(env, this.UNKNOWN);
        }
        int callChildCount = call.getChildCount();
        if (NodeUtil.isGoogBind(call.getFirstChild()) && callChildCount <= 2 || !NodeUtil.isGoogPartial(call.getFirstChild()) && callChildCount == 1) {
            this.warnings.add(JSError.make(call, WRONG_ARGUMENT_COUNT, NewTypeInference.getReadableCalleeName(call.getFirstChild()), "0", "1", ""));
        }
        int maxArity = boundFunType.hasRestFormals() ? Integer.MAX_VALUE : boundFunType.getMaxArity();
        int numArgs = bindComponents.getBoundParameterCount();
        if (numArgs > maxArity) {
            this.warnings.add(JSError.make(call, WRONG_ARGUMENT_COUNT, NewTypeInference.getReadableCalleeName(call.getFirstChild()), Integer.toString(numArgs), "0", " and at most " + maxArity));
            return this.analyzeInvocationArgsFwdWhenError(call, inEnv);
        }
        Node receiver = bindComponents.thisValue;
        if (boundFunType.isGeneric()) {
            ImmutableMap<String, JSType> typeMap = this.calcTypeInstantiationFwd(call, receiver, bindComponents.parameters, boundFunType, env);
            boundFunType = boundFunType.instantiateGenerics((Map<String, JSType>)typeMap);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        if (receiver != null) {
            JSType reqThisType = boundFunType.getThisType();
            if (reqThisType == null || boundFunType.isSomeConstructorOrInterface()) {
                reqThisType = JSType.join(this.NULL, this.TOP_OBJECT);
            }
            pair = this.analyzeExprFwd(receiver, env, reqThisType);
            env = pair.env;
            if (!pair.type.isSubtypeOf(reqThisType)) {
                this.warnings.add(JSError.make(call, INVALID_THIS_TYPE_IN_BIND, NewTypeInference.errorMsgWithTypeDiff(reqThisType, pair.type)));
            } else {
                this.instantiateGoogBind(call.getFirstChild(), pair.type);
            }
        }
        ImmutableList parametersIterable = bindComponents.parameters == null ? ImmutableList.of() : bindComponents.parameters.siblings();
        env = this.analyzeInvocationArgumentsFwd(call, (Iterable<Node>)parametersIterable, boundFunType, new ArrayList<JSType>(), env);
        for (int j = numArgs; j < boundFunType.getMaxArityWithoutRestFormals(); ++j) {
            JSType formalType = boundFunType.getFormalType(j);
            if (boundFunType.isRequiredArg(j)) {
                builder.addReqFormal(formalType);
                continue;
            }
            builder.addOptFormal(formalType);
        }
        if (boundFunType.hasRestFormals()) {
            builder.addRestFormals(boundFunType.getRestFormalsType());
        }
        return new EnvTypePair(env, this.commonTypes.fromFunctionType(builder.addRetType(boundFunType.getReturnType()).buildFunction()));
    }

    private TypeEnv analyzeInvocationArgumentsFwd(Node n, Iterable<Node> args, FunctionType funType, List<JSType> argTypesForDeferredCheck, TypeEnv inEnv) {
        Preconditions.checkState((NodeUtil.isCallOrNew(n) || n.isTemplateLit() ? 1 : 0) != 0);
        TypeEnv env = inEnv;
        int i = n.isTemplateLit() ? 1 : 0;
        for (Node arg : args) {
            JSType formalType = funType.getFormalType(i);
            Preconditions.checkState((!formalType.isBottom() ? 1 : 0) != 0);
            EnvTypePair pair = this.analyzeExprFwd(arg, env, formalType);
            if (NodeUtil.isUnannotatedCallback(arg) && formalType.getFunType() != null) {
                ++i;
                argTypesForDeferredCheck.add(null);
                continue;
            }
            JSType argTypeForDeferredCheck = pair.type;
            if (funType.isOptionalArg(i) && pair.type.equals(this.UNDEFINED)) {
                argTypeForDeferredCheck = null;
            } else if (!pair.type.isSubtypeOf(formalType)) {
                this.warnAboutInvalidArgument(n, arg, i, formalType, pair.type);
                argTypeForDeferredCheck = null;
            } else {
                this.registerImplicitUses(arg, pair.type, formalType);
            }
            argTypesForDeferredCheck.add(argTypeForDeferredCheck);
            env = pair.env;
            ++i;
        }
        return env;
    }

    private void instantiateGoogBind(Node n, JSType recvType) {
        FunctionType ft;
        JSType t;
        if (NodeUtil.isGoogBind(n) && (t = (JSType)n.getTypeI()).isFunctionType() && (ft = t.getFunType()).isGeneric()) {
            FunctionType instantiatedFunction = ft.instantiateGenericsFromArgumentTypes(null, (List<JSType>)ImmutableList.of((Object)this.UNKNOWN, (Object)recvType));
            n.setTypeI(this.commonTypes.fromFunctionType(instantiatedFunction));
        }
    }

    private void warnAboutInvalidArgument(Node call, Node arg, int argIndex, JSType formal, JSType actual) {
        String fnName = NewTypeInference.getReadableCalleeName(call.getFirstChild());
        JSError error = JSError.make(arg, INVALID_ARGUMENT_TYPE, Integer.toString(argIndex + 1), fnName, NewTypeInference.errorMsgWithTypeDiff(formal, actual));
        this.registerMismatchAndWarn(error, actual, formal);
    }

    private void computeFnDeclaredTypeForCallback(NTIScope scope) {
        Node callback = scope.getRoot();
        Preconditions.checkState((boolean)NodeUtil.isUnannotatedCallback(callback));
        Node call = callback.getParent();
        JSType calleeType = (JSType)call.getFirstChild().getTypeI();
        if (calleeType == null) {
            return;
        }
        FunctionType calleeFunType = calleeType.getFunType();
        if (calleeFunType == null) {
            return;
        }
        int argIndex = call.getIndexOfChild(callback) - 1;
        JSType formalType = calleeFunType.getFormalType(argIndex);
        if (formalType == null) {
            return;
        }
        FunctionType ft = formalType.getFunType();
        if (ft == null || ft.isLoose()) {
            return;
        }
        DeclaredFunctionType callbackDft = scope.getDeclaredFunctionType();
        JSType scopeType = this.commonTypes.fromFunctionType(callbackDft.toFunctionType());
        if (ft.isUniqueConstructor() || ft.isInterfaceDefinition()) {
            this.warnAboutInvalidArgument(call, callback, argIndex, formalType, scopeType);
            return;
        }
        DeclaredFunctionType declaredDft = (DeclaredFunctionType)Preconditions.checkNotNull((Object)ft.toDeclaredFunctionType());
        if (ft.acceptsAnyArguments() || callbackDft.getRequiredArity() <= declaredDft.getMaxArity()) {
            scope.setDeclaredType(declaredDft);
        } else {
            this.warnAboutInvalidArgument(call, callback, argIndex, formalType, scopeType);
        }
    }

    private EnvTypePair analyzeAssertionCall(Node callNode, TypeEnv env, CodingConvention.AssertionFunctionSpec assertionFunctionSpec) {
        this.analyzeExprFwdIgnoreResult(callNode.getFirstChild(), env);
        Node firstParam = callNode.getSecondChild();
        if (firstParam == null) {
            return new EnvTypePair(env, this.UNKNOWN);
        }
        for (Node assertionArgument : firstParam.siblings()) {
            this.analyzeExprFwdIgnoreResult(assertionArgument, env);
        }
        Node assertedNode = assertionFunctionSpec.getAssertedParam(firstParam);
        if (assertedNode == null) {
            return new EnvTypePair(env, this.UNKNOWN);
        }
        JSType assertedType = assertionFunctionSpec.getAssertedNewType(callNode, this.currentScope);
        if (assertedType.isUnknown()) {
            this.warnings.add(JSError.make(callNode, UNKNOWN_ASSERTION_TYPE, new String[0]));
        }
        EnvTypePair pair = this.analyzeExprFwd(assertedNode, env, this.UNKNOWN, assertedType);
        boolean haveCommonSubtype = JSType.haveCommonSubtype(assertedType, pair.type);
        if (!pair.type.isSubtypeOf(assertedType) && haveCommonSubtype) {
            pair.type = assertedType;
        }
        if (!haveCommonSubtype) {
            JSType t = this.analyzeExprFwd((Node)assertedNode, (TypeEnv)env).type.substituteGenericsWithUnknown();
            if (t.isSubtypeOf(assertedType)) {
                pair.type = t;
            } else {
                if (!firstParam.isFalse()) {
                    this.warnings.add(JSError.make(assertedNode, ASSERT_FALSE, new String[0]));
                }
                pair.type = this.UNKNOWN;
                pair.env = env;
            }
        }
        return pair;
    }

    private EnvTypePair analyzeGetElemFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        Node receiver = expr.getFirstChild();
        Node index = expr.getLastChild();
        JSType reqObjType = this.pickReqObjType(expr);
        EnvTypePair pair = this.analyzeExprFwd(receiver, inEnv, reqObjType);
        pair = this.mayWarnAboutNullableReferenceAndTighten(receiver, pair.type, null, pair.env);
        JSType recvType = pair.type.autobox();
        if (!this.mayWarnAboutNonObject(receiver, recvType, specializedType) && !this.mayWarnAboutStructPropAccess(receiver, recvType)) {
            JSType indexType = recvType.getIndexType();
            if (indexType != null) {
                pair = this.analyzeExprFwd(index, pair.env, NewTypeInference.firstNonBottom(indexType, this.UNKNOWN));
                this.mayWarnAboutBadIObjectIndex(index, recvType, pair.type, indexType);
                pair.type = this.getIndexedTypeOrUnknown(recvType);
                return pair;
            }
            if (index.isString()) {
                return this.analyzePropAccessFwd(receiver, index.getString(), inEnv, requiredType, specializedType);
            }
        }
        pair = this.analyzeExprFwd(index, pair.env);
        pair.type = this.UNKNOWN;
        return pair;
    }

    private EnvTypePair analyzeInFwd(Node expr, TypeEnv inEnv, JSType specializedType) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType reqObjType = this.pickReqObjType(expr);
        EnvTypePair pair = this.analyzeExprFwd(lhs, inEnv, this.NUMBER_OR_STRING);
        if (!pair.type.isSubtypeOf(this.NUMBER_OR_STRING)) {
            this.warnInvalidOperand(lhs, Token.IN, this.NUMBER_OR_STRING, pair.type);
        }
        pair = this.analyzeExprFwd(rhs, pair.env, reqObjType);
        if (!pair.type.isSubtypeOf(this.TOP_OBJECT)) {
            this.warnInvalidOperand(rhs, Token.IN, "Object", pair.type);
            pair.type = this.BOOLEAN;
            return pair;
        }
        if (pair.type.isStruct()) {
            this.warnings.add(JSError.make(rhs, IN_USED_WITH_STRUCT, new String[0]));
            pair.type = this.BOOLEAN;
            return pair;
        }
        JSType resultType = this.BOOLEAN;
        if (lhs.isString()) {
            QualifiedName pname = new QualifiedName(lhs.getString());
            if (specializedType.isTrueOrTruthy()) {
                pair = this.analyzeExprFwd(rhs, inEnv, reqObjType, reqObjType.withPropertyRequired(pname.getLeftmostName()));
                resultType = this.TRUE_TYPE;
            } else if (specializedType.isFalseOrFalsy()) {
                pair = this.analyzeExprFwd(rhs, inEnv, reqObjType);
                pair = this.analyzeExprFwd(rhs, inEnv, reqObjType, pair.type.withoutProperty(pname));
                resultType = this.FALSE_TYPE;
            }
        }
        pair.type = resultType;
        return pair;
    }

    private EnvTypePair analyzeArrayLitFwd(Node expr, TypeEnv inEnv) {
        TypeEnv env = inEnv;
        JSType elementType = this.BOTTOM;
        for (Node arrayElm = expr.getFirstChild(); arrayElm != null; arrayElm = arrayElm.getNext()) {
            EnvTypePair pair = this.analyzeExprFwd(arrayElm, env);
            env = pair.env;
            elementType = JSType.join(elementType, pair.type);
        }
        elementType = NewTypeInference.firstNonBottom(elementType, this.UNKNOWN);
        return new EnvTypePair(env, this.commonTypes.getArrayInstance(elementType));
    }

    private EnvTypePair analyzeCastFwd(Node expr, TypeEnv inEnv) {
        Node insideCast = expr.getFirstChild();
        EnvTypePair pair = this.analyzeExprFwd(insideCast, inEnv);
        JSType fromType = pair.type;
        JSType toType = (JSType)expr.getTypeI();
        if (!(fromType.isInterfaceInstance() || toType.isInterfaceInstance() || JSType.haveCommonSubtype(fromType, toType) || fromType.hasTypeVariable() || insideCast.isObjectLit() && !insideCast.hasChildren())) {
            JSError error = JSError.make(expr, INVALID_CAST, fromType.toString(), toType.toString());
            this.registerMismatchAndWarn(error, fromType, toType);
        } else {
            this.registerImplicitUses(expr, fromType, toType);
        }
        insideCast.putProp((byte)79, fromType);
        insideCast.setTypeI(toType);
        pair.type = toType;
        return pair;
    }

    private EnvTypePair analyzeInvocationArgsFwdWhenError(Node call, TypeEnv env) {
        return this.analyzeInvocationArgsFwdWhenError(NodeUtil.getInvocationArgsAsIterable(call), env);
    }

    private EnvTypePair analyzeInvocationArgsFwdWhenError(Iterable<Node> args, TypeEnv inEnv) {
        TypeEnv env = inEnv;
        for (Node arg : args) {
            env = this.analyzeExprFwd((Node)arg, (TypeEnv)env).env;
        }
        return new EnvTypePair(env, this.UNKNOWN);
    }

    private EnvTypePair analyzeTemplateLitFwd(Node expr, TypeEnv inEnv) {
        TypeEnv env = inEnv;
        for (Node child : expr.children()) {
            env = this.analyzeExprFwd((Node)child, (TypeEnv)env).env;
        }
        return new EnvTypePair(env, this.STRING);
    }

    private EnvTypePair analyzeStrictComparisonFwd(Token comparisonOp, Node lhs, Node rhs, TypeEnv inEnv, JSType specializedType) {
        if (specializedType.isTrueOrTruthy() || specializedType.isFalseOrFalsy()) {
            if (lhs.isTypeOf()) {
                return this.analyzeSpecializedTypeof(lhs, rhs, comparisonOp, inEnv, specializedType);
            }
            if (rhs.isTypeOf()) {
                return this.analyzeSpecializedTypeof(rhs, lhs, comparisonOp, inEnv, specializedType);
            }
            if (this.isGoogTypeof(lhs)) {
                return this.analyzeGoogTypeof(lhs, rhs, inEnv, specializedType);
            }
            if (this.isGoogTypeof(rhs)) {
                return this.analyzeGoogTypeof(rhs, lhs, inEnv, specializedType);
            }
        }
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
        JSType rhstype = rhsPair.type;
        JSType lhstype = lhsPair.type;
        if (!rhstype.isNullOrUndef()) {
            if (JSType.haveCommonSubtype(lhstype, rhstype)) {
                this.registerImplicitUses(lhs, lhstype, rhstype);
            } else {
                JSError error = JSError.make(lhs, INCOMPATIBLE_STRICT_COMPARISON, lhstype.toString(), rhstype.toString());
                this.registerMismatchAndWarn(error, lhstype, rhstype);
            }
        }
        TypeEnv preciseEnv = rhsPair.env;
        if (comparisonOp == Token.SHEQ && specializedType.isTrueOrTruthy() || comparisonOp == Token.SHNE && specializedType.isFalseOrFalsy()) {
            lhsPair = this.analyzeExprFwd(lhs, preciseEnv, this.UNKNOWN, lhsPair.type.specialize(rhsPair.type));
            rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, this.UNKNOWN, rhsPair.type.specialize(lhsPair.type));
        } else if (comparisonOp == Token.SHEQ && specializedType.isFalseOrFalsy() || comparisonOp == Token.SHNE && specializedType.isTrueOrTruthy()) {
            JSType lhsType = lhsPair.type;
            JSType rhsType = rhsPair.type;
            if (lhsType.isNullOrUndef()) {
                rhsType = rhsType.removeType(lhsType);
            } else if (rhsType.isNullOrUndef()) {
                lhsType = lhsType.removeType(rhsType);
            }
            lhsPair = this.analyzeExprFwd(lhs, preciseEnv, this.UNKNOWN, lhsType);
            rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, this.UNKNOWN, rhsType);
        }
        rhsPair.type = this.BOOLEAN;
        return rhsPair;
    }

    private EnvTypePair analyzeSpecializedTypeof(Node typeof, Node typeString, Token comparisonOp, TypeEnv inEnv, JSType specializedType) {
        EnvTypePair pair;
        Node typeofRand = typeof.getFirstChild();
        JSType comparedType = this.getTypeFromString(typeString);
        this.checkInvalidTypename(typeString);
        if (comparedType.isUnknown()) {
            pair = this.analyzeExprFwd(typeofRand, inEnv);
            pair = this.analyzeExprFwd(typeString, pair.env);
        } else if (specializedType.isTrueOrTruthy() && (comparisonOp == Token.SHEQ || comparisonOp == Token.EQ) || specializedType.isFalseOrFalsy() && (comparisonOp == Token.SHNE || comparisonOp == Token.NE)) {
            pair = this.analyzeExprFwd(typeofRand, inEnv, this.UNKNOWN, comparedType);
        } else {
            pair = this.analyzeExprFwd(typeofRand, inEnv);
            JSType rmType = pair.type.removeType(comparedType);
            if (!rmType.isBottom()) {
                pair = this.analyzeExprFwd(typeofRand, inEnv, this.UNKNOWN, rmType);
            }
        }
        pair.type = specializedType.toBoolean();
        return pair;
    }

    private EnvTypePair analyzeThisFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        this.mayWarnAboutGlobalThis(expr);
        if (!this.currentScope.hasThis()) {
            return new EnvTypePair(inEnv, this.UNKNOWN);
        }
        JSType inferredType = NewTypeInference.envGetType(inEnv, THIS_ID);
        if (!inferredType.isSubtypeOf(requiredType)) {
            return new EnvTypePair(inEnv, inferredType);
        }
        JSType preciseType = inferredType.specialize(specializedType);
        if (preciseType.isBottom()) {
            preciseType = this.pickFallbackTypeAfterBottom(THIS_ID, inferredType, specializedType);
        }
        return EnvTypePair.addBinding(inEnv, THIS_ID, preciseType);
    }

    private EnvTypePair analyzeSuperFwd(Node expr, TypeEnv inEnv) {
        Preconditions.checkArgument((boolean)expr.isSuper());
        if (this.currentScope.hasThis()) {
            NominalType thisClass = (NominalType)Preconditions.checkNotNull((Object)NewTypeInference.envGetType(inEnv, THIS_ID).getNominalTypeIfSingletonObj());
            NominalType superClass = thisClass.getInstantiatedSuperclass();
            if (superClass == null) {
                this.warnings.add(JSError.make(expr, UNDEFINED_SUPER_CLASS, thisClass.toString()));
                return new EnvTypePair(inEnv, this.UNKNOWN);
            }
            if (this.currentScope.isConstructor()) {
                JSType superCtor = this.commonTypes.fromFunctionType(superClass.getConstructorFunction());
                return new EnvTypePair(inEnv, superCtor);
            }
            return new EnvTypePair(inEnv, superClass.getInstanceAsJSType());
        }
        Node funName = NodeUtil.getBestLValue(this.currentScope.getRoot());
        Node classNameNode = funName.getFirstChild();
        JSType thisClassAsJstype = this.analyzeExprFwd((Node)classNameNode, (TypeEnv)inEnv).type;
        FunctionType thisCtor = thisClassAsJstype.getFunTypeIfSingletonObj();
        NominalType thisClass = thisCtor.getThisType().getNominalTypeIfSingletonObj();
        NominalType superClass = thisClass.getInstantiatedSuperclass();
        if (superClass == null) {
            this.warnings.add(JSError.make(expr, UNDEFINED_SUPER_CLASS, funName.toString()));
            return new EnvTypePair(inEnv, this.UNKNOWN);
        }
        return new EnvTypePair(inEnv, superClass.getNamespaceType());
    }

    /*
     * Enabled aggressive block sorting
     */
    private EnvTypePair analyzeYieldFwd(Node expr, TypeEnv inEnv) {
        JSType actualRetType;
        JSType declRetType;
        if (!expr.hasChildren()) {
            return new EnvTypePair(NewTypeInference.envPutType(inEnv, YIELDVAL_ID, this.UNDEFINED), this.UNKNOWN);
        }
        EnvTypePair resultPair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
        JSType iterable = this.commonTypes.getIterableInstance(this.UNKNOWN);
        JSType iterator = this.commonTypes.getIteratorInstance(this.UNKNOWN);
        JSType generator = this.commonTypes.getGeneratorInstance(this.UNKNOWN);
        if (!generator.isSubtypeOf(declRetType = this.getDeclaredReturnTypeOfCurrentScope(generator))) {
            resultPair.type = this.UNKNOWN;
            return resultPair;
        }
        JSType yieldType = declRetType.isSubtypeOf(iterable) ? declRetType.getInstantiatedTypeArgument(iterable) : (declRetType.isSubtypeOf(iterator) ? declRetType.getInstantiatedTypeArgument(iterator) : this.UNKNOWN);
        if (expr.isYieldAll()) {
            JSType boxedType = resultPair.type.autobox();
            if (!boxedType.isSubtypeOf(iterable)) {
                this.warnings.add(JSError.make(expr, YIELD_ALL_EXPECTS_ITERABLE, resultPair.type.toString()));
                resultPair.type = this.UNKNOWN;
                return resultPair;
            }
            actualRetType = boxedType.getInstantiatedTypeArgument(iterable);
        } else {
            actualRetType = resultPair.type;
        }
        if (!yieldType.isBottom() && !actualRetType.isSubtypeOf(yieldType)) {
            this.registerMismatchAndWarn(JSError.make(expr, YIELD_NONDECLARED_TYPE, NewTypeInference.errorMsgWithTypeDiff(yieldType, actualRetType)), actualRetType, yieldType);
            resultPair.type = this.UNKNOWN;
            return resultPair;
        }
        if (yieldType.isBottom() || yieldType.isUnknown()) {
            JSType oldType = NewTypeInference.envGetType(resultPair.env, YIELDVAL_ID);
            resultPair.env = oldType == null ? NewTypeInference.envPutType(resultPair.env, YIELDVAL_ID, actualRetType) : NewTypeInference.envPutType(resultPair.env, YIELDVAL_ID, JSType.join(oldType, actualRetType));
        }
        resultPair.type = this.UNKNOWN;
        return resultPair;
    }

    private JSType getTypeFromString(Node typeString) {
        if (!typeString.isString()) {
            return this.UNKNOWN;
        }
        switch (typeString.getString()) {
            case "number": {
                return this.NUMBER;
            }
            case "string": {
                return this.STRING;
            }
            case "boolean": {
                return this.BOOLEAN;
            }
            case "undefined": {
                return this.UNDEFINED;
            }
            case "function": {
                return this.commonTypes.looseTopFunction();
            }
            case "object": {
                return JSType.join(this.NULL, this.TOP_OBJECT);
            }
        }
        return this.UNKNOWN;
    }

    private void checkInvalidTypename(Node typeString) {
        String typeName;
        if (!typeString.isString()) {
            return;
        }
        switch (typeName = typeString.getString()) {
            case "number": 
            case "string": 
            case "boolean": 
            case "undefined": 
            case "function": 
            case "object": 
            case "symbol": 
            case "unknown": {
                break;
            }
            default: {
                this.warnings.add(JSError.make(typeString, UNKNOWN_TYPEOF_VALUE, typeName));
            }
        }
    }

    private ImmutableMap<String, JSType> calcTypeInstantiationFwd(Node callNode, Node receiver, Node firstArg, FunctionType funType, TypeEnv typeEnv) {
        return this.calcTypeInstantiation(callNode, receiver, firstArg, funType, typeEnv, true);
    }

    private ImmutableMap<String, JSType> calcTypeInstantiationBwd(Node callNode, FunctionType funType, TypeEnv typeEnv) {
        return this.calcTypeInstantiation(callNode, null, callNode.getSecondChild(), funType, typeEnv, false);
    }

    private ImmutableMap<String, JSType> calcTypeInstantiation(Node callNode, Node receiver, Node firstArg, FunctionType funType, TypeEnv typeEnv, boolean isFwd) {
        Preconditions.checkState((receiver == null || isFwd ? 1 : 0) != 0);
        ImmutableList<String> typeParameters = funType.getTypeParameters();
        LinkedHashMultimap typeMultimap = LinkedHashMultimap.create();
        JSType funRecvType = funType.getThisType();
        if (receiver != null && funRecvType != null) {
            JSType recvType = (JSType)receiver.getTypeI();
            if (recvType == null) {
                EnvTypePair pair = this.analyzeExprFwd(receiver, typeEnv);
                recvType = pair.type;
                typeEnv = pair.env;
            }
            funRecvType.unifyWith(recvType, (List<String>)typeParameters, (Multimap<String, JSType>)typeMultimap);
        }
        Node arg = firstArg;
        int i = 0;
        while (arg != null) {
            EnvTypePair pair = isFwd ? this.analyzeExprFwd(arg, typeEnv) : this.analyzeExprBwd(arg, typeEnv);
            funType.getFormalType(i).unifyWith(pair.type, (List<String>)typeParameters, (Multimap<String, JSType>)typeMultimap);
            arg = arg.getNext();
            typeEnv = pair.env;
            ++i;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String typeParam : typeParameters) {
            Collection types = typeMultimap.get((Object)typeParam);
            if (types.size() > 1) {
                if (isFwd) {
                    this.warnings.add(JSError.make(callNode, NOT_UNIQUE_INSTANTIATION, Integer.toString(types.size()), UniqueNameGenerator.getOriginalName(typeParam), types.toString(), funType.toString()));
                }
                if (this.joinTypesWhenInstantiatingGenerics) {
                    JSType joinedType = this.BOTTOM;
                    for (JSType t : types) {
                        joinedType = JSType.join(joinedType, t);
                    }
                    builder.put((Object)typeParam, (Object)joinedType);
                    continue;
                }
                builder.put((Object)typeParam, (Object)this.UNKNOWN);
                continue;
            }
            if (types.size() == 1) {
                JSType t = (JSType)Iterables.getOnlyElement((Iterable)types);
                builder.put((Object)typeParam, (Object)NewTypeInference.firstNonBottom(t, this.UNKNOWN));
                continue;
            }
            builder.put((Object)typeParam, (Object)this.UNKNOWN);
        }
        return builder.build();
    }

    private EnvTypePair analyzeNonStrictComparisonFwd(Node expr, TypeEnv inEnv, JSType specializedType) {
        Token tokenType = expr.getToken();
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        if (specializedType.isTrueOrTruthy() || specializedType.isFalseOrFalsy()) {
            if (lhs.isTypeOf()) {
                return this.analyzeSpecializedTypeof(lhs, rhs, tokenType, inEnv, specializedType);
            }
            if (rhs.isTypeOf()) {
                return this.analyzeSpecializedTypeof(rhs, lhs, tokenType, inEnv, specializedType);
            }
            if (this.isGoogTypeof(lhs)) {
                return this.analyzeGoogTypeof(lhs, rhs, inEnv, specializedType);
            }
            if (this.isGoogTypeof(rhs)) {
                return this.analyzeGoogTypeof(rhs, lhs, inEnv, specializedType);
            }
        }
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
        TypeEnv preciseEnv = rhsPair.env;
        JSType lhsType = lhsPair.type;
        JSType rhsType = rhsPair.type;
        if (tokenType == Token.EQ && specializedType.isTrueOrTruthy() || tokenType == Token.NE && specializedType.isFalseOrFalsy()) {
            if (lhsType.isNullOrUndef()) {
                rhsPair = this.analyzeExprFwd(rhs, preciseEnv, this.UNKNOWN, this.NULL_OR_UNDEFINED);
            } else if (rhsType.isNullOrUndef()) {
                lhsPair = this.analyzeExprFwd(lhs, preciseEnv, this.UNKNOWN, this.NULL_OR_UNDEFINED);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
            } else if (!this.NULL.isSubtypeOf(lhsType) && !this.UNDEFINED.isSubtypeOf(lhsType)) {
                rhsType = rhsType.removeType(this.NULL_OR_UNDEFINED);
                rhsPair = this.analyzeExprFwd(rhs, preciseEnv, this.UNKNOWN, rhsType);
            } else if (!this.NULL.isSubtypeOf(rhsType) && !this.UNDEFINED.isSubtypeOf(rhsType)) {
                lhsType = lhsType.removeType(this.NULL_OR_UNDEFINED);
                lhsPair = this.analyzeExprFwd(lhs, preciseEnv, this.UNKNOWN, lhsType);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
            }
        } else if (tokenType == Token.EQ && specializedType.isFalseOrFalsy() || tokenType == Token.NE && specializedType.isTrueOrTruthy()) {
            if (lhsType.isNullOrUndef()) {
                rhsType = rhsType.removeType(this.NULL_OR_UNDEFINED);
                rhsPair = this.analyzeExprFwd(rhs, preciseEnv, this.UNKNOWN, rhsType);
            } else if (rhsType.isNullOrUndef()) {
                lhsType = lhsType.removeType(this.NULL_OR_UNDEFINED);
                lhsPair = this.analyzeExprFwd(lhs, preciseEnv, this.UNKNOWN, lhsType);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
            }
        }
        rhsPair.type = this.BOOLEAN;
        return rhsPair;
    }

    private EnvTypePair analyzeObjLitFwd(Node objLit, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        if (NodeUtil.isEnumDecl(objLit.getParent())) {
            return this.analyzeEnumObjLitFwd(objLit, inEnv, requiredType);
        }
        JSDocInfo jsdoc = objLit.getJSDocInfo();
        boolean isStruct = jsdoc != null && jsdoc.makesStructs();
        boolean isDict = jsdoc != null && jsdoc.makesDicts();
        TypeEnv env = inEnv;
        JSType result = this.pickReqObjType(objLit);
        for (Node prop : objLit.children()) {
            JSType reqPtype;
            JSType specPtype;
            if (isStruct && prop.isQuotedString()) {
                this.warnings.add(JSError.make(prop, ILLEGAL_OBJLIT_KEY, "struct"));
            } else if (isDict && !prop.isQuotedString()) {
                this.warnings.add(JSError.make(prop, ILLEGAL_OBJLIT_KEY, "dict"));
            }
            if (prop.isGetterDef() || prop.isSetterDef()) {
                JSType propType;
                String specialPropName;
                String pname = NodeUtil.getObjectLitKeyName(prop);
                EnvTypePair pair = this.analyzeExprFwd(prop.getFirstChild(), env);
                FunctionType funType = pair.type.getFunType();
                Preconditions.checkNotNull((Object)funType);
                if (prop.isGetterDef()) {
                    specialPropName = this.commonTypes.createGetterPropName(pname);
                    propType = funType.getReturnType();
                } else {
                    specialPropName = this.commonTypes.createSetterPropName(pname);
                    propType = pair.type;
                }
                result = result.withProperty(new QualifiedName(specialPropName), propType);
                env = pair.env;
                continue;
            }
            Node pnameNode = NodeUtil.getObjectLitKeyNode(prop);
            if (pnameNode == null) {
                env = this.analyzeExprFwd((Node)prop, (TypeEnv)env).env;
                continue;
            }
            QualifiedName qname = new QualifiedName(pnameNode.getString());
            JSType jsdocType = (JSType)prop.getTypeI();
            if (jsdocType != null) {
                reqPtype = specPtype = jsdocType;
            } else if (requiredType.mayHaveProp(qname)) {
                reqPtype = specPtype = requiredType.getProp(qname);
                if (specializedType.mayHaveProp(qname)) {
                    specPtype = specializedType.getProp(qname);
                }
            } else {
                reqPtype = specPtype = this.UNKNOWN;
            }
            EnvTypePair pair = this.analyzeExprFwd(prop, env, reqPtype, specPtype);
            if (jsdocType != null) {
                result = result.withDeclaredProperty(qname, jsdocType, false);
                if (!pair.type.isSubtypeOf(jsdocType)) {
                    this.warnings.add(JSError.make(prop, INVALID_OBJLIT_PROPERTY_TYPE, NewTypeInference.errorMsgWithTypeDiff(jsdocType, pair.type)));
                    pair.type = jsdocType;
                }
            }
            result = result.withProperty(qname, pair.type);
            env = pair.env;
        }
        result = this.mayAdjustObjLitType(objLit, jsdoc, inEnv, result);
        return new EnvTypePair(env, result);
    }

    private JSType mayAdjustObjLitType(Node objLit, JSDocInfo jsdoc, TypeEnv env, JSType originalType) {
        JSType classType;
        Node parent = objLit.getParent();
        QualifiedName classqname = null;
        if (parent.isAssign() && NodeUtil.isPrototypeAssignment(parent.getFirstChild())) {
            classqname = QualifiedName.fromNode(parent.getFirstFirstChild());
        } else if (jsdoc != null && jsdoc.getLendsName() != null) {
            QualifiedName lendsQname = QualifiedName.fromQualifiedString(jsdoc.getLendsName());
            if (lendsQname.getRightmostName().equals("prototype")) {
                classqname = lendsQname.getAllButRightmost();
            }
        } else if (parent.isCall() && this.convention.getObjectLiteralCast(parent) != null) {
            CodingConvention.ObjectLiteralCast cast = this.convention.getObjectLiteralCast(parent);
            if (cast.typeName != null) {
                classqname = QualifiedName.fromQualifiedString(cast.typeName);
            }
        }
        if (classqname != null && (classType = NewTypeInference.envGetTypeOfQname(env, classqname)) != null) {
            JSType instance;
            FunctionType clazz = classType.getFunTypeIfSingletonObj();
            JSType jSType = instance = clazz == null ? null : clazz.getInstanceTypeOfCtor();
            if (instance != null) {
                return instance.getPrototypeObject();
            }
        }
        return originalType;
    }

    private EnvTypePair analyzeEnumObjLitFwd(Node objLit, TypeEnv inEnv, JSType requiredType) {
        if (objLit.getFirstChild() == null) {
            return new EnvTypePair(inEnv, requiredType);
        }
        String pname = NodeUtil.getObjectLitKeyName(objLit.getFirstChild());
        JSType enumeratedType = requiredType.getProp(new QualifiedName(pname)).getEnumeratedTypeOfEnumElement();
        if (enumeratedType == null) {
            return new EnvTypePair(inEnv, requiredType);
        }
        TypeEnv env = inEnv;
        for (Node prop : objLit.children()) {
            EnvTypePair pair = this.analyzeExprFwd(prop, env, enumeratedType);
            if (!pair.type.isSubtypeOf(enumeratedType)) {
                this.warnings.add(JSError.make(prop, INVALID_OBJLIT_PROPERTY_TYPE, NewTypeInference.errorMsgWithTypeDiff(enumeratedType, pair.type)));
            }
            env = pair.env;
        }
        return new EnvTypePair(env, requiredType);
    }

    private EnvTypePair analyzeTypePredicate(Node call, String typeHint, TypeEnv inEnv, JSType specializedType) {
        this.analyzeExprFwdIgnoreResult(call.getFirstChild(), inEnv);
        int numArgs = call.getChildCount() - 1;
        if (numArgs != 1) {
            this.warnings.add(JSError.make(call, WRONG_ARGUMENT_COUNT, call.getFirstChild().getQualifiedName(), Integer.toString(numArgs), "1", "1"));
            return this.analyzeInvocationArgsFwdWhenError(call, inEnv);
        }
        EnvTypePair pair = this.analyzeExprFwd(call.getLastChild(), inEnv);
        if (specializedType.isTrueOrTruthy() || specializedType.isFalseOrFalsy()) {
            pair = this.analyzeExprFwd(call.getLastChild(), inEnv, this.UNKNOWN, this.predicateTransformType(typeHint, specializedType, pair.type));
        }
        pair.type = this.BOOLEAN;
        return pair;
    }

    private EnvTypePair analyzeGoogTypeof(Node typeof, Node typeString, TypeEnv inEnv, JSType specializedType) {
        this.analyzeExprFwdIgnoreResult(typeString, inEnv);
        return this.analyzeTypePredicate(typeof, typeString.isString() ? typeString.getString() : "", inEnv, specializedType);
    }

    private EnvTypePair analyzePropertyTestCallFwd(Node call, TypeEnv inEnv, JSType specializedType) {
        this.analyzeExprFwdIgnoreResult(call.getFirstChild(), inEnv);
        return this.analyzeTypePredicate(call, call.getFirstChild().getLastChild().getString(), inEnv, specializedType);
    }

    private JSType predicateTransformType(String typeHint, JSType booleanContext, JSType beforeType) {
        switch (typeHint) {
            case "array": 
            case "isArray": {
                JSType arrayType = this.commonTypes.getArrayInstance();
                if (arrayType.isUnknown()) {
                    return this.UNKNOWN;
                }
                return booleanContext.isTrueOrTruthy() ? arrayType : beforeType.removeType(arrayType);
            }
            case "isArrayLike": {
                return this.TOP_OBJECT.withProperty(new QualifiedName("length"), this.NUMBER);
            }
            case "boolean": 
            case "isBoolean": {
                return booleanContext.isTrueOrTruthy() ? this.BOOLEAN : beforeType.removeType(this.BOOLEAN);
            }
            case "function": 
            case "isFunction": {
                return booleanContext.isTrueOrTruthy() ? this.commonTypes.looseTopFunction() : beforeType.removeType(this.commonTypes.topFunction());
            }
            case "null": 
            case "isNull": {
                return booleanContext.isTrueOrTruthy() ? this.NULL : beforeType.removeType(this.NULL);
            }
            case "number": 
            case "isNumber": {
                return booleanContext.isTrueOrTruthy() ? this.NUMBER : beforeType.removeType(this.NUMBER);
            }
            case "string": 
            case "isString": {
                return booleanContext.isTrueOrTruthy() ? this.STRING : beforeType.removeType(this.STRING);
            }
            case "isDef": {
                return booleanContext.isTrueOrTruthy() ? beforeType.removeType(this.UNDEFINED) : this.UNDEFINED;
            }
            case "isDefAndNotNull": {
                return booleanContext.isTrueOrTruthy() ? beforeType.removeType(this.NULL_OR_UNDEFINED) : this.NULL_OR_UNDEFINED;
            }
            case "isObject": {
                return booleanContext.isTrueOrTruthy() ? this.TOP_OBJECT : beforeType.removeType(this.TOP_OBJECT);
            }
            case "object": {
                return this.UNKNOWN;
            }
            case "undefined": {
                return booleanContext.isTrueOrTruthy() ? this.UNDEFINED : beforeType.removeType(this.UNDEFINED);
            }
        }
        return this.UNKNOWN;
    }

    private boolean tightenNameTypeAndDontWarn(String varName, Node n, JSType declared, JSType inferred, JSType required) {
        boolean isSpecializableTop = declared != null && declared.isTop() && (!inferred.isTop() || NodeUtil.isPropertyTest(this.compiler, n.getParent()));
        boolean fuzzyDeclaration = declared == null || declared.isUnknown();
        return !(!fuzzyDeclaration && !isSpecializableTop || varName != null && !this.currentScope.isFormalParam(varName) && !this.currentScope.isOuterVar(varName) || !required.isNonLooseSubtypeOf(inferred));
    }

    private boolean tightenPropertyTypeAndDontWarn(String recvName, Node propAccessNode, JSType recvType, JSType propDeclType, JSType propInferredType, JSType propRequiredType) {
        if (recvType != null && (recvType.isNamespace() || recvType.isPrototypeObject())) {
            return false;
        }
        boolean isSpecializableTop = propDeclType != null && propDeclType.isTop() && (!propInferredType.isTop() || NodeUtil.isPropertyTest(this.compiler, propAccessNode));
        boolean fuzzyDeclaration = propDeclType == null || propDeclType.isUnknown();
        return !(!fuzzyDeclaration && !isSpecializableTop || recvName != null && !this.currentScope.isFormalParam(recvName) && !this.currentScope.isOuterVar(recvName) || !propRequiredType.isNonLooseSubtypeOf(propInferredType));
    }

    private static String errorMsgWithTypeDiff(JSType expected, JSType found) {
        MismatchInfo mismatch = JSType.whyNotSubtypeOf(found, expected);
        ToStringContext ctx = ToStringContext.disambiguateTypeVars(expected, found);
        if (mismatch == null) {
            return "Expected : " + expected.toString(ctx) + "\nFound    : " + found.toString(ctx) + "\n";
        }
        StringBuilder builder = new StringBuilder("Expected : ").append(expected.toString(ctx)).append("\nFound    : ").append(found.toString(ctx)).append("\nMore details:\n");
        if (mismatch.isPropMismatch()) {
            builder.append("Incompatible types for property ").append(mismatch.getPropName()).append(".\nExpected : ").append(mismatch.getExpectedType().toString(ctx)).append("\nFound    : ").append(mismatch.getFoundType().toString(ctx));
        } else if (mismatch.isMissingProp()) {
            builder.append("The found type is missing property ").append(mismatch.getPropName());
        } else if (mismatch.wantedRequiredFoundOptional()) {
            builder.append("In found type, property ").append(mismatch.getPropName()).append(" is optional but should be required.");
        } else if (mismatch.isArgTypeMismatch()) {
            builder.append("The expected and found types are functions which have incompatible types for argument ").append(mismatch.getArgIndex() + 1).append(".\nExpected a supertype of : ").append(mismatch.getExpectedType().toString(ctx)).append("\nbut found               : ").append(mismatch.getFoundType().toString(ctx));
        } else if (mismatch.isRetTypeMismatch()) {
            builder.append("The expected and found types are functions which have incompatible return types.\nExpected a subtype of : ").append(mismatch.getExpectedType().toString(ctx)).append("\nbut found             : ").append(mismatch.getFoundType().toString(ctx));
        } else if (mismatch.isUnionTypeMismatch()) {
            builder.append("The found type is a union that includes an unexpected type: ").append(mismatch.getFoundType().toString(ctx));
        }
        return builder.toString();
    }

    private boolean mayWarnAboutNonObject(Node receiver, JSType recvType, JSType specializedType) {
        boolean mayNotBeAnObject;
        if (recvType.isBottom()) {
            return true;
        }
        boolean isNotAnObject = !JSType.haveCommonSubtype(recvType, this.TOP_OBJECT);
        boolean bl = mayNotBeAnObject = !recvType.isSubtypeOf(this.TOP_OBJECT);
        if (isNotAnObject || !specializedType.isTrueOrTruthy() && !specializedType.isFalseOrFalsy() && mayNotBeAnObject) {
            this.warnings.add(JSError.make(receiver, PROPERTY_ACCESS_ON_NONOBJECT, this.getPropNameForErrorMsg(receiver.getParent()), recvType.toString()));
            return true;
        }
        return false;
    }

    private String getPropNameForErrorMsg(Node propAccessNode) {
        Preconditions.checkArgument((propAccessNode.isGetProp() || propAccessNode.isGetElem() ? 1 : 0) != 0);
        Node propNode = propAccessNode.getLastChild();
        if (propNode.isString()) {
            return propNode.getString();
        }
        if (propNode.isQualifiedName()) {
            return "[" + propNode.getQualifiedName() + "]";
        }
        return "[unknown property]";
    }

    private boolean mayWarnAboutStructPropAccess(Node obj, JSType type) {
        if (type.mayBeStruct()) {
            this.warnings.add(JSError.make(obj, ILLEGAL_PROPERTY_ACCESS, "'[]'", "struct"));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutDictPropAccess(Node obj, JSType type) {
        if (type.mayBeDict()) {
            this.warnings.add(JSError.make(obj, ILLEGAL_PROPERTY_ACCESS, "'.'", "dict"));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutPropCreation(QualifiedName pname, Node getProp, JSType recvType) {
        Preconditions.checkArgument((boolean)getProp.isGetProp());
        if (recvType.isStructWithoutProp(pname)) {
            this.warnings.add(JSError.make(getProp, ILLEGAL_PROPERTY_CREATION, pname.toString()));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutInexistentProp(Node propAccessNode, JSType recvType, QualifiedName propQname) {
        Preconditions.checkState((propAccessNode.isGetProp() || propAccessNode.isGetElem() ? 1 : 0) != 0);
        String pname = propQname.toString();
        if (propAccessNode.isGetElem() || !recvType.isLoose() && recvType.hasProp(propQname)) {
            return false;
        }
        if (recvType.isUnknown() || recvType.isTrueOrTruthy() || recvType.isLoose() || this.allowPropertyOnSubtypes && (recvType.mayContainUnknownObject() || recvType.isIObject())) {
            if (this.symbolTable.isPropertyDefined(pname)) {
                return false;
            }
            this.warnings.add(JSError.make(propAccessNode, INEXISTENT_PROPERTY, pname, "any type in the program"));
            return true;
        }
        if (this.allowPropertyOnSubtypes && !recvType.isStruct() && recvType.isPropDefinedOnSubtype(propQname)) {
            return false;
        }
        String recvTypeAsString = recvType.toString();
        Node recv = propAccessNode.getFirstChild();
        String errorMsg = !recv.isQualifiedName() ? recvTypeAsString : (recvTypeAsString.length() > 100 ? recv.getQualifiedName() : recv.getQualifiedName() + " of type " + recvTypeAsString);
        DiagnosticType warningType = recvType.mayHaveProp(propQname) ? POSSIBLY_INEXISTENT_PROPERTY : INEXISTENT_PROPERTY;
        this.warnings.add(JSError.make(propAccessNode, warningType, pname, errorMsg));
        return true;
    }

    private boolean mayWarnAboutConst(Node n) {
        Node lhs = n.getFirstChild();
        if (lhs.isName() && this.currentScope.isConstVar(lhs.getString())) {
            this.warnings.add(JSError.make(n, CONST_REASSIGNED, new String[0]));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutConstProp(Node propAccess, JSType recvType, QualifiedName pname) {
        if (recvType.hasConstantProp(pname) && !propAccess.getBooleanProp((byte)77)) {
            this.warnings.add(JSError.make(propAccess, CONST_PROPERTY_REASSIGNED, new String[0]));
            return true;
        }
        return false;
    }

    private void mayWarnAboutGlobalThis(Node thisExpr) {
        Node parent;
        Preconditions.checkArgument((boolean)thisExpr.isThis());
        if (!(!this.currentScope.isTopLevel() && this.currentScope.hasThis() || !(parent = thisExpr.getParent()).isGetProp() && !parent.isGetElem() || NodeUtil.isCallOrNewArgument(this.currentScope.getRoot()))) {
            this.warnings.add(JSError.make(thisExpr, GLOBAL_THIS, new String[0]));
        }
    }

    private boolean mayWarnAboutBadIObjectIndex(Node n, JSType iobjectType, JSType foundIndexType, JSType requiredIndexType) {
        if (requiredIndexType.isBottom()) {
            this.warnings.add(JSError.make(n, BOTTOM_INDEX_TYPE, iobjectType.toString()));
            return true;
        }
        if (!foundIndexType.isSubtypeOf(requiredIndexType)) {
            this.warnings.add(JSError.make(n, INVALID_INDEX_TYPE, NewTypeInference.errorMsgWithTypeDiff(requiredIndexType, foundIndexType)));
            return true;
        }
        return false;
    }

    private JSType getIndexedTypeOrUnknown(JSType t) {
        JSType tmp = t.getIndexedType();
        return (JSType)MoreObjects.firstNonNull((Object)tmp, (Object)this.UNKNOWN);
    }

    private EnvTypePair analyzePropAccessFwd(Node receiver, String pname, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        QualifiedName getterPname;
        JSType recvSpecType;
        EnvTypePair pair;
        JSType recvReqType;
        QualifiedName propQname = new QualifiedName(pname);
        Node propAccessNode = receiver.getParent();
        JSType reqObjType = this.pickReqObjType(propAccessNode);
        if (NodeUtil.isPropertyTest(this.compiler, propAccessNode) && !specializedType.isFalseOrFalsy() || NodeUtil.isPropertyAbsenceTest(propAccessNode) && !specializedType.isTrueOrTruthy() || specializedType.isTrueOrTruthy()) {
            recvReqType = reqObjType;
            pair = this.analyzeExprFwd(receiver, inEnv, recvReqType);
            JSType subtypeWithProp = pair.type.findSubtypeWithProp(propQname);
            recvSpecType = subtypeWithProp.isBottom() ? reqObjType : subtypeWithProp;
            recvSpecType = specializedType.isTrueOrTruthy() ? recvSpecType.withLoose().withProperty(propQname, specializedType) : recvSpecType.withProperty(propQname, specializedType);
        } else if (specializedType.isFalseOrFalsy()) {
            recvReqType = recvSpecType = reqObjType;
        } else {
            recvReqType = reqObjType.withProperty(propQname, requiredType);
            recvSpecType = reqObjType.withProperty(propQname, specializedType);
        }
        pair = this.analyzeExprFwd(receiver, inEnv, recvReqType, recvSpecType);
        pair = this.mayWarnAboutNullableReferenceAndTighten(receiver, pair.type, recvSpecType, pair.env);
        JSType recvType = pair.type.autobox();
        if (recvType.isUnknown() || recvType.isTrueOrTruthy()) {
            this.mayWarnAboutInexistentProp(propAccessNode, recvType, propQname);
            return new EnvTypePair(pair.env, requiredType);
        }
        if (this.mayWarnAboutNonObject(receiver, recvType, specializedType)) {
            return new EnvTypePair(pair.env, requiredType);
        }
        FunctionType ft = recvType.getFunTypeIfSingletonObj();
        if (ft != null && (pname.equals("call") || pname.equals("apply"))) {
            if (ft.isAbstract()) {
                String funName = receiver.isQualifiedName() ? receiver.getQualifiedName() : "";
                this.warnings.add(JSError.make(propAccessNode, ABSTRACT_SUPER_METHOD_NOT_CALLABLE, funName));
            }
            return new EnvTypePair(pair.env, pname.equals("call") ? this.commonTypes.fromFunctionType(ft.transformByCallProperty()) : this.commonTypes.fromFunctionType(ft.transformByApplyProperty()));
        }
        if (this.convention.isSuperClassReference(pname) && ft != null && ft.isUniqueConstructor()) {
            JSType result = ft.getSuperPrototype();
            pair.type = (JSType)MoreObjects.firstNonNull((Object)result, (Object)this.UNDEFINED);
            return pair;
        }
        if (propAccessNode.isGetProp() && this.mayWarnAboutDictPropAccess(receiver, recvType)) {
            return new EnvTypePair(pair.env, requiredType);
        }
        if (recvType.isTop()) {
            recvType = this.TOP_OBJECT;
        }
        if (propAccessNode.getParent().isDelProp() && recvType.hasConstantProp(propQname)) {
            this.warnings.add(JSError.make(propAccessNode.getParent(), CONST_PROPERTY_DELETED, pname));
        }
        if (recvType.hasProp(getterPname = new QualifiedName(this.commonTypes.createGetterPropName(pname)))) {
            return new EnvTypePair(pair.env, recvType.getProp(getterPname));
        }
        JSType resultType = recvType.getProp(propQname);
        if (resultType != null && resultType.isBottom()) {
            this.warnings.add(JSError.make(propAccessNode, BOTTOM_PROP, pname, recvType.toString()));
            return new EnvTypePair(pair.env, this.UNKNOWN);
        }
        if (!(propAccessNode.getParent().isExprResult() || specializedType.isTrueOrTruthy() || specializedType.isFalseOrFalsy() || recvType.mayBeDict() || this.mayWarnAboutInexistentProp(propAccessNode, recvType, propQname) || !recvType.hasProp(propQname) || resultType.isSubtypeOf(requiredType) || !this.tightenPropertyTypeAndDontWarn(receiver.isName() ? receiver.getString() : null, propAccessNode, recvType, recvType.getDeclaredProp(propQname), resultType, requiredType))) {
            resultType = resultType.specialize(requiredType);
            LValueResultFwd lvr = this.analyzeLValueFwd(propAccessNode, inEnv, resultType);
            TypeEnv updatedEnv = this.updateLvalueTypeInEnv(lvr.env, propAccessNode, lvr.ptr, resultType);
            return new EnvTypePair(updatedEnv, resultType);
        }
        if (resultType == null) {
            resultType = this.UNKNOWN;
        }
        return new EnvTypePair(pair.env, resultType);
    }

    private TypeEnv updateLvalueTypeInEnv(TypeEnv env, Node lvalue, QualifiedName qname, JSType type) {
        Preconditions.checkNotNull((Object)type);
        switch (lvalue.getToken()) {
            case NAME: {
                return NewTypeInference.envPutType(env, lvalue.getString(), type);
            }
            case THIS: {
                JSType t = NewTypeInference.envGetType(env, THIS_ID);
                return t == null ? env : NewTypeInference.envPutType(env, THIS_ID, type);
            }
            case VAR: {
                Preconditions.checkState((lvalue.getParent().isForIn() || lvalue.getParent().isForOf() ? 1 : 0) != 0);
                return NewTypeInference.envPutType(env, lvalue.getFirstChild().getString(), type);
            }
            case GETPROP: 
            case GETELEM: {
                if (qname != null) {
                    String objName = qname.getLeftmostName();
                    QualifiedName props = qname.getAllButLeftmost();
                    JSType objType = NewTypeInference.envGetType(env, objName);
                    if (objType == null) {
                        Preconditions.checkState((boolean)objName.equals(THIS_ID));
                        return env;
                    }
                    env = NewTypeInference.envPutType(env, objName, objType.withProperty(props, type));
                }
                return env;
            }
        }
        return env;
    }

    private TypeEnv collectTypesForEscapedVarsFwd(Node n, TypeEnv env) {
        Preconditions.checkArgument((n.isFunction() || n.isName() && NodeUtil.isInvocationTarget(n) ? 1 : 0) != 0, (String)"Expected invovation target, found %s", (Object)n);
        String fnName = n.isFunction() ? this.symbolTable.getFunInternalName(n) : n.getString();
        NTIScope innerScope = this.currentScope.getScope(fnName);
        JSType summaryAsJstype = this.summaries.get(innerScope);
        if (summaryAsJstype == null) {
            Preconditions.checkState((NodeUtil.isUnannotatedCallback(n) || n.isFromExterns() ? 1 : 0) != 0);
            return env;
        }
        FunctionType summary = summaryAsJstype.getFunType();
        for (String freeVar : innerScope.getOuterVars()) {
            JSType innerType;
            if (innerScope.getDeclaredTypeOf(freeVar) != null) continue;
            JSType outerType = NewTypeInference.envGetType(env, freeVar);
            if (outerType == null) {
                outerType = this.UNKNOWN;
            }
            if (!(innerType = summary.getOuterVarPrecondition(freeVar)).isLoose() && (n.isName() || n.isFunction() && !outerType.isUndefined()) && !JSType.haveCommonSubtype(outerType, innerType)) {
                this.warnings.add(JSError.make(n, CROSS_SCOPE_GOTCHA, freeVar, outerType.toString(), innerType.toString()));
            }
            JSType freeVarType = n.isFunction() ? (!outerType.isNullOrUndef() && !outerType.isUnknown() && !innerType.isUnknown() && outerType.isSubtypeOf(innerType) ? outerType : JSType.join(innerType, outerType)) : innerType;
            env = NewTypeInference.envPutType(env, freeVar, freeVarType);
        }
        return env;
    }

    private EnvTypePair analyzeLooseCallNodeFwd(Node callNode, TypeEnv inEnv, JSType requiredType) {
        Preconditions.checkArgument((callNode.isCall() || callNode.isNew() ? 1 : 0) != 0);
        Node callee = callNode.getFirstChild();
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        TypeEnv tmpEnv = inEnv;
        for (Node arg = callee.getNext(); arg != null; arg = arg.getNext()) {
            EnvTypePair pair = this.analyzeExprFwd(arg, tmpEnv);
            tmpEnv = pair.env;
            builder.addReqFormal(pair.type);
        }
        JSType looseRetType = requiredType.isUnknown() ? this.BOTTOM : requiredType;
        JSType looseFunctionType = this.commonTypes.fromFunctionType(builder.addRetType(looseRetType).addLoose().buildFunction());
        EnvTypePair calleePair = this.analyzeExprFwd(callee, tmpEnv, this.commonTypes.topFunction(), looseFunctionType);
        FunctionType calleeType = calleePair.type.getFunType();
        JSType result = calleeType.getReturnType();
        return new EnvTypePair(calleePair.env, NewTypeInference.isImpreciseType(result) ? requiredType : result);
    }

    private static boolean isImpreciseType(JSType t) {
        return t.isBottom() || t.isTop() || t.isUnknown() || t.isUnion() || t.isTrueOrTruthy() || t.isFalseOrFalsy() || t.isLoose() || t.isNonClassyObject();
    }

    private EnvTypePair analyzeLooseCallNodeBwd(Node callNode, TypeEnv outEnv, JSType retType) {
        Preconditions.checkArgument((callNode.isCall() || callNode.isNew() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)retType);
        Node callee = callNode.getFirstChild();
        TypeEnv tmpEnv = outEnv;
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        Node target = callNode.getFirstChild();
        for (Node arg = callNode.getLastChild(); arg != target; arg = arg.getPrevious()) {
            EnvTypePair pair = this.analyzeExprBwd(arg, tmpEnv);
            JSType argType = pair.type;
            tmpEnv = pair.env;
            builder.addReqFormalToFront(NewTypeInference.isImpreciseType(argType) ? this.BOTTOM : argType);
        }
        JSType looseRetType = retType.isUnknown() ? this.BOTTOM : retType;
        JSType looseFunctionType = this.commonTypes.fromFunctionType(builder.addRetType(looseRetType).addLoose().buildFunction());
        NewTypeInference.println("loose function type is ", looseFunctionType);
        EnvTypePair calleePair = this.analyzeExprBwd(callee, tmpEnv, looseFunctionType);
        return new EnvTypePair(calleePair.env, retType);
    }

    private EnvTypePair analyzeExprBwd(Node expr, TypeEnv outEnv) {
        return this.analyzeExprBwd(expr, outEnv, this.UNKNOWN);
    }

    private EnvTypePair analyzeExprBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Preconditions.checkArgument((requiredType != null ? 1 : 0) != 0, (String)"Required type null at: %s", (Object)expr);
        Preconditions.checkArgument((!requiredType.isBottom() ? 1 : 0) != 0);
        switch (expr.getToken()) {
            case EMPTY: {
                return new EnvTypePair(outEnv, this.UNKNOWN);
            }
            case FUNCTION: {
                String fnName = this.symbolTable.getFunInternalName(expr);
                return new EnvTypePair(outEnv, NewTypeInference.envGetType(outEnv, fnName));
            }
            case FALSE: 
            case NULL: 
            case NUMBER: 
            case STRING: 
            case TRUE: {
                return new EnvTypePair(outEnv, this.scalarValueToType(expr.getToken()));
            }
            case OBJECTLIT: {
                return this.analyzeObjLitBwd(expr, outEnv, requiredType);
            }
            case THIS: {
                if (!this.currentScope.hasThis()) {
                    return new EnvTypePair(outEnv, this.UNKNOWN);
                }
                JSType thisType = this.currentScope.getDeclaredTypeOf(THIS_ID);
                return new EnvTypePair(outEnv, thisType);
            }
            case SUPER: {
                return new EnvTypePair(outEnv, this.UNKNOWN);
            }
            case NAME: {
                return this.analyzeNameBwd(expr, outEnv, requiredType);
            }
            case INC: 
            case DEC: 
            case BITNOT: 
            case NEG: {
                return this.analyzeExprBwd(expr.getFirstChild(), outEnv, this.NUMBER);
            }
            case POS: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = this.NUMBER;
                return pair;
            }
            case TYPEOF: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = this.STRING;
                return pair;
            }
            case INSTANCEOF: {
                TypeEnv env = this.analyzeExprBwd((Node)expr.getLastChild(), (TypeEnv)outEnv, (JSType)this.commonTypes.topFunction()).env;
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), env);
                pair.type = this.BOOLEAN;
                return pair;
            }
            case BITOR: 
            case BITAND: 
            case BITXOR: 
            case DIV: 
            case EXPONENT: 
            case LSH: 
            case MOD: 
            case MUL: 
            case RSH: 
            case SUB: 
            case URSH: {
                return this.analyzeBinaryNumericOpBwd(expr, outEnv);
            }
            case ADD: {
                return this.analyzeAddBwd(expr, outEnv, requiredType);
            }
            case AND: 
            case OR: {
                return this.analyzeLogicalOpBwd(expr, outEnv);
            }
            case SHEQ: 
            case SHNE: 
            case EQ: 
            case NE: {
                return this.analyzeEqNeBwd(expr, outEnv);
            }
            case LT: 
            case GT: 
            case LE: 
            case GE: {
                return this.analyzeLtGtBwd(expr, outEnv);
            }
            case ASSIGN: {
                return this.analyzeAssignBwd(expr, outEnv, requiredType);
            }
            case ASSIGN_ADD: {
                return this.analyzeAssignAddBwd(expr, outEnv, requiredType);
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_EXPONENT: {
                return this.analyzeAssignNumericOpBwd(expr, outEnv);
            }
            case GETPROP: {
                Preconditions.checkState((!NodeUtil.isAssignmentOp(expr.getParent()) || !NodeUtil.isLValue(expr) ? 1 : 0) != 0);
                if (expr.getBooleanProp((byte)76)) {
                    return new EnvTypePair(outEnv, requiredType);
                }
                return this.analyzePropAccessBwd(expr.getFirstChild(), expr.getLastChild().getString(), outEnv, requiredType);
            }
            case HOOK: {
                return this.analyzeHookBwd(expr, outEnv, requiredType);
            }
            case CALL: 
            case NEW: 
            case TAGGED_TEMPLATELIT: {
                return this.analyzeInvocationBwd(expr, outEnv, requiredType);
            }
            case COMMA: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getLastChild(), outEnv, requiredType);
                pair.env = this.analyzeExprBwd((Node)expr.getFirstChild(), (TypeEnv)pair.env).env;
                return pair;
            }
            case NOT: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = pair.type.negate();
                return pair;
            }
            case GETELEM: {
                return this.analyzeGetElemBwd(expr, outEnv, requiredType);
            }
            case VOID: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = this.UNDEFINED;
                return pair;
            }
            case IN: {
                return this.analyzeInBwd(expr, outEnv);
            }
            case DELPROP: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = this.BOOLEAN;
                return pair;
            }
            case VAR: {
                Node vdecl = expr.getFirstChild();
                String name = vdecl.getString();
                Preconditions.checkState((!vdecl.hasChildren() ? 1 : 0) != 0);
                return new EnvTypePair(NewTypeInference.envPutType(outEnv, name, this.UNKNOWN), this.UNKNOWN);
            }
            case REGEXP: {
                return new EnvTypePair(outEnv, this.commonTypes.getRegexpType());
            }
            case ARRAYLIT: {
                return this.analyzeArrayLitBwd(expr, outEnv);
            }
            case CAST: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = (JSType)expr.getTypeI();
                return pair;
            }
            case TEMPLATELIT: {
                return this.analyzeTemplateLitBwd(expr, outEnv);
            }
            case TEMPLATELIT_SUB: {
                return this.analyzeExprBwd(expr.getFirstChild(), outEnv, requiredType);
            }
            case STRING_KEY: {
                if (expr.hasChildren()) {
                    return this.analyzeExprBwd(expr.getFirstChild(), outEnv, requiredType);
                }
                return this.analyzeNameBwd(expr, outEnv, requiredType);
            }
            case MEMBER_FUNCTION_DEF: {
                return this.analyzeExprBwd(expr.getFirstChild(), outEnv, requiredType);
            }
            case COMPUTED_PROP: {
                TypeEnv env = this.analyzeExprBwd((Node)expr.getSecondChild(), (TypeEnv)outEnv).env;
                return this.analyzeExprBwd(expr.getFirstChild(), env);
            }
            case YIELD: {
                if (expr.hasChildren()) {
                    EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                    pair.type = this.UNKNOWN;
                    return pair;
                }
                return new EnvTypePair(outEnv, this.UNKNOWN);
            }
        }
        throw new RuntimeException("BWD: Unhandled expression type: " + (Object)((Object)expr.getToken()) + " with parent: " + expr.getParent());
    }

    private EnvTypePair analyzeNameBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        String varName = expr.getString();
        if (varName.equals("undefined")) {
            return new EnvTypePair(outEnv, this.UNDEFINED);
        }
        JSType inferredType = NewTypeInference.envGetType(outEnv, varName);
        NewTypeInference.println(varName, "'s inferredType: ", inferredType, " requiredType:  ", requiredType);
        if (inferredType == null) {
            return new EnvTypePair(outEnv, this.UNKNOWN);
        }
        JSType preciseType = inferredType.specialize(requiredType);
        if ((this.currentScope.isUndeclaredFormal(varName) || this.currentScope.isUndeclaredOuterVar(varName)) && preciseType.hasNonScalar()) {
            preciseType = preciseType.withLoose();
        }
        NewTypeInference.println(varName, "'s preciseType: ", preciseType);
        if (preciseType.isBottom()) {
            JSType declType = this.currentScope.getDeclaredTypeOf(varName);
            preciseType = (JSType)MoreObjects.firstNonNull((Object)declType, (Object)requiredType);
        }
        return EnvTypePair.addBinding(outEnv, varName, preciseType);
    }

    private EnvTypePair analyzeBinaryNumericOpBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        TypeEnv rhsEnv = this.analyzeExprBwd((Node)rhs, (TypeEnv)outEnv, (JSType)this.NUMBER).env;
        EnvTypePair pair = this.analyzeExprBwd(lhs, rhsEnv, this.NUMBER);
        pair.type = this.NUMBER;
        return pair;
    }

    private EnvTypePair analyzeAddBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType operandType = requiredType.isNumber() ? this.NUMBER : this.UNKNOWN;
        EnvTypePair rhsPair = this.analyzeExprBwd(rhs, outEnv, operandType);
        EnvTypePair lhsPair = this.analyzeExprBwd(lhs, rhsPair.env, operandType);
        lhsPair.type = JSType.plus(lhsPair.type, rhsPair.type);
        return lhsPair;
    }

    private EnvTypePair analyzeLogicalOpBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair rhsPair = this.analyzeExprBwd(rhs, outEnv);
        EnvTypePair lhsPair = this.analyzeExprBwd(lhs, outEnv);
        lhsPair.type = JSType.join(rhsPair.type, lhsPair.type);
        return lhsPair;
    }

    private EnvTypePair analyzeEqNeBwd(Node expr, TypeEnv outEnv) {
        TypeEnv rhsEnv = this.analyzeExprBwd((Node)expr.getLastChild(), (TypeEnv)outEnv).env;
        EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), rhsEnv);
        pair.type = this.BOOLEAN;
        return pair;
    }

    private EnvTypePair analyzeLtGtBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair rhsPair = this.analyzeExprBwd(rhs, outEnv);
        EnvTypePair lhsPair = this.analyzeExprBwd(lhs, rhsPair.env);
        JSType meetType = JSType.meet(lhsPair.type, rhsPair.type);
        if (meetType.isBottom()) {
            lhsPair.type = this.BOOLEAN;
            return lhsPair;
        }
        rhsPair = this.analyzeExprBwd(rhs, outEnv, meetType);
        lhsPair = this.analyzeExprBwd(lhs, rhsPair.env, meetType);
        lhsPair.type = this.BOOLEAN;
        return lhsPair;
    }

    private EnvTypePair analyzeAssignBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        if (expr.getBooleanProp((byte)76)) {
            return new EnvTypePair(outEnv, requiredType);
        }
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        if (lhs.getBooleanProp((byte)76)) {
            return this.analyzeExprBwd(rhs, outEnv, this.markAndGetTypeOfPreanalyzedNode(lhs, outEnv, false));
        }
        LValueResultBwd lvalue = this.analyzeLValueBwd(lhs, outEnv, requiredType, true);
        TypeEnv slicedEnv = lvalue.env;
        JSType rhsReqType = NewTypeInference.specializeKeep2ndWhenBottom(lvalue.type, requiredType);
        EnvTypePair pair = this.analyzeExprBwd(rhs, slicedEnv, rhsReqType);
        pair.env = this.analyzeLValueBwd((Node)lhs, (TypeEnv)pair.env, (JSType)requiredType, (boolean)true).env;
        return pair;
    }

    private EnvTypePair analyzeAssignAddBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType lhsReqType = NewTypeInference.specializeKeep2ndWhenBottom(requiredType, this.NUMBER_OR_STRING);
        LValueResultBwd lvalue = this.analyzeLValueBwd(lhs, outEnv, lhsReqType, false);
        JSType rhsReqType = lvalue.type.isNumber() ? this.NUMBER : this.NUMBER_OR_STRING;
        EnvTypePair pair = this.analyzeExprBwd(rhs, outEnv, rhsReqType);
        pair.env = this.analyzeLValueBwd((Node)lhs, (TypeEnv)pair.env, (JSType)lhsReqType, (boolean)false).env;
        return pair;
    }

    private EnvTypePair analyzeAssignNumericOpBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair pair = this.analyzeExprBwd(rhs, outEnv, this.NUMBER);
        LValueResultBwd lvalue = this.analyzeLValueBwd(lhs, pair.env, this.NUMBER, false);
        return new EnvTypePair(lvalue.env, this.NUMBER);
    }

    private EnvTypePair analyzeHookBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Node cond = expr.getFirstChild();
        Node thenBranch = cond.getNext();
        Node elseBranch = thenBranch.getNext();
        EnvTypePair thenPair = this.analyzeExprBwd(thenBranch, outEnv, requiredType);
        EnvTypePair elsePair = this.analyzeExprBwd(elseBranch, outEnv, requiredType);
        return this.analyzeExprBwd(cond, TypeEnv.join(thenPair.env, elsePair.env));
    }

    private EnvTypePair analyzeInvocationBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        int numArgs;
        Preconditions.checkArgument((expr.isNew() || expr.isCall() || expr.isTaggedTemplateLit() ? 1 : 0) != 0);
        Node callee = expr.getFirstChild();
        EnvTypePair pair = this.analyzeExprBwd(callee, outEnv, this.commonTypes.topFunction());
        TypeEnv envAfterCallee = pair.env;
        FunctionType funType = pair.type.getFunType();
        if (funType == null) {
            return this.analyzeInvocationArgumentsBwd(expr, expr.getFirstChild(), envAfterCallee);
        }
        if (funType.isLoose()) {
            return this.analyzeLooseCallNodeBwd(expr, envAfterCallee, requiredType);
        }
        if (expr.isCall() && funType.isSomeConstructorOrInterface() || expr.isNew() && !funType.isSomeConstructorOrInterface()) {
            return this.analyzeInvocationArgumentsBwd(expr, expr.getFirstChild(), envAfterCallee);
        }
        if (funType.isTopFunction()) {
            return this.analyzeInvocationArgumentsBwd(expr, expr.getFirstChild(), envAfterCallee);
        }
        if (callee.isName() && !funType.isGeneric() && (expr.isCall() || expr.isTaggedTemplateLit())) {
            this.createDeferredCheckBwd(expr, requiredType);
        }
        if ((numArgs = NodeUtil.getInvocationArgsCount(expr)) < funType.getMinArity() || numArgs > funType.getMaxArity()) {
            if (expr.isTaggedTemplateLit()) {
                return this.analyzeInvocationArgumentsBwd(expr.getLastChild(), null, envAfterCallee);
            }
            return this.analyzeInvocationArgumentsBwd(expr, expr.getFirstChild(), envAfterCallee);
        }
        if (funType.isGeneric()) {
            ImmutableMap<String, JSType> typeMap = this.calcTypeInstantiationBwd(expr, funType, envAfterCallee);
            funType = funType.instantiateGenerics((Map<String, JSType>)typeMap);
        }
        TypeEnv tmpEnv = envAfterCallee;
        Node target = expr.isTaggedTemplateLit() ? null : expr.getFirstChild();
        Node start = expr.isTaggedTemplateLit() ? expr.getLastChild().getLastChild() : expr.getLastChild();
        int i = numArgs;
        for (Node arg = start; arg != target; arg = arg.getPrevious()) {
            if (expr.isTaggedTemplateLit() && !arg.isTemplateLitSub()) continue;
            JSType formalType = funType.getFormalType(--i);
            formalType = NewTypeInference.firstNonBottom(formalType, this.UNKNOWN);
            tmpEnv = this.analyzeExprBwd((Node)arg, (TypeEnv)tmpEnv, (JSType)formalType).env;
        }
        JSType retType = expr.isNew() ? funType.getThisType() : funType.getReturnType();
        return new EnvTypePair(tmpEnv, retType);
    }

    private EnvTypePair analyzeGetElemBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Node receiver = expr.getFirstChild();
        Node index = expr.getLastChild();
        JSType reqObjType = this.pickReqObjType(expr);
        EnvTypePair pair = this.analyzeExprBwd(receiver, outEnv, reqObjType);
        JSType recvType = pair.type;
        JSType indexType = recvType.getIndexType();
        if (indexType != null) {
            indexType = NewTypeInference.firstNonBottom(indexType, this.UNKNOWN);
            pair = this.analyzeExprBwd(index, pair.env, indexType);
            pair.type = this.getIndexedTypeOrUnknown(recvType);
            return pair;
        }
        if (index.isString()) {
            return this.analyzePropAccessBwd(receiver, index.getString(), outEnv, requiredType);
        }
        pair = this.analyzeExprBwd(index, outEnv);
        pair = this.analyzeExprBwd(receiver, pair.env, reqObjType);
        pair.type = requiredType;
        return pair;
    }

    private EnvTypePair analyzeInBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair pair = this.analyzeExprBwd(rhs, outEnv, this.pickReqObjType(expr));
        pair = this.analyzeExprBwd(lhs, pair.env, this.NUMBER_OR_STRING);
        pair.type = this.BOOLEAN;
        return pair;
    }

    private EnvTypePair analyzeArrayLitBwd(Node expr, TypeEnv outEnv) {
        TypeEnv env = outEnv;
        JSType elementType = this.BOTTOM;
        for (Node elm = expr.getLastChild(); elm != null; elm = elm.getPrevious()) {
            EnvTypePair pair = this.analyzeExprBwd(elm, env);
            env = pair.env;
            elementType = JSType.join(elementType, pair.type);
        }
        elementType = NewTypeInference.firstNonBottom(elementType, this.UNKNOWN);
        return new EnvTypePair(env, this.commonTypes.getArrayInstance(elementType));
    }

    private EnvTypePair analyzeInvocationArgumentsBwd(Node callNode, Node target, TypeEnv outEnv) {
        TypeEnv env = outEnv;
        for (Node arg = callNode.getLastChild(); arg != target; arg = arg.getPrevious()) {
            env = this.analyzeExprBwd((Node)arg, (TypeEnv)env).env;
        }
        return new EnvTypePair(env, this.UNKNOWN);
    }

    private EnvTypePair analyzeTemplateLitBwd(Node expr, TypeEnv outEnv) {
        TypeEnv env = outEnv;
        for (Node elm = expr.getLastChild(); elm != null; elm = elm.getPrevious()) {
            env = this.analyzeExprBwd((Node)elm, (TypeEnv)env).env;
        }
        return new EnvTypePair(env, this.STRING);
    }

    private void createDeferredCheckBwd(Node expr, JSType requiredType) {
        Preconditions.checkArgument((expr.isCall() || expr.isTaggedTemplateLit() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)expr.getFirstChild().isName());
        String calleeName = expr.getFirstChild().getString();
        if (this.currentScope.isKnownFunction(calleeName) && !this.currentScope.isLocalFunDef(calleeName) && !this.currentScope.isExternalFunction(calleeName)) {
            NTIScope s = this.currentScope.getScope(calleeName);
            JSType expectedRetType = s.getDeclaredFunctionType().getReturnType() == null ? requiredType : null;
            NewTypeInference.println("Putting deferred check of function: ", calleeName, " with ret: ", expectedRetType);
            DeferredCheck dc = new DeferredCheck(expr, expectedRetType, this.currentScope, s);
            this.deferredChecks.put(expr, dc);
        }
    }

    private EnvTypePair analyzePropAccessBwd(Node receiver, String pname, TypeEnv outEnv, JSType requiredType) {
        JSType propAccessType;
        Node propAccessNode = receiver.getParent();
        QualifiedName qname = new QualifiedName(pname);
        JSType reqObjType = this.pickReqObjType(propAccessNode);
        if (!NodeUtil.isPropertyTest(this.compiler, propAccessNode)) {
            reqObjType = reqObjType.withProperty(qname, requiredType);
        }
        EnvTypePair pair = this.analyzeExprBwd(receiver, outEnv, reqObjType);
        JSType receiverType = pair.type;
        pair.type = propAccessType = receiverType.mayHaveProp(qname) ? receiverType.getProp(qname) : requiredType;
        return pair;
    }

    private EnvTypePair analyzeObjLitBwd(Node objLit, TypeEnv outEnv, JSType requiredType) {
        if (NodeUtil.isEnumDecl(objLit.getParent())) {
            return this.analyzeEnumObjLitBwd(objLit, outEnv, requiredType);
        }
        TypeEnv env = outEnv;
        JSType result = this.pickReqObjType(objLit);
        for (Node prop = objLit.getLastChild(); prop != null; prop = prop.getPrevious()) {
            if (prop.isGetterDef() || prop.isSetterDef()) {
                env = this.analyzeExprBwd((Node)prop.getFirstChild(), (TypeEnv)env).env;
                continue;
            }
            if (prop.isComputedProp() && !prop.getFirstChild().isString()) {
                env = this.analyzeExprBwd((Node)prop, (TypeEnv)env).env;
                continue;
            }
            QualifiedName pname = new QualifiedName(NodeUtil.getObjectLitKeyName(prop));
            JSType jsdocType = (JSType)prop.getTypeI();
            JSType reqPtype = jsdocType != null ? jsdocType : (requiredType.mayHaveProp(pname) ? requiredType.getProp(pname) : this.UNKNOWN);
            EnvTypePair pair = this.analyzeExprBwd(prop, env, reqPtype);
            result = result.withProperty(pname, pair.type);
            env = pair.env;
        }
        return new EnvTypePair(env, result);
    }

    private EnvTypePair analyzeEnumObjLitBwd(Node objLit, TypeEnv outEnv, JSType requiredType) {
        if (objLit.getFirstChild() == null) {
            return new EnvTypePair(outEnv, requiredType);
        }
        String pname = NodeUtil.getObjectLitKeyName(objLit.getFirstChild());
        JSType enumeratedType = requiredType.getProp(new QualifiedName(pname)).getEnumeratedTypeOfEnumElement();
        if (enumeratedType == null) {
            return new EnvTypePair(outEnv, requiredType);
        }
        TypeEnv env = outEnv;
        for (Node prop = objLit.getLastChild(); prop != null; prop = prop.getPrevious()) {
            env = this.analyzeExprBwd((Node)prop, (TypeEnv)env, (JSType)enumeratedType).env;
        }
        return new EnvTypePair(env, requiredType);
    }

    private boolean isPropertyTestCall(Node expr) {
        if (!expr.isCall()) {
            return false;
        }
        return expr.getFirstChild().isQualifiedName() && this.convention.isPropertyTestFunction(expr);
    }

    private boolean isFunctionBind(Node callee, TypeEnv env, boolean isFwd) {
        JSType recvType;
        if (NodeUtil.isFunctionBind(callee)) {
            if (isFwd) {
                this.analyzeExprFwdIgnoreResult(callee, env);
            }
            return true;
        }
        if (!(callee.isGetProp() && callee.isQualifiedName() && callee.getLastChild().getString().equals("bind"))) {
            return false;
        }
        Node recv = callee.getFirstChild();
        if (isFwd) {
            recvType = this.analyzeExprFwd((Node)recv, (TypeEnv)env).type;
            this.maybeSetTypeI(callee, recvType.getProp(new QualifiedName("bind")));
        } else {
            recvType = this.analyzeExprBwd((Node)recv, (TypeEnv)env).type;
        }
        return !recvType.isUnknown() && recvType.isSubtypeOf(this.commonTypes.topFunction());
    }

    private boolean isGoogTypeof(Node expr) {
        if (!expr.isCall()) {
            return false;
        }
        return (expr = expr.getFirstChild()).isGetProp() && expr.getFirstChild().isName() && expr.getFirstChild().getString().equals("goog") && expr.getLastChild().getString().equals("typeOf");
    }

    private JSType scalarValueToType(Token token) {
        switch (token) {
            case NUMBER: {
                return this.NUMBER;
            }
            case STRING: {
                return this.STRING;
            }
            case TRUE: {
                return this.TRUE_TYPE;
            }
            case FALSE: {
                return this.FALSE_TYPE;
            }
            case NULL: {
                return this.NULL;
            }
        }
        throw new RuntimeException("The token isn't a scalar value " + (Object)((Object)token));
    }

    private void warnInvalidOperand(Node expr, Token operatorType, Object expected, Object actual) {
        Preconditions.checkArgument((expected instanceof String || expected instanceof JSType ? 1 : 0) != 0);
        Preconditions.checkArgument((actual instanceof String || actual instanceof JSType ? 1 : 0) != 0);
        if (expected instanceof JSType && actual instanceof JSType) {
            this.warnings.add(JSError.make(expr, INVALID_OPERAND_TYPE, operatorType.toString(), NewTypeInference.errorMsgWithTypeDiff((JSType)expected, (JSType)actual)));
        } else {
            this.warnings.add(JSError.make(expr, INVALID_OPERAND_TYPE, operatorType.toString(), "Expected : " + expected + "\nFound    : " + actual + "\n"));
        }
    }

    private static JSType envGetType(TypeEnv env, String pname) {
        Preconditions.checkArgument((!pname.contains(".") ? 1 : 0) != 0, (Object)pname);
        return env.getType(pname);
    }

    private static JSType envGetTypeOfQname(TypeEnv env, QualifiedName qname) {
        JSType leftmostType = NewTypeInference.envGetType(env, qname.getLeftmostName());
        if (qname.isIdentifier()) {
            return leftmostType;
        }
        return leftmostType == null ? null : leftmostType.getProp(qname.getAllButLeftmost());
    }

    private static TypeEnv envPutType(TypeEnv env, String varName, JSType type) {
        Preconditions.checkArgument((!varName.contains(".") ? 1 : 0) != 0);
        return env.putType(varName, type);
    }

    private JSType markAndGetTypeOfPreanalyzedNode(Node n, TypeEnv env, boolean isFwd) {
        switch (n.getToken()) {
            case THIS: 
            case NAME: {
                JSType result = NewTypeInference.envGetType(env, n.isThis() ? THIS_ID : n.getString());
                Preconditions.checkNotNull((Object)result, (String)"Null declared type at node: %s", (Object)n);
                if (isFwd) {
                    this.maybeSetTypeI(n, result);
                }
                return result;
            }
            case GETPROP: {
                JSType recvType = this.markAndGetTypeOfPreanalyzedNode(n.getFirstChild(), env, isFwd);
                String pname = n.getLastChild().getString();
                JSType result = null;
                if (recvType.isSubtypeOf(this.TOP_OBJECT)) {
                    result = recvType.getProp(new QualifiedName(pname));
                }
                if (result == null) {
                    this.warnings.add(JSError.make(n, UNKNOWN_NAMESPACE_PROPERTY, n.getQualifiedName()));
                    return this.UNKNOWN;
                }
                Preconditions.checkNotNull(result, (String)"Null declared type@%s", (Object)n);
                if (isFwd) {
                    this.maybeSetTypeI(n, result);
                }
                return result;
            }
        }
        Node assign = n.getParent();
        Preconditions.checkState((assign.isAssign() && assign.getLastChild() == n ? 1 : 0) != 0, (String)"Expected assign but found %s", (Object)assign);
        JSType lhsType = (JSType)Preconditions.checkNotNull((Object)((JSType)assign.getFirstChild().getTypeI()));
        this.maybeSetTypeI(n, lhsType);
        return lhsType;
    }

    private void maybeSetTypeI(Node n, JSType t) {
        TypeI oldType = n.getTypeI();
        Preconditions.checkState((oldType == null || oldType instanceof JSType ? 1 : 0) != 0);
        if (oldType == null) {
            n.setTypeI(t);
        }
    }

    private LValueResultFwd analyzeLValueFwd(Node expr, TypeEnv inEnv, JSType type) {
        return this.analyzeLValueFwd(expr, inEnv, type, false);
    }

    private LValueResultFwd analyzeLValueFwd(Node expr, TypeEnv inEnv, JSType requiredType, boolean insideQualifiedName) {
        LValueResultFwd lvalResult = null;
        switch (expr.getToken()) {
            case THIS: {
                this.mayWarnAboutGlobalThis(expr);
                if (this.currentScope.hasThis()) {
                    lvalResult = new LValueResultFwd(inEnv, NewTypeInference.envGetType(inEnv, THIS_ID), this.currentScope.getDeclaredTypeOf(THIS_ID), new QualifiedName(THIS_ID));
                    break;
                }
                lvalResult = new LValueResultFwd(inEnv, this.UNKNOWN, null, null);
                break;
            }
            case NAME: {
                String varName = expr.getString();
                JSType varType = this.analyzeExprFwd((Node)expr, (TypeEnv)inEnv).type;
                lvalResult = new LValueResultFwd(inEnv, varType, this.currentScope.getDeclaredTypeOf(varName), varType.hasNonScalar() ? new QualifiedName(varName) : null);
                break;
            }
            case GETPROP: 
            case GETELEM: {
                Node obj = expr.getFirstChild();
                Node prop = expr.getLastChild();
                QualifiedName pname = expr.isGetProp() || prop.isString() ? new QualifiedName(prop.getString()) : null;
                LValueResultFwd recvLvalue = this.analyzeReceiverLvalFwd(obj, pname, inEnv, requiredType);
                if (!recvLvalue.type.isSubtypeOf(this.TOP_OBJECT)) {
                    EnvTypePair pair = this.analyzeExprFwd(prop, recvLvalue.env, requiredType);
                    lvalResult = new LValueResultFwd(pair.env, requiredType, null, null);
                    break;
                }
                JSType indexType = recvLvalue.type.getIndexType();
                if (expr.isGetElem() && indexType != null) {
                    lvalResult = this.analyzeIObjectElmLvalFwd(prop, recvLvalue, indexType);
                    break;
                }
                if (expr.isGetProp() || prop.isString()) {
                    lvalResult = this.analyzePropLValFwd(obj, pname, recvLvalue, requiredType, insideQualifiedName);
                    break;
                }
                EnvTypePair pair = this.analyzeExprFwd(expr, recvLvalue.env, requiredType);
                lvalResult = new LValueResultFwd(pair.env, pair.type, null, null);
                break;
            }
            case VAR: {
                Preconditions.checkState((expr.getParent().isForIn() || expr.getParent().isForOf() ? 1 : 0) != 0);
                Node nameNode = expr.getFirstChild();
                String name = nameNode.getString();
                Preconditions.checkState((!nameNode.hasChildren() ? 1 : 0) != 0);
                this.maybeSetTypeI(nameNode, requiredType);
                if (expr.getParent().isForIn()) {
                    return new LValueResultFwd(inEnv, this.STRING, null, new QualifiedName(name));
                }
                JSType declType = this.currentScope.getDeclaredTypeOf(name);
                return new LValueResultFwd(inEnv, requiredType, declType, new QualifiedName(name));
            }
            default: {
                Preconditions.checkState((boolean)insideQualifiedName);
                EnvTypePair pair = this.analyzeExprFwd(expr, inEnv, requiredType);
                return new LValueResultFwd(pair.env, pair.type, null, null);
            }
        }
        this.maybeSetTypeI(expr, lvalResult.type);
        this.mayWarnAboutUnknownType(expr, lvalResult.type);
        return lvalResult;
    }

    private LValueResultFwd analyzeIObjectElmLvalFwd(Node prop, LValueResultFwd recvLvalue, JSType indexType) {
        EnvTypePair pair = this.analyzeExprFwd(prop, recvLvalue.env, NewTypeInference.firstNonBottom(indexType, this.UNKNOWN));
        if (this.mayWarnAboutBadIObjectIndex(prop, recvLvalue.type, pair.type, indexType)) {
            return new LValueResultFwd(pair.env, this.UNKNOWN, null, null);
        }
        JSType inferred = this.getIndexedTypeOrUnknown(recvLvalue.type);
        JSType declared = null;
        if (recvLvalue.declType != null) {
            JSType receiverAdjustedDeclType = recvLvalue.declType.removeType(this.NULL_OR_UNDEFINED);
            declared = receiverAdjustedDeclType.getIndexedType();
        }
        return new LValueResultFwd(pair.env, inferred, declared, null);
    }

    private EnvTypePair mayWarnAboutNullableReferenceAndTighten(Node obj, JSType recvType, JSType maybeSpecType, TypeEnv inEnv) {
        JSType minusNull;
        if (!(recvType.isUnknown() || recvType.isTop() || !this.NULL.isSubtypeOf(recvType) && !this.UNDEFINED.isSubtypeOf(recvType) || (minusNull = recvType.removeType(this.NULL_OR_UNDEFINED)).isBottom())) {
            if (this.reportNullDeref) {
                this.warnings.add(JSError.make(obj, NULLABLE_DEREFERENCE, recvType.toString()));
            }
            TypeEnv outEnv = inEnv;
            if (obj.isQualifiedName()) {
                QualifiedName qname = QualifiedName.fromNode(obj);
                if (maybeSpecType != null && maybeSpecType.isSubtypeOf(minusNull)) {
                    minusNull = maybeSpecType;
                }
                outEnv = this.updateLvalueTypeInEnv(inEnv, obj, qname, minusNull);
            }
            return new EnvTypePair(outEnv, minusNull);
        }
        return new EnvTypePair(inEnv, recvType);
    }

    private LValueResultFwd analyzePropLValFwd(Node obj, QualifiedName pname, LValueResultFwd recvLvalue, JSType requiredType, boolean insideQualifiedName) {
        Node propAccessNode;
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        TypeEnv inEnv = recvLvalue.env;
        JSType recvType = recvLvalue.type;
        if (!recvType.isUnion() && !recvType.isSingletonObj()) {
            recvType = this.TOP_OBJECT.withLoose();
        }
        if ((propAccessNode = obj.getParent()).isGetProp() && propAccessNode.getParent().isAssign() && this.mayWarnAboutPropCreation(pname, propAccessNode, recvType)) {
            return new LValueResultFwd(inEnv, requiredType, null, null);
        }
        if (!insideQualifiedName && this.mayWarnAboutConstProp(propAccessNode, recvType, pname)) {
            return new LValueResultFwd(inEnv, requiredType, null, null);
        }
        if (!recvType.hasProp(pname)) {
            if (insideQualifiedName || !propAccessNode.getParent().isAssign()) {
                this.mayWarnAboutInexistentProp(propAccessNode, recvType, pname);
                if (!recvType.isLoose()) {
                    return new LValueResultFwd(inEnv, requiredType, null, null);
                }
            }
            if (recvType.isLoose()) {
                recvType = recvType.withProperty(pname, this.UNKNOWN);
                inEnv = this.updateLvalueTypeInEnv(inEnv, obj, recvLvalue.ptr, recvType);
            }
        }
        if (propAccessNode.isGetElem()) {
            this.mayWarnAboutStructPropAccess(obj, recvType);
        } else if (propAccessNode.isGetProp()) {
            this.mayWarnAboutDictPropAccess(obj, recvType);
        }
        QualifiedName setterPname = new QualifiedName(this.commonTypes.createSetterPropName(pname.getLeftmostName()));
        if (recvType.hasProp(setterPname)) {
            FunctionType funType = recvType.getProp(setterPname).getFunType();
            Preconditions.checkNotNull((Object)funType, (String)"recvType=%s, setterPname=%s", (Object)recvType, (Object)setterPname);
            JSType formalType = funType.getFormalType(0);
            Preconditions.checkState((!formalType.isBottom() ? 1 : 0) != 0);
            return new LValueResultFwd(inEnv, formalType, formalType, null);
        }
        QualifiedName ptr = recvLvalue.ptr == null ? null : QualifiedName.join(recvLvalue.ptr, pname);
        return recvType.mayHaveProp(pname) ? new LValueResultFwd(inEnv, recvType.getProp(pname), recvType.getDeclaredProp(pname), ptr) : new LValueResultFwd(inEnv, this.UNKNOWN, null, ptr);
    }

    private LValueResultFwd analyzeReceiverLvalFwd(Node obj, QualifiedName pname, TypeEnv inEnv, JSType propType) {
        Preconditions.checkArgument((pname == null || pname.isIdentifier() ? 1 : 0) != 0);
        JSType reqObjType = this.pickReqObjType(obj.getParent());
        if (pname != null) {
            reqObjType = reqObjType.withProperty(pname, propType);
        }
        LValueResultFwd lvalue = this.analyzeLValueFwd(obj, inEnv, reqObjType, true);
        EnvTypePair pair = this.mayWarnAboutNullableReferenceAndTighten(obj, lvalue.type, null, lvalue.env);
        JSType lvalueType = pair.type;
        if (lvalueType.isEnumElement()) {
            lvalueType = lvalueType.getEnumeratedTypeOfEnumElement();
        }
        if (!lvalueType.isSubtypeOf(this.TOP_OBJECT)) {
            this.warnings.add(JSError.make(obj, ADDING_PROPERTY_TO_NON_OBJECT, this.getPropNameForErrorMsg(obj.getParent()), lvalueType.toString()));
        }
        lvalue.type = lvalueType;
        lvalue.env = pair.env;
        return lvalue;
    }

    private boolean isGlobalVariable(Node maybeName, TypeEnv env) {
        return maybeName.isName() && NewTypeInference.envGetType(env, maybeName.getString()) == null;
    }

    private LValueResultBwd analyzeLValueBwd(Node expr, TypeEnv outEnv, JSType type, boolean doSlicing) {
        return this.analyzeLValueBwd(expr, outEnv, type, doSlicing, false);
    }

    private LValueResultBwd analyzeLValueBwd(Node expr, TypeEnv outEnv, JSType type, boolean doSlicing, boolean insideQualifiedName) {
        switch (expr.getToken()) {
            case THIS: 
            case NAME: {
                EnvTypePair pair = this.analyzeExprBwd(expr, outEnv, type);
                String name = expr.getQualifiedName();
                JSType declType = this.currentScope.getDeclaredTypeOf(name);
                if (doSlicing && !this.isGlobalVariable(expr, outEnv)) {
                    pair.env = NewTypeInference.envPutType(pair.env, name, (JSType)MoreObjects.firstNonNull((Object)declType, (Object)this.UNKNOWN));
                }
                return new LValueResultBwd(pair.env, pair.type, pair.type.hasNonScalar() ? new QualifiedName(name) : null);
            }
            case GETPROP: {
                Node obj = expr.getFirstChild();
                QualifiedName pname = new QualifiedName(expr.getLastChild().getString());
                return this.analyzePropLValBwd(obj, pname, outEnv, type, doSlicing);
            }
            case GETELEM: {
                if (expr.getLastChild().isString()) {
                    Node obj = expr.getFirstChild();
                    QualifiedName pname = new QualifiedName(expr.getLastChild().getString());
                    return this.analyzePropLValBwd(obj, pname, outEnv, type, doSlicing);
                }
                EnvTypePair pair = this.analyzeExprBwd(expr, outEnv, type);
                return new LValueResultBwd(pair.env, pair.type, null);
            }
        }
        Preconditions.checkState((boolean)insideQualifiedName);
        EnvTypePair pair = this.analyzeExprBwd(expr, outEnv, type);
        return new LValueResultBwd(pair.env, pair.type, null);
    }

    private LValueResultBwd analyzePropLValBwd(Node obj, QualifiedName pname, TypeEnv outEnv, JSType type, boolean doSlicing) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        JSType reqObjType = this.pickReqObjType(obj.getParent()).withProperty(pname, type);
        LValueResultBwd lvalue = this.analyzeLValueBwd(obj, outEnv, reqObjType, false, true);
        if (lvalue.ptr != null) {
            lvalue.ptr = QualifiedName.join(lvalue.ptr, pname);
            if (doSlicing) {
                String objName = lvalue.ptr.getLeftmostName();
                QualifiedName props = lvalue.ptr.getAllButLeftmost();
                JSType objType = NewTypeInference.envGetType(lvalue.env, objName);
                JSType slicedObjType = objType.withoutProperty(props);
                lvalue.env = NewTypeInference.envPutType(lvalue.env, objName, slicedObjType);
            }
        }
        lvalue.type = lvalue.type.mayHaveProp(pname) ? lvalue.type.getProp(pname) : this.UNKNOWN;
        return lvalue;
    }

    private JSType pickReqObjType(Node expr) {
        Token exprKind = expr.getToken();
        switch (exprKind) {
            case OBJECTLIT: {
                JSDocInfo jsdoc = expr.getJSDocInfo();
                if (jsdoc != null && jsdoc.makesStructs()) {
                    return this.commonTypes.getTopStruct();
                }
                if (jsdoc != null && jsdoc.makesDicts()) {
                    return this.commonTypes.getTopDict();
                }
                return this.commonTypes.getEmptyObjectLiteral();
            }
            case FOR: 
            case FOR_IN: {
                Preconditions.checkState((boolean)expr.isForIn());
                return this.TOP_OBJECT;
            }
            case FOR_OF: {
                Preconditions.checkState((boolean)expr.isForOf());
                return this.commonTypes.getIterableInstance(this.UNKNOWN);
            }
            case GETPROP: 
            case GETELEM: 
            case IN: {
                return this.TOP_OBJECT;
            }
        }
        throw new RuntimeException("Unhandled node for pickReqObjType: " + (Object)((Object)exprKind));
    }

    private static String getReadableCalleeName(Node expr) {
        return expr.isQualifiedName() ? expr.getQualifiedName() : "";
    }

    private static JSType specializeKeep2ndWhenBottom(JSType toBeSpecialized, JSType fallback) {
        JSType specializedType = toBeSpecialized.specialize(fallback);
        return specializedType.isBottom() ? fallback : specializedType;
    }

    private TypeEnv getEntryTypeEnv() {
        return this.getOutEnv(this.cfg.getEntry());
    }

    private TypeEnv getExitTypeEnv() {
        for (int i = 0; i < this.exitEnvs.size(); ++i) {
            TypeEnv env = this.exitEnvs.get(i);
            this.exitEnvs.set(i, NewTypeInference.envPutType(env, RETVAL_ID, this.BOTTOM));
        }
        if (!this.cfg.getImplicitReturn().getInEdges().isEmpty()) {
            this.exitEnvs.add(this.getInEnv(this.cfg.getImplicitReturn()));
        }
        Preconditions.checkState((!this.exitEnvs.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one exit env, either from a normal function exit or a throw.");
        return TypeEnv.join(this.exitEnvs);
    }

    private static JSType firstNonBottom(JSType t1, JSType t2) {
        if (t1.isBottom()) {
            Preconditions.checkArgument((!t2.isBottom() ? 1 : 0) != 0);
            return t2;
        }
        return t1;
    }

    private class DeferredCheck {
        final Node callSite;
        final NTIScope callerScope;
        final NTIScope calleeScope;
        JSType expectedRetType;
        List<JSType> argTypes;

        DeferredCheck(Node callSite, JSType expectedRetType, NTIScope callerScope, NTIScope calleeScope) {
            this.callSite = callSite;
            this.expectedRetType = expectedRetType;
            this.callerScope = callerScope;
            this.calleeScope = calleeScope;
        }

        void updateReturn(JSType expectedRetType) {
            if (this.expectedRetType != null) {
                this.expectedRetType = JSType.meet(this.expectedRetType, expectedRetType);
            }
        }

        void updateArgTypes(List<JSType> argTypes) {
            this.argTypes = argTypes;
        }

        private void runCheck(Map<NTIScope, JSType> summaries, WarningReporter warnings) {
            FunctionType fnSummary = summaries.get(this.calleeScope).getFunType();
            NewTypeInference.println(new Object[]{"Running deferred check of function: ", this.calleeScope.getReadableName(), " with FunctionSummary of: ", fnSummary, " and callsite ret: ", this.expectedRetType, " args: ", this.argTypes});
            if (this.expectedRetType != null && !fnSummary.getReturnType().isSubtypeOf(this.expectedRetType)) {
                warnings.add(JSError.make(this.callSite, INVALID_INFERRED_RETURN_TYPE, NewTypeInference.errorMsgWithTypeDiff(this.expectedRetType, fnSummary.getReturnType())));
            }
            int i = 0;
            Iterable<Node> args = NodeUtil.getInvocationArgsAsIterable(this.callSite);
            if (this.argTypes == null) {
                return;
            }
            int offset = this.callSite.isTaggedTemplateLit() ? 1 : 0;
            for (Node argNode : args) {
                JSType argType = this.argTypes.get(i);
                JSType formalType = fnSummary.getFormalType(i + offset);
                if (argNode.isName() && this.callerScope.isKnownFunction(argNode.getString())) {
                    argType = summaries.get(this.callerScope.getScope(argNode.getString()));
                }
                if (argType != null) {
                    if (argType.isSubtypeOf(formalType)) {
                        NewTypeInference.this.registerImplicitUses(argNode, argType, formalType);
                    } else {
                        JSError error = JSError.make(argNode, INVALID_ARGUMENT_TYPE, Integer.toString(i + offset + 1), this.calleeScope.getReadableName(), NewTypeInference.errorMsgWithTypeDiff(formalType, argType));
                        NewTypeInference.this.registerMismatchAndWarn(error, argType, formalType);
                    }
                }
                ++i;
            }
        }

        public boolean equals(Object o) {
            Preconditions.checkArgument((boolean)(o instanceof DeferredCheck));
            DeferredCheck dc2 = (DeferredCheck)o;
            return this.callSite == dc2.callSite && this.callerScope == dc2.callerScope && this.calleeScope == dc2.calleeScope && Objects.equals(this.expectedRetType, dc2.expectedRetType) && Objects.equals(this.argTypes, dc2.argTypes);
        }

        public int hashCode() {
            return Objects.hash(this.callSite, this.callerScope, this.calleeScope, this.expectedRetType, this.argTypes);
        }
    }

    private static class LValueResultBwd {
        TypeEnv env;
        JSType type;
        QualifiedName ptr;

        LValueResultBwd(TypeEnv env, JSType type, QualifiedName ptr) {
            Preconditions.checkNotNull((Object)type);
            this.env = env;
            this.type = type;
            this.ptr = ptr;
        }
    }

    private static class LValueResultFwd {
        TypeEnv env;
        JSType type;
        JSType declType;
        QualifiedName ptr;

        LValueResultFwd(TypeEnv env, JSType type, JSType declType, QualifiedName ptr) {
            Preconditions.checkNotNull((Object)type);
            this.env = env;
            this.type = type;
            this.declType = declType;
            this.ptr = ptr;
        }
    }

    private static class EnvTypePair {
        TypeEnv env;
        JSType type;

        EnvTypePair(TypeEnv env, JSType type) {
            this.env = env;
            this.type = type;
        }

        static EnvTypePair addBinding(TypeEnv env, String varName, JSType type) {
            return new EnvTypePair(NewTypeInference.envPutType(env, varName, type), type);
        }

        static EnvTypePair join(EnvTypePair p1, EnvTypePair p2) {
            return new EnvTypePair(TypeEnv.join(p1.env, p2.env), JSType.join(p1.type, p2.type));
        }
    }

    public static class WarningReporter {
        AbstractCompiler compiler;

        WarningReporter(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        void add(JSError warning) {
            String filename = warning.node.getSourceFileName();
            if (filename != null && filename.startsWith(" [synthetic") || JSType.mockToString) {
                return;
            }
            this.compiler.report(warning);
        }
    }
}

