/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.InferJSDocInfo;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeInferencePass;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import java.util.Collections;
import java.util.List;

public abstract class PassConfig {
    protected final CompilerOptions options;
    private TypedScopeCreator typedScopeCreator;
    TypedScope topScope = null;

    public PassConfig(CompilerOptions options) {
        this.options = options;
    }

    void regenerateGlobalTypedScope(AbstractCompiler compiler, Node root) {
        this.typedScopeCreator = new TypedScopeCreator(compiler);
        this.topScope = this.typedScopeCreator.createScope(root, (AbstractScope)null);
    }

    void clearTypedScope() {
        this.typedScopeCreator = null;
        this.topScope = null;
    }

    void patchGlobalTypedScope(AbstractCompiler compiler, Node scriptRoot) {
        Preconditions.checkNotNull((Object)this.typedScopeCreator);
        this.typedScopeCreator.patchGlobalScope(this.topScope, scriptRoot);
    }

    TypedScopeCreator getTypedScopeCreator() {
        return this.typedScopeCreator;
    }

    TypedScope getTopScope() {
        return this.topScope;
    }

    protected List<PassFactory> getWhitespaceOnlyPasses() {
        return Collections.emptyList();
    }

    protected List<PassFactory> getTranspileOnlyPasses() {
        return Collections.emptyList();
    }

    protected abstract List<PassFactory> getChecks();

    protected abstract List<PassFactory> getOptimizations();

    GraphvizGraph getPassGraph() {
        LinkedDirectedGraph<String, String> graph = LinkedDirectedGraph.createWithoutAnnotations();
        Iterable allPasses = Iterables.concat(this.getChecks(), this.getOptimizations());
        String lastPass = null;
        String loopStart = null;
        for (PassFactory pass : allPasses) {
            String passName = pass.getName();
            int i = 1;
            while (graph.hasNode(passName)) {
                passName = pass.getName() + i++;
            }
            graph.createNode((Object)passName);
            if (loopStart == null && !pass.isOneTimePass()) {
                loopStart = passName;
            } else if (loopStart != null && pass.isOneTimePass()) {
                graph.connect(lastPass, "loop", loopStart);
                loopStart = null;
            }
            if (lastPass != null) {
                graph.connect(lastPass, "", passName);
            }
            lastPass = passName;
        }
        return graph;
    }

    final TypeInferencePass makeTypeInference(AbstractCompiler compiler) {
        return new TypeInferencePass(compiler, compiler.getReverseAbstractInterpreter(), this.topScope, this.typedScopeCreator);
    }

    static final InferJSDocInfo makeInferJsDocInfo(AbstractCompiler compiler) {
        return new InferJSDocInfo(compiler);
    }

    final TypeCheck makeTypeCheck(AbstractCompiler compiler) {
        return new TypeCheck(compiler, compiler.getReverseAbstractInterpreter(), compiler.getTypeRegistry(), this.topScope, this.typedScopeCreator).reportMissingProperties(!this.options.disables(DiagnosticGroup.forType(TypeCheck.INEXISTENT_PROPERTY)));
    }

    static final void addPassFactoryBefore(List<PassFactory> factoryList, PassFactory factory, String passName) {
        factoryList.add(PassConfig.findPassIndexByName(factoryList, passName), factory);
    }

    static final void replacePassFactory(List<PassFactory> factoryList, PassFactory factory) {
        factoryList.set(PassConfig.findPassIndexByName(factoryList, factory.getName()), factory);
    }

    private static int findPassIndexByName(List<PassFactory> factoryList, String name) {
        for (int i = 0; i < factoryList.size(); ++i) {
            if (!factoryList.get(i).getName().equals(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("No factory named '" + name + "' in the factory list");
    }

    final PassConfig getBasePassConfig() {
        PassConfig current = this;
        while (current instanceof PassConfigDelegate) {
            current = ((PassConfigDelegate)current).delegate;
        }
        return current;
    }

    static class PassConfigDelegate
    extends PassConfig {
        private final PassConfig delegate;

        PassConfigDelegate(PassConfig delegate) {
            super(delegate.options);
            this.delegate = delegate;
        }

        @Override
        protected List<PassFactory> getWhitespaceOnlyPasses() {
            return this.delegate.getWhitespaceOnlyPasses();
        }

        @Override
        protected List<PassFactory> getChecks() {
            return this.delegate.getChecks();
        }

        @Override
        protected List<PassFactory> getOptimizations() {
            return this.delegate.getOptimizations();
        }

        @Override
        protected List<PassFactory> getTranspileOnlyPasses() {
            return this.delegate.getTranspileOnlyPasses();
        }

        @Override
        TypedScopeCreator getTypedScopeCreator() {
            return this.delegate.getTypedScopeCreator();
        }

        @Override
        TypedScope getTopScope() {
            return this.delegate.getTopScope();
        }
    }
}

