/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.SourceFile;
import java.util.HashMap;
import java.util.Map;

public class PersistentInputStore {
    Map<String, CacheEntry> store = new HashMap<String, CacheEntry>();

    public void addInput(String path, String digest) {
        if (this.store.containsKey(path)) {
            CacheEntry dep = this.store.get(path);
            dep.updateDigest(digest);
        } else {
            this.store.put(path, new CacheEntry(digest));
        }
    }

    public CompilerInput getCachedCompilerInput(SourceFile source) {
        String originalPath = source.getOriginalPath();
        if (originalPath.contains(".js.zip!/")) {
            int indexOf = originalPath.indexOf(".js.zip!/");
            String zipPath = originalPath.substring(0, indexOf + ".js.zip".length());
            Preconditions.checkState((boolean)this.store.containsKey(zipPath));
            return this.store.get(zipPath).getCachedZipEntry(source);
        }
        if (this.store.containsKey(originalPath)) {
            CacheEntry cacheEntry = this.store.get(originalPath);
            if (cacheEntry.input == null) {
                cacheEntry.input = CompilerInput.makePersistentInput(source);
            }
            return cacheEntry.input;
        }
        return new CompilerInput(source);
    }

    private static class CacheEntry {
        String digest;
        CompilerInput input;
        private Map<String, CompilerInput> zipEntries = ImmutableMap.of();

        CacheEntry(String digest) {
            this.digest = digest;
        }

        CompilerInput getCachedZipEntry(SourceFile zipEntry) {
            String originalPath = zipEntry.getOriginalPath();
            if (this.zipEntries.isEmpty()) {
                this.zipEntries = new HashMap<String, CompilerInput>();
            }
            this.zipEntries.computeIfAbsent(originalPath, k -> CompilerInput.makePersistentInput(zipEntry));
            return this.zipEntries.get(originalPath);
        }

        void updateDigest(String newDigest) {
            if (!newDigest.equals(this.digest)) {
                this.input = null;
                this.digest = newDigest;
                this.zipEntries = ImmutableMap.of();
            }
        }
    }
}

