/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GuardedCallback;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.resources.ResourceLoader;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class RewritePolyfills
implements HotSwapCompilerPass {
    static final DiagnosticType INSUFFICIENT_OUTPUT_VERSION_ERROR = DiagnosticType.disabled("JSC_INSUFFICIENT_OUTPUT_VERSION", "Built-in ''{0}'' not supported in output version {1}");
    private final AbstractCompiler compiler;
    private final Polyfills polyfills;
    private static final ImmutableSet<String> GLOBAL_NAMES = ImmutableSet.of((Object)"goog.global.", (Object)"window.");

    public RewritePolyfills(AbstractCompiler compiler) {
        this(compiler, Polyfills.fromTable(ResourceLoader.loadTextResource(RewritePolyfills.class, "js/polyfills.txt")));
    }

    RewritePolyfills(AbstractCompiler compiler, Polyfills polyfills) {
        this.compiler = compiler;
        this.polyfills = polyfills;
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        Traverser traverser = new Traverser();
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, traverser);
        if (!traverser.libraries.isEmpty()) {
            Node lastNode = null;
            for (String library : traverser.libraries) {
                lastNode = this.compiler.ensureLibraryInjected(library, false);
            }
            if (lastNode != null) {
                Node parent = lastNode.getParent();
                this.removeUnneededPolyfills(parent, lastNode.getNext());
                this.compiler.reportChangeToEnclosingScope(parent);
            }
        }
    }

    private void removeUnneededPolyfills(Node parent, Node runtimeEnd) {
        Node node = parent.getFirstChild();
        while (node != null && node != runtimeEnd) {
            FeatureSet nativeVersion;
            Node call;
            Node name;
            Node next = node.getNext();
            if (NodeUtil.isExprCall(node) && (name = (call = node.getFirstChild()).getFirstChild()).matchesQualifiedName("$jscomp.polyfill") && this.languageOutIsAtLeast(nativeVersion = FeatureSet.valueOf(name.getNext().getNext().getNext().getString()))) {
                NodeUtil.removeChild(parent, node);
            }
            node = next;
        }
    }

    @Override
    public void process(Node externs, Node root) {
        this.hotSwapScript(root, null);
    }

    private boolean languageOutIsAtLeast(CompilerOptions.LanguageMode mode) {
        return this.compiler.getOptions().getLanguageOut().compareTo(mode) >= 0;
    }

    private boolean languageOutIsAtLeast(FeatureSet features) {
        switch (features.version()) {
            case "ts": {
                return this.languageOutIsAtLeast(CompilerOptions.LanguageMode.ECMASCRIPT6_TYPED);
            }
            case "es9": {
                return this.languageOutIsAtLeast(CompilerOptions.LanguageMode.ECMASCRIPT_2018);
            }
            case "es8": {
                return this.languageOutIsAtLeast(CompilerOptions.LanguageMode.ECMASCRIPT_2017);
            }
            case "es7": {
                return this.languageOutIsAtLeast(CompilerOptions.LanguageMode.ECMASCRIPT_2016);
            }
            case "es6": 
            case "es6-impl": {
                return this.languageOutIsAtLeast(CompilerOptions.LanguageMode.ECMASCRIPT_2015);
            }
            case "es5": {
                return this.languageOutIsAtLeast(CompilerOptions.LanguageMode.ECMASCRIPT5);
            }
            case "es3": {
                return this.languageOutIsAtLeast(CompilerOptions.LanguageMode.ECMASCRIPT3);
            }
        }
        return false;
    }

    private static boolean isRootInScope(Node node, NodeTraversal traversal) {
        Node root = NodeUtil.getRootOfQualifiedName(node);
        return !root.isName() || traversal.getScope().getVar(root.getString()) != null;
    }

    private class Traverser
    extends GuardedCallback<String> {
        final Set<String> libraries;

        Traverser() {
            super(RewritePolyfills.this.compiler);
            this.libraries = new LinkedHashSet<String>();
        }

        @Override
        public void visitGuarded(NodeTraversal traversal, Node node, Node parent) {
            String name;
            if (node.isQualifiedName() && RewritePolyfills.this.polyfills.checkSuffix(node)) {
                Polyfill polyfill;
                name = node.getQualifiedName();
                boolean isExplicitGlobal = false;
                for (String global : GLOBAL_NAMES) {
                    if (!name.startsWith(global)) continue;
                    name = name.substring(global.length());
                    isExplicitGlobal = true;
                    break;
                }
                if ((polyfill = (Polyfill)RewritePolyfills.this.polyfills.statics.get((Object)name)) != null && !isExplicitGlobal && RewritePolyfills.isRootInScope(node, traversal)) {
                    polyfill = null;
                }
                if (polyfill != null && !this.isGuarded(name)) {
                    if (!RewritePolyfills.this.languageOutIsAtLeast(polyfill.polyfillVersion)) {
                        traversal.report(node, INSUFFICIENT_OUTPUT_VERSION_ERROR, name, RewritePolyfills.this.compiler.getOptions().getLanguageOut().toString());
                    }
                    this.inject(polyfill);
                    return;
                }
            }
            if (node.isGetProp() && node.getLastChild().isString()) {
                name = node.getLastChild().getString();
                ImmutableCollection methods = RewritePolyfills.this.polyfills.methods.get((Object)name);
                if (!methods.isEmpty() && !this.isGuarded("." + name)) {
                    for (Polyfill polyfill : methods) {
                        this.inject(polyfill);
                    }
                }
            }
        }

        private void inject(Polyfill polyfill) {
            if (!RewritePolyfills.this.languageOutIsAtLeast(polyfill.nativeVersion) && !polyfill.library.isEmpty()) {
                this.libraries.add(polyfill.library);
            }
        }
    }

    static class Polyfills {
        private final ImmutableMultimap<String, Polyfill> methods;
        private final ImmutableMap<String, Polyfill> statics;
        private final ImmutableSet<String> suffixes;
        private static final Function<String, String> EXTRACT_SUFFIX = new Function<String, String>(){

            public String apply(String arg) {
                return arg.substring(arg.lastIndexOf(46) + 1);
            }
        };

        private Polyfills(ImmutableMultimap<String, Polyfill> methods, ImmutableMap<String, Polyfill> statics) {
            this.methods = methods;
            this.statics = statics;
            this.suffixes = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)statics.keySet(), EXTRACT_SUFFIX));
        }

        static Polyfills fromTable(String table) {
            ImmutableMultimap.Builder methods = ImmutableMultimap.builder();
            ImmutableMap.Builder statics = ImmutableMap.builder();
            for (String line : Splitter.on((char)'\n').omitEmptyStrings().split((CharSequence)table)) {
                List tokens = Splitter.on((char)' ').omitEmptyStrings().splitToList((CharSequence)line.trim());
                if (tokens.size() == 1 && ((String)tokens.get(0)).isEmpty()) continue;
                if (tokens.size() < 3) {
                    throw new IllegalArgumentException("Invalid table: too few tokens on line: " + line);
                }
                String symbol = (String)tokens.get(0);
                Polyfill polyfill = new Polyfill(FeatureSet.valueOf((String)tokens.get(1)), FeatureSet.valueOf((String)tokens.get(2)), tokens.size() > 3 ? (String)tokens.get(3) : "");
                if (symbol.contains(".prototype.")) {
                    methods.put((Object)symbol.replaceAll(".*\\.prototype\\.", ""), (Object)polyfill);
                    continue;
                }
                statics.put((Object)symbol, (Object)polyfill);
            }
            return new Polyfills((ImmutableMultimap<String, Polyfill>)methods.build(), (ImmutableMap<String, Polyfill>)statics.build());
        }

        boolean checkSuffix(Node node) {
            return node.isGetProp() ? this.suffixes.contains((Object)node.getLastChild().getString()) : (node.isName() ? this.suffixes.contains((Object)node.getString()) : false);
        }
    }

    private static class Polyfill {
        final FeatureSet nativeVersion;
        final FeatureSet polyfillVersion;
        final String library;

        Polyfill(FeatureSet nativeVersion, FeatureSet polyfillVersion, String library) {
            this.nativeVersion = nativeVersion;
            this.polyfillVersion = polyfillVersion;
            this.library = library;
        }
    }
}

