/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.InferJSDocInfo;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.TypeInferencePass;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeMapReplacer;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class TypeCheck
implements NodeTraversal.Callback,
CompilerPass {
    static final DiagnosticType UNEXPECTED_TOKEN = DiagnosticType.error("JSC_INTERNAL_ERROR_UNEXPECTED_TOKEN", "Internal Error: TypeCheck doesn''t know how to handle {0}");
    protected static final String OVERRIDING_PROTOTYPE_WITH_NON_OBJECT = "overriding prototype with non-object";
    static final DiagnosticType DETERMINISTIC_TEST = DiagnosticType.warning("JSC_DETERMINISTIC_TEST", "condition always evaluates to {2}\nleft : {0}\nright: {1}");
    static final DiagnosticType INEXISTENT_ENUM_ELEMENT = DiagnosticType.warning("JSC_INEXISTENT_ENUM_ELEMENT", "element {0} does not exist on this enum");
    public static final DiagnosticType INEXISTENT_PROPERTY = DiagnosticType.warning("JSC_INEXISTENT_PROPERTY", "Property {0} never defined on {1}");
    static final DiagnosticType POSSIBLE_INEXISTENT_PROPERTY = DiagnosticType.disabled("JSC_POSSIBLE_INEXISTENT_PROPERTY", "Property {0} never defined on {1}");
    static final DiagnosticType INEXISTENT_PROPERTY_WITH_SUGGESTION = DiagnosticType.disabled("JSC_INEXISTENT_PROPERTY_WITH_SUGGESTION", "Property {0} never defined on {1}. Did you mean {2}?");
    public static final DiagnosticType STRICT_INEXISTENT_PROPERTY = DiagnosticType.disabled("JSC_STRICT_INEXISTENT_PROPERTY", "Property {0} never defined on {1}");
    public static final DiagnosticType STRICT_INEXISTENT_UNION_PROPERTY = DiagnosticType.disabled("JSC_STRICT_INEXISTENT_UNION_PROPERTY", "Property {0} not defined on all member types of {1}");
    static final DiagnosticType STRICT_INEXISTENT_PROPERTY_WITH_SUGGESTION = DiagnosticType.disabled("JSC_STRICT_INEXISTENT_PROPERTY_WITH_SUGGESTION", "Property {0} never defined on {1}. Did you mean {2}?");
    protected static final DiagnosticType NOT_A_CONSTRUCTOR = DiagnosticType.warning("JSC_NOT_A_CONSTRUCTOR", "cannot instantiate non-constructor");
    static final DiagnosticType INSTANTIATE_ABSTRACT_CLASS = DiagnosticType.warning("JSC_INSTANTIATE_ABSTRACT_CLASS", "cannot instantiate abstract class");
    static final DiagnosticType BIT_OPERATION = DiagnosticType.warning("JSC_BAD_TYPE_FOR_BIT_OPERATION", "operator {0} cannot be applied to {1}");
    static final DiagnosticType NOT_CALLABLE = DiagnosticType.warning("JSC_NOT_FUNCTION_TYPE", "{0} expressions are not callable");
    static final DiagnosticType CONSTRUCTOR_NOT_CALLABLE = DiagnosticType.warning("JSC_CONSTRUCTOR_NOT_CALLABLE", "Constructor {0} should be called with the \"new\" keyword");
    static final DiagnosticType ABSTRACT_SUPER_METHOD_NOT_CALLABLE = DiagnosticType.warning("JSC_ABSTRACT_SUPER_METHOD_NOT_CALLABLE", "Abstract super method {0} cannot be called");
    static final DiagnosticType FUNCTION_MASKS_VARIABLE = DiagnosticType.warning("JSC_FUNCTION_MASKS_VARIABLE", "function {0} masks variable (IE bug)");
    static final DiagnosticType MULTIPLE_VAR_DEF = DiagnosticType.warning("JSC_MULTIPLE_VAR_DEF", "declaration of multiple variables with shared type information");
    static final DiagnosticType ENUM_DUP = DiagnosticType.error("JSC_ENUM_DUP", "enum element {0} already defined");
    static final DiagnosticType INVALID_INTERFACE_MEMBER_DECLARATION = DiagnosticType.warning("JSC_INVALID_INTERFACE_MEMBER_DECLARATION", "interface members can only be empty property declarations, empty functions{0}");
    static final DiagnosticType INTERFACE_METHOD_NOT_EMPTY = DiagnosticType.warning("JSC_INTERFACE_METHOD_NOT_EMPTY", "interface member functions must have an empty body");
    static final DiagnosticType CONFLICTING_EXTENDED_TYPE = DiagnosticType.warning("JSC_CONFLICTING_EXTENDED_TYPE", "{1} cannot extend this type; {0}s can only extend {0}s");
    static final DiagnosticType ES5_CLASS_EXTENDING_ES6_CLASS = DiagnosticType.warning("JSC_ES5_CLASS_EXTENDING_ES6_CLASS", "ES5 class {0} cannot extend ES6 class {1}");
    static final DiagnosticType INTERFACE_EXTENDS_LOOP = DiagnosticType.warning("JSC_INTERFACE_EXTENDS_LOOP", "extends loop involving {0}, loop: {1}");
    static final DiagnosticType CONFLICTING_IMPLEMENTED_TYPE = DiagnosticType.warning("JSC_CONFLICTING_IMPLEMENTED_TYPE", "{0} cannot implement this type; an interface can only extend, but not implement interfaces");
    static final DiagnosticType BAD_IMPLEMENTED_TYPE = DiagnosticType.warning("JSC_IMPLEMENTS_NON_INTERFACE", "can only implement interfaces");
    static final DiagnosticType HIDDEN_SUPERCLASS_PROPERTY = DiagnosticType.disabled("JSC_HIDDEN_SUPERCLASS_PROPERTY", "property {0} already defined on superclass {1}; use @override to override it");
    static final DiagnosticType HIDDEN_INTERFACE_PROPERTY = DiagnosticType.disabled("JSC_HIDDEN_INTERFACE_PROPERTY", "property {0} already defined on interface {1}; use @override to override it");
    static final DiagnosticType HIDDEN_SUPERCLASS_PROPERTY_MISMATCH = DiagnosticType.warning("JSC_HIDDEN_SUPERCLASS_PROPERTY_MISMATCH", "mismatch of the {0} property type and the type of the property it overrides from superclass {1}\noriginal: {2}\noverride: {3}");
    static final DiagnosticType UNKNOWN_OVERRIDE = DiagnosticType.warning("JSC_UNKNOWN_OVERRIDE", "property {0} not defined on any superclass of {1}");
    static final DiagnosticType INTERFACE_METHOD_OVERRIDE = DiagnosticType.warning("JSC_INTERFACE_METHOD_OVERRIDE", "property {0} is already defined by the {1} extended interface");
    static final DiagnosticType UNKNOWN_EXPR_TYPE = DiagnosticType.disabled("JSC_UNKNOWN_EXPR_TYPE", "could not determine the type of this expression");
    static final DiagnosticType UNRESOLVED_TYPE = DiagnosticType.warning("JSC_UNRESOLVED_TYPE", "could not resolve the name {0} to a type");
    static final DiagnosticType WRONG_ARGUMENT_COUNT = DiagnosticType.warning("JSC_WRONG_ARGUMENT_COUNT", "Function {0}: called with {1} argument(s). Function requires at least {2} argument(s){3}.");
    static final DiagnosticType ILLEGAL_IMPLICIT_CAST = DiagnosticType.warning("JSC_ILLEGAL_IMPLICIT_CAST", "Illegal annotation on {0}. @implicitCast may only be used in externs.");
    static final DiagnosticType INCOMPATIBLE_EXTENDED_PROPERTY_TYPE = DiagnosticType.warning("JSC_INCOMPATIBLE_EXTENDED_PROPERTY_TYPE", "Interface {0} has a property {1} with incompatible types in its super interfaces {2} and {3}");
    static final DiagnosticType EXPECTED_THIS_TYPE = DiagnosticType.warning("JSC_EXPECTED_THIS_TYPE", "\"{0}\" must be called with a \"this\" type");
    static final DiagnosticType IN_USED_WITH_STRUCT = DiagnosticType.warning("JSC_IN_USED_WITH_STRUCT", "Cannot use the IN operator with structs");
    static final DiagnosticType ILLEGAL_PROPERTY_CREATION = DiagnosticType.warning("JSC_ILLEGAL_PROPERTY_CREATION", "Cannot add a property to a struct instance after it is constructed. (If you already declared the property, make sure to give it a type.)");
    static final DiagnosticType ILLEGAL_OBJLIT_KEY = DiagnosticType.warning("JSC_ILLEGAL_OBJLIT_KEY", "Illegal key, the object literal is a {0}");
    static final DiagnosticType NON_STRINGIFIABLE_OBJECT_KEY = DiagnosticType.warning("JSC_NON_STRINGIFIABLE_OBJECT_KEY", "Object type \"{0}\" contains non-stringifiable key and it may lead to an error. Please use ES6 Map instead or implement your own Map structure.");
    static final DiagnosticType ABSTRACT_METHOD_IN_CONCRETE_CLASS = DiagnosticType.warning("JSC_ABSTRACT_METHOD_IN_CONCRETE_CLASS", "Abstract methods can only appear in abstract classes. Please declare the class as @abstract");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(DETERMINISTIC_TEST, INEXISTENT_ENUM_ELEMENT, INEXISTENT_PROPERTY, POSSIBLE_INEXISTENT_PROPERTY, INEXISTENT_PROPERTY_WITH_SUGGESTION, NOT_A_CONSTRUCTOR, INSTANTIATE_ABSTRACT_CLASS, BIT_OPERATION, NOT_CALLABLE, CONSTRUCTOR_NOT_CALLABLE, FUNCTION_MASKS_VARIABLE, MULTIPLE_VAR_DEF, ENUM_DUP, INVALID_INTERFACE_MEMBER_DECLARATION, INTERFACE_METHOD_NOT_EMPTY, CONFLICTING_EXTENDED_TYPE, CONFLICTING_IMPLEMENTED_TYPE, BAD_IMPLEMENTED_TYPE, HIDDEN_SUPERCLASS_PROPERTY_MISMATCH, UNKNOWN_OVERRIDE, INTERFACE_METHOD_OVERRIDE, UNRESOLVED_TYPE, WRONG_ARGUMENT_COUNT, ILLEGAL_IMPLICIT_CAST, INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, EXPECTED_THIS_TYPE, IN_USED_WITH_STRUCT, ILLEGAL_PROPERTY_CREATION, ILLEGAL_OBJLIT_KEY, NON_STRINGIFIABLE_OBJECT_KEY, ABSTRACT_METHOD_IN_CONCRETE_CLASS, ABSTRACT_SUPER_METHOD_NOT_CALLABLE, ES5_CLASS_EXTENDING_ES6_CLASS, RhinoErrorReporter.TYPE_PARSE_ERROR, RhinoErrorReporter.UNRECOGNIZED_TYPE_ERROR, TypedScopeCreator.UNKNOWN_LENDS, TypedScopeCreator.LENDS_ON_NON_OBJECT, TypedScopeCreator.CTOR_INITIALIZER, TypedScopeCreator.IFACE_INITIALIZER, FunctionTypeBuilder.THIS_TYPE_NON_OBJECT);
    private final AbstractCompiler compiler;
    private final TypeValidator validator;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private final JSTypeRegistry typeRegistry;
    private TypedScope topScope;
    private TypedScopeCreator scopeCreator;
    private final boolean reportUnknownTypes;
    private JSType.SubtypingMode subtypingMode = JSType.SubtypingMode.NORMAL;
    private boolean reportMissingProperties = true;
    private boolean strictOperatorChecks = false;
    private InferJSDocInfo inferJSDocInfo = null;
    private int typedCount = 0;
    private int nullCount = 0;
    private int unknownCount = 0;
    private boolean inExterns;

    public TypeCheck(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, JSTypeRegistry typeRegistry, TypedScope topScope, TypedScopeCreator scopeCreator) {
        this.compiler = compiler;
        this.validator = compiler.getTypeValidator();
        this.reverseInterpreter = reverseInterpreter;
        this.typeRegistry = typeRegistry;
        this.topScope = topScope;
        this.scopeCreator = scopeCreator;
        this.reportUnknownTypes = ((Compiler)compiler).getOptions().enables(DiagnosticGroups.REPORT_UNKNOWN_TYPES);
        this.inferJSDocInfo = new InferJSDocInfo(compiler);
    }

    public TypeCheck(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, JSTypeRegistry typeRegistry) {
        this(compiler, reverseInterpreter, typeRegistry, null, null);
    }

    TypeCheck reportMissingProperties(boolean report) {
        this.reportMissingProperties = report;
        return this;
    }

    @Override
    public void process(Node externsRoot, Node jsRoot) {
        Node externsAndJs;
        Preconditions.checkNotNull((Object)this.scopeCreator);
        Preconditions.checkNotNull((Object)this.topScope);
        if (this.compiler.getOptions().enables(DiagnosticGroups.STRICT_PRIMITIVE_OPERATORS)) {
            this.strictOperatorChecks = true;
            this.validator.setStrictOperatorChecks(true);
        }
        Preconditions.checkState(((externsAndJs = jsRoot.getParent()) != null ? 1 : 0) != 0);
        Preconditions.checkState((externsRoot == null || externsAndJs.hasChild(externsRoot) ? 1 : 0) != 0);
        if (externsRoot != null) {
            this.check(externsRoot, true);
        }
        this.check(jsRoot, false);
    }

    public TypedScope processForTesting(Node externsRoot, Node jsRoot) {
        Preconditions.checkState((this.scopeCreator == null ? 1 : 0) != 0);
        Preconditions.checkState((this.topScope == null ? 1 : 0) != 0);
        Preconditions.checkState((jsRoot.getParent() != null ? 1 : 0) != 0);
        Node externsAndJsRoot = jsRoot.getParent();
        this.scopeCreator = new TypedScopeCreator(this.compiler);
        this.topScope = this.scopeCreator.createScope(externsAndJsRoot, (AbstractScope)null);
        TypeInferencePass inference = new TypeInferencePass(this.compiler, this.reverseInterpreter, this.topScope, this.scopeCreator);
        inference.process(externsRoot, jsRoot);
        this.process(externsRoot, jsRoot);
        return this.topScope;
    }

    void check(Node node, boolean externs) {
        Preconditions.checkNotNull((Object)node);
        NodeTraversal t = new NodeTraversal(this.compiler, this, this.scopeCreator);
        this.inExterns = externs;
        t.traverseWithScope(node, this.topScope);
        if (externs) {
            this.inferJSDocInfo.process(node, null);
        } else {
            this.inferJSDocInfo.process(null, node);
        }
    }

    private void report(NodeTraversal t, Node n, DiagnosticType diagnosticType, String ... arguments) {
        t.report(n, diagnosticType, arguments);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            String filename = n.getSourceFileName();
            this.subtypingMode = filename != null && filename.endsWith(".java.js") ? JSType.SubtypingMode.IGNORE_NULL_UNDEFINED : JSType.SubtypingMode.NORMAL;
            this.validator.setSubtypingMode(this.subtypingMode);
        }
        switch (n.getToken()) {
            case FUNCTION: {
                TypedScope outerScope = t.getTypedScope();
                TypedVar var = (TypedVar)outerScope.getVar(n.getFirstChild().getString());
                if (var == null || !((TypedScope)var.getScope()).hasSameContainerScope(outerScope) || var.getType() instanceof FunctionType || TypeValidator.hasDuplicateDeclarationSuppression(this.compiler, var.getNameNode())) break;
                this.report(t, n, FUNCTION_MASKS_VARIABLE, var.getName());
                break;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        boolean typeable = true;
        switch (n.getToken()) {
            case CAST: {
                Node expr = n.getFirstChild();
                JSType exprType = this.getJSType(expr);
                JSType castType = this.getJSType(n);
                if (!expr.isObjectLit()) {
                    this.validator.expectCanCast(t, n, castType, exprType);
                }
                this.ensureTyped(t, n, castType);
                expr.putProp((byte)79, exprType);
                if (!castType.restrictByNotNullOrUndefined().isSubtypeOf(exprType) && !expr.isObjectLit()) break;
                expr.setJSType(castType);
                break;
            }
            case NAME: {
                typeable = this.visitName(t, n, parent);
                break;
            }
            case COMMA: {
                this.ensureTyped(t, n, this.getJSType(n.getLastChild()));
                break;
            }
            case THIS: {
                this.ensureTyped(t, n, t.getTypedScope().getTypeOfThis());
                break;
            }
            case SUPER: {
                this.ensureTyped(t, n);
                break;
            }
            case NULL: {
                this.ensureTyped(t, n, JSTypeNative.NULL_TYPE);
                break;
            }
            case NUMBER: {
                this.ensureTyped(t, n, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: {
                break;
            }
            case ARRAYLIT: {
                this.ensureTyped(t, n, JSTypeNative.ARRAY_TYPE);
                break;
            }
            case REGEXP: {
                this.ensureTyped(t, n, JSTypeNative.REGEXP_TYPE);
                break;
            }
            case GETPROP: {
                this.visitGetProp(t, n);
                typeable = !parent.isAssign() || parent.getFirstChild() != n;
                break;
            }
            case GETELEM: {
                this.visitGetElem(t, n);
                typeable = false;
                break;
            }
            case VAR: {
                this.visitVar(t, n);
                typeable = false;
                break;
            }
            case NEW: {
                this.visitNew(t, n);
                break;
            }
            case CALL: {
                this.visitCall(t, n);
                typeable = !parent.isExprResult();
                break;
            }
            case RETURN: {
                this.visitReturn(t, n);
                typeable = false;
                break;
            }
            case YIELD: {
                this.visitYield(t, n);
                typeable = false;
                break;
            }
            case DEC: 
            case INC: {
                Node left = n.getFirstChild();
                this.checkPropCreation(t, left);
                this.validator.expectNumber(t, left, this.getJSType(left), "increment/decrement");
                this.ensureTyped(t, n, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case VOID: {
                this.ensureTyped(t, n, JSTypeNative.VOID_TYPE);
                break;
            }
            case STRING: 
            case TYPEOF: {
                this.ensureTyped(t, n, JSTypeNative.STRING_TYPE);
                break;
            }
            case BITNOT: {
                JSType childType = this.getJSType(n.getFirstChild());
                if (!childType.matchesNumberContext()) {
                    this.report(t, n, BIT_OPERATION, NodeUtil.opToStr(n.getToken()), childType.toString());
                } else if (this.strictOperatorChecks) {
                    this.validator.expectNumberStrict(n, childType, "bitwise NOT");
                }
                this.ensureTyped(t, n, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case POS: 
            case NEG: {
                Node left = n.getFirstChild();
                if (n.getToken() == Token.NEG) {
                    this.validator.expectNumber(t, left, this.getJSType(left), "sign operator");
                }
                this.ensureTyped(t, n, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                if (left.isTypeOf()) {
                    if (right.isString()) {
                        this.checkTypeofString(t, right, right.getString());
                    }
                } else if (right.isTypeOf() && left.isString()) {
                    this.checkTypeofString(t, left, left.getString());
                }
                JSType leftType = this.getJSType(left);
                JSType rightType = this.getJSType(right);
                JSType leftTypeRestricted = leftType.restrictByNotNullOrUndefined();
                JSType rightTypeRestricted = rightType.restrictByNotNullOrUndefined();
                TernaryValue result = TernaryValue.UNKNOWN;
                if (n.getToken() == Token.EQ || n.isNE()) {
                    result = leftTypeRestricted.testForEquality(rightTypeRestricted);
                    if (n.isNE()) {
                        result = result.not();
                    }
                } else if (!leftTypeRestricted.canTestForShallowEqualityWith(rightTypeRestricted)) {
                    TernaryValue ternaryValue = result = n.getToken() == Token.SHEQ ? TernaryValue.FALSE : TernaryValue.TRUE;
                }
                if (result != TernaryValue.UNKNOWN) {
                    this.report(t, n, DETERMINISTIC_TEST, leftType.toString(), rightType.toString(), result.toString());
                }
                this.ensureTyped(t, n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case LT: 
            case LE: 
            case GT: 
            case GE: {
                JSType leftType = this.getJSType(n.getFirstChild());
                JSType rightType = this.getJSType(n.getLastChild());
                if (rightType.isUnknownType()) {
                    this.validator.expectStringOrNumber(t, n, leftType, "left side of comparison");
                } else if (leftType.isUnknownType()) {
                    this.validator.expectStringOrNumber(t, n, leftType, "right side of comparison");
                } else if (rightType.isNumber()) {
                    this.validator.expectNumber(t, n, leftType, "left side of numeric comparison");
                } else if (leftType.isNumber()) {
                    this.validator.expectNumber(t, n, rightType, "right side of numeric comparison");
                } else if (this.strictOperatorChecks) {
                    String errorMsg = "expected matching types in comparison";
                    this.validator.expectMatchingTypes(n, leftType, rightType, errorMsg);
                } else if (!leftType.matchesNumberContext() || !rightType.matchesNumberContext()) {
                    String message = "left side of comparison";
                    this.validator.expectString(t, n, leftType, message);
                    this.validator.expectNotNullOrUndefined(t, n, leftType, message, this.getNativeType(JSTypeNative.STRING_TYPE));
                    message = "right side of comparison";
                    this.validator.expectString(t, n, rightType, message);
                    this.validator.expectNotNullOrUndefined(t, n, rightType, message, this.getNativeType(JSTypeNative.STRING_TYPE));
                }
                this.ensureTyped(t, n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case IN: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                JSType rightType = this.getJSType(right);
                this.validator.expectString(t, left, this.getJSType(left), "left side of 'in'");
                this.validator.expectObject(t, n, rightType, "'in' requires an object");
                if (rightType.isStruct()) {
                    this.report(t, right, IN_USED_WITH_STRUCT, new String[0]);
                }
                this.ensureTyped(t, n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case INSTANCEOF: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                JSType rightType = this.getJSType(right).restrictByNotNullOrUndefined();
                this.validator.expectAnyObject(t, left, this.getJSType(left), "deterministic instanceof yields false");
                this.validator.expectActualObject(t, right, rightType, "instanceof requires an object");
                this.ensureTyped(t, n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case ASSIGN: {
                this.visitAssign(t, n);
                typeable = false;
                break;
            }
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_SUB: 
            case ASSIGN_ADD: 
            case ASSIGN_MUL: {
                this.checkPropCreation(t, n.getFirstChild());
            }
            case LSH: 
            case RSH: 
            case URSH: 
            case DIV: 
            case MOD: 
            case BITOR: 
            case BITXOR: 
            case BITAND: 
            case SUB: 
            case ADD: 
            case MUL: {
                this.visitBinaryOperator(n.getToken(), t, n);
                break;
            }
            case TRUE: 
            case FALSE: 
            case NOT: 
            case DELPROP: {
                this.ensureTyped(t, n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case CASE: {
                JSType switchType = this.getJSType(parent.getFirstChild());
                JSType caseType = this.getJSType(n.getFirstChild());
                this.validator.expectSwitchMatchesCase(t, n, switchType, caseType);
                typeable = false;
                break;
            }
            case WITH: {
                Node child = n.getFirstChild();
                JSType childType = this.getJSType(child);
                this.validator.expectObject(t, child, childType, "with requires an object");
                typeable = false;
                break;
            }
            case MEMBER_FUNCTION_DEF: {
                this.ensureTyped(t, n, this.getJSType(n.getFirstChild()));
                break;
            }
            case FUNCTION: {
                this.visitFunction(t, n);
                break;
            }
            case PARAM_LIST: 
            case STRING_KEY: 
            case LABEL: 
            case LABEL_NAME: 
            case SWITCH: 
            case BREAK: 
            case CATCH: 
            case TRY: 
            case SCRIPT: 
            case EXPR_RESULT: 
            case BLOCK: 
            case ROOT: 
            case EMPTY: 
            case DEFAULT_CASE: 
            case CONTINUE: 
            case DEBUGGER: 
            case THROW: 
            case DO: 
            case IF: 
            case WHILE: 
            case FOR: {
                typeable = false;
                break;
            }
            case FOR_IN: {
                Node obj = n.getSecondChild();
                if (this.getJSType(obj).isStruct()) {
                    this.report(t, obj, IN_USED_WITH_STRUCT, new String[0]);
                }
                typeable = false;
                break;
            }
            case FOR_OF: {
                this.ensureTyped(t, n.getSecondChild());
                JSType iterable = this.getJSType(n.getSecondChild());
                this.validator.expectIterable(t, n.getSecondChild(), iterable, "Can only iterate over a (non-null) Iterable type");
                typeable = false;
                break;
            }
            case AND: 
            case HOOK: 
            case OBJECTLIT: 
            case OR: {
                if (n.getJSType() != null) {
                    this.ensureTyped(t, n);
                } else if (n.isObjectLit() && parent.getJSType() instanceof EnumType) {
                    this.ensureTyped(t, n, parent.getJSType());
                } else {
                    this.ensureTyped(t, n);
                }
                if (!n.isObjectLit()) break;
                JSType typ = this.getJSType(n);
                for (Node key : n.children()) {
                    this.visitObjLitKey(t, key, n, typ);
                }
                break;
            }
            default: {
                this.report(t, n, UNEXPECTED_TOKEN, n.getToken().toString());
                this.ensureTyped(t, n);
            }
        }
        boolean bl = typeable = typeable && !this.inExterns;
        if (typeable) {
            this.doPercentTypedAccounting(t, n);
        }
        this.checkJsdocInfoContainsObjectWithBadKey(t, n);
    }

    private void checkTypeofString(NodeTraversal t, Node n, String s) {
        if (!(s.equals("number") || s.equals("string") || s.equals("boolean") || s.equals("undefined") || s.equals("function") || s.equals("object") || s.equals("symbol") || s.equals("unknown"))) {
            this.validator.expectValidTypeofName(t, n, s);
        }
    }

    private void doPercentTypedAccounting(NodeTraversal t, Node n) {
        JSType type = n.getJSType();
        if (type == null) {
            ++this.nullCount;
        } else if (type.isUnknownType()) {
            if (this.reportUnknownTypes) {
                this.compiler.report(t.makeError(n, UNKNOWN_EXPR_TYPE, new String[0]));
            }
            ++this.unknownCount;
        } else {
            ++this.typedCount;
        }
    }

    private void visitAssign(NodeTraversal t, Node assign) {
        Node rightChild;
        JSType rightType;
        TypedVar var;
        JSDocInfo info = assign.getJSDocInfo();
        Node lvalue = assign.getFirstChild();
        Node rvalue = assign.getLastChild();
        if (lvalue.isGetProp()) {
            JSType expectedType;
            FunctionType functionType;
            JSType jsType;
            Node object = lvalue.getFirstChild();
            JSType objectJsType = this.getJSType(object);
            Node property = lvalue.getLastChild();
            String pname = property.getString();
            if (object.isGetProp() && (jsType = this.getJSType(object.getFirstChild())).isInterface() && object.getLastChild().getString().equals("prototype")) {
                this.visitInterfaceGetprop(t, assign, object, rvalue);
            }
            this.checkEnumAlias(t, info, rvalue);
            this.checkPropCreation(t, lvalue);
            if (pname.equals("prototype") && objectJsType != null && objectJsType.isFunctionType() && (functionType = objectJsType.toMaybeFunctionType()).isConstructor()) {
                JSType rvalueType = rvalue.getJSType();
                this.validator.expectObject(t, rvalue, rvalueType, OVERRIDING_PROTOTYPE_WITH_NON_OBJECT);
                return;
            }
            ObjectType type = ObjectType.cast(objectJsType.restrictByNotNullOrUndefined());
            if (type != null && type.hasProperty(pname) && !type.isPropertyTypeInferred(pname) && !(expectedType = type.getPropertyType(pname)).isUnknownType()) {
                if (!TypeCheck.propertyIsImplicitCast(type, pname)) {
                    this.validator.expectCanAssignToPropertyOf(t, assign, this.getJSType(rvalue), expectedType, object, pname);
                    this.checkPropertyInheritanceOnGetpropAssign(t, assign, object, pname, info, expectedType);
                }
                return;
            }
            this.checkPropertyInheritanceOnGetpropAssign(t, assign, object, pname, info, this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
        }
        JSType leftType = this.getJSType(lvalue);
        if (lvalue.isQualifiedName() && (var = (TypedVar)t.getTypedScope().getVar(lvalue.getQualifiedName())) != null) {
            if (var.isTypeInferred()) {
                return;
            }
            if (NodeUtil.getRootOfQualifiedName(lvalue).isThis() && t.getTypedScope() != var.getScope()) {
                return;
            }
            if (var.getType() != null) {
                leftType = var.getType();
            }
        }
        if (this.validator.expectCanAssignTo(t, assign, rightType = this.getJSType(rightChild = assign.getLastChild()), leftType, "assignment")) {
            this.ensureTyped(t, assign, rightType);
        } else {
            this.ensureTyped(t, assign);
        }
    }

    private void checkPropCreation(NodeTraversal t, Node lvalue) {
        Node prop;
        String propName;
        JSTypeRegistry.PropDefinitionKind kind;
        JSType objType;
        if (lvalue.isGetProp() && !(objType = this.getJSType(lvalue.getFirstChild())).isEmptyType() && !objType.isUnknownType() && !(kind = this.typeRegistry.canPropertyBeDefined(objType, propName = (prop = lvalue.getLastChild()).getString())).equals((Object)JSTypeRegistry.PropDefinitionKind.KNOWN)) {
            if (objType.isStruct()) {
                this.report(t, prop, ILLEGAL_PROPERTY_CREATION, new String[0]);
            } else {
                if (!objType.isNoType() && !objType.isUnknownType() && objType.isSubtypeOf(this.getNativeType(JSTypeNative.NULL_VOID))) {
                    return;
                }
                this.reportMissingProperty(objType, propName, kind, t, lvalue, true);
            }
        }
    }

    private void checkPropertyInheritanceOnGetpropAssign(NodeTraversal t, Node assign, Node object, String property, JSDocInfo info, JSType propertyType) {
        if (object.isGetProp()) {
            FunctionType functionType;
            JSType jsType;
            Node object2 = object.getFirstChild();
            String property2 = NodeUtil.getStringValue(object.getLastChild());
            if ("prototype".equals(property2) && (jsType = this.getJSType(object2)).isFunctionType() && ((functionType = jsType.toMaybeFunctionType()).isConstructor() || functionType.isInterface())) {
                this.checkDeclaredPropertyInheritance(t, assign, functionType, property, info, propertyType);
                this.checkAbstractMethodInConcreteClass(t, assign, functionType, info);
            }
        }
    }

    private void checkPropertyInheritanceOnPrototypeLitKey(NodeTraversal t, Node key, String propertyName, ObjectType type) {
        FunctionType ctorType = type.getOwnerFunction();
        if (ctorType == null || !ctorType.isConstructor() && !ctorType.isInterface()) {
            return;
        }
        JSType propertyType = type.getPropertyType(propertyName);
        this.checkDeclaredPropertyInheritance(t, key.getFirstChild(), ctorType, propertyName, key.getJSDocInfo(), propertyType);
    }

    private void visitObjLitKey(NodeTraversal t, Node key, Node objlit, JSType litType) {
        boolean valid;
        if (objlit.isFromExterns()) {
            this.ensureTyped(t, key);
            return;
        }
        if (litType.isStruct() && key.isQuotedString()) {
            this.report(t, key, ILLEGAL_OBJLIT_KEY, "struct");
        } else if (litType.isDict() && !key.isQuotedString()) {
            this.report(t, key, ILLEGAL_OBJLIT_KEY, "dict");
        }
        Node rvalue = key.getFirstChild();
        JSType rightType = TypeCheck.getObjectLitKeyTypeFromValueType(key, this.getJSType(rvalue));
        if (rightType == null) {
            rightType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        Node owner = objlit;
        JSType keyType = this.getJSType(key);
        JSType allowedValueType = keyType;
        if (allowedValueType.isEnumElementType()) {
            allowedValueType = allowedValueType.toMaybeEnumElementType().getPrimitiveType();
        }
        if (valid = this.validator.expectCanAssignToPropertyOf(t, key, rightType, allowedValueType, owner, NodeUtil.getObjectLitKeyName(key))) {
            this.ensureTyped(t, key, rightType);
        } else {
            this.ensureTyped(t, key);
        }
        JSType objlitType = this.getJSType(objlit);
        ObjectType type = ObjectType.cast(objlitType.restrictByNotNullOrUndefined());
        if (type != null) {
            String property = NodeUtil.getObjectLitKeyName(key);
            this.checkPropertyInheritanceOnPrototypeLitKey(t, key, property, type);
            if (type.hasProperty(property) && !type.isPropertyTypeInferred(property) && !TypeCheck.propertyIsImplicitCast(type, property)) {
                this.validator.expectCanAssignToPropertyOf(t, key, keyType, type.getPropertyType(property), owner, property);
            }
            return;
        }
    }

    private static boolean propertyIsImplicitCast(ObjectType type, String prop) {
        while (type != null) {
            JSDocInfo docInfo = type.getOwnPropertyJSDocInfo(prop);
            if (docInfo != null && docInfo.isImplicitCast()) {
                return true;
            }
            type = type.getImplicitPrototype();
        }
        return false;
    }

    private void checkDeclaredPropertyInheritance(NodeTraversal t, Node n, FunctionType ctorType, String propertyName, JSDocInfo info, JSType propertyType) {
        boolean bl;
        if (TypeCheck.hasUnknownOrEmptySupertype(ctorType)) {
            return;
        }
        FunctionType superClass = ctorType.getSuperClassConstructor();
        boolean superClassHasProperty = superClass != null && superClass.getInstanceType().hasProperty(propertyName);
        boolean superClassHasDeclaredProperty = superClass != null && superClass.getInstanceType().isPropertyTypeDeclared(propertyName);
        boolean superInterfaceHasProperty = false;
        boolean superInterfaceHasDeclaredProperty = false;
        if (ctorType.isInterface()) {
            for (ObjectType interfaceType : ctorType.getExtendedInterfaces()) {
                superInterfaceHasProperty = superInterfaceHasProperty || interfaceType.hasProperty(propertyName);
                superInterfaceHasDeclaredProperty = superInterfaceHasDeclaredProperty || interfaceType.isPropertyTypeDeclared(propertyName);
            }
        }
        boolean declaredOverride = info != null && info.isOverride();
        boolean foundInterfaceProperty = false;
        if (ctorType.isConstructor()) {
            for (JSType jSType : ctorType.getAllImplementedInterfaces()) {
                if (jSType.isUnknownType() || jSType.isEmptyType()) continue;
                FunctionType interfaceType = jSType.toObjectType().getConstructor();
                Preconditions.checkNotNull((Object)interfaceType);
                boolean interfaceHasProperty = interfaceType.getPrototype().hasProperty(propertyName);
                boolean bl2 = foundInterfaceProperty = foundInterfaceProperty || interfaceHasProperty;
                if (declaredOverride || !interfaceHasProperty || "__proto__".equals(propertyName)) continue;
                this.compiler.report(t.makeError(n, HIDDEN_INTERFACE_PROPERTY, propertyName, interfaceType.getTopMostDefiningType(propertyName).toString()));
            }
        }
        if (!(declaredOverride || superClassHasProperty || superInterfaceHasProperty)) {
            return;
        }
        ObjectType topInstanceType = superClassHasDeclaredProperty ? superClass.getTopMostDefiningType(propertyName) : null;
        boolean bl3 = bl = ctorType.isConstructor() && (ctorType.getPrototype().hasOwnProperty(propertyName) || ctorType.getInstanceType().hasOwnProperty(propertyName));
        if (!declaredOverride && superClassHasDeclaredProperty && bl && !"__proto__".equals(propertyName)) {
            this.compiler.report(t.makeError(n, HIDDEN_SUPERCLASS_PROPERTY, propertyName, topInstanceType.toString()));
        }
        if (superClassHasDeclaredProperty) {
            JSType superClassPropType = superClass.getInstanceType().getPropertyType(propertyName);
            TemplateTypeMap ctorTypeMap = ctorType.getTypeOfThis().getTemplateTypeMap();
            if (!ctorTypeMap.isEmpty()) {
                superClassPropType = superClassPropType.visit(new TemplateTypeMapReplacer(this.typeRegistry, ctorTypeMap));
            }
            if (!propertyType.isSubtype(superClassPropType, this.subtypingMode)) {
                this.compiler.report(t.makeError(n, HIDDEN_SUPERCLASS_PROPERTY_MISMATCH, propertyName, topInstanceType.toString(), superClassPropType.toString(), propertyType.toString()));
            }
        } else if (superInterfaceHasDeclaredProperty) {
            for (ObjectType interfaceType : ctorType.getExtendedInterfaces()) {
                JSType superPropertyType;
                if (!interfaceType.hasProperty(propertyName) || propertyType.isSubtype(superPropertyType = interfaceType.getPropertyType(propertyName), this.subtypingMode)) continue;
                topInstanceType = interfaceType.getConstructor().getTopMostDefiningType(propertyName);
                this.compiler.report(t.makeError(n, HIDDEN_SUPERCLASS_PROPERTY_MISMATCH, propertyName, topInstanceType.toString(), superPropertyType.toString(), propertyType.toString()));
            }
        } else if (!(foundInterfaceProperty || superClassHasProperty || superInterfaceHasProperty)) {
            this.compiler.report(t.makeError(n, UNKNOWN_OVERRIDE, propertyName, ctorType.getInstanceType().toString()));
        }
    }

    private void checkAbstractMethodInConcreteClass(NodeTraversal t, Node n, FunctionType ctorType, JSDocInfo info) {
        if (info == null || !info.isAbstract()) {
            return;
        }
        if (ctorType.isConstructor() && !ctorType.isAbstract()) {
            this.report(t, n, ABSTRACT_METHOD_IN_CONCRETE_CLASS, new String[0]);
        }
    }

    private static boolean hasUnknownOrEmptySupertype(FunctionType ctor) {
        Preconditions.checkArgument((ctor.isConstructor() || ctor.isInterface() ? 1 : 0) != 0);
        Preconditions.checkArgument((!ctor.isUnknownType() ? 1 : 0) != 0);
        ObjectType maybeSuperInstanceType;
        while ((maybeSuperInstanceType = ctor.getPrototype().getImplicitPrototype()) != null) {
            if (maybeSuperInstanceType.isUnknownType() || maybeSuperInstanceType.isEmptyType()) {
                return true;
            }
            ctor = maybeSuperInstanceType.getConstructor();
            if (ctor == null) {
                return false;
            }
            Preconditions.checkState((ctor.isConstructor() || ctor.isInterface() ? 1 : 0) != 0);
        }
        return false;
    }

    static JSType getObjectLitKeyTypeFromValueType(Node key, JSType valueType) {
        if (valueType != null) {
            switch (key.getToken()) {
                case GETTER_DEF: {
                    if (valueType.isFunctionType()) {
                        FunctionType fntype = valueType.toMaybeFunctionType();
                        valueType = fntype.getReturnType();
                        break;
                    }
                    return null;
                }
                case SETTER_DEF: {
                    if (valueType.isFunctionType()) {
                        FunctionType fntype = valueType.toMaybeFunctionType();
                        Node param = fntype.getParametersNode().getFirstChild();
                        valueType = param.getJSType();
                        break;
                    }
                    return null;
                }
            }
        }
        return valueType;
    }

    private void visitInterfaceGetprop(NodeTraversal t, Node assign, Node object, Node rvalue) {
        JSType rvalueType = this.getJSType(rvalue);
        String abstractMethodName = this.compiler.getCodingConvention().getAbstractMethodName();
        if (!rvalueType.isFunctionType()) {
            String abstractMethodMessage = abstractMethodName != null ? ", or " + abstractMethodName : "";
            this.compiler.report(t.makeError(object, INVALID_INTERFACE_MEMBER_DECLARATION, abstractMethodMessage));
        }
        if (assign.getLastChild().isFunction() && !NodeUtil.isEmptyBlock(assign.getLastChild().getLastChild())) {
            this.compiler.report(t.makeError(object, INTERFACE_METHOD_NOT_EMPTY, abstractMethodName));
        }
    }

    boolean visitName(NodeTraversal t, Node n, Node parent) {
        Token parentNodeType = parent.getToken();
        if (parentNodeType == Token.FUNCTION || parentNodeType == Token.CATCH || parentNodeType == Token.PARAM_LIST || parentNodeType == Token.VAR) {
            return false;
        }
        if (parent.isForIn() && parent.getFirstChild() == n) {
            return false;
        }
        JSType type = n.getJSType();
        if (type == null) {
            JSType varType;
            type = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            TypedVar var = (TypedVar)t.getTypedScope().getVar(n.getString());
            if (var != null && (varType = var.getType()) != null) {
                type = varType;
            }
        }
        this.ensureTyped(t, n, type);
        return true;
    }

    private void visitGetProp(NodeTraversal t, Node n) {
        Node property = n.getLastChild();
        Node objNode = n.getFirstChild();
        JSType childType = this.getJSType(objNode);
        if (childType.isDict()) {
            this.report(t, property, TypeValidator.ILLEGAL_PROPERTY_ACCESS, "'.'", "dict");
        } else if (this.validator.expectNotNullOrUndefined(t, n, childType, "No properties on this expression", this.getNativeType(JSTypeNative.OBJECT_TYPE))) {
            this.checkPropertyAccess(childType, property.getString(), t, n);
        }
        this.ensureTyped(t, n);
    }

    private void checkPropertyAccess(JSType childType, String propName, NodeTraversal t, Node n) {
        JSType propType = this.getJSType(n);
        if (propType.isEquivalentTo(this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE))) {
            ObjectType objectType = ObjectType.cast(childType = childType.autobox());
            if (objectType != null) {
                if (!objectType.hasProperty(propName) || objectType.isEquivalentTo(this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE))) {
                    if (objectType instanceof EnumType) {
                        this.report(t, n, INEXISTENT_ENUM_ELEMENT, propName);
                    } else {
                        this.checkPropertyAccessHelper(objectType, propName, t, n, false);
                    }
                }
            } else {
                this.checkPropertyAccessHelper(childType, propName, t, n, false);
            }
        } else if (childType.isUnionType() && !this.isLValueGetProp(n)) {
            this.checkPropertyAccessHelper(childType, propName, t, n, true);
        }
    }

    boolean isLValueGetProp(Node n) {
        Node parent = n.getParent();
        return (NodeUtil.isUpdateOperator(parent) || NodeUtil.isAssignmentOp(parent)) && parent.getFirstChild() == n;
    }

    private void checkPropertyAccessHelper(JSType objectType, String propName, NodeTraversal t, Node n, boolean strictCheck) {
        boolean maybePropExistenceCheck;
        boolean isStruct = objectType.isStruct();
        boolean bl = maybePropExistenceCheck = !isStruct && this.allowLoosePropertyAccessOnNode(n);
        if (!this.reportMissingProperties || objectType.isEmptyType() || this.allowStrictPropertyAccessOnNode(n)) {
            return;
        }
        JSTypeRegistry.PropDefinitionKind kind = this.typeRegistry.canPropertyBeDefined(objectType, propName);
        if (kind.equals((Object)JSTypeRegistry.PropDefinitionKind.KNOWN)) {
            return;
        }
        boolean isLooselyAssociated = kind.equals((Object)JSTypeRegistry.PropDefinitionKind.LOOSE) || kind.equals((Object)JSTypeRegistry.PropDefinitionKind.LOOSE_UNION);
        boolean isUnknownType = objectType.isUnknownType();
        if (isLooselyAssociated && isUnknownType) {
            return;
        }
        boolean loosePropertyDeclaration = this.isQNameAssignmentTarget(n) && !isStruct;
        boolean strictReport = strictCheck || isLooselyAssociated || loosePropertyDeclaration || maybePropExistenceCheck;
        this.reportMissingProperty(objectType, propName, kind, t, n, strictReport);
    }

    private void reportMissingProperty(JSType objectType, String propName, JSTypeRegistry.PropDefinitionKind kind, NodeTraversal t, Node n, boolean strictReport) {
        Preconditions.checkState((boolean)n.isGetProp());
        boolean isUnknownType = objectType.isUnknownType();
        boolean isObjectType = objectType.isEquivalentTo(this.getNativeType(JSTypeNative.OBJECT_TYPE));
        boolean lowConfidence = isUnknownType || isObjectType;
        boolean isKnownToUnionMember = kind.equals((Object)JSTypeRegistry.PropDefinitionKind.LOOSE_UNION);
        SuggestionPair pair = null;
        if (!lowConfidence && !isKnownToUnionMember) {
            pair = TypeCheck.getClosestPropertySuggestion(objectType, propName);
        }
        if (pair != null && pair.distance * 4 < propName.length()) {
            DiagnosticType reportType = strictReport ? STRICT_INEXISTENT_PROPERTY_WITH_SUGGESTION : INEXISTENT_PROPERTY_WITH_SUGGESTION;
            this.report(t, n.getLastChild(), reportType, propName, this.typeRegistry.getReadableTypeName(n.getFirstChild()), pair.suggestion);
        } else {
            DiagnosticType reportType = strictReport ? (isKnownToUnionMember ? STRICT_INEXISTENT_UNION_PROPERTY : STRICT_INEXISTENT_PROPERTY) : (lowConfidence ? POSSIBLE_INEXISTENT_PROPERTY : INEXISTENT_PROPERTY);
            this.report(t, n.getLastChild(), reportType, propName, this.typeRegistry.getReadableTypeName(n.getFirstChild()));
        }
    }

    private boolean allowStrictPropertyAccessOnNode(Node n) {
        return n.getParent().isTypeOf();
    }

    private boolean allowLoosePropertyAccessOnNode(Node n) {
        Node parent = n.getParent();
        return NodeUtil.isPropertyTest(this.compiler, n) || n.isQualifiedName() && parent.isExprResult();
    }

    private boolean isQNameAssignmentTarget(Node n) {
        Node parent = n.getParent();
        return n.isQualifiedName() && parent.isAssign() && parent.getFirstChild() == n;
    }

    private static SuggestionPair getClosestPropertySuggestion(JSType objectType, String propName) {
        return null;
    }

    private void visitGetElem(NodeTraversal t, Node n) {
        this.validator.expectIndexMatch(t, n, this.getJSType(n.getFirstChild()), this.getJSType(n.getLastChild()));
        this.ensureTyped(t, n);
    }

    private void visitVar(NodeTraversal t, Node n) {
        JSDocInfo varInfo = n.hasOneChild() ? n.getJSDocInfo() : null;
        for (Node name : n.children()) {
            Node value = name.getFirstChild();
            TypedVar var = (TypedVar)t.getTypedScope().getVar(name.getString());
            if (value == null) continue;
            JSType valueType = this.getJSType(value);
            JSType nameType = var.getType();
            nameType = nameType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : nameType;
            JSDocInfo info = name.getJSDocInfo();
            if (info == null) {
                info = varInfo;
            }
            this.checkEnumAlias(t, info, value);
            if (var.isTypeInferred()) {
                this.ensureTyped(t, name, valueType);
                continue;
            }
            this.validator.expectCanAssignTo(t, value, valueType, nameType, "initializing variable");
        }
    }

    private void visitNew(NodeTraversal t, Node n) {
        Node constructor = n.getFirstChild();
        JSType type = this.getJSType(constructor).restrictByNotNullOrUndefined();
        if (!this.couldBeAConstructor(type) || type.isEquivalentTo(this.typeRegistry.getNativeType(JSTypeNative.SYMBOL_OBJECT_FUNCTION_TYPE))) {
            this.report(t, n, NOT_A_CONSTRUCTOR, new String[0]);
            this.ensureTyped(t, n);
            return;
        }
        FunctionType fnType = type.toMaybeFunctionType();
        if (fnType != null && fnType.hasInstanceType()) {
            FunctionType ctorType = fnType.getInstanceType().getConstructor();
            if (ctorType != null && ctorType.isAbstract()) {
                this.report(t, n, INSTANTIATE_ABSTRACT_CLASS, new String[0]);
            }
            this.visitParameterList(t, n, fnType);
            this.ensureTyped(t, n, fnType.getInstanceType());
        } else {
            this.ensureTyped(t, n);
        }
    }

    private boolean couldBeAConstructor(JSType type) {
        return type.isConstructor() || type.isEmptyType() || type.isUnknownType();
    }

    private void checkInterfaceConflictProperties(NodeTraversal t, Node n, String functionName, Map<String, ObjectType> properties, Map<String, ObjectType> currentProperties, ObjectType interfaceType) {
        ObjectType implicitProto = interfaceType.getImplicitPrototype();
        Object currentPropertyNames = implicitProto == null ? ImmutableSet.of() : implicitProto.getOwnPropertyNames();
        Iterator<Object> iterator = currentPropertyNames.iterator();
        while (iterator.hasNext()) {
            JSType oPropType;
            JSType thisPropType;
            String name = (String)iterator.next();
            ObjectType oType = properties.get(name);
            currentProperties.put(name, interfaceType);
            if (oType == null || (thisPropType = interfaceType.getPropertyType(name)).isSubtype(oPropType = oType.getPropertyType(name), this.subtypingMode) || oPropType.isSubtype(thisPropType, this.subtypingMode) || thisPropType.isFunctionType() && oPropType.isFunctionType() && thisPropType.toMaybeFunctionType().hasEqualCallType(oPropType.toMaybeFunctionType())) continue;
            this.compiler.report(t.makeError(n, INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, functionName, name, oType.toString(), interfaceType.toString()));
        }
        for (ObjectType iType : interfaceType.getCtorExtendedInterfaces()) {
            this.checkInterfaceConflictProperties(t, n, functionName, properties, currentProperties, iType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void visitFunction(NodeTraversal t, Node n) {
        FunctionType functionType = JSType.toMaybeFunctionType(n.getJSType());
        String functionPrivateName = n.getFirstChild().getString();
        if (functionType.isConstructor()) {
            FunctionType baseConstructor = functionType.getSuperClassConstructor();
            if (!Objects.equals(baseConstructor, this.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE)) && baseConstructor != null && baseConstructor.isInterface()) {
                this.compiler.report(t.makeError(n, CONFLICTING_EXTENDED_TYPE, "constructor", functionPrivateName));
            } else {
                if (baseConstructor != null && baseConstructor.getSource() != null && baseConstructor.getSource().getBooleanProp((byte)92) && !functionType.getSource().getBooleanProp((byte)92)) {
                    this.compiler.report(t.makeError(n, ES5_CLASS_EXTENDING_ES6_CLASS, functionType.getDisplayName(), baseConstructor.getDisplayName()));
                }
                for (JSType jSType : functionType.getImplementedInterfaces()) {
                    boolean badImplementedType = false;
                    ObjectType baseInterfaceObj = ObjectType.cast(jSType);
                    if (baseInterfaceObj != null) {
                        FunctionType interfaceConstructor = baseInterfaceObj.getConstructor();
                        if (interfaceConstructor != null && !interfaceConstructor.isInterface()) {
                            badImplementedType = true;
                        }
                    } else {
                        badImplementedType = true;
                    }
                    if (!badImplementedType) continue;
                    this.report(t, n, BAD_IMPLEMENTED_TYPE, functionPrivateName);
                }
                this.validator.expectAllInterfaceProperties(t, n, functionType);
                if (!functionType.isAbstract()) {
                    this.validator.expectAbstractMethodsImplemented(n, functionType);
                }
            }
        } else if (functionType.isInterface()) {
            List<FunctionType> loopPath;
            for (ObjectType extInterface : functionType.getExtendedInterfaces()) {
                if (extInterface.getConstructor() == null || extInterface.getConstructor().isInterface()) continue;
                this.compiler.report(t.makeError(n, CONFLICTING_EXTENDED_TYPE, "interface", functionPrivateName));
            }
            if (functionType.getExtendedInterfacesCount() > 1) {
                HashMap<String, ObjectType> properties = new HashMap<String, ObjectType>();
                LinkedHashMap<String, ObjectType> currentProperties = new LinkedHashMap<String, ObjectType>();
                for (ObjectType interfaceType : functionType.getExtendedInterfaces()) {
                    currentProperties.clear();
                    this.checkInterfaceConflictProperties(t, n, functionPrivateName, properties, currentProperties, interfaceType);
                    properties.putAll(currentProperties);
                }
            }
            if ((loopPath = functionType.checkExtendsLoop()) != null) {
                void var7_13;
                String strPath = "";
                boolean bl = false;
                while (var7_13 < loopPath.size() - 1) {
                    strPath = strPath + loopPath.get((int)var7_13).getDisplayName() + " -> ";
                    ++var7_13;
                }
                strPath = strPath + ((FunctionType)Iterables.getLast(loopPath)).getDisplayName();
                this.compiler.report(t.makeError(n, INTERFACE_EXTENDS_LOOP, loopPath.get(0).getDisplayName(), strPath));
            }
        } else if (n.isGeneratorFunction()) {
            JSType returnType = functionType.getReturnType();
            this.validator.expectGeneratorSupertype(t, n, returnType, "A generator function must return a (supertype of) Generator");
        }
    }

    private void checkCallConventions(NodeTraversal t, Node n) {
        CodingConvention.SubclassRelationship relationship = this.compiler.getCodingConvention().getClassesDefinedByCall(n);
        TypedScope scope = t.getTypedScope();
        if (relationship != null) {
            ObjectType superClass = TypeValidator.getInstanceOfCtor((TypedVar)scope.getVar(relationship.superclassName));
            ObjectType subClass = TypeValidator.getInstanceOfCtor((TypedVar)scope.getVar(relationship.subclassName));
            if (relationship.type == CodingConvention.SubclassType.INHERITS && superClass != null && !superClass.isEmptyType() && subClass != null && !subClass.isEmptyType()) {
                this.validator.expectSuperType(t, n, superClass, subClass);
            }
        }
    }

    private void visitCall(NodeTraversal t, Node n) {
        this.checkCallConventions(t, n);
        Node child = n.getFirstChild();
        JSType childType = this.getJSType(child).restrictByNotNullOrUndefined();
        if (!childType.canBeCalled()) {
            this.report(t, n, NOT_CALLABLE, childType.toString());
            this.ensureTyped(t, n);
            return;
        }
        if (childType.isFunctionType()) {
            FunctionType functionType = childType.toMaybeFunctionType();
            if (functionType.isConstructor() && !functionType.isNativeObjectType() && (functionType.getReturnType().isUnknownType() || functionType.getReturnType().isVoidType())) {
                this.report(t, n, CONSTRUCTOR_NOT_CALLABLE, childType.toString());
            }
            if (!(!functionType.isOrdinaryFunction() || functionType.getTypeOfThis().isUnknownType() || functionType.getTypeOfThis().toObjectType() != null && functionType.getTypeOfThis().toObjectType().isNativeObjectType() || child.isGetElem() || child.isGetProp())) {
                this.report(t, n, EXPECTED_THIS_TYPE, functionType.toString());
            }
            this.checkAbstractMethodCall(t, n);
            this.visitParameterList(t, n, functionType);
            this.ensureTyped(t, n, functionType.getReturnType());
        } else {
            this.ensureTyped(t, n);
        }
    }

    private void checkAbstractMethodCall(NodeTraversal t, Node call) {
        if (NodeUtil.isFunctionObjectCall(call) || NodeUtil.isFunctionObjectApply(call)) {
            Node method = call.getFirstFirstChild();
            if (method.isGetProp() && (method.getFirstChild().isThis() || method.getFirstChild().matchesQualifiedName("$jscomp$this"))) {
                return;
            }
            FunctionType methodType = method.getJSType().toMaybeFunctionType();
            if (methodType != null && methodType.isAbstract() && !methodType.isConstructor()) {
                this.report(t, call, ABSTRACT_SUPER_METHOD_NOT_CALLABLE, methodType.getDisplayName());
            }
        } else {
            FunctionType methodType;
            Node maybePrototype;
            Node rootOfQName;
            Node maybeGetProp = call.getFirstChild();
            if (maybeGetProp.isGetProp() && maybeGetProp.isQualifiedName() && (rootOfQName = NodeUtil.getRootOfQualifiedName(maybeGetProp)).isName() && (maybePrototype = rootOfQName.getNext()).isString() && maybePrototype.getString().equals("prototype") && (methodType = maybeGetProp.getJSType().toMaybeFunctionType()) != null && methodType.isAbstract() && !methodType.isConstructor() && rootOfQName.getJSType() != null && methodType.getTypeOfThis().equals(rootOfQName.getJSType().toMaybeFunctionType().getInstanceType())) {
                this.report(t, call, ABSTRACT_SUPER_METHOD_NOT_CALLABLE, methodType.getDisplayName());
            }
        }
    }

    private void visitParameterList(NodeTraversal t, Node call, FunctionType functionType) {
        Iterator<Node> arguments = call.children().iterator();
        arguments.next();
        Iterator<Node> parameters = functionType.getParameters().iterator();
        int ordinal = 0;
        Node parameter = null;
        Node argument = null;
        while (arguments.hasNext() && (parameters.hasNext() || parameter != null && parameter.isVarArgs())) {
            if (parameters.hasNext()) {
                parameter = parameters.next();
            }
            argument = arguments.next();
            this.validator.expectArgumentMatchesParameter(t, argument, this.getJSType(argument), this.getJSType(parameter), call, ++ordinal);
        }
        int numArgs = call.getChildCount() - 1;
        int minArity = functionType.getMinArity();
        int maxArity = functionType.getMaxArity();
        if (minArity > numArgs || maxArity < numArgs) {
            this.report(t, call, WRONG_ARGUMENT_COUNT, this.typeRegistry.getReadableTypeNameNoDeref(call.getFirstChild()), String.valueOf(numArgs), String.valueOf(minArity), maxArity == Integer.MAX_VALUE ? "" : " and no more than " + maxArity + " argument(s)");
        }
    }

    private void visitReturn(NodeTraversal t, Node n) {
        Node enclosingFunction = t.getEnclosingFunction();
        if (enclosingFunction.isGeneratorFunction() && !n.hasChildren()) {
            return;
        }
        JSType jsType = this.getJSType(enclosingFunction);
        if (jsType.isFunctionType()) {
            JSType actualReturnType;
            FunctionType functionType = jsType.toMaybeFunctionType();
            JSType returnType = functionType.getReturnType();
            if (returnType == null) {
                returnType = this.getNativeType(JSTypeNative.VOID_TYPE);
            } else if (enclosingFunction.isGeneratorFunction()) {
                returnType = this.getTemplateTypeOfGenerator(returnType);
            }
            Node valueNode = n.getFirstChild();
            if (valueNode == null) {
                actualReturnType = this.getNativeType(JSTypeNative.VOID_TYPE);
                valueNode = n;
            } else {
                actualReturnType = this.getJSType(valueNode);
            }
            this.validator.expectCanAssignTo(t, valueNode, actualReturnType, returnType, "inconsistent return type");
        }
    }

    private void visitYield(NodeTraversal t, Node n) {
        JSType actualYieldType;
        Node valueNode;
        JSType jsType = this.getJSType(t.getEnclosingFunction());
        JSType declaredYieldType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        if (jsType.isFunctionType()) {
            FunctionType functionType = jsType.toMaybeFunctionType();
            JSType returnType = functionType.getReturnType();
            declaredYieldType = this.getTemplateTypeOfGenerator(returnType);
        }
        if ((valueNode = n.getFirstChild()) == null) {
            actualYieldType = this.getNativeType(JSTypeNative.VOID_TYPE);
            valueNode = n;
        } else {
            actualYieldType = this.getJSType(valueNode);
        }
        if (n.isYieldAll()) {
            if (!this.validator.expectIterable(t, n, actualYieldType, "Expression yield* expects an iterable")) {
                return;
            }
            actualYieldType = actualYieldType.dereference().getTemplateTypeMap().getResolvedTemplateType(this.typeRegistry.getIterableTemplate());
        }
        this.validator.expectCanAssignTo(t, valueNode, actualYieldType, declaredYieldType, "Yielded type does not match declared return type.");
    }

    private JSType getTemplateTypeOfGenerator(JSType generator) {
        return TypeCheck.getTemplateTypeOfGenerator(this.typeRegistry, generator);
    }

    static JSType getTemplateTypeOfGenerator(JSTypeRegistry typeRegistry, JSType generator) {
        ObjectType dereferencedType = generator.dereference();
        if (dereferencedType != null) {
            TemplateTypeMap templateTypeMap = dereferencedType.getTemplateTypeMap();
            if (templateTypeMap.hasTemplateKey(typeRegistry.getIterableTemplate())) {
                return templateTypeMap.getResolvedTemplateType(typeRegistry.getIterableTemplate());
            }
            if (templateTypeMap.hasTemplateKey(typeRegistry.getIteratorTemplate())) {
                return templateTypeMap.getResolvedTemplateType(typeRegistry.getIteratorTemplate());
            }
        }
        return typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
    }

    private void visitBinaryOperator(Token op, NodeTraversal t, Node n) {
        Node left = n.getFirstChild();
        JSType leftType = this.getJSType(left);
        Node right = n.getLastChild();
        JSType rightType = this.getJSType(right);
        switch (op) {
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case LSH: 
            case RSH: 
            case URSH: {
                String opStr = NodeUtil.opToStr(n.getToken());
                if (!leftType.matchesNumberContext()) {
                    this.report(t, left, BIT_OPERATION, opStr, leftType.toString());
                } else if (this.strictOperatorChecks) {
                    this.validator.expectNumberStrict(n, leftType, "operator " + opStr);
                }
                if (!rightType.matchesNumberContext()) {
                    this.report(t, right, BIT_OPERATION, opStr, rightType.toString());
                    break;
                }
                if (!this.strictOperatorChecks) break;
                this.validator.expectNumberStrict(n, rightType, "operator " + opStr);
                break;
            }
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case DIV: 
            case MOD: 
            case SUB: 
            case MUL: {
                this.validator.expectNumber(t, left, leftType, "left operand");
                this.validator.expectNumber(t, right, rightType, "right operand");
                break;
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case BITOR: 
            case BITXOR: 
            case BITAND: {
                this.validator.expectBitwiseable(t, left, leftType, "bad left operand to bitwise operator");
                this.validator.expectBitwiseable(t, right, rightType, "bad right operand to bitwise operator");
                break;
            }
            case ASSIGN_ADD: 
            case ADD: {
                break;
            }
            default: {
                this.report(t, n, UNEXPECTED_TOKEN, op.toString());
            }
        }
        this.ensureTyped(t, n);
    }

    private void checkEnumAlias(NodeTraversal t, JSDocInfo declInfo, Node value) {
        if (declInfo == null || !declInfo.hasEnumParameterType()) {
            return;
        }
        JSType valueType = this.getJSType(value);
        if (!valueType.isEnumType()) {
            return;
        }
        EnumType valueEnumType = valueType.toMaybeEnumType();
        JSType valueEnumPrimitiveType = valueEnumType.getElementsType().getPrimitiveType();
        this.validator.expectCanAssignTo(t, value, valueEnumPrimitiveType, declInfo.getEnumParameterType().evaluate(t.getTypedScope(), this.typeRegistry), "incompatible enum element types");
    }

    private JSType getJSType(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jsType;
    }

    private void ensureTyped(NodeTraversal t, Node n) {
        this.ensureTyped(t, n, this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
    }

    private void ensureTyped(NodeTraversal t, Node n, JSTypeNative type) {
        this.ensureTyped(t, n, this.getNativeType(type));
    }

    private void ensureTyped(NodeTraversal t, Node n, JSType type) {
        Preconditions.checkState((!n.isFunction() || type.isFunctionType() || type.isUnknownType() ? 1 : 0) != 0);
        JSDocInfo info = n.getJSDocInfo();
        if (info != null && info.isImplicitCast() && !this.inExterns) {
            String propName = n.isGetProp() ? n.getLastChild().getString() : "(missing)";
            this.compiler.report(t.makeError(n, ILLEGAL_IMPLICIT_CAST, propName));
        }
        if (n.getJSType() == null) {
            n.setJSType(type);
        }
    }

    double getTypedPercent() {
        int total = this.nullCount + this.unknownCount + this.typedCount;
        return total == 0 ? 0.0 : 100.0 * (double)this.typedCount / (double)total;
    }

    private JSType getNativeType(JSTypeNative typeId) {
        return this.typeRegistry.getNativeType(typeId);
    }

    private void checkJsdocInfoContainsObjectWithBadKey(NodeTraversal t, Node n) {
        if (n.getJSDocInfo() != null) {
            JSDocInfo info = n.getJSDocInfo();
            this.checkTypeContainsObjectWithBadKey(t, n, info.getType());
            this.checkTypeContainsObjectWithBadKey(t, n, info.getReturnType());
            this.checkTypeContainsObjectWithBadKey(t, n, info.getTypedefType());
            for (String param : info.getParameterNames()) {
                this.checkTypeContainsObjectWithBadKey(t, n, info.getParameterType(param));
            }
        }
    }

    private void checkTypeContainsObjectWithBadKey(NodeTraversal t, Node n, JSTypeExpression type) {
        JSType realType;
        JSType objectWithBadKey;
        if (type != null && type.getRoot().getJSType() != null && (objectWithBadKey = this.findObjectWithNonStringifiableKey(realType = type.getRoot().getJSType(), new HashSet<JSType>())) != null) {
            this.compiler.report(t.makeError(n, NON_STRINGIFIABLE_OBJECT_KEY, objectWithBadKey.toString()));
        }
    }

    private boolean isReasonableObjectPropertyKey(JSType type) {
        Object templatizedType;
        if (type.isUnknownType() || type.isNumber() || type.isString() || type.isSymbol() || type.isBooleanObjectType() || type.isBooleanValueType() || type.isDateType() || type.isRegexpType() || type.isInterface() || type.isRecordType() || type.isNullType() || type.isVoidType()) {
            return true;
        }
        if (type.toMaybeEnumElementType() != null) {
            return this.isReasonableObjectPropertyKey(type.toMaybeEnumElementType().getPrimitiveType());
        }
        if (type.isArrayType()) {
            return true;
        }
        if (type.isTemplatizedType() && ((TemplatizedType)(templatizedType = type.toMaybeTemplatizedType())).getReferencedType().isArrayType()) {
            return this.isReasonableObjectPropertyKey((JSType)((TemplatizedType)templatizedType).getTemplateTypes().get(0));
        }
        if (type instanceof NamedType) {
            return this.isReasonableObjectPropertyKey(((NamedType)type).getReferencedType());
        }
        if (type.isUnionType()) {
            for (JSType alternateType : type.toMaybeUnionType().getAlternates()) {
                if (this.isReasonableObjectPropertyKey(alternateType)) continue;
                return false;
            }
            return true;
        }
        if (type.isObject()) {
            ObjectType objectType = type.toMaybeObjectType();
            FunctionType constructor = objectType.getConstructor();
            if (constructor != null && ((JSType)constructor).isInterface()) {
                return true;
            }
            return this.classHasToString(objectType);
        }
        return false;
    }

    private boolean isObjectTypeWithNonStringifiableKey(JSType type) {
        if (!type.isTemplatizedType()) {
            return false;
        }
        TemplatizedType templatizedType = type.toMaybeTemplatizedType();
        if (templatizedType.getReferencedType().isNativeObjectType() && templatizedType.getTemplateTypes().size() > 1) {
            return !this.isReasonableObjectPropertyKey((JSType)templatizedType.getTemplateTypes().get(0));
        }
        return false;
    }

    private JSType findObjectWithNonStringifiableKey(JSType type, Set<JSType> alreadyCheckedTypes) {
        JSType result;
        if (alreadyCheckedTypes.contains(type)) {
            return null;
        }
        alreadyCheckedTypes.add(type);
        if (this.isObjectTypeWithNonStringifiableKey(type)) {
            return type;
        }
        if (type.isUnionType()) {
            for (JSType alternateType : type.toMaybeUnionType().getAlternates()) {
                result = this.findObjectWithNonStringifiableKey(alternateType, alreadyCheckedTypes);
                if (result == null) continue;
                return result;
            }
        }
        if (type.isTemplatizedType()) {
            for (JSType templateType : type.toMaybeTemplatizedType().getTemplateTypes()) {
                result = this.findObjectWithNonStringifiableKey(templateType, alreadyCheckedTypes);
                if (result == null) continue;
                return result;
            }
        }
        if (type.isOrdinaryFunction()) {
            FunctionType function = type.toMaybeFunctionType();
            for (Node parameter : function.getParameters()) {
                JSType result2 = this.findObjectWithNonStringifiableKey(parameter.getJSType(), alreadyCheckedTypes);
                if (result2 == null) continue;
                return result2;
            }
            return this.findObjectWithNonStringifiableKey(function.getReturnType(), alreadyCheckedTypes);
        }
        return null;
    }

    private boolean classHasToString(ObjectType type) {
        Property toStringProperty = type.getOwnSlot("toString");
        if (toStringProperty != null) {
            return toStringProperty.getType().isFunctionType();
        }
        ObjectType parent = type.getParentScope();
        if (parent != null && !parent.isNativeObjectType()) {
            return this.classHasToString(parent);
        }
        return false;
    }

    private static final class SuggestionPair {
        private final String suggestion;
        final int distance;

        private SuggestionPair(String suggestion, int distance) {
            this.suggestion = suggestion;
            this.distance = distance;
        }
    }
}

