/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeIEnv;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;

public class TypedScope
extends AbstractScope<TypedScope, TypedVar>
implements StaticTypedScope<JSType>,
TypeIEnv<JSType> {
    private final TypedScope parent;
    private final int depth;
    private final boolean isBottom;
    private TypeResolver typeResolver;

    TypedScope(TypedScope parent, Node rootNode) {
        super(rootNode);
        this.checkChildScope(parent);
        this.parent = parent;
        this.depth = parent.depth + 1;
        this.isBottom = false;
    }

    private TypedScope(Node rootNode, boolean isBottom) {
        super(rootNode);
        this.checkRootScope();
        this.parent = null;
        this.depth = 0;
        this.isBottom = isBottom;
    }

    static TypedScope createGlobalScope(Node rootNode) {
        return new TypedScope(rootNode, false);
    }

    static TypedScope createLatticeBottom(Node rootNode) {
        return new TypedScope(rootNode, true);
    }

    @Override
    public TypedScope typed() {
        return this;
    }

    boolean isBottom() {
        return this.isBottom;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public TypedScope getParent() {
        return this.parent;
    }

    @Override
    public JSType getTypeOfThis() {
        if (this.isGlobal()) {
            return ObjectType.cast(this.getRootNode().getJSType());
        }
        if (!this.getRootNode().isFunction()) {
            return ((TypedScope)this.getClosestContainerScope()).getTypeOfThis();
        }
        Preconditions.checkState((boolean)this.getRootNode().isFunction());
        JSType nodeType = this.getRootNode().getJSType();
        if (nodeType != null && nodeType.isFunctionType()) {
            return nodeType.toMaybeFunctionType().getTypeOfThis();
        }
        return null;
    }

    TypedVar declare(String name, Node nameNode, JSType type, CompilerInput input) {
        return this.declare(name, nameNode, type, input, true);
    }

    TypedVar declare(String name, Node nameNode, JSType type, CompilerInput input, boolean inferred) {
        Preconditions.checkState((name != null && !name.isEmpty() ? 1 : 0) != 0);
        TypedVar var = new TypedVar(inferred, name, nameNode, type, this, this.getVarCount(), input);
        this.declareInternal(name, var);
        return var;
    }

    @Override
    TypedVar makeImplicitVar(AbstractScope.ImplicitVar var) {
        if (this.isGlobal()) {
            return null;
        }
        return new TypedVar(false, var.name, null, this.getImplicitVarType(var), this, -1, null);
    }

    private JSType getImplicitVarType(AbstractScope.ImplicitVar var) {
        if (var == AbstractScope.ImplicitVar.ARGUMENTS) {
            TypedVar globalArgs = (TypedVar)((TypedScope)this.getGlobalScope()).getVar("arguments");
            return globalArgs != null && globalArgs.isExtern() ? globalArgs.getType() : null;
        }
        return this.getTypeOfThis();
    }

    public Iterable<TypedVar> getDeclarativelyUnboundVarsWithoutTypes() {
        return Iterables.filter((Iterable)this.getVarIterable(), var -> var.getParentNode() != null && var.getType() == null && var.getParentNode().isVar() && !var.isExtern());
    }

    void resolveTypes() {
        if (this.typeResolver != null) {
            this.typeResolver.resolveTypes();
            this.typeResolver = null;
        }
    }

    void setTypeResolver(TypeResolver resolver) {
        this.typeResolver = resolver;
    }

    @Override
    public JSType getNamespaceOrTypedefType(String typeName) {
        StaticTypedSlot slot = (StaticTypedSlot)this.getSlot(typeName);
        return slot == null ? null : (JSType)slot.getType();
    }

    @Override
    public JSDocInfo getJsdocOfTypeDeclaration(String typeName) {
        StaticTypedSlot slot = (StaticTypedSlot)this.getSlot(typeName);
        return slot == null ? null : slot.getJSDocInfo();
    }

    static interface TypeResolver {
        public void resolveTypes();
    }
}

