/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NoType;
import javax.annotation.Nullable;

public class NoResolvedType
extends NoType {
    private static final long serialVersionUID = 1L;
    @Nullable
    private String referenceName;
    @Nullable
    private ImmutableList<JSType> templateTypes;

    NoResolvedType(JSTypeRegistry registry) {
        super(registry);
    }

    NoResolvedType(JSTypeRegistry registry, String referenceName, ImmutableList<JSType> templateTypes) {
        this(registry);
        this.referenceName = referenceName;
        this.templateTypes = templateTypes;
    }

    @Override
    @Nullable
    public String getReferenceName() {
        return this.referenceName;
    }

    @Override
    @Nullable
    public ImmutableList<JSType> getTemplateTypes() {
        return this.templateTypes;
    }

    @Override
    public boolean isNoResolvedType() {
        return true;
    }

    @Override
    public boolean isNoType() {
        return false;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, JSType.ImplCache.create(), JSType.SubtypingMode.NORMAL);
    }

    @Override
    protected boolean isSubtype(JSType that, JSType.ImplCache implicitImplCache, JSType.SubtypingMode subtypingMode) {
        if (JSType.isSubtypeHelper(this, that, implicitImplCache, subtypingMode)) {
            return true;
        }
        return !that.isNoType();
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        return sb.append(forAnnotations ? "?" : "NoResolvedType");
    }
}

