/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.classloader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.util.ClassUtils;

public class RepositoryClassLoader
extends URLClassLoader
implements LogEnabled {
    protected Logger log;

    public RepositoryClassLoader() {
        super(new URL[0], ClassUtils.getClassLoader());
    }

    public RepositoryClassLoader(URL[] urls) {
        super(urls, ClassUtils.getClassLoader());
    }

    public RepositoryClassLoader(URL[] urls, ClassLoader parentClassLoader) {
        super(urls, parentClassLoader);
    }

    protected RepositoryClassLoader(Vector repositories) {
        this((Collection)repositories);
    }

    protected RepositoryClassLoader(Collection repositories) {
        this();
        Iterator i = repositories.iterator();
        while (i.hasNext()) {
            try {
                this.addDirectory((File)i.next());
            }
            catch (IOException ioe) {
                this.log.error("Repository could not be added", (Throwable)ioe);
            }
        }
    }

    public void enableLogging(Logger logger) {
        if (this.log == null) {
            this.log = logger;
        }
    }

    public void addDirectory(File repository) throws IOException {
        try {
            this.addURL(repository.getCanonicalFile().toURL());
        }
        catch (MalformedURLException mue) {
            this.log.error("The repository had a bad URL", (Throwable)mue);
            throw new CascadingIOException("Could not add repository", mue);
        }
    }

    public void addDirectory(String repository) throws IOException {
        try {
            File file = new File(repository);
            this.addURL(file.getCanonicalFile().toURL());
        }
        catch (MalformedURLException mue) {
            this.log.error("The repository had a bad URL", (Throwable)mue);
            throw new CascadingIOException("Could not add repository", mue);
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public Class defineClass(byte[] b) throws ClassFormatError {
        return super.defineClass(null, b, 0, b.length);
    }
}

