/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractInputModule;

public class NamingInputModule
extends AbstractInputModule
implements ThreadSafe,
Initializable {
    private Properties properties;
    private InitialContext context;

    @Override
    public void configure(Configuration conf) throws ConfigurationException {
        Configuration[] parameters = conf.getChildren();
        this.properties = new Properties();
        for (int i = 0; i < parameters.length; ++i) {
            String key = parameters[i].getName();
            String val = parameters[i].getValue("");
            this.properties.put(key, val);
        }
    }

    public void initialize() throws Exception {
        this.context = new InitialContext(this.properties);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        String pname = (String)this.properties.get("path");
        if (pname == null) {
            pname = name;
        }
        if (modeConf != null) {
            pname = modeConf.getAttribute("path", pname);
            pname = modeConf.getChild("path").getValue(pname);
        }
        try {
            return this.context.lookup(pname);
        }
        catch (NamingException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Can't get parameter " + pname, (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        return Collections.EMPTY_LIST.iterator();
    }
}

