/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.sax;

import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.cocoon.components.sax.AbstractXMLByteStreamCompiler;
import org.apache.cocoon.components.sax.XMLSerializer;

public final class XMLByteStreamCompiler
extends AbstractXMLByteStreamCompiler
implements XMLSerializer,
Recyclable {
    private byte[] buf;
    private int bufCount;
    private int bufCountAverage = 2000;

    public XMLByteStreamCompiler() {
        this.initOutput();
    }

    private void initOutput() {
        this.buf = new byte[this.bufCountAverage];
        this.bufCount = 0;
    }

    @Override
    public void recycle() {
        this.bufCountAverage = (this.bufCountAverage + this.bufCount) / 2;
        this.initOutput();
        super.recycle();
    }

    @Override
    public Object getSAXFragment() {
        if (this.bufCount == 0) {
            return null;
        }
        byte[] newbuf = new byte[this.bufCount];
        System.arraycopy(this.buf, 0, newbuf, 0, this.bufCount);
        return newbuf;
    }

    @Override
    protected void write(int b) {
        int newcount = this.bufCount + 1;
        this.assure(newcount);
        this.buf[this.bufCount] = (byte)b;
        this.bufCount = newcount;
    }

    private void assure(int size) {
        if (size > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, size)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.bufCount);
            this.buf = newbuf;
        }
    }
}

