/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.SimpleSelectorProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ComponentsSelector;
import org.apache.cocoon.components.treeprocessor.sitemap.SelectNode;
import org.apache.cocoon.components.treeprocessor.sitemap.SwitchSelectNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.selection.Selector;
import org.apache.cocoon.selection.SwitchSelector;

public class SelectNodeBuilder
extends AbstractParentProcessingNodeBuilder {
    private static final String SELECTOR_ROLE = Selector.ROLE + "Selector";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingNode buildNode(Configuration config) throws Exception {
        SimpleSelectorProcessingNode node;
        String type = this.treeBuilder.getTypeForStatement(config, SELECTOR_ROLE);
        ArrayList<ProcessingNode[]> whenChildren = new ArrayList<ProcessingNode[]>();
        ArrayList<VariableResolver> whenTests = new ArrayList<VariableResolver>();
        ProcessingNode[] otherwiseNodes = null;
        Configuration[] childrenConfig = config.getChildren();
        for (int i = 0; i < childrenConfig.length; ++i) {
            Configuration childConfig = childrenConfig[i];
            String name = childConfig.getName();
            if ("when".equals(name)) {
                this.checkNamespace(childConfig);
                whenTests.add(VariableResolverFactory.getResolver(childConfig.getAttribute("test"), this.manager));
                whenChildren.add(this.buildChildNodes(childConfig));
                continue;
            }
            if ("otherwise".equals(name)) {
                this.checkNamespace(childConfig);
                if (otherwiseNodes != null) {
                    String msg = "Duplicate " + name + " (only one is allowed) at " + childConfig.getLocation();
                    this.getLogger().error(msg);
                    throw new ConfigurationException(msg);
                }
                otherwiseNodes = this.buildChildNodes(childConfig);
                continue;
            }
            if (this.isParameter(childConfig)) continue;
            String msg = "Unknown element '" + name + "' in select at " + childConfig.getLocation();
            throw new ConfigurationException(msg);
        }
        ProcessingNode[][] whenChildrenNodes = (ProcessingNode[][])whenChildren.toArray((T[])new ProcessingNode[0][0]);
        VariableResolver[] whenResolvers = whenTests.toArray(new VariableResolver[whenTests.size()]);
        ComponentsSelector compSelector = (ComponentsSelector)this.manager.lookup(SELECTOR_ROLE);
        Class<?> clazz = null;
        try {
            Selector selector = (Selector)compSelector.select(type);
            try {
                clazz = selector.getClass();
            }
            finally {
                compSelector.release(selector);
            }
        }
        finally {
            this.manager.release((Component)compSelector);
        }
        if (SwitchSelector.class.isAssignableFrom(clazz)) {
            node = new SwitchSelectNode(type);
            this.treeBuilder.setupNode(node, config);
            ((SwitchSelectNode)node).setCases(whenChildrenNodes, whenResolvers, otherwiseNodes);
            return node;
        }
        node = new SelectNode(type);
        this.treeBuilder.setupNode(node, config);
        ((SelectNode)node).setCases(whenChildrenNodes, whenResolvers, otherwiseNodes);
        return node;
    }
}

