/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xslt;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationUtils;

public class TraxErrorListener
implements ErrorListener {
    private Logger logger;
    private String uri;
    private TransformerException warningEx;
    private TransformerException exception;

    public TraxErrorListener(Logger logger, String uri) {
        this.logger = logger;
        this.uri = uri;
    }

    public Throwable getThrowable() {
        if (this.exception == null) {
            return null;
        }
        Location loc = LocationUtils.getLocation(this.exception);
        if (LocationUtils.isKnown(loc)) {
            return this.exception;
        }
        if (this.exception.getCause() != null) {
            return this.exception.getCause();
        }
        return this.exception;
    }

    @Override
    public void warning(TransformerException ex) throws TransformerException {
        if (this.logger.isWarnEnabled()) {
            Location loc = LocationUtils.getLocation(ex);
            this.logger.warn(ex.getMessage() + " at " + loc == null ? this.uri : loc.toString());
        }
        this.warningEx = ex;
    }

    @Override
    public void error(TransformerException ex) throws TransformerException {
        if (this.warningEx != null && ex.getCause() == null) {
            ex = this.warningEx;
        }
        this.warningEx = null;
        this.exception = ex;
        throw ex;
    }

    @Override
    public void fatalError(TransformerException ex) throws TransformerException {
        if (this.warningEx != null && ex.getCause() == null) {
            ex = this.warningEx;
        }
        this.warningEx = null;
        this.exception = ex;
        throw ex;
    }
}

