/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment;

import java.io.IOException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.PermanentRedirector;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.cocoon.environment.wrapper.MutableEnvironmentFacade;

public abstract class ForwardRedirector
extends AbstractLogEnabled
implements Redirector,
PermanentRedirector {
    private boolean hasRedirected = false;
    protected Environment env;

    public ForwardRedirector(Environment env) {
        this.env = env;
    }

    @Override
    public void redirect(boolean sessionMode, String url) throws IOException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Redirecting to '" + url + "'");
        }
        if (url.startsWith("cocoon:")) {
            this.cocoonRedirect(url);
        } else {
            this.env.redirect(sessionMode, url);
        }
        this.hasRedirected = true;
    }

    @Override
    public void permanentRedirect(boolean sessionMode, String url) throws IOException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Redirecting to '" + url + "'");
        }
        if (url.startsWith("cocoon:")) {
            this.cocoonRedirect(url);
        } else if (this.env instanceof PermanentRedirector) {
            ((PermanentRedirector)((Object)this.env)).permanentRedirect(sessionMode, url);
        } else {
            this.env.redirect(sessionMode, url);
        }
        this.hasRedirected = true;
    }

    @Override
    public void globalRedirect(boolean sessionMode, String url) throws IOException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Redirecting to '" + url + "'");
        }
        if (url.startsWith("cocoon:")) {
            this.cocoonRedirect(url);
        } else if (this.env instanceof MutableEnvironmentFacade) {
            ((MutableEnvironmentFacade)this.env).getDelegate().globalRedirect(sessionMode, url);
        } else if (this.env instanceof EnvironmentWrapper) {
            ((EnvironmentWrapper)this.env).globalRedirect(sessionMode, url);
        } else {
            this.env.redirect(sessionMode, url);
        }
        this.hasRedirected = true;
    }

    protected abstract void cocoonRedirect(String var1) throws IOException, ProcessingException;

    @Override
    public boolean hasRedirected() {
        return this.hasRedirected;
    }

    @Override
    public void sendStatus(int sc) {
        this.env.setStatus(sc);
        this.hasRedirected = true;
    }
}

