/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.selection.Selector;

public class RequestAttributeSelector
extends AbstractLogEnabled
implements Configurable,
ThreadSafe,
Selector {
    protected String defaultName;

    public void configure(Configuration config) throws ConfigurationException {
        this.defaultName = config.getChild("attribute-name").getValue(null);
    }

    @Override
    public boolean select(String expression, Map objectModel, Parameters parameters) {
        String name = parameters.getParameter("attribute-name", this.defaultName);
        if (name == null) {
            this.getLogger().warn("No attribute name given -- failing.");
            return false;
        }
        Object value = ObjectModelHelper.getRequest(objectModel).getAttribute(name);
        if (value == null) {
            this.getLogger().debug("Request attribute '" + name + "' not set -- failing.");
            return false;
        }
        return value.toString().equals(expression);
    }
}

