/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.impl.MultiSourceValidity;
import org.apache.cocoon.components.xpointer.XPointer;
import org.apache.cocoon.components.xpointer.XPointerContext;
import org.apache.cocoon.components.xpointer.parser.ParseException;
import org.apache.cocoon.components.xpointer.parser.XPointerFrameworkParser;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.util.NetUtils;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLBaseSupport;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class XIncludeTransformer
extends AbstractTransformer
implements Serviceable,
CacheableProcessingComponent {
    protected SourceResolver resolver;
    protected ServiceManager manager;
    private XIncludePipe xIncludePipe;
    public static final String XMLBASE_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLBASE_NAMESPACE_PREFIX = "xml";
    public static final String XMLBASE_ATTRIBUTE = "base";
    public static final String XMLBASE_ATTRIBUTE_TYPE = "CDATA";
    public static final String XINCLUDE_NAMESPACE_URI = "http://www.w3.org/2001/XInclude";
    public static final String XINCLUDE_INCLUDE_ELEMENT = "include";
    public static final String XINCLUDE_FALLBACK_ELEMENT = "fallback";
    public static final String XINCLUDE_INCLUDE_ELEMENT_HREF_ATTRIBUTE = "href";
    public static final String XINCLUDE_INCLUDE_ELEMENT_XPOINTER_ATTRIBUTE = "xpointer";
    public static final String XINCLUDE_INCLUDE_ELEMENT_PARSE_ATTRIBUTE = "parse";
    private static final String XINCLUDE_CACHE_KEY = "XInclude";
    protected MultiSourceValidity validity;

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.resolver = resolver;
        this.validity = new MultiSourceValidity(resolver, -1L);
        this.xIncludePipe = new XIncludePipe();
        this.xIncludePipe.enableLogging(this.getLogger());
        this.xIncludePipe.init(null, null);
        super.setContentHandler((ContentHandler)((Object)this.xIncludePipe));
        super.setLexicalHandler((LexicalHandler)((Object)this.xIncludePipe));
    }

    @Override
    public void setConsumer(XMLConsumer consumer) {
        this.xIncludePipe.setConsumer(consumer);
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.xIncludePipe.setContentHandler(handler);
    }

    @Override
    public void setLexicalHandler(LexicalHandler handler) {
        this.xIncludePipe.setLexicalHandler(handler);
    }

    public void service(ServiceManager manager) {
        this.manager = manager;
    }

    @Override
    public Serializable getKey() {
        return XINCLUDE_CACHE_KEY;
    }

    @Override
    public SourceValidity getValidity() {
        return this.validity;
    }

    @Override
    public void recycle() {
        this.resolver = null;
        this.validity = null;
        this.xIncludePipe = null;
        super.recycle();
    }

    private class XIncludePipe
    extends AbstractXMLPipe {
        private XMLBaseSupport xmlBaseSupport;
        private int xIncludeElementLevel = 0;
        private int useFallbackLevel = 0;
        private int fallbackElementLevel;
        private Exception fallBackException;
        private Locator locator;
        private String href;
        private String xpointer;
        private int level = 0;
        private String parentBaseURI = null;
        private XIncludePipe parent;

        private XIncludePipe() {
        }

        public void init(String uri, String xpointer) {
            this.href = uri;
            this.xpointer = xpointer;
            this.xmlBaseSupport = new XMLBaseSupport(XIncludeTransformer.this.resolver, this.getLogger());
        }

        public void setParent(XIncludePipe parent) {
            this.parent = parent;
        }

        public XIncludePipe getParent() {
            return this.parent;
        }

        public String getHref() {
            return this.href;
        }

        public String getXpointer() {
            return this.xpointer;
        }

        private boolean isEvaluatingContent() {
            return this.xIncludeElementLevel == 0 || this.fallbackElementLevel > 0 && this.fallbackElementLevel == this.useFallbackLevel;
        }

        @Override
        public void endDocument() throws SAXException {
            XIncludeTransformer.this.validity.close();
            super.endDocument();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
            this.parentBaseURI = this.xmlBaseSupport.getCurrentBase();
            this.xmlBaseSupport.startElement(uri, name, raw, attr);
            ++this.level;
            if (XIncludeTransformer.XINCLUDE_NAMESPACE_URI.equals(uri)) {
                if (XIncludeTransformer.XINCLUDE_INCLUDE_ELEMENT.equals(name)) {
                    if (this.isEvaluatingContent()) {
                        String href = attr.getValue("", XIncludeTransformer.XINCLUDE_INCLUDE_ELEMENT_HREF_ATTRIBUTE);
                        String parse = attr.getValue("", XIncludeTransformer.XINCLUDE_INCLUDE_ELEMENT_PARSE_ATTRIBUTE);
                        String xpointer = attr.getValue("", XIncludeTransformer.XINCLUDE_INCLUDE_ELEMENT_XPOINTER_ATTRIBUTE);
                        try {
                            this.processXIncludeElement(href, parse, xpointer);
                        }
                        catch (ProcessingException e) {
                            this.getLogger().debug("Rethrowing exception", (Throwable)((Object)e));
                            throw new SAXException((Exception)((Object)e));
                        }
                        catch (IOException e) {
                            this.getLogger().debug("Rethrowing exception", (Throwable)e);
                            throw new SAXException(e);
                        }
                    }
                    ++this.xIncludeElementLevel;
                    return;
                }
                if (!XIncludeTransformer.XINCLUDE_FALLBACK_ELEMENT.equals(name)) throw new SAXException("Unknown XInclude element " + raw + " at " + this.getLocation());
                ++this.fallbackElementLevel;
                return;
            }
            if (!this.isEvaluatingContent()) return;
            if (this.mustAddBaseAttr()) {
                super.startElement(uri, name, raw, this.addBaseURI(attr));
                return;
            } else {
                super.startElement(uri, name, raw, attr);
            }
        }

        private boolean mustAddBaseAttr() {
            if (this.level != 1) {
                return false;
            }
            if (this.parent == null) {
                return false;
            }
            String parentBase = this.parent.parentBaseURI;
            String currentBase = this.xmlBaseSupport.getCurrentBase();
            if (currentBase == null) {
                return false;
            }
            return parentBase == null || !parentBase.equals(currentBase);
        }

        private Attributes addBaseURI(Attributes oldAttr) throws SAXException {
            String currentBaseURI = this.xmlBaseSupport.getCurrentBase();
            AttributesImpl fixedAttr = new AttributesImpl(oldAttr);
            int xmlBaseAttrIdx = fixedAttr.getIndex(XIncludeTransformer.XMLBASE_NAMESPACE_URI, XIncludeTransformer.XMLBASE_ATTRIBUTE);
            if (xmlBaseAttrIdx != -1) {
                fixedAttr.removeAttribute(xmlBaseAttrIdx);
            }
            fixedAttr.addAttribute(XIncludeTransformer.XMLBASE_NAMESPACE_URI, XIncludeTransformer.XMLBASE_ATTRIBUTE, "xml:base", XIncludeTransformer.XMLBASE_ATTRIBUTE_TYPE, currentBaseURI);
            return fixedAttr;
        }

        @Override
        public void endElement(String uri, String name, String raw) throws SAXException {
            this.xmlBaseSupport.endElement(uri, name, raw);
            --this.level;
            if (XIncludeTransformer.XINCLUDE_NAMESPACE_URI.equals(uri)) {
                if (XIncludeTransformer.XINCLUDE_INCLUDE_ELEMENT.equals(name)) {
                    --this.xIncludeElementLevel;
                    if (this.useFallbackLevel > this.xIncludeElementLevel) {
                        this.useFallbackLevel = this.xIncludeElementLevel;
                    }
                } else if (XIncludeTransformer.XINCLUDE_FALLBACK_ELEMENT.equals(name)) {
                    --this.fallbackElementLevel;
                }
            } else if (this.isEvaluatingContent()) {
                super.endElement(uri, name, raw);
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.isEvaluatingContent()) {
                super.startPrefixMapping(prefix, uri);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            if (this.isEvaluatingContent()) {
                super.endPrefixMapping(prefix);
            }
        }

        @Override
        public void characters(char[] c, int start, int len) throws SAXException {
            if (this.isEvaluatingContent()) {
                super.characters(c, start, len);
            }
        }

        @Override
        public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
            if (this.isEvaluatingContent()) {
                super.ignorableWhitespace(c, start, len);
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (this.isEvaluatingContent()) {
                super.processingInstruction(target, data);
            }
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            if (this.isEvaluatingContent()) {
                super.skippedEntity(name);
            }
        }

        @Override
        public void startEntity(String name) throws SAXException {
            if (this.isEvaluatingContent()) {
                super.startEntity(name);
            }
        }

        @Override
        public void endEntity(String name) throws SAXException {
            if (this.isEvaluatingContent()) {
                super.endEntity(name);
            }
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.isEvaluatingContent()) {
                super.startCDATA();
            }
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this.isEvaluatingContent()) {
                super.endCDATA();
            }
        }

        @Override
        public void comment(char[] ch, int start, int len) throws SAXException {
            if (this.isEvaluatingContent()) {
                super.comment(ch, start, len);
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            block7: {
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("setDocumentLocator called " + locator.getSystemId());
                    }
                    if (locator.getSystemId() == null) break block7;
                    Source source = XIncludeTransformer.this.resolver.resolveURI(locator.getSystemId());
                    try {
                        this.xmlBaseSupport.setDocumentLocation(source.getURI());
                        if (this.href == null) {
                            this.href = source.getURI();
                        }
                    }
                    finally {
                        XIncludeTransformer.this.resolver.release(source);
                    }
                }
                catch (Exception e) {
                    throw new CascadingRuntimeException("Error in XIncludeTransformer while trying to resolve base URL for document", (Throwable)e);
                }
            }
            this.locator = locator;
            super.setDocumentLocator(locator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void processXIncludeElement(String href, String parse, String xpointer) throws SAXException, ProcessingException, IOException {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Processing XInclude element: href=" + href + ", parse=" + parse + ", xpointer=" + xpointer);
            }
            if (parse == null) {
                parse = XIncludeTransformer.XMLBASE_NAMESPACE_PREFIX;
            }
            Source url = null;
            try {
                int fragmentIdentifierPos = href.indexOf(35);
                if (fragmentIdentifierPos != -1) {
                    this.getLogger().warn("Fragment identifer found in 'href' attribute: " + href + "\nFragment identifiers are forbidden by the XInclude specification. " + "They are still handled by XIncludeTransformer for backward " + "compatibility, but their use is deprecated and will be prohibited " + "in a future release.  Use the 'xpointer' attribute instead.");
                    if (xpointer == null) {
                        xpointer = href.substring(fragmentIdentifierPos + 1);
                    }
                    href = href.substring(0, fragmentIdentifierPos);
                }
                if (href == null || href.length() == 0) {
                    if (this.href == null) {
                        throw new SAXException("XIncludeTransformer: encountered empty href (= href pointing to the current document) but the location of the current document is unknown.");
                    }
                    int fragmentIdentifierPos2 = this.href.indexOf(35);
                    href = fragmentIdentifierPos2 != -1 ? this.href.substring(0, fragmentIdentifierPos2) : this.href;
                }
                url = this.xmlBaseSupport.makeAbsolute(href);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("URL: " + url.getURI() + "\nXPointer: " + xpointer);
                }
                XIncludeTransformer.this.validity.addSource(url);
                if (parse.equals("text")) {
                    this.getLogger().debug("Parse type is text");
                    if (xpointer != null) {
                        throw new SAXException("xpointer attribute must not be present when parse='text': " + this.getLocation());
                    }
                    InputStream is = null;
                    InputStreamReader isr = null;
                    Reader reader = null;
                    try {
                        int read;
                        is = url.getInputStream();
                        isr = new InputStreamReader(is);
                        reader = new BufferedReader(isr);
                        char[] ary = new char[4096];
                        while ((read = reader.read(ary)) != -1) {
                            super.characters(ary, 0, read);
                        }
                    }
                    catch (SourceNotFoundException e) {
                        ++this.useFallbackLevel;
                        this.fallBackException = new CascadingException("Resource not found: " + url.getURI());
                        this.getLogger().error("xIncluded resource not found: " + url.getURI(), (Throwable)e);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                    }
                } else {
                    if (!parse.equals(XIncludeTransformer.XMLBASE_NAMESPACE_PREFIX)) throw new SAXException("Found 'parse' attribute with unknown value " + parse + " at " + this.getLocation());
                    this.getLogger().debug("Parse type is XML");
                    if (this.isLoopInclusion(url.getURI(), xpointer)) {
                        throw new ProcessingException("Detected loop inclusion of href=" + url.getURI() + ", xpointer=" + xpointer);
                    }
                    XIncludePipe subPipe = new XIncludePipe();
                    subPipe.enableLogging(this.getLogger());
                    subPipe.init(url.getURI(), xpointer);
                    subPipe.setConsumer(this.xmlConsumer);
                    subPipe.setParent(this);
                    try {
                        if (xpointer != null && xpointer.length() > 0) {
                            XPointer xptr = XPointerFrameworkParser.parse(NetUtils.decodePath(xpointer));
                            XPointerContext context = new XPointerContext(xpointer, url, subPipe, this.getLogger(), XIncludeTransformer.this.manager);
                            xptr.process(context);
                        } else {
                            SourceUtil.toSAX(url, (ContentHandler)((Object)new IncludeXMLConsumer(subPipe)));
                        }
                        if (this.locator != null) {
                            this.xmlConsumer.setDocumentLocator(this.locator);
                        }
                    }
                    catch (ResourceNotFoundException e) {
                        ++this.useFallbackLevel;
                        this.fallBackException = new CascadingException("Resource not found: " + url.getURI());
                        this.getLogger().error("xIncluded resource not found: " + url.getURI(), (Throwable)((Object)e));
                    }
                    catch (ParseException e) {
                        ++this.useFallbackLevel;
                        this.fallBackException = new CascadingException("Error parsing xPointer expression", (Throwable)e);
                        this.fallBackException.fillInStackTrace();
                        this.getLogger().error("Error parsing XPointer expression, will try to use fallback.", (Throwable)e);
                    }
                    catch (SAXException e) {
                        this.getLogger().error("Error in processXIncludeElement", (Throwable)e);
                        throw e;
                    }
                    catch (ProcessingException e) {
                        this.getLogger().error("Error in processXIncludeElement", (Throwable)((Object)e));
                        throw e;
                    }
                    catch (MalformedURLException e) {
                        ++this.useFallbackLevel;
                        this.fallBackException = e;
                        this.getLogger().error("Error processing an xInclude, will try to use fallback.", (Throwable)e);
                    }
                    catch (IOException e) {
                        ++this.useFallbackLevel;
                        this.fallBackException = e;
                        this.getLogger().error("Error processing an xInclude, will try to use fallback.", (Throwable)e);
                    }
                }
                if (url == null) return;
            }
            catch (SourceException se) {
                try {
                    throw SourceUtil.handle(se);
                }
                catch (Throwable throwable) {
                    if (url == null) throw throwable;
                    XIncludeTransformer.this.resolver.release(url);
                    throw throwable;
                }
            }
            XIncludeTransformer.this.resolver.release(url);
            return;
        }

        public boolean isLoopInclusion(String uri, String xpointer) {
            if (xpointer == null) {
                xpointer = "";
            }
            if (uri.equals(this.href) && xpointer.equals(this.xpointer == null ? "" : this.xpointer)) {
                return true;
            }
            for (XIncludePipe parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!uri.equals(parent.getHref()) || !xpointer.equals(parent.getXpointer() == null ? "" : parent.getXpointer())) continue;
                return true;
            }
            return false;
        }

        private String getLocation() {
            if (this.locator == null) {
                return "unknown location";
            }
            return this.locator.getSystemId() + ":" + this.locator.getColumnNumber() + ":" + this.locator.getLineNumber();
        }
    }
}

